/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import java.util.StringJoiner;

public abstract class FrameRenderingFlags {
    public static int MINIMAP_MODE = 1;
    public static int HIGHLIGHTING = 2;
    public static int HIGHLIGHTED_FRAME = 4;
    public static int HOVERED = 8;
    public static int HOVERED_SIBLING = 16;
    public static int FOCUSING = 32;
    public static int FOCUSED_FRAME = 64;
    public static int PARTIAL_FRAME = 128;

    public static int toFlags(boolean minimapMode, boolean highlightingOn, boolean highlighted, boolean hovered, boolean hoveredSibling, boolean focusing, boolean focusedFrame, boolean partialFrame) {
        return (minimapMode ? MINIMAP_MODE : 0) | (highlightingOn ? HIGHLIGHTING : 0) | (highlighted ? HIGHLIGHTED_FRAME : 0) | (hovered ? HOVERED : 0) | (hoveredSibling ? HOVERED_SIBLING : 0) | (focusing ? FOCUSING : 0) | (focusedFrame ? FOCUSED_FRAME : 0) | (partialFrame ? PARTIAL_FRAME : 0);
    }

    public static String toString(int flags) {
        StringJoiner sb = new StringJoiner(", ", "[", "]");
        if ((flags & MINIMAP_MODE) != 0) {
            sb.add("minimapMode");
        }
        if ((flags & HIGHLIGHTING) != 0) {
            sb.add("highlighting");
        }
        if ((flags & HIGHLIGHTED_FRAME) != 0) {
            sb.add("highlighted");
        }
        if ((flags & HOVERED) != 0) {
            sb.add("hovered");
        }
        if ((flags & HOVERED_SIBLING) != 0) {
            sb.add("hovered sibling");
        }
        if ((flags & FOCUSING) != 0) {
            sb.add("focusing");
        }
        if ((flags & FOCUSED_FRAME) != 0) {
            sb.add("focused");
        }
        if ((flags & PARTIAL_FRAME) != 0) {
            sb.add("partial");
        }
        return sb.toString();
    }

    public static boolean isMinimapMode(int flags) {
        return (flags & MINIMAP_MODE) != 0;
    }

    public static boolean isHighlighting(int flags) {
        return (flags & HIGHLIGHTING) != 0;
    }

    public static boolean isHighlightedFrame(int flags) {
        return (flags & HIGHLIGHTED_FRAME) != 0;
    }

    public static boolean isHovered(int flags) {
        return (flags & HOVERED) != 0;
    }

    public static boolean isHoveredSibling(int flags) {
        return (flags & HOVERED_SIBLING) != 0;
    }

    public static boolean isFocusing(int flags) {
        return (flags & FOCUSING) != 0;
    }

    public static boolean isFocusedFrame(int flags) {
        return (flags & FOCUSED_FRAME) != 0;
    }

    public static boolean isPartialFrame(int flags) {
        return (flags & PARTIAL_FRAME) != 0;
    }

    private FrameRenderingFlags() {
    }
}

