/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.browser.attach;

import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.VirtualMachine;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.remote.JMXServiceURL;
import org.openjdk.jmc.browser.attach.BrowserAttachPlugin;
import org.openjdk.jmc.browser.attach.LazyServiceURLResolveException;
import org.openjdk.jmc.browser.attach.LocalJVMToolkit;
import org.openjdk.jmc.browser.attach.Messages;
import org.openjdk.jmc.common.util.Environment;
import org.openjdk.jmc.rjmx.common.ConnectionToolkit;
import org.openjdk.jmc.rjmx.common.IConnectionDescriptor;

public class LocalConnectionDescriptor
implements IConnectionDescriptor {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.browser.attach");
    private static final String SELF_HOST_NAME = "localhost";
    private static final String ATTACH_TIMED_OUT_ERROR_MESSAGE = "Timed out attempting to attach to target JVM!";
    private static final String COULD_NOT_RETRIEVE_URL_ERROR_MESSAGE = "Could not retrieve the in-memory service URL after starting the in-memory agent!";
    private final boolean isAutoStartAgent = LocalConnectionDescriptor.fetchAutoStartAgentFromStore();
    private final int pid;
    private static final int TIMEOUT_THRESHOLD = 5;
    private final boolean attachable;
    private JMXServiceURL url;

    public LocalConnectionDescriptor(int pid, String address, boolean attachable) {
        this.pid = pid;
        this.attachable = attachable;
        this.setAddress(address);
    }

    private boolean isSelfMonitoring() {
        return this.pid == Environment.getThisPID();
    }

    private void startManagementServer() throws IOException {
        if (this.isSelfMonitoring()) {
            return;
        }
        String pidStr = String.valueOf(this.pid);
        try {
            this.tryJCMDStyleStartingOfTheAgent(pidStr);
        }
        catch (Exception exception) {
            this.tryAgentLoadingStyleOfStartingTheAgent(pidStr);
        }
    }

    private void tryAgentLoadingStyleOfStartingTheAgent(final String pid) throws LazyServiceURLResolveException {
        try {
            ExecutorService service = Executors.newSingleThreadExecutor();
            Future<Void> future = service.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    VirtualMachine vm = VirtualMachine.attach(pid);
                    String home = vm.getSystemProperties().getProperty("java.home");
                    String agent = String.valueOf(home) + File.separator + "jre" + File.separator + "lib" + File.separator + "management-agent.jar";
                    File f = new File(agent);
                    if (!f.exists() && !(f = new File(agent = String.valueOf(home) + File.separator + "lib" + File.separator + "management-agent.jar")).exists()) {
                        throw new LazyServiceURLResolveException("Management agent not found");
                    }
                    agent = f.getCanonicalPath();
                    vm.loadAgent(agent, "com.sun.management.jmxremote");
                    Properties agentProps = vm.getAgentProperties();
                    LocalConnectionDescriptor.this.setAddress((String)agentProps.get("com.sun.management.jmxremote.localConnectorAddress"));
                    vm.detach();
                    return null;
                }
            });
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException t) {
            throw new LazyServiceURLResolveException(ATTACH_TIMED_OUT_ERROR_MESSAGE, t);
        }
        catch (Exception x) {
            LazyServiceURLResolveException lsure = new LazyServiceURLResolveException("Attach not supported for the JVM with PID " + pid + ". Try starting it with the jvm flag -Dcom.sun.management.jmxremote to start the local management agent", x);
            throw lsure;
        }
    }

    private void setAddress(String address) {
        if (this.isSelfMonitoring() || address == null) {
            try {
                this.url = ConnectionToolkit.createServiceURL((String)SELF_HOST_NAME, (int)0);
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.SEVERE, "Failed to parse url", e);
            }
        } else {
            try {
                this.url = new JMXServiceURL(address);
            }
            catch (MalformedURLException e) {
                BrowserAttachPlugin.getPluginLogger().log(Level.SEVERE, "Could not get create service URL from a local address!", e);
            }
        }
    }

    private void tryJCMDStyleStartingOfTheAgent(final String name) throws IOException, AgentLoadException {
        try {
            ExecutorService service = Executors.newSingleThreadExecutor();
            Future<Void> future = service.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    VirtualMachine vm = null;
                    try {
                        vm = VirtualMachine.attach(name);
                        LocalJVMToolkit.executeCommandForPid(vm, name, "ManagementAgent.start_local");
                        JMXServiceURL inMemURL = LocalJVMToolkit.getInMemoryURLFromPID(Integer.parseInt(name));
                        if (inMemURL == null) {
                            BrowserAttachPlugin.getPluginLogger().log(Level.SEVERE, LocalConnectionDescriptor.COULD_NOT_RETRIEVE_URL_ERROR_MESSAGE);
                            throw new LazyServiceURLResolveException(LocalConnectionDescriptor.COULD_NOT_RETRIEVE_URL_ERROR_MESSAGE);
                        }
                        LocalConnectionDescriptor.this.url = inMemURL;
                    }
                    finally {
                        if (vm != null) {
                            vm.detach();
                        }
                    }
                    return null;
                }
            });
            future.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException t) {
            throw new LazyServiceURLResolveException(ATTACH_TIMED_OUT_ERROR_MESSAGE, t);
        }
        catch (Exception exception) {
            throw new LazyServiceURLResolveException(COULD_NOT_RETRIEVE_URL_ERROR_MESSAGE);
        }
    }

    public JMXServiceURL createJMXServiceURL() throws IOException {
        if (this.url == null) {
            JMXServiceURL inMemURL = LocalJVMToolkit.getInMemoryURLFromPID(this.pid);
            if (inMemURL != null) {
                BrowserAttachPlugin.getPluginLogger().info("Found URL! No need to start an Agent!");
                this.url = inMemURL;
            } else if (this.isAutoStartAgent()) {
                if (!this.isAttachable()) {
                    throw new LazyServiceURLResolveException(Messages.LocalConnectionDescriptor_ERROR_MESSAGE_ATTACH_NOT_SUPPORTED);
                }
                BrowserAttachPlugin.getPluginLogger().info("No URL found. Attempting to start the Agent!");
                this.startManagementServer();
            } else {
                throw new LazyServiceURLResolveException(Messages.LocalConnectionDescriptor_ERROR_AUTO_START_SWITCHED_OFF);
            }
        }
        return this.url;
    }

    private boolean isAutoStartAgent() {
        return this.isAutoStartAgent;
    }

    public int getPID() {
        return this.pid;
    }

    public boolean isAttachable() {
        return this.attachable;
    }

    private static final boolean fetchAutoStartAgentFromStore() {
        return BrowserAttachPlugin.getDefault().getPreferenceStore().getBoolean("autoStartPreference");
    }

    public Map<String, Object> getEnvironment() {
        return new HashMap<String, Object>(2);
    }

    public String toString() {
        return "LocalConnectionDescriptor [PID=" + this.getPID() + "]";
    }
}

