/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.openjdk.jmc.common.collection.ListToolkit;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.internal.ChunkInfo;
import org.openjdk.jmc.flightrecorder.internal.EventArray;
import org.openjdk.jmc.flightrecorder.internal.EventArrays;
import org.openjdk.jmc.flightrecorder.internal.FlightRecordingLoader;
import org.openjdk.jmc.flightrecorder.internal.IChunkSupplier;
import org.openjdk.jmc.flightrecorder.internal.NotEnoughMemoryException;
import org.openjdk.jmc.flightrecorder.internal.VersionNotSupportedException;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.JfrEditor;
import org.openjdk.jmc.flightrecorder.ui.SelectRangeWizardPage;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.MCPathEditorInput;
import org.openjdk.jmc.ui.WorkbenchToolkit;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.wizards.OnePageWizardDialog;

public class RecordingLoader
extends Job {
    private static final int UNZIPPED_FILE_TO_MEMORY_QUOTA = 4;
    private static int zippedFileMemoryFactor = 40;
    private final JfrEditor editor;
    private final ProgressIndicator ui;

    public RecordingLoader(JfrEditor editor, ProgressIndicator ui) {
        super(MessageFormat.format(Messages.FILE_OPENER_LOAD_JOB_TITLE, editor.getEditorInput().getName()));
        this.editor = editor;
        this.ui = ui;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IEditorInput ei = this.editor.getEditorInput();
        boolean closeEditor = true;
        try {
            File file = MCPathEditorInput.getFile((IEditorInput)ei);
            EventArrays events = this.doCreateRecording(file, new ProgressMonitor(monitor, this.ui));
            RecordingLoader.checkForJRockitRecording(events);
            this.onRecordingLoaded(events);
            closeEditor = false;
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (VersionNotSupportedException versionNotSupportedException) {
            Status status = new Status(4, "org.openjdk.jmc.flightrecorder.ui", MessageFormat.format(Messages.FILE_OPENER_VERSION_NOT_SUPPORTED, ei.getToolTipText()));
            return status;
        }
        catch (CouldNotLoadRecordingException e) {
            Status status = new Status(4, "org.openjdk.jmc.flightrecorder.ui", MessageFormat.format(Messages.FILE_OPENER_COULD_NOT_LOAD_FILE, ei.getToolTipText()), (Throwable)e);
            return status;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.openjdk.jmc.flightrecorder.ui", MessageFormat.format(Messages.FILE_OPENER_COULD_NOT_LOAD_FILE, ei.getToolTipText()), (Throwable)e);
            return status;
        }
        finally {
            if (closeEditor) {
                WorkbenchToolkit.asyncCloseEditor((IEditorPart)this.editor);
            }
        }
    }

    private void onRecordingLoaded(final EventArrays events) {
        String warning;
        ITypedQuantity startTime = null;
        ITypedQuantity endTime = null;
        EventArray[] eventArrayArray = events.getArrays();
        int n = eventArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventArray typeEntry = eventArrayArray[n2];
            IItem[] ea = typeEntry.getEvents();
            IMemberAccessor stAccessor = JfrAttributes.START_TIME.getAccessor(typeEntry.getType());
            IMemberAccessor etAccessor = JfrAttributes.END_TIME.getAccessor(typeEntry.getType());
            if (ea.length > 0 && stAccessor != null && etAccessor != null) {
                IQuantity arrayStart = (IQuantity)stAccessor.getMember((Object)ea[0]);
                IQuantity arrayEnd = (IQuantity)etAccessor.getMember((Object)ea[ea.length - 1]);
                if (startTime == null || startTime.compareTo((Object)arrayStart) > 0) {
                    startTime = arrayStart;
                }
                if (endTime == null || endTime.compareTo((Object)arrayEnd) < 0) {
                    endTime = arrayEnd;
                }
            }
            ++n2;
        }
        if (startTime == null) {
            warning = Messages.FILE_OPENER_WARNING_NO_EVENTS;
            startTime = UnitLookup.EPOCH_NS.quantity(0L);
            endTime = UnitLookup.EPOCH_NS.quantity(System.currentTimeMillis() * 1000L * 1000L);
        } else if (startTime.compareTo(endTime) == 0) {
            warning = MessageFormat.format(Messages.FILE_OPENER_WARNING_SHORT_TIME, startTime.displayUsing("auto"));
            ITypedQuantity halfSecond = UnitLookup.NANOSECOND.quantity(500000000L);
            endTime = startTime.add((IQuantity)halfSecond);
            startTime = startTime.subtract((IQuantity)halfSecond);
        } else {
            warning = null;
        }
        final IRange fullRange = QuantityRange.createWithEnd((IQuantity)startTime, endTime);
        DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (warning != null) {
                    DialogToolkit.showWarning((Shell)RecordingLoader.this.editor.getSite().getShell(), (String)Messages.FILE_OPENER_WARNING_TITLE, (String)warning);
                }
                RecordingLoader.this.editor.repositoryLoaded(events, (IRange<IQuantity>)fullRange);
            }
        });
    }

    private EventArrays doCreateRecording(File file, ProgressMonitor lm) throws CouldNotLoadRecordingException, IOException {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        long availableMemory = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
        if (availableMemory > (long)zippedFileMemoryFactor * file.length()) {
            try {
                Throwable throwable = null;
                Object var7_8 = null;
                try (InputStream stream = IOToolkit.openUncompressedStream((File)file);){
                    boolean hideExperimentals = !FlightRecorderUI.getDefault().includeExperimentalEventsAndFields();
                    boolean ignoreTruncatedChunk = FlightRecorderUI.getDefault().allowIncompleteRecordingFile();
                    return FlightRecordingLoader.loadStream((InputStream)stream, (boolean)hideExperimentals, (boolean)ignoreTruncatedChunk);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (OutOfMemoryError | NotEnoughMemoryException throwable) {}
        }
        String fileName = file.getName();
        if (IOToolkit.isCompressedFile((File)file)) {
            file = this.unzipFile(file);
        }
        return this.loadFromUnzippedFile(file, fileName, lm, availableMemory);
    }

    private static void checkForJRockitRecording(EventArrays events) {
        EventArray[] eventArrayArray = events.getArrays();
        int n = eventArrayArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventArray ea = eventArrayArray[n2];
            if (ea.getType().getIdentifier().startsWith("http://www.oracle.com/jrockit/")) {
                DisplayToolkit.safeSyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DialogToolkit.showError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.FILE_OPENER_JROCKIT_TITLE, (String)Messages.FILE_OPENER_JROCKIT_TEXT);
                    }
                });
                throw new OperationCanceledException();
            }
            ++n2;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EventArrays loadFromUnzippedFile(File unzippedFile, String recordingFileName, ProgressMonitor lm, long availableMemory) throws IOException, CouldNotLoadRecordingException {
        boolean hideExperimentals = !FlightRecorderUI.getDefault().includeExperimentalEventsAndFields();
        boolean ignoreTruncatedChunk = FlightRecorderUI.getDefault().allowIncompleteRecordingFile();
        Throwable throwable = null;
        Object var9_9 = null;
        try (RandomAccessFile raf = new RandomAccessFile(unzippedFile, "r");){
            List<ChunkInfo> allChunks = FlightRecordingLoader.readChunkInfo((IChunkSupplier)FlightRecordingLoader.createChunkSupplier((RandomAccessFile)raf));
            IRange<IQuantity> fullRange = RecordingLoader.getRange(allChunks);
            long maxLoadSize = availableMemory / 4L;
            List<ChunkInfo> toLoad = unzippedFile.length() > maxLoadSize ? RecordingLoader.getLastChunks(allChunks, maxLoadSize) : allChunks;
            while (!toLoad.isEmpty()) {
                try {
                    raf.seek(0L);
                    if (toLoad.size() != allChunks.size()) {
                        IRange<IQuantity> confirmedRange;
                        IRange<IQuantity> toLoadRange = RecordingLoader.getRange(toLoad);
                        if (!toLoadRange.equals(confirmedRange = this.confirmRangeWizard(toLoadRange, fullRange, recordingFileName))) {
                            toLoad = RecordingLoader.getChunksInRange(allChunks, confirmedRange);
                        }
                        lm.setWorkSize(toLoad.size());
                        return FlightRecordingLoader.readChunks((Runnable)lm, (IChunkSupplier)FlightRecordingLoader.createChunkSupplier((RandomAccessFile)raf, toLoad), (boolean)hideExperimentals, (boolean)ignoreTruncatedChunk);
                    }
                    lm.setWorkSize(allChunks.size());
                }
                catch (NotEnoughMemoryException notEnoughMemoryException) {
                    block15: {
                        break block15;
                        catch (OutOfMemoryError outOfMemoryError) {}
                    }
                    int keepChunks = (int)((double)toLoad.size() * 0.7);
                    toLoad = toLoad.subList(toLoad.size() - keepChunks, toLoad.size());
                    continue;
                    throw new NotEnoughMemoryException();
                }
                return FlightRecordingLoader.readChunks((Runnable)lm, (IChunkSupplier)FlightRecordingLoader.createChunkSupplier((RandomAccessFile)raf), (boolean)hideExperimentals, (boolean)ignoreTruncatedChunk);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private File unzipFile(File file) throws IOException {
        File unzippedFile = RecordingLoader.getUnzippedDestinationFile(file);
        if (unzippedFile.exists() && unzippedFile.lastModified() > file.lastModified()) {
            return unzippedFile;
        }
        this.bringToFront();
        boolean acceptUnzip = DialogToolkit.openQuestionOnUiThread((String)Messages.FILE_OPENER_ZIPPED_FILE_TITLE, (String)MessageFormat.format(Messages.FILE_OPENER_ZIPPED_FILE_TEXT, file.getName(), unzippedFile.getAbsolutePath()));
        if (acceptUnzip) {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream is = IOToolkit.openUncompressedStream((File)file);){
                IOToolkit.write((InputStream)is, (File)unzippedFile, (boolean)false);
                return unzippedFile;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        throw new OperationCanceledException();
    }

    private static File getUnzippedDestinationFile(File file) throws IOException {
        String fileName = file.getName();
        int dot = fileName.lastIndexOf(46);
        String hash = IOToolkit.calculateFileHash((File)file);
        File tmpDir = FlightRecorderUI.getDefault().getTempRecordingsDir();
        return new File(tmpDir, String.valueOf(fileName.substring(0, dot)) + hash + fileName.substring(dot));
    }

    private static IRange<IQuantity> getRange(List<ChunkInfo> chunks) {
        IQuantity minStart = chunks.stream().map(ci -> (IQuantity)ci.getChunkRange().getStart()).min(Comparator.naturalOrder()).get();
        IQuantity maxEnd = chunks.stream().map(ci -> (IQuantity)ci.getChunkRange().getEnd()).max(Comparator.naturalOrder()).get();
        return QuantityRange.createWithEnd((IQuantity)minStart, (IQuantity)maxEnd);
    }

    private static List<ChunkInfo> getChunksInRange(List<ChunkInfo> chunks, IRange<IQuantity> range) {
        return chunks.stream().filter(ci -> QuantityRange.intersection((IRange)ci.getChunkRange(), (IRange)range) != null).collect(Collectors.toList());
    }

    private static List<ChunkInfo> getLastChunks(List<ChunkInfo> chunks, long maxTotalSize) {
        LinkedList<ChunkInfo> result = new LinkedList<ChunkInfo>();
        for (ChunkInfo ci : ListToolkit.backwards(chunks)) {
            if (maxTotalSize <= ci.getChunkSize()) break;
            result.addFirst(ci);
            maxTotalSize -= ci.getChunkSize();
        }
        return result;
    }

    private IRange<IQuantity> confirmRangeWizard(IRange<IQuantity> suggested, IRange<IQuantity> fullRange, String recordingFileName) {
        SelectRangeWizardPage rangeWizard = new SelectRangeWizardPage(suggested, fullRange, recordingFileName);
        final OnePageWizardDialog dialog = new OnePageWizardDialog(this.editor.getSite().getShell(), (IWizardPage)rangeWizard);
        dialog.setWidthConstraint(600, 600);
        dialog.setHeightConstraint(400, 400);
        DisplayToolkit.safeSyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        if (dialog.getReturnCode() == 0) {
            return rangeWizard.getRange();
        }
        throw new OperationCanceledException();
    }

    private void bringToFront() {
        DisplayToolkit.safeSyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                RecordingLoader.this.editor.getSite().getShell().forceActive();
            }
        });
    }

    public static void setZippedFileMemoryFactor(int zippedFileMemoryFactor) {
        RecordingLoader.zippedFileMemoryFactor = zippedFileMemoryFactor;
    }

    public static int getZippedFileMemoryFactor() {
        return zippedFileMemoryFactor;
    }

    private static class ProgressMonitor
    implements Runnable {
        private final IProgressMonitor pm;
        private final ProgressIndicator ui;

        ProgressMonitor(IProgressMonitor pm, ProgressIndicator ui) {
            this.pm = pm;
            this.ui = ui;
        }

        public void setWorkSize(int totalWork) {
            this.pm.beginTask("", totalWork);
            DisplayToolkit.safeAsyncExec(() -> this.ui.beginTask(totalWork));
        }

        @Override
        public void run() {
            if (this.pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.pm.worked(1);
            DisplayToolkit.safeAsyncExec(() -> this.ui.worked(1.0));
        }
    }
}

