/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.viewers;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.openjdk.jmc.joverflow.ui.model.MemoryStatisticsItem;
import org.openjdk.jmc.joverflow.ui.viewers.PieChartViewer;

class MemoryStatisticsTableViewer
extends TableViewer {
    private long mHeapSize = 1L;
    private final TableViewerColumn mPrimaryColumn;
    private final MemoryStatisticsContentProvider mContentProvider = new MemoryStatisticsContentProvider(this);
    private MemoryStatisticsItem mHighlightedItem = null;
    private PieChartViewer mPieChartViewer;

    MemoryStatisticsTableViewer(Composite parent, int style) {
        super(parent, style | 0x10000000 | 0x10000);
        this.setContentProvider((IContentProvider)this.mContentProvider);
        this.mPrimaryColumn = this.createTableColumnViewer("Name", MemoryStatisticsItem::getName, null, item -> this.mPieChartViewer != null ? this.mPieChartViewer.getArcAttributeProvider().getColor(item) : null, Comparator.comparing(MemoryStatisticsItem::getName));
        TableViewerColumn sortingColumn = this.createTableColumnViewer("Memory KB", model -> String.format("%,.2f (%d%%)", (double)model.getMemory() / 1024.0, Math.round((double)model.getMemory() * 100.0 / (double)this.mHeapSize)), model -> String.format("%,d Bytes", model.getMemory()), null, this.mContentProvider.getSortingComparator());
        this.createTableColumnViewer("Overhead KB", model -> String.format("%,.2f (%d%%)", (double)model.getOverhead() / 1024.0, Math.round((double)model.getOverhead() * 100.0 / (double)this.mHeapSize)), model -> String.format("%,d Bytes", model.getMemory()), null, Comparator.comparingLong(MemoryStatisticsItem::getMemory));
        this.createTableColumnViewer("Objects", model -> String.format("%,d", model.getSize()), null, null, Comparator.comparingInt(MemoryStatisticsItem::getSize));
        this.getTable().setSortColumn(sortingColumn.getColumn());
        this.getTable().setSortDirection(1024);
        this.getTable().setLinesVisible(true);
        this.getTable().setHeaderVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this);
        this.getTable().addMouseMoveListener(e -> {
            ViewerRow row = this.getViewerRow(new Point(e.x, e.y));
            if (row == null) {
                this.setHighlightedItem(null);
            } else {
                this.setHighlightedItem((MemoryStatisticsItem)row.getElement());
            }
        });
        this.getTable().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                MemoryStatisticsTableViewer.this.setHighlightedItem(null);
            }

            public void mouseEnter(MouseEvent e) {
                MemoryStatisticsTableViewer.this.setHighlightedItem(null);
            }
        });
    }

    public void setPieChartViewer(PieChartViewer pieChartViewer) {
        this.mPieChartViewer = pieChartViewer;
    }

    public void setHighlightedItem(MemoryStatisticsItem item) {
        if (this.mHighlightedItem != item) {
            MemoryStatisticsItem oldItem = this.mHighlightedItem;
            this.mHighlightedItem = item;
            if (oldItem != null) {
                this.mPrimaryColumn.getViewer().update((Object)oldItem, null);
            }
            if (this.mHighlightedItem != null) {
                this.mPrimaryColumn.getViewer().update((Object)this.mHighlightedItem, null);
            }
        }
        if (this.mPieChartViewer != null) {
            this.mPieChartViewer.setHighlightedItem(item);
        }
    }

    private TableViewerColumn createTableColumnViewer(String label, final Function<MemoryStatisticsItem, String> labelProvider, final Function<MemoryStatisticsItem, String> toolTipProvider, final Function<MemoryStatisticsItem, Color> colorProvider, final Comparator<MemoryStatisticsItem> comparator) {
        final TableViewerColumn column = new TableViewerColumn((TableViewer)this, 0);
        column.getColumn().setWidth(200);
        column.getColumn().setText(label);
        column.getColumn().setMoveable(true);
        column.setLabelProvider((CellLabelProvider)new OwnerDrawLabelProvider(){

            protected void paint(Event event, Object element) {
                Color color;
                Widget item = event.item;
                event.gc.setAntialias(1);
                Rectangle bounds = ((TableItem)item).getBounds(event.index);
                Color bg = event.gc.getBackground();
                Color fg = event.gc.getForeground();
                Point p = event.gc.stringExtent((String)labelProvider.apply((MemoryStatisticsItem)element));
                int margin = (bounds.height - p.y) / 2;
                int dx = bounds.x + margin;
                if (colorProvider != null && (color = (Color)colorProvider.apply((MemoryStatisticsItem)element)) != null) {
                    event.gc.setBackground(color);
                    if (MemoryStatisticsTableViewer.this.mHighlightedItem == element) {
                        event.gc.fillArc(dx - margin / 2, bounds.y + margin * 2, p.y - margin, p.y - margin, 0, 360);
                    } else {
                        event.gc.fillArc(dx, bounds.y + margin * 2, p.y - margin * 2, p.y - margin * 2, 0, 360);
                    }
                    dx += p.y + margin;
                }
                event.gc.drawString((String)labelProvider.apply((MemoryStatisticsItem)element), dx, bounds.y + margin, true);
                event.gc.setBackground(bg);
                event.gc.setForeground(fg);
            }

            protected void measure(Event event, Object element) {
            }

            protected void erase(Event event, Object element) {
            }

            public String getToolTipText(Object element) {
                if (toolTipProvider == null) {
                    return super.getToolTipText(element);
                }
                return (String)toolTipProvider.apply((MemoryStatisticsItem)element);
            }
        });
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Comparator newComparator = MemoryStatisticsTableViewer.this.mContentProvider.getSortingComparator();
                int newDirection = MemoryStatisticsTableViewer.this.mContentProvider.getSortingDirection();
                if (MemoryStatisticsTableViewer.this.mContentProvider.getSortingComparator() == comparator) {
                    newDirection *= -1;
                } else {
                    newComparator = comparator;
                    newDirection = -1;
                }
                MemoryStatisticsTableViewer.this.getTable().setSortColumn(column.getColumn());
                MemoryStatisticsTableViewer.this.getTable().setSortDirection(newDirection == 1 ? 128 : 1024);
                MemoryStatisticsTableViewer.this.mContentProvider.sort(newComparator, newDirection);
            }
        });
        return column;
    }

    void setHeapSize(long size) {
        this.mHeapSize = size;
    }

    void setPrimaryColumnText(String text) {
        this.mPrimaryColumn.getColumn().setText(text);
    }

    static class MemoryStatisticsContentProvider
    extends ArrayContentProvider
    implements ILazyContentProvider {
        private Comparator<MemoryStatisticsItem> mComparator = Comparator.comparingLong(MemoryStatisticsItem::getMemory);
        private int mDirection = -1;
        private TableViewer mTableViewer;
        private Object[] mItems = new MemoryStatisticsItem[0];

        MemoryStatisticsContentProvider(TableViewer tableViewer) {
            this.mTableViewer = tableViewer;
        }

        public void updateElement(int index) {
            if (index >= this.mItems.length) {
                return;
            }
            this.mTableViewer.replace(this.mItems[index], index);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.mItems = (Object[])newInput;
        }

        void setInput(Object input) {
            Object selected = null;
            if (this.mTableViewer.getTable().getSelection().length > 0) {
                selected = this.mTableViewer.getTable().getSelection()[0].getData();
            }
            Object[] items = this.getElements(input);
            items = Arrays.stream(items).filter(item -> ((MemoryStatisticsItem)item).getSize() > 0).toArray();
            this.mItems = Arrays.copyOf(items, items.length, MemoryStatisticsItem[].class);
            this.sort(this.mComparator, this.mDirection);
            this.mTableViewer.setItemCount(this.mItems.length);
            int index = Arrays.asList(this.mItems).indexOf(selected);
            if (index == -1) {
                this.mTableViewer.getTable().deselectAll();
                return;
            }
            this.mTableViewer.getTable().setSelection(index);
        }

        void sort(Comparator<MemoryStatisticsItem> comparator, int direction) {
            this.mComparator = comparator;
            this.mDirection = direction;
            if (this.mComparator != null) {
                Arrays.sort(this.mItems, (o1, o2) -> comparator.compare((MemoryStatisticsItem)o1, (MemoryStatisticsItem)o2) * direction);
            }
            this.mTableViewer.setInput((Object)this.mItems);
        }

        Comparator<MemoryStatisticsItem> getSortingComparator() {
            return this.mComparator;
        }

        int getSortingDirection() {
            return this.mDirection;
        }
    }
}

