/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.IStateful;
import org.openjdk.jmc.common.IWritableState;
import org.openjdk.jmc.common.util.StateToolkit;
import org.openjdk.jmc.common.util.StatefulState;
import org.openjdk.jmc.flightrecorder.ui.DataPageDescriptor;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.PageExtensionReader;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.pages.MessagePageFactory;
import org.openjdk.jmc.ui.CoreImages;

public class PageManager {
    private static final String ELEMENT_ENCOUNTERED_PAGES = "encounteredPages";
    private static final String ELEMENT_PAGE = "page";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_FACTORY = "factory";
    private static final String ATTRIBUTE_PARENT = "parent";
    private static final String ELEMENT_STATE = "state";
    private static final String RESULT_OVERVIEW_ID = "org.openjdk.jmc.flightrecorder.ui.resultoverview";
    private final List<DataPageDescriptor> rootPages = new ArrayList<DataPageDescriptor>();
    private final Set<String> encounteredPages = new HashSet<String>();
    private final Runnable onChangeCallback;
    private final Map<String, IDataPageFactory> factories;

    PageManager(String state, Runnable onChangeCallback) {
        this.onChangeCallback = onChangeCallback;
        PageExtensionReader extensionReader = new PageExtensionReader();
        this.factories = extensionReader.getFactories();
        if (state != null) {
            try {
                StatefulState child;
                StatefulState persistedState = StatefulState.create((IStateful)StateToolkit.statefulFromXMLString((String)state));
                StatefulState[] statefulStateArray = persistedState.getChildren(ELEMENT_ENCOUNTERED_PAGES);
                int n = statefulStateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    child = statefulStateArray[n2];
                    this.encounteredPages.add(child.getAttribute(ATTRIBUTE_ID));
                    ++n2;
                }
                statefulStateArray = persistedState.getChildren(ELEMENT_PAGE);
                n = statefulStateArray.length;
                n2 = 0;
                while (n2 < n) {
                    child = statefulStateArray[n2];
                    this.rootPages.add(this.createDataPageDescriptor(child));
                    ++n2;
                }
            }
            catch (RuntimeException e) {
                FlightRecorderUI.getDefault().getLogger().log(Level.SEVERE, "Could not load persisted UI state", e);
            }
        }
        this.insertPages(extensionReader.getPages().filter(page -> this.encounteredPages.add(page.getAttribute(ATTRIBUTE_ID))));
    }

    void reset() {
        this.rootPages.clear();
        this.insertPages(new PageExtensionReader().getPages());
    }

    public void resetPage(DataPageDescriptor page) {
        Optional<DataPageDescriptor> original = this.getInitialPages().filter(dpd -> page.getId().equals(dpd.getId())).findFirst();
        page.setPageState(original.map(DataPageDescriptor::getPageState).orElse(null));
    }

    void insertPages(Stream<StatefulState> pages) {
        ArrayList addToParentPages = new ArrayList();
        pages.forEach(page -> {
            String parentId = page.getAttribute(ATTRIBUTE_PARENT);
            DataPageDescriptor dpd = this.createDataPageDescriptor((StatefulState)page);
            if (parentId == null) {
                this.rootPages.add(dpd);
            } else {
                addToParentPages.add(new AbstractMap.SimpleEntry<String, DataPageDescriptor>(parentId, dpd));
            }
        });
        int i = 0;
        while (i < addToParentPages.size()) {
            Map.Entry page2 = (Map.Entry)addToParentPages.get(i);
            String parentId = (String)page2.getKey();
            int pagesHandled = i + 1;
            Optional<DataPageDescriptor> parent = PageManager.findBreadthFirst(this.rootPages::stream, parentId);
            if (!parent.isPresent()) {
                parent = PageManager.findBreadthFirst(() -> addToParentPages.stream().map(Map.Entry::getValue).skip(pagesHandled), parentId);
            }
            this.addChild((DataPageDescriptor)page2.getValue(), parent.orElse(null));
            ++i;
        }
        this.onChangeCallback.run();
    }

    private static Optional<DataPageDescriptor> findBreadthFirst(Supplier<Stream<DataPageDescriptor>> pages, String pageId) {
        if (pages.get().findAny().isPresent()) {
            Optional<DataPageDescriptor> pageWithId = pages.get().filter(p -> p.getId().equals(pageId)).findAny();
            if (!pageWithId.isPresent()) {
                return PageManager.findBreadthFirst(() -> ((Stream)pages.get()).flatMap(p -> p.getChildList().stream()), pageId);
            }
            return pageWithId;
        }
        return Optional.empty();
    }

    public List<DataPageDescriptor> getRootPages() {
        if (!FlightRecorderUI.getDefault().isAnalysisEnabled()) {
            return this.rootPages.stream().filter(rp -> !rp.getId().equals(RESULT_OVERVIEW_ID)).collect(Collectors.toList());
        }
        return this.rootPages;
    }

    public Stream<DataPageDescriptor> getAllPages() {
        return PageManager.flatten(this.rootPages.stream());
    }

    Stream<DataPageDescriptor> getInitialPages() {
        return PageManager.flatten(new PageExtensionReader().getPages().map(this::createDataPageDescriptor));
    }

    private static Stream<DataPageDescriptor> flatten(Stream<DataPageDescriptor> pages) {
        return pages.flatMap(dpd -> dpd.getChildList().isEmpty() ? Stream.of(dpd) : Stream.concat(Stream.of(dpd), PageManager.flatten(dpd.getChildList().stream())));
    }

    String getState() {
        return StateToolkit.toXMLString(state -> {
            for (String id : this.encounteredPages) {
                state.createChild(ELEMENT_ENCOUNTERED_PAGES).putString(ATTRIBUTE_ID, id);
            }
            for (DataPageDescriptor dpd : this.rootPages) {
                PageManager.deepSavePage(dpd, state.createChild(ELEMENT_PAGE), pdp -> true);
            }
        });
    }

    public <T extends IDataPageFactory> DataPageDescriptor createPage(Class<T> factoryType, IStateful stateful) {
        StatefulState state = StatefulState.create((IStateful)stateful);
        Map.Entry factory = this.factories.entrySet().stream().filter(e -> ((IDataPageFactory)e.getValue()).getClass().equals(factoryType)).findAny().get();
        return new DataPageDescriptor(UUID.randomUUID().toString(), (String)factory.getKey(), (IDataPageFactory)factory.getValue(), state);
    }

    private DataPageDescriptor createDataPageDescriptor(StatefulState page) {
        String id = page.getAttribute(ATTRIBUTE_ID);
        String factoryId = page.getAttribute(ATTRIBUTE_FACTORY);
        StatefulState state = page.getChild(ELEMENT_STATE);
        IDataPageFactory factory = this.factories.get(factoryId);
        if (factory == null) {
            factory = new MessagePageFactory(Messages.PAGE_MANAGER_MISSING_IMPLEMENTATION, NLS.bind((String)Messages.PAGE_MANAGER_FACTORY_NOT_INSTALLED, (Object)factoryId), CoreImages.ERROR);
        }
        DataPageDescriptor dpd = new DataPageDescriptor(id, factoryId, factory, state);
        StatefulState[] statefulStateArray = page.getChildren(ELEMENT_PAGE);
        int n = statefulStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            StatefulState child = statefulStateArray[n2];
            this.addChild(this.createDataPageDescriptor(child), dpd);
            ++n2;
        }
        return dpd;
    }

    void deletePage(DataPageDescriptor dpd) {
        this.detachPage(dpd);
        this.onChangeCallback.run();
    }

    static void savePages(Set<DataPageDescriptor> pages, IWritableState toState) {
        for (DataPageDescriptor dpd : pages) {
            DataPageDescriptor parent = dpd.getParent();
            if (parent != null && pages.contains(parent)) continue;
            IWritableState writablePage = toState.createChild(ELEMENT_PAGE);
            PageManager.deepSavePage(dpd, writablePage, pages::contains);
            if (parent == null) continue;
            writablePage.putString(ATTRIBUTE_PARENT, parent.getId());
        }
    }

    private static void savePage(DataPageDescriptor page, IWritableState toState) {
        toState.putString(ATTRIBUTE_ID, page.getId());
        toState.putString(ATTRIBUTE_FACTORY, page.getFactoryId());
        page.getPageState().saveTo(toState.createChild(ELEMENT_STATE));
    }

    private static void deepSavePage(DataPageDescriptor page, IWritableState toState, Predicate<DataPageDescriptor> include) {
        PageManager.savePage(page, toState);
        for (DataPageDescriptor childPage : page.getChildList()) {
            if (!include.test(childPage)) continue;
            PageManager.deepSavePage(childPage, toState.createChild(ELEMENT_PAGE), include);
        }
    }

    void makeSibling(DataPageDescriptor pageToAdd, DataPageDescriptor reference, int stepsFromReference) {
        DataPageDescriptor oldParent = pageToAdd.getParent();
        DataPageDescriptor refParent = reference.getParent();
        List<DataPageDescriptor> refSiblings = this.getChildren(refParent);
        int addAtIndex = refSiblings.indexOf(reference) + stepsFromReference;
        if (Objects.equals(oldParent, refParent) && refSiblings.indexOf(pageToAdd) <= addAtIndex) {
            --addAtIndex;
        }
        addAtIndex = Math.min(Math.max(0, addAtIndex), refSiblings.size());
        this.getChildren(oldParent).remove(pageToAdd);
        refSiblings.add(addAtIndex, pageToAdd);
        pageToAdd.setParent(refParent);
        this.onChangeCallback.run();
    }

    void makeChild(DataPageDescriptor pageToAdd, DataPageDescriptor reference, int stepsFromReference) {
        DataPageDescriptor newParent = reference;
        if (stepsFromReference != 0) {
            List<DataPageDescriptor> refSiblings = this.getChildren(reference.getParent());
            int parentIndex = refSiblings.indexOf(reference) + stepsFromReference;
            newParent = refSiblings.get(Math.min(Math.max(0, parentIndex), refSiblings.size() - 1));
        }
        if (!pageToAdd.equals(newParent)) {
            this.detachPage(pageToAdd);
            this.addChild(pageToAdd, newParent);
        }
        this.onChangeCallback.run();
    }

    public void makeRoot(DataPageDescriptor pageToAdd) {
        this.detachPage(pageToAdd);
        this.addChild(pageToAdd, null);
        this.onChangeCallback.run();
    }

    private void addChild(DataPageDescriptor page, DataPageDescriptor parent) {
        this.getChildren(parent).add(page);
        page.setParent(parent);
    }

    private void detachPage(DataPageDescriptor page) {
        this.getChildren(page.getParent()).remove(page);
        page.setParent(null);
    }

    private List<DataPageDescriptor> getChildren(DataPageDescriptor parent) {
        return parent == null ? this.rootPages : parent.getChildList();
    }
}

