/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.internal;

import java.util.ArrayList;
import java.util.logging.Level;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.openjdk.jmc.rjmx.common.RJMXCorePlugin;
import org.openjdk.jmc.rjmx.common.internal.SyntheticNotificationEntry;

public class SyntheticNotificationMBean
extends RequiredModelMBean {
    public SyntheticNotificationMBean(SyntheticNotificationEntry[] entries) throws RuntimeOperationsException, MBeanException {
        this.initializeModelMBeanInfo(entries);
    }

    private void initializeModelMBeanInfo(SyntheticNotificationEntry[] entries) {
        try {
            this.setModelMBeanInfo(new ModelMBeanInfoSupport(this.getClass().getName(), "Synthetic notification.", null, null, null, this.createNotificationInfo(entries)));
        }
        catch (Exception e) {
            RJMXCorePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not setup synthetic notification MBean!", e);
        }
    }

    private ModelMBeanNotificationInfo[] createNotificationInfo(SyntheticNotificationEntry[] entries) {
        ArrayList<ModelMBeanNotificationInfo> list = new ArrayList<ModelMBeanNotificationInfo>();
        for (SyntheticNotificationEntry entry : entries) {
            ModelMBeanNotificationInfo notificationInfo = this.createNotificationInfo(entry);
            Descriptor descriptorCopy = notificationInfo.getDescriptor();
            descriptorCopy.setField("openType", entry.getNotification().getValueType());
            notificationInfo.setDescriptor(descriptorCopy);
            list.add(notificationInfo);
        }
        return list.toArray(new ModelMBeanNotificationInfo[list.size()]);
    }

    private ModelMBeanNotificationInfo createNotificationInfo(SyntheticNotificationEntry entry) {
        return new ModelMBeanNotificationInfo(new String[]{entry.getNotificationDescriptor().getDataPath()}, Notification.class.getName(), entry.getDescription());
    }
}

