/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.servermodel.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.management.remote.JMXServiceURL;
import org.openjdk.jmc.common.security.ICredentials;
import org.openjdk.jmc.common.security.PersistentCredentials;
import org.openjdk.jmc.common.security.SecurityException;
import org.openjdk.jmc.common.security.SecurityManagerFactory;
import org.openjdk.jmc.common.util.XmlToolkit;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.common.ConnectionDescriptorBuilder;
import org.openjdk.jmc.rjmx.common.IConnectionDescriptor;
import org.openjdk.jmc.rjmx.common.IServerDescriptor;
import org.openjdk.jmc.rjmx.common.internal.ServerDescriptor;
import org.openjdk.jmc.rjmx.servermodel.internal.Server;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ModelPersistence {
    static final String SERVER_CREDENTIALS_FAMILY = "org.openjdk.jmc.rjmx.servermodel.ModelPersistence";
    private static final String XML_COMPONENT_TAG = "server";
    private static final String XML_ELEMENT_SERVER_NAME = "server_name";
    private static final String XML_ELEMENT_SERVER_PATH = "server_path";
    private static final String XML_ELEMENT_JMX_SERVICE_URL = "jmx_service_url";
    private static final String XML_ELEMENT_CREDENTIALS_ID = "credentials_id";
    private static final String XML_ELEMENT_UID = "uid";
    private static final String XML_ROOT_TAG = "server_model";
    private static final Server[] EMPTY = new Server[0];

    ModelPersistence() {
    }

    static synchronized Document export(boolean exportForTransfer, Server ... servers) throws Exception {
        Document doc = XmlToolkit.createNewDocument((String)XML_ROOT_TAG);
        Element repoRoot = doc.getDocumentElement();
        HashSet<String> credentialIds = new HashSet<String>();
        Server[] serverArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            Server s = serverArray[n2];
            ModelPersistence.exportToXml(s, repoRoot, exportForTransfer, credentialIds);
            ++n2;
        }
        if (!exportForTransfer) {
            SecurityManagerFactory.getSecurityManager().clearFamily(SERVER_CREDENTIALS_FAMILY, credentialIds);
        }
        return doc;
    }

    private static void exportToXml(Server me, Element parentNode, boolean exportForTransfer, Set<String> credentialIds) throws SecurityException {
        if (me != null && me.getDiscoveryInfo() == null) {
            String storedCredentialsId;
            Element connectionNode = XmlToolkit.createElement((Element)parentNode, (String)XML_COMPONENT_TAG);
            IServerDescriptor descriptor = me.getServerHandle().getServerDescriptor();
            if (!exportForTransfer) {
                XmlToolkit.setSetting((Element)connectionNode, (String)XML_ELEMENT_UID, (String)descriptor.getGUID());
            }
            XmlToolkit.setSetting((Element)connectionNode, (String)XML_ELEMENT_JMX_SERVICE_URL, (String)me.getConnectionUrl().toString());
            XmlToolkit.setSetting((Element)connectionNode, (String)XML_ELEMENT_SERVER_NAME, (String)descriptor.getDisplayName());
            XmlToolkit.setSetting((Element)connectionNode, (String)XML_ELEMENT_SERVER_PATH, (String)me.getPath());
            if (!exportForTransfer && me.getCredentials() != null && (storedCredentialsId = me.getCredentials().getExportedId()) != null) {
                XmlToolkit.setSetting((Element)connectionNode, (String)XML_ELEMENT_CREDENTIALS_ID, (String)storedCredentialsId);
                credentialIds.add(storedCredentialsId);
            }
        }
    }

    static synchronized Server[] loadSettings(Document doc) throws IOException {
        try {
            Element root = doc.getDocumentElement();
            if (root.getTagName().equals(XML_ROOT_TAG)) {
                return ModelPersistence.loadServersFromXml(root);
            }
            throw new IOException();
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Problem initializing from browser settings", e);
            return EMPTY;
        }
    }

    private static Server loadServerFromXml(Element node) throws MalformedURLException {
        JMXServiceURL url = new JMXServiceURL(XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_JMX_SERVICE_URL, null));
        String guid = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_UID, null);
        String credentialsId = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_CREDENTIALS_ID, null);
        PersistentCredentials c = credentialsId == null ? null : new PersistentCredentials(credentialsId);
        String name = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_SERVER_NAME, null);
        String path = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_SERVER_PATH, null);
        ServerDescriptor sd = new ServerDescriptor(guid, name, null);
        IConnectionDescriptor cd = new ConnectionDescriptorBuilder().url(url).credentials((ICredentials)c).build();
        return new Server(path, url, (ICredentials)c, null, (IServerDescriptor)sd, cd);
    }

    private static Server[] loadServersFromXml(Element node) {
        ArrayList<Server> servers = new ArrayList<Server>();
        for (Element e : XmlToolkit.getChildElementsByTag((Node)node, (String)XML_COMPONENT_TAG)) {
            try {
                servers.add(ModelPersistence.loadServerFromXml(e));
            }
            catch (MalformedURLException e1) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Problem loading server from element " + e, e1);
            }
        }
        return servers.toArray(new Server[servers.size()]);
    }
}

