/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IItemQuery;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.ItemToolkit;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.QuantitiesToolkit;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.unit.RangeContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.ColorToolkit;
import org.openjdk.jmc.common.util.CompositeKey;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.PageManager;
import org.openjdk.jmc.flightrecorder.ui.common.AggregationGrid;
import org.openjdk.jmc.flightrecorder.ui.common.BucketBuilder;
import org.openjdk.jmc.flightrecorder.ui.common.ChartToolTipProvider;
import org.openjdk.jmc.flightrecorder.ui.common.FilterEditor;
import org.openjdk.jmc.flightrecorder.ui.common.ItemHistogram;
import org.openjdk.jmc.flightrecorder.ui.common.ItemList;
import org.openjdk.jmc.flightrecorder.ui.common.ItemRow;
import org.openjdk.jmc.flightrecorder.ui.common.TypeFilterBuilder;
import org.openjdk.jmc.flightrecorder.ui.common.TypeLabelProvider;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.ui.overview.ResultOverview;
import org.openjdk.jmc.flightrecorder.ui.pages.itemhandler.ItemHandlerPage;
import org.openjdk.jmc.flightrecorder.ui.selection.IFilterFlavor;
import org.openjdk.jmc.flightrecorder.ui.selection.IItemStreamFlavor;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStore;
import org.openjdk.jmc.flightrecorder.ui.selection.SelectionStoreActionToolkit;
import org.openjdk.jmc.ui.charts.AWTChartToolkit;
import org.openjdk.jmc.ui.charts.IChartInfoVisitor;
import org.openjdk.jmc.ui.charts.IQuantitySeries;
import org.openjdk.jmc.ui.charts.ISpanSeries;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.QuantitySeries;
import org.openjdk.jmc.ui.charts.RendererToolkit;
import org.openjdk.jmc.ui.charts.SpanRenderer;
import org.openjdk.jmc.ui.charts.SubdividedQuantityRange;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.charts.XYDataRenderer;
import org.openjdk.jmc.ui.charts.XYQuantities;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.ColumnMenusFactory;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.handlers.ActionToolkit;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.ChartTextCanvas;
import org.openjdk.jmc.ui.misc.CompositeToolkit;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.OverlayImageDescriptor;
import org.openjdk.jmc.ui.misc.SWTColorToolkit;

public class DataPageToolkit {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.flightrecorder.ui.common");
    public static final AWTChartToolkit.IColorProvider<IItem> ITEM_COLOR = item -> TypeLabelProvider.getColorOrDefault(item.getType().getIdentifier());
    private static final Map<String, Color> FIELD_COLOR_MAP = new HashMap<String, Color>();
    private static final Map<String, Integer> DEFAULT_COLUMNS_ORDER;
    public static final Color ALLOCATION_COLOR;
    public static final String FORM_TOOLBAR_PAGE_RESULTS = "pageResults";
    public static final String FORM_TOOLBAR_PAGE_SETUP = "pageSetup";
    public static final String FORM_TOOLBAR_PAGE_NAV = "pageNav";
    public static final String RESULT_ACTION_ID = "resultAction";
    public static final Color GC_BASE_COLOR;
    private static final Color VM_OPERATIONS_BASE_COLOR;
    private static final AWTChartToolkit.IColorProvider<RangePayload> GC_COLOR;
    private static final AWTChartToolkit.IColorProvider<RangePayload> APPLICATION_PAUSE_COLOR;
    public static final ImageDescriptor GC_LEGEND_ICON;

    static {
        FIELD_COLOR_MAP.put(JdkAttributes.MACHINE_TOTAL.getIdentifier(), new Color(255, 128, 0));
        FIELD_COLOR_MAP.put(JdkAttributes.JVM_SYSTEM.getIdentifier(), new Color(128, 128, 128));
        FIELD_COLOR_MAP.put(JdkAttributes.JVM_USER.getIdentifier(), new Color(0, 0, 255));
        FIELD_COLOR_MAP.put(JdkAttributes.JVM_TOTAL.getIdentifier(), new Color(64, 64, 191));
        HashMap<String, Integer> columnsOrderMap = new HashMap<String, Integer>();
        columnsOrderMap.put(DataPageToolkit.createColumnId(JfrAttributes.START_TIME), 1);
        columnsOrderMap.put(DataPageToolkit.createColumnId(JfrAttributes.DURATION), 2);
        columnsOrderMap.put(DataPageToolkit.createColumnId(JfrAttributes.END_TIME), 3);
        columnsOrderMap.put(DataPageToolkit.createColumnId(JfrAttributes.EVENT_THREAD), 4);
        DEFAULT_COLUMNS_ORDER = Collections.unmodifiableMap(columnsOrderMap);
        ALLOCATION_COLOR = new Color(64, 144, 230);
        GC_BASE_COLOR = TypeLabelProvider.getColor("jdk.GCPhasePause");
        VM_OPERATIONS_BASE_COLOR = TypeLabelProvider.getColor("jdk.ExecuteVMOperation");
        GC_COLOR = payload -> DataPageToolkit.adjustAlpha(GC_BASE_COLOR, payload.rangeInPixels);
        APPLICATION_PAUSE_COLOR = payload -> DataPageToolkit.adjustAlpha(payload.item.getType().getIdentifier().equals("jdk.GCPhasePause") ? GC_BASE_COLOR : VM_OPERATIONS_BASE_COLOR, payload.rangeInPixels);
        GC_LEGEND_ICON = new OverlayImageDescriptor(SWTColorToolkit.getColorThumbnailDescriptor((RGB)SWTColorToolkit.asRGB((Color)GC_BASE_COLOR)), false, new ImageDescriptor[]{FlightRecorderUI.getDefault().getMCImageDescriptor("trash_overlay.png")});
    }

    public static final AWTChartToolkit.IColorProvider<IItem> getAttributeValueColor(final IAttribute<?> attribute) {
        return new AWTChartToolkit.IColorProvider<IItem>(){

            public Color getColor(IItem item) {
                IMemberAccessor accessor = attribute.getAccessor(ItemToolkit.getItemType((IItem)item));
                Object attributeValue = accessor != null ? accessor.getMember((Object)item) : null;
                return attributeValue != null ? TypeLabelProvider.getColorOrDefault(String.valueOf(attribute.getIdentifier()) + "=" + attributeValue + "(" + item.getType().getIdentifier() + ")") : ITEM_COLOR.getColor((Object)item);
            }
        };
    }

    public static Color getFieldColor(String fieldId) {
        return FIELD_COLOR_MAP.getOrDefault(fieldId, ColorToolkit.getDistinguishableColor((Object)fieldId));
    }

    public static Color getFieldColor(IAttribute<?> attribute) {
        return DataPageToolkit.getFieldColor(attribute.getIdentifier());
    }

    public static TableSettings createTableSettingsByOrderByAndColumnsWithDefaultOrdering(String orderBy, Collection<TableSettings.ColumnSettings> columns) {
        Stream<TableSettings.ColumnSettings> defaultOrderColumns = columns.stream().filter(c -> DEFAULT_COLUMNS_ORDER.containsKey(c.getId())).filter(c -> c.isHidden() == false).sorted((c1, c2) -> Integer.compare(DEFAULT_COLUMNS_ORDER.get(c1.getId()), DEFAULT_COLUMNS_ORDER.get(c2.getId())));
        Stream<TableSettings.ColumnSettings> naturalOrderColumns = columns.stream().filter(c -> !DEFAULT_COLUMNS_ORDER.containsKey(c.getId())).sorted((c1, c2) -> String.CASE_INSENSITIVE_ORDER.compare(c1.getId(), c2.getId()));
        List resultColumns = Stream.concat(defaultOrderColumns, naturalOrderColumns).collect(Collectors.toList());
        return new TableSettings(orderBy, resultColumns);
    }

    public static TableSettings createTableSettingsByAllAndVisibleColumns(Collection<String> allColumns, Collection<String> visibleColumns) {
        ArrayList<TableSettings.ColumnSettings> defaultListCols = new ArrayList<TableSettings.ColumnSettings>();
        for (String columnId : allColumns) {
            defaultListCols.add(new TableSettings.ColumnSettings(columnId, Boolean.valueOf(!visibleColumns.contains(columnId)), null, null));
        }
        return DataPageToolkit.createTableSettingsByOrderByAndColumnsWithDefaultOrdering(null, defaultListCols);
    }

    private static String createColumnId(IAttribute<?> attr) {
        return attr.getIdentifier() + ":" + attr.getContentType().getIdentifier();
    }

    public static IAction createAttributeCheckAction(IAttribute<?> attribute, Consumer<Boolean> onChange) {
        return DataPageToolkit.createCheckAction(attribute.getName(), attribute.getDescription(), attribute.getIdentifier(), DataPageToolkit.getFieldColor(attribute), onChange);
    }

    public static IAction createTypeCheckAction(String actionId, String typeId, String name, String description, Consumer<Boolean> onChange) {
        return DataPageToolkit.createCheckAction(name, description, actionId, TypeLabelProvider.getColorOrDefault(typeId), onChange);
    }

    public static IAction createAggregatorCheckAction(IAggregator<?, ?> aggregator, String id, Color color, Consumer<Boolean> onChange) {
        return DataPageToolkit.createCheckAction(aggregator.getName(), aggregator.getDescription(), id, color, onChange);
    }

    public static IAction createCheckAction(String name, String description, String id, Color color, Consumer<Boolean> onChange) {
        return DataPageToolkit.createCheckAction(name, description, id, SWTColorToolkit.getColorThumbnailDescriptor((RGB)SWTColorToolkit.asRGB((Color)color)), onChange);
    }

    public static IAction createCheckAction(String name, String description, String id, ImageDescriptor icon, Consumer<Boolean> onChange) {
        return ActionToolkit.checkAction(onChange, (String)name, (String)description, (ImageDescriptor)icon, (String)id);
    }

    public static Optional<IXDataRenderer> buildLinesRow(String title, String description, IItemCollection items, boolean fill, IItemQuery query, Predicate<IAttribute<IQuantity>> attributeFilter, IQuantity includeLow, IQuantity includeHigh) {
        XYDataRenderer renderer = includeHigh != null ? new XYDataRenderer(includeLow, includeHigh, true, title, description) : new XYDataRenderer(includeLow, title, description);
        IItemCollection filteredItemsSupplier = items.apply(query.getFilter());
        Stream<IAttribute<IQuantity>> attributes = DataPageToolkit.getQuantityAttributes(query);
        if (attributeFilter != null) {
            attributes = attributes.filter(attributeFilter);
        }
        if (DataPageToolkit.addEndTimeLines(renderer, filteredItemsSupplier, fill, attributes)) {
            return Optional.of(new ItemRow(title, description, (IXDataRenderer)renderer, filteredItemsSupplier));
        }
        return Optional.empty();
    }

    public static Stream<IAttribute<IQuantity>> getQuantityAttributes(IItemQuery q) {
        return q.getAttributes().stream();
    }

    public static void setChart(ChartCanvas canvas, XYChart chart, Consumer<IItemCollection> selectionListener) {
        DataPageToolkit.setChart(canvas, chart, selectionListener, null);
    }

    public static void setChart(ChartTextCanvas canvas, XYChart chart, Consumer<IItemCollection> selectionListener) {
        DataPageToolkit.setChart(canvas, chart, selectionListener, null);
    }

    public static void setChart(final ChartCanvas canvas, final XYChart chart, Consumer<IItemCollection> selectionListener, Consumer<IRange<IQuantity>> selectRangeConsumer) {
        IMenuManager contextMenu = canvas.getContextMenu();
        contextMenu.removeAll();
        canvas.getContextMenu().add((IAction)new Action(Messages.CHART_ZOOM_TO_SELECTED_RANGE){

            public void run() {
                IQuantity selectionStart = chart.getSelectionStart();
                IQuantity selectionEnd = chart.getSelectionEnd();
                if (selectionStart == null || selectionEnd == null) {
                    chart.clearVisibleRange();
                } else {
                    chart.setVisibleRange(selectionStart, selectionEnd);
                }
                canvas.redrawChart();
            }
        });
        canvas.setSelectionListener(() -> {
            selectionListener.accept(ItemRow.getRangeSelection(chart, (ICanonicalAccessorFactory<IRange<IQuantity>>)JfrAttributes.LIFETIME));
            IQuantity start = chart.getSelectionStart();
            IQuantity end = chart.getSelectionEnd();
            if (selectRangeConsumer != null) {
                selectRangeConsumer.accept(start != null && end != null ? QuantityRange.createWithEnd((IQuantity)start, (IQuantity)end) : null);
            }
        });
        canvas.setChart(chart);
    }

    public static void setChart(final ChartTextCanvas canvas, final XYChart chart, Consumer<IItemCollection> selectionListener, Consumer<IRange<IQuantity>> selectRangeConsumer) {
        IMenuManager contextMenu = canvas.getContextMenu();
        contextMenu.removeAll();
        canvas.getContextMenu().add((IAction)new Action(Messages.CHART_ZOOM_TO_SELECTED_RANGE){

            public void run() {
                IQuantity selectionStart = chart.getSelectionStart();
                IQuantity selectionEnd = chart.getSelectionEnd();
                if (selectionStart == null || selectionEnd == null) {
                    chart.clearVisibleRange();
                } else {
                    chart.setVisibleRange(selectionStart, selectionEnd);
                }
                canvas.redrawChartText();
            }
        });
        canvas.setSelectionListener(() -> {
            selectionListener.accept(ItemRow.getRangeSelection(chart, (ICanonicalAccessorFactory<IRange<IQuantity>>)JfrAttributes.LIFETIME));
            IQuantity start = chart.getSelectionStart();
            IQuantity end = chart.getSelectionEnd();
            if (selectRangeConsumer != null) {
                selectRangeConsumer.accept(start != null && end != null ? QuantityRange.createWithEnd((IQuantity)start, (IQuantity)end) : null);
            }
        });
        canvas.setChart(chart);
    }

    public static void setChart(ChartCanvas canvas, XYChart chart, IAttribute<IQuantity> selectionAttribute, Consumer<IItemCollection> selectionListener) {
        IMenuManager contextMenu = canvas.getContextMenu();
        contextMenu.removeAll();
        canvas.setSelectionListener(() -> selectionListener.accept(ItemRow.getSelection(chart, (ICanonicalAccessorFactory<IQuantity>)selectionAttribute)));
        canvas.setChart(chart);
    }

    private static ISpanSeries<RangePayload> rangeSeries(final IItemCollection events, final IAttribute<IQuantity> startAttribute, final IAttribute<IQuantity> endAttribute) {
        return new ISpanSeries<RangePayload>(){

            public XYQuantities<RangePayload[]> getQuantities(SubdividedQuantityRange xBucketRange) {
                SubdividedQuantityRange xRange = xBucketRange.copyWithPixelSubdividers();
                ArrayList spanningPixels = new ArrayList();
                RangePayload[] pixelBuckets = new RangePayload[xRange.getNumSubdividers()];
                events.forEach(is -> {
                    IMemberAccessor startAccessor = startAttribute.getAccessor(is.getType());
                    IMemberAccessor endAccessor = endAttribute.getAccessor(is.getType());
                    is.forEach(item -> {
                        IQuantity start = (IQuantity)startAccessor.getMember(item);
                        IQuantity end = (IQuantity)endAccessor.getMember(item);
                        int xPos = xRange.getFloorSubdivider(start);
                        int endPos = xRange.getFloorSubdivider(end);
                        if (xPos < pixelBuckets.length && endPos >= 0) {
                            double rangeInPixels = xRange.getPixel(end) - xRange.getPixel(start);
                            if (xPos != endPos) {
                                spanningPixels.add(new RangePayload((IItem)item, start, end, rangeInPixels));
                            } else if (pixelBuckets[xPos] == null) {
                                rangePayloadArray[xPos] = new RangePayload((IItem)item, start, end, rangeInPixels);
                            } else {
                                pixelBuckets[xPos].combineWith((IItem)item, start, end, rangeInPixels);
                            }
                        }
                    });
                });
                RangePayload[] sorted = (RangePayload[])Stream.concat(Stream.of(pixelBuckets).filter(Objects::nonNull), spanningPixels.stream()).sorted(Comparator.comparing(r -> r.start)).toArray(RangePayload[]::new);
                List starts = Stream.of(sorted).map(r -> r.start).collect(Collectors.toList());
                List ends = Stream.of(sorted).map(r -> r.end).collect(Collectors.toList());
                return XYQuantities.create((Object)sorted, starts, ends, (SubdividedQuantityRange)xRange);
            }

            public IQuantity getStartX(RangePayload payload) {
                return payload.start;
            }
        };
    }

    private static Color adjustAlpha(Color color, double fraction) {
        return ColorToolkit.withAlpha((Color)color, (int)Math.min(200, (int)((Math.max(0.0, fraction) + 0.15) * 255.0)));
    }

    public static ItemRow buildGcPauseRow(IItemCollection items) {
        IItemCollection pauseEvents = items.apply(JdkFilters.GC_PAUSE);
        ISpanSeries<RangePayload> gcBackdrop = DataPageToolkit.rangeSeries(pauseEvents, (IAttribute<IQuantity>)JfrAttributes.START_TIME, (IAttribute<IQuantity>)JfrAttributes.END_TIME);
        return new ItemRow(SpanRenderer.build(gcBackdrop, GC_COLOR), pauseEvents);
    }

    public static ItemRow buildApplicationPauseRow(IItemCollection items) {
        IItemFilter vmOperationPauseFilter = ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.VM_OPERATIONS, ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.SAFEPOINT, (Object)true)});
        IItemCollection applicationPauses = items.apply(ItemFilters.or((IItemFilter[])new IItemFilter[]{JdkFilters.GC_PAUSE, JdkFilters.SAFE_POINTS, vmOperationPauseFilter}));
        ISpanSeries<RangePayload> pausesSeries = DataPageToolkit.rangeSeries(applicationPauses, (IAttribute<IQuantity>)JfrAttributes.START_TIME, (IAttribute<IQuantity>)JfrAttributes.END_TIME);
        return new ItemRow(SpanRenderer.build(pausesSeries, APPLICATION_PAUSE_COLOR), applicationPauses);
    }

    public static IXDataRenderer buildTimestampHistogramRenderer(IItemCollection items, IAggregator<IQuantity, ?> aggregator, IAttribute<IQuantity> timestampAttribute, Color color) {
        IQuantitySeries aggregatorSeries = BucketBuilder.aggregatorSeries(items, aggregator, timestampAttribute);
        XYDataRenderer renderer = new XYDataRenderer((IQuantity)DataPageToolkit.getKindOfQuantity(aggregator).getDefaultUnit().quantity(0L), aggregator.getName(), aggregator.getDescription());
        renderer.addBarChart(aggregator.getName(), aggregatorSeries, color);
        return renderer;
    }

    public static IXDataRenderer buildTimestampHistogramRenderer(IItemCollection items, IAggregator<IQuantity, ?> aggregator, Color color) {
        return DataPageToolkit.buildTimestampHistogramRenderer(items, aggregator, (IAttribute<IQuantity>)JfrAttributes.CENTER_TIME, color);
    }

    public static ItemRow buildTimestampHistogram(String title, String description, IItemCollection items, IAggregator<IQuantity, ?> aggregator, IAttribute<IQuantity> timestampAttribute, Color color) {
        return new ItemRow(title, description, DataPageToolkit.buildTimestampHistogramRenderer(items, aggregator, timestampAttribute, color), items);
    }

    public static ItemRow buildTimestampHistogram(String title, String description, IItemCollection items, IAggregator<IQuantity, ?> aggregator, Color color) {
        return new ItemRow(title, description, DataPageToolkit.buildTimestampHistogramRenderer(items, aggregator, color), items);
    }

    public static ItemHistogram createDistinctItemsTable(Composite parent, IItemCollection items, IItemQuery query, TableSettings settings) {
        ItemHistogram.CompositeKeyHistogramBuilder histogramBuilder = new ItemHistogram.CompositeKeyHistogramBuilder();
        for (IAttribute attribute : query.getAttributes()) {
            histogramBuilder.addKeyColumn(attribute);
        }
        for (IAggregator aggregator : query.getAggregators()) {
            histogramBuilder.addColumn(aggregator.getName(), aggregator);
        }
        ItemHistogram table = histogramBuilder.buildWithoutBorder(parent, settings);
        return table;
    }

    public static IBaseLabelProvider createTableHighlightProvider(final Pattern highlightPattern, final boolean isWarning) {
        return new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                org.eclipse.swt.graphics.Color color = isWarning ? new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), 240, 120, 140) : new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), 255, 144, 4);
                String text = this.getText(cell.getElement(), cell.getColumnIndex());
                Matcher matcher = highlightPattern.matcher(text);
                if (matcher.find()) {
                    cell.getViewerRow().setBackground(0, color);
                    cell.getViewerRow().setBackground(1, color);
                }
                cell.setText(text);
                super.update(cell);
            }

            private String getText(Object element, int index) {
                Object key = AggregationGrid.getKey(element);
                Object[] keyElements = ((CompositeKey)key).getKeyElements();
                return keyElements[index].toString();
            }
        };
    }

    public static void addContextMenus(IPageContainer pc, ItemHistogram h, String selectionName, IAction ... extraActions) {
        MCContextMenuManager mm = MCContextMenuManager.create((Control)h.getManager().getViewer().getControl());
        ColumnMenusFactory.addDefaultMenus((ColumnManager)h.getManager(), (MCContextMenuManager)mm);
        SelectionStoreActionToolkit.addSelectionStoreActions(pc.getSelectionStore(), h, selectionName, (IContributionManager)mm);
        IAction[] iActionArray = extraActions;
        int n = extraActions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            mm.add(action);
            ++n2;
        }
    }

    public static IXDataRenderer buildSizeRow(String title, String description, IItemCollection items, IAggregator<IQuantity, ?> a, Color color, AWTChartToolkit.IColorProvider<IItem> cp) {
        return RendererToolkit.layers((IXDataRenderer[])new IXDataRenderer[]{DataPageToolkit.buildSpanRenderer(items, cp), DataPageToolkit.buildTimestampHistogram(title, description, items, a, color)});
    }

    public static ItemRow buildDurationHistogram(String title, String description, IItemCollection items, IAggregator<IQuantity, ?> a, Color color) {
        IQuantitySeries allocationSeries = BucketBuilder.aggregatorSeries(items, a, (IAttribute<IQuantity>)JfrAttributes.DURATION);
        XYDataRenderer renderer = new XYDataRenderer((IQuantity)DataPageToolkit.getKindOfQuantity(a).getDefaultUnit().quantity(0L), title, description);
        renderer.addBarChart(a.getName(), allocationSeries, color);
        return new ItemRow(title, description, (IXDataRenderer)renderer, items);
    }

    public static ItemRow buildSizeHistogram(String title, String description, IItemCollection items, IAggregator<IQuantity, ?> a, Color color, IAttribute<IQuantity> attribute) {
        IQuantitySeries allocationSeries = BucketBuilder.aggregatorSeries(items, a, (IAttribute<IQuantity>)JdkAttributes.IO_SIZE);
        XYDataRenderer renderer = new XYDataRenderer((IQuantity)DataPageToolkit.getKindOfQuantity(a).getDefaultUnit().quantity(0L), title, description);
        renderer.addBarChart(a.getName(), allocationSeries, color);
        return new ItemRow(title, description, (IXDataRenderer)renderer, items);
    }

    public static IRange<IQuantity> buildSizeRange(IItemCollection items, boolean isSocket) {
        IQuantity end = null;
        end = isSocket ? (IQuantity)QuantitiesToolkit.maxPresent((Comparable)((IQuantity)items.getAggregate(JdkAggregators.SOCKET_READ_LARGEST)), (Comparable)((IQuantity)items.getAggregate(JdkAggregators.SOCKET_WRITE_LARGEST))) : (IQuantity)QuantitiesToolkit.maxPresent((Comparable)((IQuantity)items.getAggregate(JdkAggregators.FILE_READ_LARGEST)), (Comparable)((IQuantity)items.getAggregate(JdkAggregators.FILE_WRITE_LARGEST)));
        end = end == null ? UnitLookup.BYTE.quantity(1024L) : end;
        return QuantityRange.createWithEnd((IQuantity)UnitLookup.BYTE.quantity(0L), (IQuantity)end);
    }

    public static IXDataRenderer buildSpanRenderer(IItemCollection pathItems, AWTChartToolkit.IColorProvider<IItem> cp) {
        ISpanSeries dataSeries = QuantitySeries.max((IItemCollection)pathItems, (IAttribute)JfrAttributes.START_TIME, (IAttribute)JfrAttributes.END_TIME);
        return SpanRenderer.withBoundaries((ISpanSeries)dataSeries, cp);
    }

    public static boolean addEndTimeLines(XYDataRenderer renderer, IItemCollection items, boolean fill, Stream<IAttribute<IQuantity>> yAttributes) {
        Iterator ii = items.iterator();
        if (ii.hasNext()) {
            IType type;
            IItemIterable itemStream = (IItemIterable)ii.next();
            return yAttributes.peek(arg_0 -> DataPageToolkit.lambda$11(renderer, itemStream, type = itemStream.getType(), fill, arg_0)).mapToLong(a -> 1L).sum() > 0L;
        }
        return false;
    }

    public static void addEndTimeLine(XYDataRenderer renderer, Iterator<? extends IItem> items, IType<IItem> type, IAttribute<IQuantity> yAttribute, boolean fill) {
        IQuantitySeries<?> qs = DataPageToolkit.buildQuantitySeries(items, type, (IAttribute<IQuantity>)JfrAttributes.END_TIME, yAttribute);
        renderer.addLineChart(yAttribute.getName(), qs, DataPageToolkit.getFieldColor(yAttribute), fill);
    }

    public static IQuantitySeries<?> buildQuantitySeries(Iterator<? extends IItem> items, IType<IItem> type, IAttribute<IQuantity> xAttribute, IAttribute<IQuantity> yAttribute) {
        IMemberAccessor yAccessor = yAttribute.getAccessor(type);
        if (yAccessor == null) {
            throw new RuntimeException(String.valueOf(yAttribute.getIdentifier()) + " is not an attribute for " + type.getIdentifier());
        }
        return DataPageToolkit.buildQuantitySeries(items, type, xAttribute, (IMemberAccessor<? extends IQuantity, IItem>)yAccessor);
    }

    public static IQuantitySeries<?> buildQuantitySeries(Iterator<? extends IItem> items, IType<IItem> type, IAttribute<IQuantity> xAttribute, IMemberAccessor<? extends IQuantity, IItem> yAccessor) {
        IMemberAccessor xAccessor = xAttribute.getAccessor(type);
        return QuantitySeries.all(items, (IMemberAccessor)xAccessor, yAccessor);
    }

    public static void createChartTooltip(ChartCanvas chart) {
        DataPageToolkit.createChartTooltip(chart, ChartToolTipProvider::new);
    }

    public static void createChartTimestampTooltip(ChartCanvas chart) {
        DataPageToolkit.createChartTooltip(chart, JfrAttributes.START_TIME, JfrAttributes.END_TIME, JfrAttributes.DURATION, JfrAttributes.EVENT_TYPE, JfrAttributes.EVENT_STACKTRACE);
    }

    public static void createChartTooltip(ChartCanvas chart, IAttribute<?> ... excludedAttributes) {
        DataPageToolkit.createChartTooltip(chart, new HashSet(Arrays.asList(excludedAttributes)));
    }

    public static void createChartTooltip(ChartCanvas chart, final Set<IAttribute<?>> excludedAttributes) {
        DataPageToolkit.createChartTooltip(chart, () -> new ChartToolTipProvider(){

            @Override
            protected Stream<IAttribute<?>> getAttributeStream(IType<IItem> type) {
                return type.getAttributes().stream().filter(a -> !excludedAttributes.contains(a));
            }
        });
    }

    public static void createChartTooltip(final ChartCanvas chart, final Supplier<ChartToolTipProvider> toolTipProviderSupplier) {
        new ToolTip((Control)chart){
            String html;
            Map<String, Image> images;

            protected boolean shouldCreateToolTip(Event event) {
                ChartToolTipProvider provider = (ChartToolTipProvider)toolTipProviderSupplier.get();
                chart.infoAt((IChartInfoVisitor)provider, event.x, event.y);
                this.html = provider.getHTML();
                this.images = provider.getImages();
                return this.html != null;
            }

            protected Composite createToolTipContentArea(Event event, Composite parent) {
                FormText formText = CompositeToolkit.createInfoFormText((Composite)parent);
                for (Map.Entry<String, Image> imgEntry : this.images.entrySet()) {
                    formText.setImage(imgEntry.getKey(), imgEntry.getValue());
                }
                formText.setText(this.html, true, false);
                return formText;
            }
        };
    }

    private static KindOfQuantity<?> getKindOfQuantity(IAggregator<IQuantity, ?> a) {
        IType ct = a.getValueType();
        return (KindOfQuantity)ct;
    }

    public static Form createForm(Composite parent, FormToolkit toolkit, String title, Image img) {
        Form form = toolkit.createForm(parent);
        form.setText(title.replaceAll("&", "&&"));
        form.setImage(img);
        toolkit.decorateFormHeading(form);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 15;
        fillLayout.marginWidth = 8;
        form.getBody().setLayout((Layout)fillLayout);
        form.getToolBarManager().add((IContributionItem)new Separator(FORM_TOOLBAR_PAGE_RESULTS));
        form.getToolBarManager().add((IContributionItem)new Separator(FORM_TOOLBAR_PAGE_SETUP));
        form.getToolBarManager().add((IContributionItem)new Separator(FORM_TOOLBAR_PAGE_NAV));
        return form;
    }

    public static void addRuleResultAction(Form form, IPageContainer pageContainer, Supplier<String> tooltip, String[] topics) {
        if (topics == null || topics.length == 0 || !FlightRecorderUI.getDefault().isAnalysisEnabled()) {
            return;
        }
        ImageDescriptor icon = DataPageToolkit.getResultIcon(pageContainer.getRuleManager().getMaxSeverity(topics));
        ShowResultAction resultAction = new ShowResultAction(Messages.RULES_SHOW_RESULTS_ACTION, 1, icon, tooltip, pageContainer, topics);
        resultAction.setId(RESULT_ACTION_ID);
        form.getToolBarManager().appendToGroup(FORM_TOOLBAR_PAGE_RESULTS, (IAction)resultAction);
        form.getToolBarManager().update(true);
        form.addDisposeListener(e -> resultAction.removeListeners());
    }

    private static ImageDescriptor getResultIcon(Severity severity) {
        switch (severity) {
            case OK: {
                return ResultOverview.ICON_OK;
            }
            case INFO: {
                return ResultOverview.ICON_INFO;
            }
            case WARNING: {
                return ResultOverview.ICON_WARNING;
            }
            case IGNORE: {
                return ResultOverview.ICON_IGNORE;
            }
            case NA: {
                return ResultOverview.ICON_NA;
            }
        }
        return null;
    }

    public static IAction disabledAction(String text) {
        Action disabledAction = new Action(text){

            public boolean isEnabled() {
                return false;
            }
        };
        disabledAction.setId(text);
        return disabledAction;
    }

    public static FilterEditor buildFilterSelector(Composite parent, IItemFilter filter, final IItemCollection items, final Supplier<Stream<SelectionStore.SelectionStoreEntry>> selections, Consumer<IItemFilter> onSelect, boolean hasBorder) {
        final Supplier<Collection<IAttribute<?>>> attributeSupplier = () -> DataPageToolkit.getPersistableAttributes(DataPageToolkit.getAttributes(filter != null ? items.apply(filter) : items)).collect(Collectors.toList());
        FilterEditor.AttributeValueProvider valueSupplier = new FilterEditor.AttributeValueProvider(){

            @Override
            public <V> V defaultValue(ICanonicalAccessorFactory<V> attribute) {
                return DataPageToolkit.findValueForFilter(items, attribute);
            }
        };
        final FilterEditor editor = new FilterEditor(parent, onSelect, filter, attributeSupplier, valueSupplier, TypeLabelProvider::getColorOrDefault, hasBorder ? 2048 : 0);
        MenuManager addFromSelectionPredicate = new MenuManager(Messages.FILTER_ADD_FROM_SELECTION);
        editor.getContextMenu().prependToGroup("group.new", (IContributionItem)addFromSelectionPredicate);
        addFromSelectionPredicate.setRemoveAllWhenShown(true);
        addFromSelectionPredicate.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ((Stream)selections.get()).forEach(entry -> {
                    MenuManager selectionFlavors = new MenuManager(entry.getName());
                    entry.getSelection().getFlavors(editor.getFilter(), items, null).filter(f -> f instanceof IFilterFlavor).forEach(flavor -> selectionFlavors.add((IAction)new Action(flavor.getName(), (IItemStreamFlavor)flavor){
                        private final /* synthetic */ IItemStreamFlavor val$flavor;
                        {
                            this.val$flavor = iItemStreamFlavor;
                            super($anonymous0);
                        }

                        public void run() {
                            editor.addRoot(((IFilterFlavor)this.val$flavor).getFilter());
                        }
                    }));
                    if (!selectionFlavors.isEmpty()) {
                        if (manager.find(Messages.FILTER_NO_SELECTION_AVAILABLE) != null) {
                            manager.remove(Messages.FILTER_NO_SELECTION_AVAILABLE);
                        }
                        manager.add((IContributionItem)selectionFlavors);
                    } else {
                        manager.add(DataPageToolkit.disabledAction(Messages.FILTER_NO_SELECTION_AVAILABLE));
                    }
                });
            }
        });
        final MenuManager addAttributeValuePredicate = new MenuManager(Messages.FILTER_ADD_FROM_ATTRIBUTE);
        editor.getContextMenu().prependToGroup("group.new", (IContributionItem)addAttributeValuePredicate);
        addAttributeValuePredicate.setRemoveAllWhenShown(true);
        addAttributeValuePredicate.addMenuListener(new IMenuListener(){
            Collection<IAttribute<?>> attributes;

            public void menuAboutToShow(IMenuManager manager) {
                if (this.attributes == null) {
                    this.attributes = (Collection)attributeSupplier.get();
                }
                if (!this.attributes.isEmpty()) {
                    if (manager.find(Messages.FILTER_NO_ATTRIBUTE_AVAILABLE) != null) {
                        manager.remove(Messages.FILTER_NO_ATTRIBUTE_AVAILABLE);
                    }
                    this.attributes.stream().distinct().sorted((a1, a2) -> a1.getName().compareTo(a2.getName())).forEach(attr -> addAttributeValuePredicate.add((IAction)new Action(attr.getName(), (IAttribute)attr, editor){
                        private final /* synthetic */ IAttribute val$attr;
                        private final /* synthetic */ FilterEditor val$editor;
                        {
                            this.val$attr = iAttribute;
                            this.val$editor = filterEditor;
                            super($anonymous0);
                        }

                        public void run() {
                            IItemFilter filter = DataPageToolkit.createDefaultFilter(items, this.val$attr);
                            this.val$editor.addRoot(filter);
                        }
                    }));
                } else {
                    manager.add(DataPageToolkit.disabledAction(Messages.FILTER_NO_ATTRIBUTE_AVAILABLE));
                }
            }
        });
        return editor;
    }

    private static Stream<IAttribute<?>> getAttributes(IItemCollection items) {
        return items.stream().filter(IItemIterable::hasItems).flatMap(is -> is.getType().getAttributes().stream());
    }

    public static Stream<IAttribute<?>> getPersistableAttributes(Stream<IAttribute<?>> attributes) {
        return attributes.map(a -> a.equals(JfrAttributes.EVENT_THREAD) ? JdkAttributes.EVENT_THREAD_NAME : a).flatMap(a -> a.equals(JfrAttributes.EVENT_STACKTRACE) ? Stream.of(JdkAttributes.STACK_TRACE_STRING, JdkAttributes.STACK_TRACE_TOP_METHOD_STRING, JdkAttributes.STACK_TRACE_TOP_CLASS_STRING, JdkAttributes.STACK_TRACE_TOP_PACKAGE, JdkAttributes.STACK_TRACE_BOTTOM_METHOD_STRING) : Stream.of(a)).map(a -> a.equals(JdkAttributes.COMPILER_METHOD) ? JdkAttributes.COMPILER_METHOD_STRING : a).map(a -> a.equals(JdkAttributes.REC_SETTING_FOR) ? JdkAttributes.REC_SETTING_FOR_NAME : a).map(a -> a.equals(JdkAttributes.CLASS_DEFINING_CLASSLOADER) ? JdkAttributes.CLASS_DEFINING_CLASSLOADER_STRING : a).map(a -> a.equals(JdkAttributes.CLASS_INITIATING_CLASSLOADER) ? JdkAttributes.CLASS_INITIATING_CLASSLOADER_STRING : a).map(a -> a.equals(JdkAttributes.PARENT_CLASSLOADER) ? JdkAttributes.PARENT_CLASSLOADER_STRING : a).map(a -> a.equals(JdkAttributes.CLASSLOADER) ? JdkAttributes.CLASSLOADER_STRING : a).filter(a -> a.equals(JfrAttributes.EVENT_TYPE) || a.getContentType() instanceof RangeContentType || a.getContentType().getPersister() != null).distinct();
    }

    private static <V> V findValueForFilter(IItemCollection items, ICanonicalAccessorFactory<V> attribute) {
        IItem firstItem = items.stream().filter(is -> is.getType().hasAttribute(attribute)).flatMap(iterable -> iterable.stream()).filter(i -> attribute.getAccessor(i.getType()).getMember(i) != null).findFirst().orElse(null);
        if (firstItem != null) {
            IMemberAccessor accessor = attribute.getAccessor(firstItem.getType());
            return (V)accessor.getMember((Object)firstItem);
        }
        if (UnitLookup.PLAIN_TEXT.equals(attribute.getContentType())) {
            return (V)"";
        }
        if (attribute.getContentType() instanceof KindOfQuantity) {
            return (V)((KindOfQuantity)attribute.getContentType()).getDefaultUnit().quantity(0L);
        }
        return null;
    }

    private static <V> IItemFilter createDefaultFilter(IItemCollection items, ICanonicalAccessorFactory<V> attribute) {
        V value = DataPageToolkit.findValueForFilter(items, attribute);
        if (value == null) {
            return ItemFilters.hasAttribute(attribute);
        }
        if (attribute.equals((Object)JfrAttributes.EVENT_TYPE)) {
            return ItemFilters.type((String)((IType)value).getIdentifier());
        }
        return ItemFilters.equals(attribute, value);
    }

    public static void addRenameAction(final Form form, final IPageContainer editor) {
        form.getMenuManager().add((IAction)new Action(Messages.PAGE_RENAME_MENU_ACTION){

            public void run() {
                InputDialog dialog = new InputDialog(form.getShell(), Messages.PAGE_RENAME_DIALOG_TITLE, Messages.PAGE_RENAME_DIALOG_MESSAGE, form.getText(), null);
                if (dialog.open() == 0) {
                    form.setText(dialog.getValue());
                    editor.currentPageRefresh();
                }
            }
        });
    }

    public static void addIconChangeAction(final Form form, final IPageContainer editor, final Consumer<Image> newIconConsumer) {
        form.getMenuManager().add((IAction)new Action(Messages.PAGE_CHANGE_ICON_MENU_ACTION){

            public void run() {
                WizardDialog dialog = new WizardDialog(form.getShell(), (IWizard)new IconChangeWizard(form.getImage(), newIconConsumer));
                dialog.open();
                editor.currentPageRefresh();
            }
        });
    }

    public static ItemList createSimpleItemList(Composite parent, ItemList.ItemListBuilder listBuilder, IPageContainer pageContainer, TableSettings tableSettings, String selectionName) {
        ItemList list = listBuilder.build(parent, tableSettings);
        ColumnViewer viewer = list.getManager().getViewer();
        MCContextMenuManager mm = MCContextMenuManager.create((Control)viewer.getControl());
        list.setMenuManager(mm);
        ColumnMenusFactory.addDefaultMenus((ColumnManager)list.getManager(), (MCContextMenuManager)mm);
        viewer.addSelectionChangedListener(e -> pageContainer.showSelection(ItemCollectionToolkit.build(list.getSelection().get())));
        if (selectionName != null) {
            SelectionStoreActionToolkit.addSelectionStoreActions(pageContainer.getSelectionStore(), list, selectionName, (IContributionManager)mm);
        }
        return list;
    }

    public static void addTabItem(CTabFolder tabFolder, Control section, String name) {
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setControl(section);
        tabItem.setText(name);
    }

    public static TypeFilterBuilder buildEventTypeTree(Composite parent, FormToolkit toolkit, Runnable onChange, boolean checkbox) {
        Composite treeComposite = new Composite(parent, 0);
        treeComposite.setLayout((Layout)new GridLayout());
        toolkit.adapt(treeComposite);
        Label caption = toolkit.createLabel(treeComposite, Messages.EVENT_TYPE_TREE_TITLE);
        caption.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        caption.setLayoutData((Object)new GridData(4, 128, true, false));
        TypeFilterBuilder typeFilterTree = new TypeFilterBuilder(treeComposite, onChange, checkbox);
        typeFilterTree.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        return typeFilterTree;
    }

    public static boolean isTypeWithThreadAndDuration(IType<?> type) {
        return JfrAttributes.EVENT_THREAD.getAccessor(type) != null && JfrAttributes.START_TIME.getAccessor(type) != JfrAttributes.END_TIME.getAccessor(type);
    }

    public static void addPage(Set<IType<?>> selectedTypes) {
        PageManager pm = FlightRecorderUI.getDefault().getPageManager();
        pm.makeRoot(pm.createPage(ItemHandlerPage.Factory.class, new ItemHandlerPage.ItemHandlerUiStandIn(selectedTypes)));
    }

    private static /* synthetic */ void lambda$11(XYDataRenderer xYDataRenderer, IItemIterable iItemIterable, IType iType, boolean bl, IAttribute a) {
        DataPageToolkit.addEndTimeLine(xYDataRenderer, iItemIterable.iterator(), (IType<IItem>)iType, (IAttribute<IQuantity>)a, bl);
    }

    private static class IconChangeWizard
    extends Wizard {
        private final Image currentImage;
        private final Consumer<Image> imageConsumer;
        private Label imageLabel;

        public IconChangeWizard(Image currentImage, Consumer<Image> imageConsumer) {
            this.setWindowTitle(Messages.PAGE_CHANGE_ICON_WIZARD_TITLE);
            this.currentImage = currentImage;
            this.imageConsumer = imageConsumer;
        }

        public void addPages() {
            this.addPage((IWizardPage)new WizardPage(Messages.PAGE_CHANGE_ICON_WIZARD_PAGE_TITLE){

                public String getTitle() {
                    return Messages.PAGE_CHANGE_ICON_WIZARD_PAGE_TITLE;
                }

                public String getDescription() {
                    return Messages.PAGE_CHANGE_ICON_WIZARD_PAGE_DESC;
                }

                public void createControl(Composite parent) {
                    Composite container = new Composite(parent, 0);
                    GridLayout layout = new GridLayout(1, false);
                    container.setLayout((Layout)layout);
                    Button button = new Button(container, 0);
                    button.setText(Messages.PAGE_CHANGE_ICON_CHOOSE_IMAGE_FILE);
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            this.chooseImageFileDialog();
                        }
                    });
                    if (currentImage != null) {
                        new Label(container, 0).setText(Messages.PAGE_CHANGE_ICON_CURRENT_ICON);
                        new Label(container, 2048).setImage(currentImage);
                    }
                    new Label(container, 0).setText(Messages.PAGE_CHANGE_ICON_NEW_ICON_PREVIEW);
                    imageLabel = new Label(container, 2048);
                    GridData gd = new GridData(16, 16);
                    imageLabel.setLayoutData((Object)gd);
                    this.setControl((Control)container);
                }

                private void chooseImageFileDialog() {
                    FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
                    String[] filterNames = new String[]{"Image Files", "All Files (*)"};
                    String[] filterExtensions = new String[]{"*.gif;*.png;*.xpm;*.jpg;*.jpeg;*.tiff", "*"};
                    fileDialog.setFilterNames(filterNames);
                    fileDialog.setFilterExtensions(filterExtensions);
                    String filename = fileDialog.open();
                    if (filename == null) {
                        return;
                    }
                    try {
                        Throwable throwable = null;
                        Object var6_8 = null;
                        try (FileInputStream fis = new FileInputStream(filename);){
                            ImageData imageData = new ImageData((InputStream)fis);
                            if (imageData.width != 16 || imageData.height != 16) {
                                imageData = this.resizeImage(imageData, 16, 16);
                            }
                            DisplayToolkit.dispose((Resource)imageLabel.getImage());
                            imageLabel.setImage(new Image((Device)this.getShell().getDisplay(), imageData));
                            imageLabel.getParent().layout();
                            this.setPageComplete(this.isPageComplete());
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "Failed to load image " + filename, e);
                    }
                }

                private ImageData resizeImage(ImageData imageData, int width, int height) {
                    Image original = ImageDescriptor.createFromImageDataProvider(zoom -> imageData).createImage();
                    Image scaled = new Image((Device)Display.getDefault(), width, height);
                    GC gc = new GC((Drawable)scaled);
                    gc.setAntialias(1);
                    gc.setInterpolation(2);
                    gc.drawImage(original, 0, 0, imageData.width, imageData.height, 0, 0, width, height);
                    gc.dispose();
                    original.dispose();
                    ImageData scaledData = scaled.getImageData();
                    scaled.dispose();
                    return scaledData;
                }

                public boolean isPageComplete() {
                    return imageLabel.getImage() != null;
                }
            });
        }

        public boolean performFinish() {
            this.imageConsumer.accept(this.imageLabel.getImage());
            DisplayToolkit.dispose((Resource)this.currentImage);
            return true;
        }

        public boolean performCancel() {
            DisplayToolkit.dispose((Resource)this.imageLabel.getImage());
            return true;
        }
    }

    private static class RangePayload
    implements IAdaptable {
        IItem item;
        IQuantity start;
        IQuantity end;
        double rangeInPixels;

        RangePayload(IItem item, IQuantity start, IQuantity end, double rangeInPixels) {
            this.item = item;
            this.start = start;
            this.end = end;
            this.rangeInPixels = rangeInPixels;
        }

        void combineWith(IItem item, IQuantity start, IQuantity end, double rangeInPixels) {
            if (this.start.compareTo((Object)start) < 0) {
                this.start = start;
                this.end = end;
                this.item = item;
                this.extendRangeInPixels(this.end.compareTo((Object)start) > 0, rangeInPixels);
            } else {
                this.extendRangeInPixels(end.compareTo((Object)this.start) > 0, rangeInPixels);
            }
        }

        void extendRangeInPixels(boolean overlapping, double rangeInPixels) {
            this.rangeInPixels = overlapping ? Math.max(this.rangeInPixels, rangeInPixels) : this.rangeInPixels + rangeInPixels;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return IItem.class.isAssignableFrom(adapter) ? (T)adapter.cast(this.item) : null;
        }
    }

    public static class ShowResultAction
    extends Action {
        private String[] topics;
        private final IPageContainer pageContainer;
        private volatile Severity maxSeverity;
        private final List<Consumer<IResult>> listeners = new ArrayList<Consumer<IResult>>();

        ShowResultAction(String title, int style, ImageDescriptor icon, Supplier<String> tooltip, IPageContainer pageContainer, String ... topics) {
            super(title, style);
            this.setImageDescriptor(icon);
            this.setToolTipText(tooltip.get());
            this.topics = topics;
            this.pageContainer = pageContainer;
            this.maxSeverity = pageContainer.getRuleManager().getMaxSeverity(topics);
            String[] stringArray = topics;
            int n = topics.length;
            int n2 = 0;
            while (n2 < n) {
                String topic = stringArray[n2];
                Consumer<IResult> listener = result -> {
                    Severity severity = result.getSeverity();
                    if (severity.compareTo((Enum)this.maxSeverity) > 0) {
                        this.maxSeverity = severity;
                        this.setImageDescriptor(DataPageToolkit.getResultIcon(this.maxSeverity));
                    } else if (severity.compareTo((Enum)this.maxSeverity) < 0) {
                        this.maxSeverity = pageContainer.getRuleManager().getMaxSeverity(topics);
                    }
                    this.setToolTipText((String)tooltip.get());
                };
                this.listeners.add(listener);
                pageContainer.getRuleManager().addResultListener(topic, listener);
                ++n2;
            }
        }

        private void removeListeners() {
            this.listeners.forEach(l -> this.pageContainer.getRuleManager().removeResultListener((Consumer<IResult>)l));
        }

        public void run() {
            this.pageContainer.showResults(this.topics);
        }
    }
}

