/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.CompositeKey;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.flightrecorder.ui.common.AggregationGrid;
import org.openjdk.jmc.flightrecorder.ui.common.CompositeKeyAccessorFactory;
import org.openjdk.jmc.flightrecorder.ui.common.ItemList;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.CoreImages;
import org.openjdk.jmc.ui.TypeAppearance;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.accessibility.FocusTracker;
import org.openjdk.jmc.ui.column.ColumnBuilder;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.TableSettings;
import org.openjdk.jmc.ui.misc.BackgroundFractionDrawer;
import org.openjdk.jmc.ui.misc.DelegatingLabelProvider;

public class ItemHistogram {
    public static final String KEY_COL_ID = "itemhistogram.key";
    public static final String COUNT_COL_ID = "itemhistogram.count";
    private static final Listener COUNT_DRAWER = BackgroundFractionDrawer.unchecked(AggregationGrid::getCountFraction);
    private final AggregationGrid grid;
    private final ColumnManager columnManager;
    private final IAccessorFactory<?> classifier;

    private ItemHistogram(ColumnManager columnManager, IAccessorFactory<?> classifier, AggregationGrid grid) {
        this.columnManager = columnManager;
        this.grid = grid;
        this.classifier = classifier;
    }

    public ColumnManager getManager() {
        return this.columnManager;
    }

    public HistogramSelection getAllRows() {
        return new HistogramSelection(Stream.of(((Table)this.columnManager.getViewer().getControl()).getItems()).map(ti -> ti.getData()).collect(Collectors.toList()));
    }

    public HistogramSelection getSelection() {
        return new HistogramSelection(((IStructuredSelection)this.columnManager.getViewer().getSelection()).toList());
    }

    public void show(IItemCollection items) {
        this.columnManager.getViewer().setInput((Object)this.grid.buildRows(items, this.classifier));
    }

    public static class CompositeKeyHistogramBuilder {
        private final ItemHistogramBuilder histogramBuilder = new ItemHistogramBuilder();
        private final CompositeKeyAccessorFactory factory = new CompositeKeyAccessorFactory();

        public void addKeyColumn(IAttribute<?> attribute) {
            this.addKeyColumn(ItemList.getColumnId(attribute), attribute.getName(), (IAccessorFactory<?>)attribute);
        }

        public void addKeyColumn(String id, String name, IAccessorFactory<?> keyElementProvider) {
            IMemberAccessor<?, CompositeKey> keyElementAccessor = this.factory.add(keyElementProvider);
            IMemberAccessor rowTokeyElementAccessor = row -> keyElementAccessor.getMember((Object)((CompositeKey)AggregationGrid.getKey(row)));
            this.histogramBuilder.columns.add(new ColumnBuilder(name, id, rowTokeyElementAccessor).build());
        }

        public void addCountColumn() {
            this.histogramBuilder.addCountColumn();
        }

        public void addColumn(String colId, IAggregator<?, ?> a) {
            this.histogramBuilder.addColumn(colId, a);
        }

        public ItemHistogram build(Composite container, TableSettings tableSettings) {
            return this.histogramBuilder.build(container, this.histogramBuilder.columns, this.factory, tableSettings, 2048);
        }

        public ItemHistogram buildWithoutBorder(Composite container, TableSettings tableSettings) {
            return this.histogramBuilder.build(container, this.histogramBuilder.columns, this.factory, tableSettings, 0);
        }
    }

    public static class HistogramSelection {
        private final List<?> selection;

        private HistogramSelection(List<?> selection) {
            this.selection = selection;
        }

        public int getRowCount() {
            return this.selection.size();
        }

        public IItemCollection getItems() {
            List rows = this.selection.stream().map(AggregationGrid::getItems).collect(Collectors.toList());
            return ItemCollectionToolkit.merge(rows::stream);
        }

        public <T> Stream<T> getSelectedRows(BiFunction<Object, IItemCollection, T> rowBuilder) {
            return this.selection.stream().map(row -> rowBuilder.apply(AggregationGrid.getKey(row), AggregationGrid.getItems(row)));
        }
    }

    public static class ItemHistogramBuilder {
        private final AggregationGrid grid = new AggregationGrid();
        private final List<IColumn> columns = new ArrayList<IColumn>();

        public void addCountColumn() {
            this.columns.add(new ColumnBuilder(Messages.COUNT_COLUMN_NAME, ItemHistogram.COUNT_COL_ID, AggregationGrid::getCount).columnDrawer(COUNT_DRAWER).style(131072).build());
        }

        public void addColumn(String colId, IAggregator<?, ?> a) {
            int style = a.getValueType() instanceof LinearKindOfQuantity ? 131072 : 0;
            this.addColumn(colId, ic -> ic.getAggregate(a), a.getName(), a.getDescription(), style);
        }

        public void addPercentageColumn(String colId, IAggregator<?, ?> a) {
            this.addPercentageColumn(colId, a, a.getName(), a.getDescription());
        }

        public void addPercentageColumn(String colId, IAggregator<?, ?> a, String name, String description) {
            int style = a.getValueType() instanceof LinearKindOfQuantity ? 131072 : 0;
            BiFunction<IItemCollection, IItemCollection, Object> percentageFunction = (rowItems, allItems) -> {
                if (a.getValueType() instanceof LinearKindOfQuantity) {
                    IQuantity rowResult = (IQuantity)rowItems.getAggregate(a);
                    IQuantity allResult = (IQuantity)allItems.getAggregate(a);
                    if (rowResult != null && allResult != null) {
                        return UnitLookup.PERCENT.quantity(rowResult.ratioTo(allResult) * 100.0);
                    }
                }
                return rowItems.getAggregate(a);
            };
            this.addPercentageColumn(colId, percentageFunction, name, description, style);
        }

        public void addColumn(String colId, Function<IItemCollection, ?> valueFunction, String name, String description) {
            this.addColumn(colId, valueFunction, name, description, 0);
        }

        public void addColumn(String colId, Function<IItemCollection, ?> valueFunction, String name, String description, int style) {
            this.columns.add(new ColumnBuilder(name, colId, this.grid.addColumn(valueFunction)).description(description).style(style).build());
        }

        public void addPercentageColumn(String colId, BiFunction<IItemCollection, IItemCollection, ?> valueFunction, String name, String description, int style) {
            final IMemberAccessor<?, Object> column = this.grid.addPercentageColumn(valueFunction);
            BackgroundFractionDrawer percentageValueDrawer = new BackgroundFractionDrawer(){

                public void handleEvent(Event event) {
                    Object row = event.item.getData();
                    Object item = column.getMember(row);
                    if (item instanceof Number) {
                        this.draw(((Number)item).doubleValue() / 100.0, event);
                    }
                }
            };
            this.columns.add(new ColumnBuilder(name, colId, column).description(description).style(style).columnDrawer((Listener)percentageValueDrawer).build());
        }

        public <T> void addColumn(IAttribute<T> a) {
            IMemberAccessor anyValueAccessor = row -> AggregationGrid.getItems(row).stream().flatMap(is -> is.stream().map(arg_0 -> ((IMemberAccessor)a.getAccessor(is.getType())).getMember(arg_0))).filter(Objects::nonNull).findAny().orElse(null);
            this.columns.add(new ColumnBuilder(a.getName(), a.getIdentifier(), anyValueAccessor).description(a.getDescription()).build());
        }

        public <T> ItemHistogram build(Composite container, IAttribute<T> classifier, TableSettings tableSettings) {
            return this.build(container, classifier.getName(), (ContentType<? super T>)classifier.getContentType(), (IAccessorFactory<T>)classifier, tableSettings);
        }

        public <T> ItemHistogram buildWithoutBorder(Composite container, IAttribute<T> classifier, TableSettings tableSettings) {
            return this.buildWithoutBorder(container, classifier.getName(), (ContentType<? super T>)classifier.getContentType(), (IAccessorFactory<T>)classifier, tableSettings);
        }

        public <T> ItemHistogram buildWithoutBorder(Composite container, String colLabel, ContentType<? super T> keyType, IAccessorFactory<T> classifier, TableSettings tableSettings) {
            return this.build(container, colLabel, keyType, classifier, tableSettings, 0);
        }

        public <T> ItemHistogram build(Composite container, String colLabel, ContentType<? super T> keyType, IAccessorFactory<T> classifier, TableSettings tableSettings) {
            return this.build(container, colLabel, keyType, classifier, tableSettings, 2048);
        }

        public <T> ItemHistogram build(Composite container, String colLabel, ContentType<? super T> keyType, IAccessorFactory<T> classifier, TableSettings tableSettings, int border) {
            ColumnLabelProvider lp = null;
            lp = UnitLookup.METHOD.getIdentifier().equals(keyType.getIdentifier()) || UnitLookup.STACKTRACE_FRAME.getIdentifier().equals(keyType.getIdentifier()) ? new MethodLabelProvider() : new KeyLabelProvider(keyType);
            return this.build(container, colLabel, keyType, classifier, tableSettings, border, lp);
        }

        public <T> ItemHistogram build(Composite container, String colLabel, ContentType<? super T> keyType, IAccessorFactory<T> classifier, TableSettings tableSettings, int border, ColumnLabelProvider labelProvider) {
            ArrayList<IColumn> columns = new ArrayList<IColumn>();
            IMemberAccessor keyAccessor = AggregationGrid::getKey;
            DelegatingLabelProvider keyLp = new DelegatingLabelProvider(labelProvider, keyAccessor);
            columns.add(new ColumnBuilder(colLabel, ItemHistogram.KEY_COL_ID, keyAccessor, (ColumnLabelProvider)keyLp).build());
            columns.addAll(this.columns);
            return this.build(container, columns, classifier, tableSettings, border);
        }

        private <T> ItemHistogram build(Composite container, List<IColumn> columns, IAccessorFactory<T> classifier, TableSettings tableSettings, int border) {
            TableViewer tableViewer = new TableViewer(container, 0x10302 | border);
            tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
            if (UIPlugin.getDefault().getAccessibilityMode()) {
                FocusTracker.enableFocusTracking((Composite)tableViewer.getTable());
            }
            return new ItemHistogram(ColumnManager.build((TableViewer)tableViewer, columns, (TableSettings)tableSettings), classifier, this.grid);
        }

        public <T> ItemHistogram buildWithoutBorder(Composite container, String colLabel, ContentType<? super T> keyType, IAccessorFactory<T> classifier, TableSettings tableSettings, ColumnLabelProvider labelProvider) {
            return this.build(container, colLabel, keyType, classifier, tableSettings, 0, labelProvider);
        }

        public <T> ItemHistogram buildWithoutBorder(Composite container, IAttribute<T> classifier, TableSettings tableSettings, ColumnLabelProvider labelProvider) {
            return this.build(container, classifier.getName(), (ContentType<? super T>)classifier.getContentType(), (IAccessorFactory<T>)classifier, tableSettings, 0, labelProvider);
        }
    }

    static class KeyLabelProvider
    extends ColumnLabelProvider {
        private final Image image;

        KeyLabelProvider(ContentType<?> ct) {
            this.image = TypeAppearance.getImage((String)ct.getIdentifier());
        }

        public Font getFont(Object key) {
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }

        public Image getImage(Object key) {
            return this.image;
        }

        public String getText(Object key) {
            if (key instanceof IDisplayable) {
                return ((IDisplayable)key).displayUsing("exact");
            }
            return TypeHandling.getValueString((Object)key);
        }

        public String getToolTipText(Object key) {
            if (key instanceof IDisplayable) {
                return ((IDisplayable)key).displayUsing("verbose");
            }
            return null;
        }
    }

    static class MethodLabelProvider
    extends ColumnLabelProvider {
        private final Image nonoptimizedMethodImage;
        private final Image defaultMethodImage = CoreImages.METHOD_DEFAULT.createImage();
        private final Image publicMethodImage;
        private final Image protectedMethodImage;
        private final Image privateMethodImage;

        MethodLabelProvider() {
            this.nonoptimizedMethodImage = CoreImages.METHOD_NON_OPTIMIZED.createImage();
            this.publicMethodImage = CoreImages.METHOD_PUBLIC.createImage();
            this.protectedMethodImage = CoreImages.METHOD_PROTECTED.createImage();
            this.privateMethodImage = CoreImages.METHOD_PRIVATE.createImage();
        }

        public Font getFont(Object key) {
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }

        public Image getImage(Object key) {
            IMCMethod method = null;
            if (key instanceof IMCMethod) {
                method = (IMCMethod)key;
            } else if (key instanceof IMCFrame) {
                method = ((IMCFrame)key).getMethod();
            }
            if (method != null) {
                if ((method.getModifier() & 1) != 0) {
                    return this.publicMethodImage;
                }
                if ((method.getModifier() & 4) != 0) {
                    return this.protectedMethodImage;
                }
                if ((method.getModifier() & 2) != 0) {
                    return this.privateMethodImage;
                }
                return this.defaultMethodImage;
            }
            return this.nonoptimizedMethodImage;
        }

        public String getText(Object key) {
            if (key instanceof IMCFrame) {
                key = ((IMCFrame)key).getMethod();
            }
            if (key instanceof IDisplayable) {
                return ((IDisplayable)key).displayUsing("exact");
            }
            return TypeHandling.getValueString((Object)key);
        }

        public String getToolTipText(Object key) {
            if (key instanceof IDisplayable) {
                return ((IDisplayable)key).displayUsing("verbose");
            }
            return null;
        }
    }
}

