/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import org.openjdk.jmc.common.IDescribable;
import org.openjdk.jmc.common.unit.IConstraint;
import org.openjdk.jmc.common.unit.IDescribedMap;
import org.openjdk.jmc.common.unit.IOptionDescriptor;
import org.openjdk.jmc.flightrecorder.configuration.ConfigurationToolkit;
import org.openjdk.jmc.flightrecorder.configuration.events.EventConfiguration;
import org.openjdk.jmc.flightrecorder.configuration.events.EventOptionID;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventConfiguration;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventTypeID;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventTypeInfo;
import org.openjdk.jmc.flightrecorder.configuration.events.SchemaVersion;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.EventOptionVisitor;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.PathElement;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;

public class EventConfigurationModel
implements Consumer<EventOptionVisitor> {
    private final EventConfiguration configuration;
    private final IDescribedMap<EventOptionID> serverDefaults;
    private final Map<? extends IEventTypeID, ? extends IEventTypeInfo> serverEventTypeInfos;

    public EventConfigurationModel createEditableClone() {
        EventConfigurationModel clone = EventConfigurationModel.create(this.configuration.createClone(), this.serverDefaults, this.serverEventTypeInfos);
        return clone;
    }

    public static EventConfigurationModel create(IEventConfiguration configuration, RecordingWizardModel recordingWizardModel) {
        boolean compatibleVersion = recordingWizardModel.isCompatibleVersion(configuration);
        if (compatibleVersion) {
            return EventConfigurationModel.create(configuration, recordingWizardModel.getEventOptions(), recordingWizardModel.getEventTypeInfoMap());
        }
        return EventConfigurationModel.create(configuration, (IDescribedMap<EventOptionID>)ConfigurationToolkit.getEventOptions((SchemaVersion)configuration.getVersion()), Collections.emptyMap());
    }

    public static EventConfigurationModel create(IEventConfiguration configuration, IDescribedMap<EventOptionID> serverDefaults, Map<? extends IEventTypeID, ? extends IEventTypeInfo> serverEventTypeInfos) {
        return new EventConfigurationModel(configuration, serverDefaults, serverEventTypeInfos);
    }

    private EventConfigurationModel(IEventConfiguration configuration, IDescribedMap<EventOptionID> serverDefaults, Map<? extends IEventTypeID, ? extends IEventTypeInfo> serverEventTypeInfos) {
        this.configuration = (EventConfiguration)configuration;
        this.serverDefaults = serverDefaults;
        this.serverEventTypeInfos = serverEventTypeInfos;
    }

    public IEventConfiguration getConfiguration() {
        return this.configuration;
    }

    public IDescribedMap<EventOptionID> getServerDefaults() {
        return this.serverDefaults;
    }

    public Map<? extends IEventTypeID, ? extends IEventTypeInfo> getServerEventTypeInfos() {
        return this.serverEventTypeInfos;
    }

    public boolean isOffline() {
        return this.serverDefaults == null || this.serverDefaults.keySet() == null || this.serverDefaults.keySet().isEmpty();
    }

    public static EventConfigurationModel pushServerMetadataToLocalConfiguration(IEventConfiguration configuration, IDescribedMap<EventOptionID> serverDefaults, Map<? extends IEventTypeID, ? extends IEventTypeInfo> serverEventTypeInfos, boolean override) {
        EventConfigurationModel model = EventConfigurationModel.create(configuration, serverDefaults, serverEventTypeInfos);
        model.pushServerMetadataToLocalConfiguration(override);
        return model;
    }

    public void pushServerMetadataToLocalConfiguration(boolean override) {
        for (Map.Entry<? extends IEventTypeID, ? extends IEventTypeInfo> entry : this.serverEventTypeInfos.entrySet()) {
            IEventTypeID eventTypeID = entry.getKey();
            if (this.configuration.getVersion() == SchemaVersion.V2) {
                String[] configCategory = this.configuration.getEventCategory(eventTypeID);
                if (override || configCategory == null || configCategory.length == 0) {
                    IEventTypeInfo serverEventTypeInfo = entry.getValue();
                    String[] categories = serverEventTypeInfo.getHierarchicalCategory();
                    this.configuration.putEventInCategory(eventTypeID, categories);
                }
            }
            IEventTypeInfo serverEventTypeInfo = entry.getValue();
            this.configuration.populateEventMetadata(eventTypeID, serverEventTypeInfo, override);
        }
        for (EventOptionID optionKey : this.serverDefaults.keySet()) {
            IEventTypeInfo serverEventTypeInfo = this.serverEventTypeInfos.get(optionKey.getEventTypeID());
            IOptionDescriptor serverOptionInfo = serverEventTypeInfo.getOptionInfo(optionKey.getOptionKey());
            this.configuration.populateOption(optionKey, serverOptionInfo, this.serverDefaults.getPersistableString((Object)optionKey), override);
        }
    }

    @Override
    public void accept(EventOptionVisitor visitor) {
        HashSet<? extends IEventTypeID> eventTypeIDs = new HashSet<IEventTypeID>();
        eventTypeIDs.addAll(this.configuration.getConfigEventTypes());
        eventTypeIDs.addAll(this.serverEventTypeInfos.keySet());
        for (IEventTypeID iEventTypeID : eventTypeIDs) {
            IEventTypeInfo serverInfo = this.serverEventTypeInfos.get(iEventTypeID);
            String[] category = this.getCategory(iEventTypeID, serverInfo);
            String label = this.getLabel(iEventTypeID, serverInfo);
            String description = this.getDescription(iEventTypeID, serverInfo);
            this.visitEventType(visitor, iEventTypeID, category, label, description, this.configuration.hasEvent(iEventTypeID), serverInfo != null);
        }
        this.addOptions(visitor, (IDescribedMap<EventOptionID>)((IDescribedMap)this.configuration.getEventOptions(this.serverDefaults.emptyWithSameConstraints())), PathElement.PathElementKind.IN_CONFIGURATION, this.serverEventTypeInfos);
        this.addOptions(visitor, this.serverDefaults, PathElement.PathElementKind.IN_SERVER, this.serverEventTypeInfos);
    }

    private void visitEventType(EventOptionVisitor visitor, IEventTypeID eventTypeID, String[] category, String label, String description, boolean inConfig, boolean onServer) {
        PathElement.PathElementKind kind = PathElement.PathElementKind.UNKNOWN;
        if (inConfig) {
            kind = kind.add(PathElement.PathElementKind.IN_CONFIGURATION);
        }
        if (onServer) {
            kind = kind.add(PathElement.PathElementKind.IN_SERVER);
        }
        visitor.visitEventType(kind, eventTypeID, category, label, description);
    }

    private void addOptions(EventOptionVisitor visitor, IDescribedMap<EventOptionID> options, PathElement.PathElementKind kind, Map<? extends IEventTypeID, ? extends IEventTypeInfo> serverEventTypeInfos) {
        for (EventOptionID eventOptionID : options.keySet()) {
            IEventTypeID eventTypeID = eventOptionID.getEventTypeID();
            IEventTypeInfo serverInfo = serverEventTypeInfos.get(eventTypeID);
            IOptionDescriptor serverOptionDescriptor = serverInfo != null ? serverInfo.getOptionInfo(eventOptionID.getOptionKey()) : null;
            String optionValue = options.getPersistableString((Object)eventOptionID);
            IConstraint constraint = options.getConstraint((Object)eventOptionID);
            String[] eventCategory = this.getCategory(eventTypeID, serverInfo);
            String eventLabel = this.getLabel(eventTypeID, serverInfo);
            String eventDescription = this.getDescription(eventTypeID, serverInfo);
            IDescribable optionDescribable = options.getDescribable((Object)eventOptionID);
            String optionLabel = this.getOptionLabel(eventOptionID, optionDescribable, serverOptionDescriptor);
            String optionDescription = this.getOptionDescription(eventOptionID, optionDescribable, serverOptionDescriptor);
            visitor.visitOption(optionValue, constraint, kind, eventOptionID, eventCategory, optionLabel, optionDescription, eventLabel, eventDescription);
        }
    }

    private String[] getCategory(IEventTypeID eventTypeID, IEventTypeInfo serverInfo) {
        String[] fallback;
        String[] path = this.configuration.getEventCategory(eventTypeID);
        if (path.length == 0 && serverInfo != null) {
            path = serverInfo.getHierarchicalCategory();
        }
        if (path.length == 0 && (fallback = eventTypeID.getFallbackHierarchy()) != null && fallback.length > 1) {
            path = Arrays.copyOf(fallback, fallback.length - 1);
        }
        return path;
    }

    private String getLabel(IEventTypeID eventTypeID, IEventTypeInfo serverInfo) {
        String label = this.configuration.getEventLabel(eventTypeID);
        if (label == null && serverInfo != null) {
            label = serverInfo.getName();
        }
        if (label == null) {
            String[] hierarchy = eventTypeID.getFallbackHierarchy();
            label = hierarchy.length > 1 ? hierarchy[hierarchy.length - 1] : eventTypeID.getRelativeKey();
        }
        return label;
    }

    private String getDescription(IEventTypeID eventTypeID, IEventTypeInfo serverInfo) {
        String description = this.configuration.getEventDescription(eventTypeID);
        if (description == null && serverInfo != null) {
            description = serverInfo.getDescription();
        }
        String fullKey = "[" + eventTypeID.getFullKey() + "]";
        return description != null ? String.valueOf(description) + " " + fullKey : fullKey;
    }

    private String getOptionLabel(EventOptionID eventOptionID, IDescribable optionDescribable, IOptionDescriptor<?> serverOptionDescriptor) {
        String optionLabel = null;
        optionLabel = this.configuration.getConfigOptionLabel(eventOptionID);
        if (optionLabel == null && optionDescribable != null) {
            optionLabel = optionDescribable.getName();
        }
        if (optionLabel == null && serverOptionDescriptor != null) {
            optionLabel = serverOptionDescriptor.getName();
        }
        if (optionLabel == null) {
            optionLabel = eventOptionID.getOptionKey();
        }
        return optionLabel;
    }

    private String getOptionDescription(EventOptionID eventOptionID, IDescribable optionDescribable, IOptionDescriptor<?> serverOptionDescriptor) {
        String optionDescription = null;
        optionDescription = this.configuration.getConfigOptionDescription(eventOptionID);
        if (optionDescription == null && optionDescribable != null) {
            optionDescription = optionDescribable.getDescription();
        }
        if (optionDescription == null && serverOptionDescriptor != null) {
            optionDescription = serverOptionDescriptor.getDescription();
        }
        String optiondId = "[" + eventOptionID.getOptionKey() + "]";
        return optionDescription != null ? String.valueOf(optionDescription) + " " + optiondId : optiondId;
    }
}

