/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.openjdk.jmc.common.unit.IConstraint;
import org.openjdk.jmc.common.unit.IFormatter;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.configuration.events.EventConfiguration;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventConfiguration;
import org.openjdk.jmc.flightrecorder.configuration.events.SchemaVersion;
import org.openjdk.jmc.flightrecorder.configuration.internal.CommonConstraints;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.ControlPanel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.ErrorTracker;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.EventConfigurationModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.PathElement;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.Property;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.PropertyContainer;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.PropertyContentProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.PropertyLabelProvider;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.RecordingTemplateViewerComparator;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.recordingconfiguration.RecordingTemplateViewerFilter;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.misc.QuantityKindProposal;

public class EventConfigurationPart {
    public static final String RECORDINGTEMPLATEPART_PREFIX = "recording.configuration.";
    public static final String RECORDINGTEMPLATEPART_FILTERTEXT_NAME = "recording.configuration.filtertext";
    private static final int PROPERTY_EDITORS_MIN_WIDTH = 200;
    private static final int PROPERTY_EDITORS_MIN_HEIGHT = 150;
    protected static final IQuantity CUSTOM_PERIOD_DEFAULT = UnitLookup.MILLISECOND.quantity(20L);
    private final WizardPage m_wizardPage;
    private EventConfigurationModel editableConfigModel;
    private TreeViewer m_propertyTreeViewer;
    private PathElement m_selectedElement;
    private Composite m_propertyEditorsContainer;
    private boolean m_editable;
    private Text m_filterText;
    private RecordingTemplateViewerFilter m_filter;
    private ErrorTracker m_errorTracker;
    private Button m_refreshButton;
    private boolean m_enableRefresh;

    public EventConfigurationPart(WizardPage wizardPage, EventConfigurationModel editableConfigModel, boolean enableRefresh) {
        this.m_wizardPage = wizardPage;
        this.editableConfigModel = editableConfigModel;
        this.m_enableRefresh = enableRefresh;
        this.m_editable = true;
        this.m_errorTracker = new ErrorTracker(arg_0 -> ((WizardPage)wizardPage).setErrorMessage(arg_0));
    }

    private IEventConfiguration getRecordingConfiguration() {
        return this.editableConfigModel.getConfiguration();
    }

    public void setInput(EventConfigurationModel editableConfigModel) {
        this.editableConfigModel = editableConfigModel;
        this.updateInput();
    }

    public void setEditable(boolean editable) {
        this.m_editable = editable;
    }

    public boolean getEditable() {
        return this.m_editable;
    }

    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, false, false);
        Label filterLabel = this.createFilterDetailsLabel(container);
        filterLabel.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        Text filterText = this.createFilterDetailsText(container);
        filterText.setLayoutData((Object)gd2);
        filterText.setData("name", (Object)RECORDINGTEMPLATEPART_FILTERTEXT_NAME);
        if (this.m_enableRefresh) {
            GridData gd3 = new GridData(131072, 4, false, false);
            Button refreshButton = this.createRefreshButton(container);
            refreshButton.setLayoutData((Object)gd3);
        }
        GridData gd4 = new GridData(4, 4, true, true);
        TreeViewer viewer = this.createTreeViewer(container);
        gd4.horizontalSpan = 2;
        viewer.getControl().setLayoutData((Object)gd4);
        GridData gd5 = new GridData(4, 4, true, true);
        Composite details = this.createScrollablePropertyEditorsContainer(container);
        details.setLayoutData((Object)gd5);
        this.hookListeners();
        this.updateInput();
        return container;
    }

    private Label createFilterDetailsLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_FILTER_TEXT);
        return label;
    }

    private Text createFilterDetailsText(Composite parent) {
        this.m_filterText = new Text(parent, 2048);
        this.updateFilter();
        return this.m_filterText;
    }

    private void updateFilter() {
        if (this.m_filter != null) {
            String filterText = this.m_filterText != null ? this.m_filterText.getText() : "";
            this.m_filter.update(filterText);
        }
    }

    private Button createRefreshButton(Composite parent) {
        this.m_refreshButton = new Button(parent, 0);
        this.m_refreshButton.setText(Messages.BUTTON_REFRESH_TEXT);
        this.m_refreshButton.setToolTipText(Messages.BUTTON_REFRESH_TOOLTIP);
        this.m_refreshButton.setVisible(!this.editableConfigModel.isOffline());
        return this.m_refreshButton;
    }

    private void refreshFromServer() {
        this.editableConfigModel.pushServerMetadataToLocalConfiguration(true);
        this.updateInput();
    }

    private Composite createScrollablePropertyEditorsContainer(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 2304);
        Composite wrapped = this.createPropertyEditorsContainer((Composite)sc);
        sc.setContent((Control)wrapped);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.setMinHeight(150);
        sc.setMinWidth(200);
        return sc;
    }

    private Composite createPropertyEditorsContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.m_propertyEditorsContainer = container;
        return container;
    }

    private TreeViewer createTreeViewer(Composite parent) {
        this.m_propertyTreeViewer = new TreeViewer(parent, 2304);
        this.m_propertyTreeViewer.setAutoExpandLevel(2);
        this.m_propertyTreeViewer.setLabelProvider((IBaseLabelProvider)new PropertyLabelProvider());
        this.m_propertyTreeViewer.setContentProvider((IContentProvider)new PropertyContentProvider());
        this.m_filter = new RecordingTemplateViewerFilter();
        this.updateFilter();
        this.m_propertyTreeViewer.addFilter((ViewerFilter)this.m_filter);
        this.m_propertyTreeViewer.setComparator((ViewerComparator)new RecordingTemplateViewerComparator());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_propertyTreeViewer);
        return this.m_propertyTreeViewer;
    }

    private void hookListeners() {
        this.hookFilterListener();
        if (this.m_enableRefresh) {
            this.hookRefreshListener();
        }
        this.hookTreeSelectionListener();
    }

    private void hookRefreshListener() {
        this.m_refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventConfigurationPart.this.refreshFromServer();
            }
        });
    }

    private void hookFilterListener() {
        this.m_filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EventConfigurationPart.this.refreshTreeWithFilter();
            }
        });
    }

    private void refreshTreeWithFilter() {
        this.updateFilter();
        Composite treeParent = this.m_propertyTreeViewer.getTree().getParent();
        treeParent.setRedraw(false);
        this.m_propertyTreeViewer.refresh();
        if (this.m_filterText.getText().length() == 0) {
            this.m_propertyTreeViewer.collapseAll();
        } else {
            this.m_propertyTreeViewer.expandAll();
        }
        treeParent.setRedraw(true);
        treeParent.redraw();
    }

    private void hookTreeSelectionListener() {
        this.m_propertyTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EventConfigurationPart.this.updateSelected(((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
    }

    private void updateInput() {
        this.m_propertyTreeViewer.getControl().setRedraw(false);
        TreePath[] expanded = this.m_propertyTreeViewer.getExpandedTreePaths();
        ISelection currentSelection = this.m_propertyTreeViewer.getSelection();
        this.m_propertyTreeViewer.setInput((Object)this.editableConfigModel);
        this.m_propertyTreeViewer.setExpandedTreePaths(expanded);
        if (currentSelection != null) {
            this.m_propertyTreeViewer.setSelection(currentSelection, true);
        }
        this.m_propertyTreeViewer.getControl().setRedraw(true);
        this.m_propertyTreeViewer.getControl().redraw();
    }

    private void updateSelected(Object object) {
        if (object == this.m_selectedElement) {
            return;
        }
        this.m_selectedElement = object instanceof PathElement ? (PathElement)object : null;
        this.updatePropertyEditors();
    }

    private void updatePropertyEditors() {
        Control[] controlArray = this.m_propertyEditorsContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.clearErrorMessages();
        Map<PropertyKey, Set<Property>> properties = this.findProperties();
        for (Map.Entry<PropertyKey, Set<Property>> entry : properties.entrySet()) {
            CommonValueProperties<?> cvp = this.findCommonValueProperties(entry.getValue());
            if (cvp.constraint == null) continue;
            GridData gd1 = new GridData(16384, 0x1000000, false, false);
            final Label propertyKeyLabel = new Label(this.m_propertyEditorsContainer, 0);
            propertyKeyLabel.setText(entry.getKey().optionLabel);
            propertyKeyLabel.setLayoutData((Object)gd1);
            propertyKeyLabel.setToolTipText(this.getOptionKeysString(entry.getValue()));
            GridData gd2 = new GridData(4, 4, true, false);
            Control propertyControl = this.createPropertyControl(this.m_propertyEditorsContainer, cvp, entry.getValue());
            propertyControl.setData("name", (Object)(RECORDINGTEMPLATEPART_PREFIX + entry.getKey().getLabel()));
            propertyControl.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = propertyKeyLabel.getText();
                }
            });
            propertyControl.setLayoutData((Object)gd2);
        }
        this.m_propertyEditorsContainer.layout(true, true);
    }

    private String getOptionKeysString(Set<Property> propertySet) {
        return propertySet.stream().map(p -> p.getDescription()).distinct().collect(Collectors.joining(", "));
    }

    private Map<PropertyKey, Set<Property>> findProperties() {
        return EventConfigurationPart.findProperties(this.m_selectedElement);
    }

    public static Map<PropertyKey, Set<Property>> findProperties(PathElement selectedSubTree) {
        TreeMap<PropertyKey, Set<Property>> properties = new TreeMap<PropertyKey, Set<Property>>();
        EventConfigurationPart.findProperties(selectedSubTree, properties);
        return properties;
    }

    private static void findProperties(PathElement pathElement, Map<PropertyKey, Set<Property>> properties) {
        if (pathElement instanceof Property) {
            EventConfigurationPart.findProperties((Property)pathElement, properties);
        } else if (pathElement instanceof PropertyContainer) {
            for (PathElement pathElement2 : ((PropertyContainer)pathElement).getChildren()) {
                EventConfigurationPart.findProperties(pathElement2, properties);
            }
        }
    }

    private static void findProperties(Property property, Map<PropertyKey, Set<Property>> properties) {
        IConstraint<?> constraint = property.getConstraint();
        if (constraint != null) {
            properties.computeIfAbsent(new PropertyKey(property.getName(), constraint), key -> new HashSet()).add(property);
        }
    }

    private Control createPropertyControl(Composite parent, CommonValueProperties<?> cvp, Set<Property> properties) {
        IConstraint constraint = cvp.constraint;
        if (UnitLookup.FLAG.equals(constraint)) {
            CommonValueProperties<Boolean> boolCVP = cvp;
            return this.createBooleanPropertyControl(parent, properties, boolCVP);
        }
        if (CommonConstraints.PERIOD_V2 == constraint) {
            return this.createPeriodPropertyControl(parent, properties, cvp);
        }
        return this.createTextPropertyControl(parent, properties, cvp);
    }

    private CommonValueProperties<?> findCommonValueProperties(Set<Property> properties) {
        CommonValueProperties<?> cvp = null;
        for (Property property : properties) {
            IConstraint<?> constraint = property.getConstraint();
            if (cvp == null) {
                cvp = this.initCommonValueProperties(constraint, property.getValue());
                continue;
            }
            this.updateCommonValueProperties(cvp, constraint, property.getValue());
        }
        return cvp;
    }

    private <T> CommonValueProperties<T> initCommonValueProperties(IConstraint<T> constraint, String value) {
        CommonValueProperties cvp = new CommonValueProperties();
        cvp.constraint = constraint;
        try {
            cvp.value = constraint.parsePersisted(value);
        }
        catch (QuantityConversionException e) {
            cvp.value = null;
            ControlPanel.getDefault().getLogger().log(Level.WARNING, e.getMessage(), e);
        }
        return cvp;
    }

    private <T> void updateCommonValueProperties(CommonValueProperties<T> cvp, IConstraint<?> constraint, String persistedValue) {
        if (cvp.constraint != null && constraint != null) {
            cvp.constraint = cvp.constraint.combine(constraint);
        }
        if (cvp.constraint != null && cvp.value != null) {
            try {
                Object value = cvp.constraint.parsePersisted(persistedValue);
                if (!cvp.value.equals(value)) {
                    cvp.value = null;
                }
            }
            catch (QuantityConversionException quantityConversionException) {
                cvp.value = null;
            }
        }
    }

    private Control createBooleanPropertyControl(Composite parent, Set<Property> properties, CommonValueProperties<Boolean> cvp) {
        if (UIPlugin.getDefault().getAccessibilityMode() && !this.getEditable()) {
            Text text = new Text(parent, 0);
            text.setEditable(false);
            if (cvp.value != null) {
                text.setText((Boolean)cvp.value != false ? Messages.ACCESSIBILITY_CHECKBOX_CHECKED : Messages.ACCESSIBILITY_CHECKBOX_NOT_CHECKED);
            }
            return text;
        }
        Button checkbox = new Button(parent, 32);
        if (cvp.value != null) {
            checkbox.setSelection(((Boolean)cvp.value).booleanValue());
        } else {
            checkbox.setGrayed(true);
            checkbox.setSelection(true);
        }
        checkbox.setEnabled(this.getEditable());
        checkbox.addSelectionListener(this.createSelectionListener(properties, checkbox));
        return checkbox;
    }

    private SelectionListener createSelectionListener(final Set<Property> properties, final Button checkbox) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (checkbox.getGrayed()) {
                    checkbox.setGrayed(false);
                    checkbox.setSelection(true);
                }
                EventConfigurationPart.this.updateProperties(properties, Boolean.toString(checkbox.getSelection()));
            }
        };
    }

    private <T> Text createTextPropertyControl(Composite parent, Set<Property> properties, CommonValueProperties<T> cvp) {
        Text text;
        Text text2 = text = this.getEditable() ? new Text(parent, 2048) : new Text(parent, 0);
        if (cvp.value != null) {
            String interactiveValue = cvp.interactiveValue();
            this.setFormattedEmptyValue(interactiveValue, cvp.value, cvp.constraint, arg_0 -> ((Text)text).setMessage(arg_0));
            text.setText(interactiveValue);
        }
        text.setEditable(this.getEditable());
        QuantityKindProposal.install((Text)text, cvp.constraint);
        text.addModifyListener(this.createModifyListener(properties, text, cvp.constraint));
        return text;
    }

    private Control createPeriodPropertyControl(Composite parent, Set<Property> properties, final CommonValueProperties<?> cvp) {
        ArrayList<IQuantity> knownPeriodOptions = new ArrayList<IQuantity>();
        ArrayList<IQuantity> periodOptions = new ArrayList<IQuantity>();
        knownPeriodOptions.add(CommonConstraints.EVERY_CHUNK_MAGIC_INSTANCE);
        if (this.editableConfigModel.getConfiguration().getVersion() == SchemaVersion.V2) {
            knownPeriodOptions.add(CommonConstraints.BEGIN_CHUNK_MAGIC_INSTANCE);
            knownPeriodOptions.add(CommonConstraints.END_CHUNK_MAGIC_INSTANCE);
        }
        periodOptions.addAll(knownPeriodOptions);
        periodOptions.add(CUSTOM_PERIOD_DEFAULT);
        ComboViewer comboViewer = new ComboViewer(parent, 4);
        ArrayContentProvider cp = new ArrayContentProvider();
        comboViewer.setContentProvider((IContentProvider)cp);
        comboViewer.setComparer((IElementComparer)new IdentityComparer());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IQuantity && cvp.constraint instanceof IFormatter) {
                    IFormatter formatter = (IFormatter)cvp.constraint;
                    return formatter.format((Object)((IQuantity)element));
                }
                return super.getText(element);
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }
        });
        IConstraint constraint = cvp.constraint;
        comboViewer.setInput(periodOptions);
        QuantityKindProposal.install((Combo)comboViewer.getCombo(), cvp.constraint);
        if (cvp.value != null) {
            if (periodOptions.contains(cvp.value)) {
                IQuantity option = (IQuantity)cvp.value;
                if (!this.containsObject(periodOptions, option)) {
                    option = (IQuantity)periodOptions.get(periodOptions.indexOf(option));
                }
                comboViewer.setSelection((ISelection)new StructuredSelection((Object)option), true);
            } else {
                periodOptions.set(periodOptions.size() - 1, (IQuantity)cvp.value);
                comboViewer.setInput(periodOptions);
                comboViewer.setSelection((ISelection)new StructuredSelection(cvp.value), true);
            }
        }
        comboViewer.getCombo().addModifyListener(this.createPeriodModifyListener(properties, comboViewer, constraint, Collections.unmodifiableList(knownPeriodOptions), periodOptions));
        return comboViewer.getControl();
    }

    private boolean containsObject(List<?> list, Object object) {
        for (Object item : list) {
            if (item != object) continue;
            return true;
        }
        return false;
    }

    private <T> ModifyListener createModifyListener(final Set<Property> properties, final Text text, final IConstraint<T> constraint) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                try {
                    String interactiveValue = text.getText();
                    Object value = constraint.parseInteractive(interactiveValue);
                    EventConfigurationPart.this.setFormattedEmptyValue(interactiveValue, value, constraint, arg_0 -> ((Text)text).setMessage(arg_0));
                    EventConfigurationPart.this.updateProperties(properties, constraint.persistableString(value));
                    EventConfigurationPart.this.clearErrorMessage(this);
                }
                catch (QuantityConversionException e) {
                    EventConfigurationPart.this.setErrorMessage(this, e.getLocalizedMessage());
                }
            }
        };
    }

    private ModifyListener createPeriodModifyListener(final Set<Property> properties, final ComboViewer comboViewer, final IConstraint<IQuantity> constraint, final List<IQuantity> knownPeriodOptions, final List<IQuantity> periodOptions) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ISelection selection = comboViewer.getSelection();
                try {
                    Object selected;
                    String interactiveValue = comboViewer.getCombo().getText();
                    IQuantity value = null;
                    if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0 && knownPeriodOptions.contains(selected = ((IStructuredSelection)selection).getFirstElement())) {
                        value = (IQuantity)selected;
                    }
                    if (value == null) {
                        value = (IQuantity)constraint.parseInteractive(interactiveValue);
                    }
                    if (value == periodOptions.get(periodOptions.size() - 1)) {
                        value = (IQuantity)constraint.parseInteractive(interactiveValue);
                        periodOptions.set(periodOptions.size() - 1, value);
                    }
                    EventConfigurationPart.this.setFormattedEmptyValue(interactiveValue, value, constraint, arg_0 -> ((Combo)comboViewer.getCombo()).setText(arg_0));
                    EventConfigurationPart.this.updateProperties(properties, constraint.persistableString((Object)value));
                    EventConfigurationPart.this.clearErrorMessage(this);
                }
                catch (QuantityConversionException e) {
                    EventConfigurationPart.this.setErrorMessage(this, e.getLocalizedMessage());
                }
            }
        };
    }

    protected <T> void setFormattedEmptyValue(String interactiveValue, T value, IConstraint<T> constraint, Consumer<String> msgConsumer) {
        IFormatter formatter;
        String msg;
        if (interactiveValue.isEmpty() && constraint instanceof IFormatter && !(msg = (formatter = (IFormatter)constraint).format(value)).isEmpty()) {
            msgConsumer.accept(msg);
        }
    }

    private void setErrorMessage(Object errorKey, String errorMessage) {
        this.m_errorTracker.trackError(errorKey, errorMessage);
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setPageComplete(!this.m_errorTracker.hasErrors());
        }
    }

    private void clearErrorMessage(Object errorKey) {
        this.setErrorMessage(errorKey, null);
    }

    private void clearErrorMessages() {
        this.m_errorTracker.clear();
    }

    private void updateProperties(Set<Property> properties, String newValue) {
        IEventConfiguration configuration = this.getRecordingConfiguration();
        for (Property property : properties) {
            property.setValue(newValue, PathElement.PathElementKind.IN_CONFIGURATION);
            configuration.putPersistedString(property.getEventOptionID(), newValue);
        }
        this.m_propertyTreeViewer.refresh();
        ((EventConfiguration)configuration).getXMLModel().markDirty();
    }

    private static class CommonValueProperties<T> {
        private IConstraint<T> constraint;
        private T value;

        private CommonValueProperties() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + '[' + this.constraint + ',' + this.value + ']';
        }

        public String interactiveValue() {
            if (this.constraint != null && this.value != null) {
                try {
                    return this.constraint.interactiveFormat(this.value);
                }
                catch (QuantityConversionException e) {
                    ControlPanel.getDefault().getLogger().log(Level.WARNING, e.getMessage(), e);
                }
            }
            return "";
        }

        public String formattedValue() {
            if (this.constraint instanceof IFormatter && this.value != null) {
                IFormatter formatter = (IFormatter)this.constraint;
                return formatter.format(this.value);
            }
            return this.interactiveValue();
        }
    }

    private static class IdentityComparer
    implements IElementComparer {
        private IdentityComparer() {
        }

        public int hashCode(Object element) {
            return element.hashCode();
        }

        public boolean equals(Object a, Object b) {
            return a == b;
        }
    }

    public static class PropertyKey
    implements Comparable<PropertyKey> {
        final String optionLabel;
        final IConstraint<?> constraint;

        public PropertyKey(String optionLabel, IConstraint<?> constraint) {
            this.optionLabel = optionLabel;
            this.constraint = constraint;
        }

        public String getLabel() {
            return this.optionLabel;
        }

        @Override
        public int compareTo(PropertyKey o) {
            int optionCompare = this.optionLabel.compareTo(o.optionLabel);
            if (optionCompare == 0) {
                return this.constraint.hashCode() - o.constraint.hashCode();
            }
            return optionCompare;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.constraint.hashCode();
            result = 31 * result + this.optionLabel.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyKey other = (PropertyKey)obj;
            if (!this.constraint.equals(other.constraint)) {
                return false;
            }
            return this.optionLabel.equals(other.optionLabel);
        }

        public String toString() {
            return String.valueOf(this.optionLabel) + ":" + this.constraint;
        }
    }
}

