/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.ui.charts.XYChart;
import org.openjdk.jmc.ui.misc.ChartButtonGroup;
import org.openjdk.jmc.ui.misc.ChartCanvas;
import org.openjdk.jmc.ui.misc.ChartLaneHeightControls;
import org.openjdk.jmc.ui.misc.ChartTextCanvas;
import org.openjdk.jmc.ui.misc.TimeFilter;

public class ChartControlBar
extends Composite {
    private ChartButtonGroup buttonGroup;
    private ChartLaneHeightControls laneHeightControls;
    private Composite laneFilterContainer;
    private TimeFilter timeFilter;

    public ChartControlBar(Composite parent, Listener resetListener, IRange<IQuantity> recordingRange) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(4, false));
        this.timeFilter = new TimeFilter(this, recordingRange, resetListener);
        this.timeFilter.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.laneFilterContainer = new Composite((Composite)this, 0);
        this.laneFilterContainer.setLayout((Layout)new GridLayout());
        Composite buttonGroupContainer = new Composite((Composite)this, 0);
        buttonGroupContainer.setLayout((Layout)new GridLayout(3, false));
        buttonGroupContainer.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.buttonGroup = new ChartButtonGroup(buttonGroupContainer);
        this.laneHeightControls = new ChartLaneHeightControls(buttonGroupContainer);
        this.buttonGroup.setResetLaneHeightAction(() -> this.resetLaneHeightToMinimum());
    }

    public Composite getLaneFilterContainer() {
        return this.laneFilterContainer;
    }

    public ChartButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    public void resetLaneHeightToMinimum() {
        this.laneHeightControls.resetLaneHeightToMinimum();
    }

    public void setChart(XYChart chart) {
        this.buttonGroup.setChart(chart);
        this.timeFilter.setChart(chart);
    }

    public void setChartCanvas(ChartCanvas canvas) {
        this.buttonGroup.setChartCanvas(canvas);
        this.laneHeightControls.setChartCanvas(canvas);
        this.timeFilter.setChartCanvas(canvas);
    }

    public void setTextCanvas(ChartTextCanvas textCanvas) {
        this.buttonGroup.setTextCanvas(textCanvas);
        this.laneHeightControls.setTextCanvas(textCanvas);
    }

    public void setStartTime(IQuantity startTime) {
        this.timeFilter.setStartTime(startTime);
    }

    public void setEndTime(IQuantity endTime) {
        this.timeFilter.setEndTime(endTime);
    }
}

