/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.internal;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.rjmx.IServerHandle;
import org.openjdk.jmc.rjmx.common.ConnectionException;
import org.openjdk.jmc.rjmx.common.IConnectionDescriptor;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.IConnectionListener;
import org.openjdk.jmc.rjmx.common.IServerDescriptor;
import org.openjdk.jmc.rjmx.common.internal.DefaultConnectionHandle;
import org.openjdk.jmc.rjmx.common.internal.RJMXConnection;
import org.openjdk.jmc.rjmx.common.internal.ServerDescriptor;
import org.openjdk.jmc.rjmx.internal.ServiceFactoryInitializer;
import org.openjdk.jmc.rjmx.internal.SyntheticRepositoryInitializer;

public final class ServerHandle
implements IServerHandle {
    private final List<DefaultConnectionHandle> connectionHandles = new ArrayList<DefaultConnectionHandle>();
    private final RJMXConnection connection;
    private final Runnable observer;
    private Boolean disposedGracefully;
    private final Runnable connectionListener = new Runnable(){

        @Override
        public void run() {
            ServerHandle.this.disconnect();
        }
    };
    private final IConnectionListener connectionHandleListener = new IConnectionListener(){

        public void onConnectionChange(IConnectionHandle handle) {
            if (!handle.isConnected() && ServerHandle.this.removeConnectionHandle(handle)) {
                ServerHandle.this.nofifyObserver();
            }
        }
    };

    public ServerHandle(IConnectionDescriptor descriptor) {
        this((IServerDescriptor)new ServerDescriptor(), descriptor, null);
    }

    public ServerHandle(IServerDescriptor server, IConnectionDescriptor descriptor, Runnable observer) {
        this.observer = observer;
        this.connection = new RJMXConnection(descriptor, server, this.connectionListener, SyntheticRepositoryInitializer.initializeAttributeEntries(), SyntheticRepositoryInitializer.initializeNotificationEntries());
    }

    public IConnectionDescriptor getConnectionDescriptor() {
        return this.connection.getConnectionDescriptor();
    }

    @Override
    public IServerDescriptor getServerDescriptor() {
        return this.connection.getServerDescriptor();
    }

    public synchronized IConnectionHandle[] getConnectionHandles() {
        IConnectionHandle[] handles = new IConnectionHandle[this.connectionHandles.size()];
        Iterator<DefaultConnectionHandle> it = this.connectionHandles.iterator();
        int i = 0;
        while (i < handles.length) {
            handles[i] = (IConnectionHandle)it.next();
            ++i;
        }
        return handles;
    }

    @Override
    public IConnectionHandle connect(String usage) throws ConnectionException {
        IConnectionListener[] listeners = new IConnectionListener[]{this.connectionHandleListener};
        return this.doConnect(usage, listeners);
    }

    @Override
    public IConnectionHandle connect(String usage, IConnectionListener listener) throws ConnectionException {
        IConnectionListener[] listeners = new IConnectionListener[]{listener, this.connectionHandleListener};
        return this.doConnect(usage, listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IConnectionHandle doConnect(String usage, IConnectionListener[] listeners) throws ConnectionException {
        DefaultConnectionHandle newConnectionHandle;
        boolean performedConnect;
        ServerHandle serverHandle = this;
        synchronized (serverHandle) {
            if (this.isDisposed()) {
                throw new ConnectionException("Server handle is disposed");
            }
            performedConnect = this.connection.connect();
            newConnectionHandle = new DefaultConnectionHandle(this.connection, usage, listeners, ServiceFactoryInitializer.initializeFromExtensions());
            this.connectionHandles.add(newConnectionHandle);
        }
        if (performedConnect) {
            this.nofifyObserver();
        }
        return newConnectionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(boolean gracefully) {
        ServerHandle serverHandle = this;
        synchronized (serverHandle) {
            if (!this.isDisposed()) {
                this.disposedGracefully = gracefully;
            }
        }
        this.disconnect();
    }

    @Override
    public void dispose() {
        this.dispose(true);
    }

    private synchronized boolean isDisposed() {
        return this.disposedGracefully != null;
    }

    private synchronized boolean removeConnectionHandle(IConnectionHandle handle) {
        this.connectionHandles.remove(handle);
        if (this.connectionHandles.size() == 0) {
            this.connection.close();
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.disconnect();
    }

    private void disconnect() {
        IConnectionHandle[] iConnectionHandleArray = this.getConnectionHandles();
        int n = iConnectionHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionHandle handle = iConnectionHandleArray[n2];
            IOToolkit.closeSilently((Closeable)handle);
            ++n2;
        }
    }

    public String toString() {
        return this.connection.toString();
    }

    private void nofifyObserver() {
        if (this.observer != null) {
            this.observer.run();
        }
    }

    @Override
    public synchronized IServerHandle.State getState() {
        if (this.isDisposed()) {
            return this.disposedGracefully != false ? IServerHandle.State.DISPOSED : IServerHandle.State.FAILED;
        }
        return this.connection.isConnected() ? IServerHandle.State.CONNECTED : IServerHandle.State.DISCONNECTED;
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }
}

