/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.util.internal;

import java.util.ArrayList;
import java.util.List;
import org.openjdk.jmc.common.tree.IParent;
import org.openjdk.jmc.rjmx.RJMXPlugin;

public class PartitionedList<T>
implements IParent<T>,
Comparable<PartitionedList<T>> {
    private final int firstObjectIndex;
    private final int lastObjectIndex;
    private final List<T> list;
    private final int fromIndex;
    private final int toIndex;

    private PartitionedList(int firstObjectIndex, int lastObjectIndex, List<T> list, int fromIndex, int toIndex) {
        this.firstObjectIndex = firstObjectIndex;
        this.lastObjectIndex = lastObjectIndex;
        this.list = list;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    public boolean hasChildren() {
        return true;
    }

    public List<T> getChildren() {
        return this.list.subList(this.fromIndex, this.toIndex);
    }

    public String toString() {
        return "[" + this.firstObjectIndex + "..." + this.lastObjectIndex + ']';
    }

    @Override
    public int compareTo(PartitionedList<T> o) {
        return this.fromIndex - o.fromIndex;
    }

    public static <T> List<?> create(List<T> list) {
        int maxChildCount = RJMXPlugin.getDefault().getRJMXPreferences().getInt("rjmx.internal.listAggregateSize", 40);
        return PartitionedList.create(list, 1, list.size(), maxChildCount);
    }

    static <T> List<?> create(List<T> list, int levelMultiplier, int totalObjects, int maxChildCount) {
        int size = list.size();
        if (size > maxChildCount) {
            int partitionCount = (int)Math.ceil((double)size / (double)maxChildCount);
            ArrayList<PartitionedList<T>> partitions = new ArrayList<PartitionedList<T>>(partitionCount);
            int i = 0;
            while (i < partitionCount) {
                int fromIndex = i * maxChildCount;
                int toIndex = Math.min((i + 1) * maxChildCount, size);
                int firstObjectIndex = levelMultiplier * fromIndex;
                int lastObjectIndex = Math.min(totalObjects, levelMultiplier * toIndex) - 1;
                partitions.add(new PartitionedList<T>(firstObjectIndex, lastObjectIndex, list, fromIndex, toIndex));
                ++i;
            }
            return PartitionedList.create(partitions, levelMultiplier * maxChildCount, totalObjects, maxChildCount);
        }
        return list;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.firstObjectIndex;
        result = 31 * result + this.fromIndex;
        result = 31 * result + this.lastObjectIndex;
        result = 31 * result + (this.list == null ? 0 : this.list.hashCode());
        result = 31 * result + this.toIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartitionedList other = (PartitionedList)obj;
        if (this.firstObjectIndex != other.firstObjectIndex) {
            return false;
        }
        if (this.fromIndex != other.fromIndex) {
            return false;
        }
        if (this.lastObjectIndex != other.lastObjectIndex) {
            return false;
        }
        if (this.list == null ? other.list != null : !this.list.equals(other.list)) {
            return false;
        }
        return this.toIndex == other.toIndex;
    }
}

