/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.internal;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.openjdk.jmc.rjmx.common.subscription.MRI;
import org.openjdk.jmc.rjmx.ui.internal.AttributeConfiguratorTableFactory;
import org.openjdk.jmc.rjmx.ui.internal.AttributeLabelProvider;
import org.openjdk.jmc.rjmx.ui.internal.AttributeSelectionContentModel;
import org.openjdk.jmc.rjmx.ui.internal.AttributeSelectionViewModel;

public class AttributeConfiguratorWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "org.openjdk.jmc.rjmx.attribute.configuration";
    private final AttributeSelectionViewModel m_viewModel;
    private final AttributeSelectionContentModel m_selectorModel;
    private TableViewer table;

    private static AttributeLabelProvider createNameLabelProvider(AttributeSelectionContentModel selectorModel) {
        return new AttributeLabelProvider(selectorModel.getMetadataService(), selectorModel.getMRIService());
    }

    public AttributeConfiguratorWizardPage(AttributeSelectionViewModel viewModel, AttributeSelectionContentModel selectorModel) {
        super(PAGE_NAME, viewModel.getConfigureAttributePageTitle(), null);
        this.setDescription(viewModel.getConfigureAttributePageDescription());
        this.m_viewModel = viewModel;
        this.m_selectorModel = selectorModel;
    }

    public void createControl(Composite parent) {
        this.table = AttributeConfiguratorTableFactory.createAttributeConfiguratorTable(parent, AttributeConfiguratorWizardPage.createNameLabelProvider(this.m_selectorModel), this.m_viewModel, this.m_selectorModel, new Runnable(){

            @Override
            public void run() {
                AttributeConfiguratorWizardPage.this.setPageComplete(AttributeConfiguratorWizardPage.this.isPageComplete());
            }
        });
        this.setControl((Control)this.table.getTable());
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.table.setInput((Object)this.m_selectorModel.getSelectedAttributes());
        }
        super.setVisible(visible);
    }

    public boolean isPageComplete() {
        MRI[] selectedAttributes = this.m_selectorModel.getSelectedAttributes();
        if (selectedAttributes.length == 0) {
            return false;
        }
        if (this.m_viewModel.isNumericalOnly()) {
            MRI[] mRIArray = selectedAttributes;
            int n = selectedAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                MRI attribute = mRIArray[n2];
                if (this.m_selectorModel.getAttributeUnit(attribute) == null) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }
}

