/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.jdp.client;

import java.util.Collection;
import org.openjdk.jmc.jdp.client.DiscoveryEvent;
import org.openjdk.jmc.jdp.client.JDPClient;
import org.openjdk.jmc.jdp.client.PacketProcessor;

final class Pruner
implements Runnable {
    static final long PRUNING_INTERVAL = 3000L;
    static final int DEFAULT_MAX_HB_TIME = 12000;
    final int maxHBTime;
    static double HB_MISSED_BEFORE_DOWN = 2.5;
    private volatile boolean isRunning;
    private final PacketProcessor processor;

    public Pruner(PacketProcessor processor, int maxHBTime) {
        this.processor = processor;
        this.maxHBTime = maxHBTime;
    }

    @Override
    public void run() {
        JDPClient.LOGGER.fine("JDP prune thread started!");
        this.isRunning = true;
        while (this.isRunning) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkPackets();
        }
        JDPClient.LOGGER.info("JDP prune thread shutting down!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPackets() {
        JDPClient.LOGGER.finer("JDP prune checking...");
        long now = System.currentTimeMillis();
        PacketProcessor packetProcessor = this.processor;
        synchronized (packetProcessor) {
            PacketProcessor.DiscoverableInfo[] discoverableInfos;
            Collection<PacketProcessor.DiscoverableInfo> values = this.processor.infoMap.values();
            for (PacketProcessor.DiscoverableInfo info : discoverableInfos = values.toArray(new PacketProcessor.DiscoverableInfo[values.size()])) {
                if (info.heartBeat != 0L) {
                    if (!((double)(now - info.timestamp) > (double)info.heartBeat * HB_MISSED_BEFORE_DOWN)) continue;
                    this.remove(info);
                    continue;
                }
                if (now - info.timestamp <= (long)this.maxHBTime) continue;
                this.remove(info);
            }
        }
    }

    private void remove(PacketProcessor.DiscoverableInfo info) {
        this.processor.infoMap.remove(info.packet.getSessionId());
        JDPClient.LOGGER.fine("Lost " + info.packet);
        this.processor.fireEvent(new DiscoveryEvent(DiscoveryEvent.Kind.LOST, info.packet));
    }

    public void stop() {
        this.isRunning = false;
    }
}

