/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.tabs.system;

import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.jvm.JVMDescriptor;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.console.ui.messages.internal.Messages;
import org.openjdk.jmc.rjmx.common.ConnectionToolkit;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.IServerDescriptor;
import org.openjdk.jmc.ui.UIPlugin;

public class ServerInformationModelBuilder {
    private static String getConnectionInformation(IConnectionHandle ch) {
        String serverName = ch.getServerDescriptor().getDisplayName();
        return NLS.bind((String)Messages.CONNECTION_INFORMATION_VALUE, (Object)serverName, (Object)ch.toString());
    }

    private static String getOsVersion(Map<String, String> systemProperties) {
        return String.valueOf(systemProperties.get("os.name")) + ' ' + systemProperties.get("os.version");
    }

    private static IQuantity getTotalPhysicalMemory(MBeanServerConnection server) {
        Object memory = ServerInformationModelBuilder.getAttributeValue(server, "java.lang:type=OperatingSystem", "TotalPhysicalMemorySize");
        return memory instanceof Number ? UnitLookup.BYTE.quantity((Number)memory) : null;
    }

    private static Integer getPID(RuntimeMXBean runtimeBean) {
        try {
            return Integer.valueOf(runtimeBean.getName().split("@")[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getVmVersion(Map<String, String> systemProperties) {
        Object[] values = new String[]{systemProperties.get("java.vm.name"), systemProperties.get("java.vm.version"), systemProperties.get("java.runtime.version")};
        return values[0].isEmpty() ? "" : NLS.bind((String)Messages.VM_VERSION_VALUE, (Object[])values);
    }

    private static String getVmArguments(List<String> arguments) {
        StringBuilder argBuilder = new StringBuilder();
        for (String argument : arguments) {
            if (argBuilder.length() > 0) {
                argBuilder.append(' ');
            }
            argBuilder.append(argument);
        }
        return argBuilder.toString();
    }

    private static String getApplicationArguments(IServerDescriptor serverDesc, MBeanServerConnection server, Map<String, String> systemProperties) {
        JVMDescriptor jvmInfo;
        Object a = ServerInformationModelBuilder.getAttributeValue(server, "oracle.jrockit.management:type=PerfCounters", "sun.rt.javaCommand");
        if (a != null) {
            return a.toString();
        }
        String arguments = systemProperties.get("sun.java.command");
        if ((arguments == null || arguments.length() == 0) && (jvmInfo = serverDesc.getJvmInfo()) != null && jvmInfo.getJavaCommand() != null) {
            arguments = jvmInfo.getJavaCommand();
        }
        return arguments == null ? "" : arguments;
    }

    private static Object getAttributeValue(MBeanServerConnection server, String mBean, String attribute) {
        try {
            return server.getAttribute(new ObjectName(mBean), attribute);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object[][] build(IConnectionHandle connection) {
        try {
            IServerDescriptor serverDescriptor = connection.getServerDescriptor();
            MBeanServerConnection server = (MBeanServerConnection)connection.getServiceOrThrow(MBeanServerConnection.class);
            RuntimeMXBean rtBean = ConnectionToolkit.getRuntimeBean((MBeanServerConnection)server);
            OperatingSystemMXBean osBean = ConnectionToolkit.getOperatingSystemBean((MBeanServerConnection)server);
            Map<String, String> props = rtBean.getSystemProperties();
            return new Object[][]{ServerInformationModelBuilder.buildDataRow(Messages.CONNECTION_INFORMATION_LABEL, ServerInformationModelBuilder.getConnectionInformation(connection)), ServerInformationModelBuilder.buildDataRow(Messages.OPERATING_SYSTEM_LABEL, ServerInformationModelBuilder.getOsVersion(props)), ServerInformationModelBuilder.buildDataRow(Messages.OPERATING_SYSTEM_ARCHITECTURE_LABEL, props.get("os.arch")), ServerInformationModelBuilder.buildDataRow(Messages.NUMBER_OF_PROCESSORS_LABEL, UnitLookup.NUMBER_UNITY.quantity((long)osBean.getAvailableProcessors())), ServerInformationModelBuilder.buildDataRow(Messages.TOTAL_PHYSICAL_MEMORY_LABEL, ServerInformationModelBuilder.getTotalPhysicalMemory(server)), ServerInformationModelBuilder.buildDataRow(Messages.PROCESS_ID_LABEL, ServerInformationModelBuilder.getPID(rtBean)), ServerInformationModelBuilder.buildDataRow(Messages.VM_VERSION_LABEL, ServerInformationModelBuilder.getVmVersion(props)), ServerInformationModelBuilder.buildDataRow(Messages.VM_VENDOR_LABEL, props.get("java.vm.vendor")), ServerInformationModelBuilder.buildDataRow(Messages.START_TIME_LABEL, UnitLookup.EPOCH_MS.quantity(rtBean.getStartTime())), ServerInformationModelBuilder.buildDataRow(Messages.CLASS_PATH_LABEL, props.get("java.class.path")), ServerInformationModelBuilder.buildDataRow(Messages.VM_ARGUMENTS_LABEL, ServerInformationModelBuilder.getVmArguments(rtBean.getInputArguments())), ServerInformationModelBuilder.buildDataRow(Messages.APPLICATION_ARGUMENTS_LABEL, ServerInformationModelBuilder.getApplicationArguments(serverDescriptor, server, props)), ServerInformationModelBuilder.buildDataRow(Messages.LIBRARY_PATH_LABEL, props.get("java.library.path")), ServerInformationModelBuilder.buildDataRow(Messages.BOOT_CLASS_PATH_LABEL, props.get("sun.boot.class.path"))};
        }
        catch (Exception e) {
            UIPlugin.getDefault().getLogger().log(Level.WARNING, "Could not build ServerInformationModel", e);
            return new Object[0][];
        }
    }

    private static Object[] buildDataRow(String label, Object value) {
        return new Object[]{label, value};
    }
}

