/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.logging.Level;
import org.openjdk.jmc.common.unit.ComparableConstraint;
import org.openjdk.jmc.common.unit.IConstraint;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.configuration.events.SchemaVersion;
import org.openjdk.jmc.flightrecorder.configuration.internal.CommonConstraints;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.JFCGrammar;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLAttribute;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLModel;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLTag;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLTagInstance;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.AndNode;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.ConditionNode;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.ConditionNodeItem;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.FlagNode;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.Node;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.NotNode;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.OrNode;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.ProducerEnvironment;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.SelectionNode;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.SettingNode;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.TestNode;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.TextNode;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.configuration.model.gui.WidgetNode;
import org.openjdk.jmc.ui.UIPlugin;

public final class GUIModel
extends Observable {
    private static final IPersister<String> PLAIN_TEXT_PERSISTER = UnitLookup.PLAIN_TEXT.getPersister();
    private final List<ProducerEnvironment> m_producerEnvs;
    private final HashMap<String, Node> m_transmitterNodes;
    private final HashMap<String, List<Node>> m_receiverNodeLists;
    private final XMLModel m_model;
    private SchemaVersion m_schemaVersion;

    public GUIModel(XMLModel model) {
        this.m_model = model;
        this.m_producerEnvs = new ArrayList<ProducerEnvironment>();
        this.m_transmitterNodes = new HashMap();
        this.m_receiverNodeLists = new HashMap();
        this.m_schemaVersion = SchemaVersion.fromBeanVersion((String)this.m_model.getRoot().getValue(JFCGrammar.ATTRIBUTE_VERSION));
        for (XMLTagInstance producerElement : model.getRoot().getTagsInstances(JFCGrammar.TAG_PRODUCER)) {
            this.createProducer(producerElement);
        }
        this.createGlobalProducer(model.getRoot());
        this.hookupTransmittersAndReceivers();
    }

    private void hookupTransmittersAndReceivers() {
        for (Map.Entry<String, List<Node>> entry : this.m_receiverNodeLists.entrySet()) {
            Node transmitter = this.m_transmitterNodes.get(entry.getKey());
            if (transmitter == null) continue;
            for (Node receiver : entry.getValue()) {
                transmitter.addReceiver(receiver);
            }
        }
    }

    public void evaluate() {
        for (ProducerEnvironment producer : this.m_producerEnvs) {
            for (WidgetNode topNode : producer.getWidgets()) {
                topNode.fireChange();
            }
        }
    }

    private void createProducer(XMLTagInstance producerElement) {
        ProducerEnvironment producerEnv = this.createProducerEnvironment(producerElement);
        this.createControls(producerElement.getTagsInstances(JFCGrammar.TAG_CONTROL), producerEnv);
        this.createEventSettings(producerElement.getTagsInstances(JFCGrammar.TAG_EVENTTYPE_V1), producerEnv);
    }

    private ProducerEnvironment createProducerEnvironment(XMLTagInstance producerElement) {
        ProducerEnvironment environment = new ProducerEnvironment();
        environment.setName(producerElement.getValue(JFCGrammar.ATTRIBUTE_LABEL));
        environment.setDescription(producerElement.getValue(JFCGrammar.ATTRIBUTE_DESCRIPTION));
        environment.setURI(producerElement.getValue(JFCGrammar.ATTRIBUTE_URI));
        this.m_producerEnvs.add(environment);
        return environment;
    }

    private void createGlobalProducer(XMLTagInstance rootElement) {
        List controlElements = rootElement.getTagsInstances(JFCGrammar.TAG_CONTROL);
        if (!controlElements.isEmpty()) {
            ProducerEnvironment environment = new ProducerEnvironment();
            environment.setDescription(rootElement.getValue(JFCGrammar.ATTRIBUTE_DESCRIPTION));
            this.m_producerEnvs.add(environment);
            this.createControls(controlElements, environment);
            this.createEventSettings(this.findNestedEventsV2(rootElement), environment);
        }
    }

    private List<XMLTagInstance> findNestedEventsV2(XMLTagInstance rootElement) {
        List categories = rootElement.getTagsInstances(JFCGrammar.TAG_CATEGORY);
        List events = rootElement.getTagsInstances(JFCGrammar.TAG_EVENTTYPE_V2);
        int i = 0;
        while (i < categories.size()) {
            XMLTagInstance category = (XMLTagInstance)categories.get(i);
            events.addAll(category.getTagsInstances(JFCGrammar.TAG_EVENTTYPE_V2));
            for (XMLTagInstance subcategory : category.getTagsInstances(JFCGrammar.TAG_CATEGORY)) {
                categories.add(subcategory);
            }
            ++i;
        }
        return events;
    }

    private void createControls(Iterable<XMLTagInstance> controlElements, ProducerEnvironment producerEnv) {
        for (XMLTagInstance controlElement : controlElements) {
            this.createInputs(controlElement, producerEnv);
            this.createConditionals(controlElement, producerEnv);
        }
    }

    public String addProducerPrefix(ProducerEnvironment producerEnv, XMLTagInstance tagInstance, XMLAttribute attribute) {
        String value = tagInstance.getValue(attribute);
        if (GUIModel.isURI(value)) {
            return value;
        }
        return String.valueOf(producerEnv.getURI()) + value;
    }

    private static boolean isURI(String value) {
        return value.contains(":");
    }

    private void createConditionals(XMLTagInstance controlElement, ProducerEnvironment producerEnv) {
        for (XMLTagInstance conditionElement : controlElement.getTagsInstances(JFCGrammar.TAG_CONDITION)) {
            ConditionNodeItem item = this.buildConditionItem(producerEnv, conditionElement);
            String name = this.addProducerPrefix(producerEnv, conditionElement, JFCGrammar.ATTRIBUTE_NAME_DEFINITION);
            ConditionNode node = (ConditionNode)this.m_transmitterNodes.get(name);
            if (node == null) {
                node = new ConditionNode();
                this.addTransmitterNode(producerEnv, name, node);
            }
            item.addReceiver(node);
        }
    }

    private void createEventSettings(Iterable<XMLTagInstance> eventElements, ProducerEnvironment producerEnv) {
        for (XMLTagInstance eventElement : eventElements) {
            for (XMLTagInstance settingElement : eventElement.getTagsInstances(JFCGrammar.TAG_SETTING)) {
                this.createSetting(producerEnv, settingElement);
            }
        }
    }

    private void createSetting(ProducerEnvironment producerEnv, XMLTagInstance settingElement) {
        String variableName = settingElement.getValue(JFCGrammar.ATTRIBUTE_CONTROL_REFERENCE);
        if (!variableName.trim().isEmpty()) {
            variableName = this.addProducerPrefix(producerEnv, settingElement, JFCGrammar.ATTRIBUTE_CONTROL_REFERENCE);
            this.addReceiverNode(producerEnv, variableName, new SettingNode(this.m_model, settingElement));
        }
    }

    private void addReceiverNode(ProducerEnvironment producerEnv, String variableName, Node receiverNode) {
        List<Node> receiverList = this.m_receiverNodeLists.get(variableName);
        if (receiverList == null) {
            receiverList = new ArrayList<Node>();
            this.m_receiverNodeLists.put(variableName, receiverList);
        }
        receiverList.add(receiverNode);
    }

    private void addTransmitterNode(ProducerEnvironment producerEnv, String variableName, Node transmitterNode) {
        producerEnv.addNode(transmitterNode);
        this.m_transmitterNodes.put(variableName, transmitterNode);
    }

    private void createInputs(XMLTagInstance controlElement, ProducerEnvironment producerEnv) {
        for (XMLTagInstance inputElement : controlElement.getTagsInstances()) {
            String name;
            WidgetNode node;
            if (inputElement.getTag() == JFCGrammar.TAG_TEXT) {
                String typeStr = inputElement.getExplicitValue(JFCGrammar.ATTRIBUTE_CONTENT_TYPE);
                String minPersisted = inputElement.getExplicitValue(JFCGrammar.ATTRIBUTE_MINIMUM);
                String maxPersisted = inputElement.getExplicitValue(JFCGrammar.ATTRIBUTE_MAXIMUM);
                IConstraint constraint = PLAIN_TEXT_PERSISTER;
                if (this.m_schemaVersion != SchemaVersion.V1) {
                    constraint = CommonConstraints.forContentTypeV2((String)typeStr);
                }
                if (constraint == PLAIN_TEXT_PERSISTER) {
                    constraint = CommonConstraints.forContentTypeV1((String)typeStr);
                }
                if (constraint != PLAIN_TEXT_PERSISTER) {
                    try {
                        constraint = ComparableConstraint.constrain((IConstraint)constraint, (String)minPersisted, (String)maxPersisted);
                    }
                    catch (QuantityConversionException e) {
                        UIPlugin.getDefault().getLogger().log(Level.WARNING, "Control element limit out of range.", e);
                    }
                }
                TextNode node2 = new TextNode(this.m_model, inputElement, constraint);
                node2.setLabel(inputElement.getValue(JFCGrammar.ATTRIBUTE_LABEL_MANDATORY));
                node2.setDescription(inputElement.getValue(JFCGrammar.ATTRIBUTE_DESCRIPTION));
                String name2 = this.addProducerPrefix(producerEnv, inputElement, JFCGrammar.ATTRIBUTE_NAME_DEFINITION);
                this.addTransmitterNode(producerEnv, name2, node2);
            }
            if (inputElement.getTag() == JFCGrammar.TAG_FLAG) {
                node = new FlagNode(this.m_model, inputElement);
                node.setLabel(inputElement.getValue(JFCGrammar.ATTRIBUTE_LABEL_MANDATORY));
                node.setDescription(inputElement.getValue(JFCGrammar.ATTRIBUTE_DESCRIPTION));
                name = this.addProducerPrefix(producerEnv, inputElement, JFCGrammar.ATTRIBUTE_NAME_DEFINITION);
                this.addTransmitterNode(producerEnv, name, node);
            }
            if (inputElement.getTag() != JFCGrammar.TAG_SELECTION) continue;
            node = new SelectionNode(this.m_model, inputElement);
            node.setLabel(inputElement.getValue(JFCGrammar.ATTRIBUTE_LABEL_MANDATORY));
            node.setDescription(inputElement.getValue(JFCGrammar.ATTRIBUTE_DESCRIPTION));
            name = this.addProducerPrefix(producerEnv, inputElement, JFCGrammar.ATTRIBUTE_NAME_DEFINITION);
            for (XMLTagInstance optionElement : inputElement.getTagsInstances(JFCGrammar.TAG_OPTION)) {
                ((SelectionNode)node).addItem(optionElement);
            }
            this.addTransmitterNode(producerEnv, name, node);
        }
    }

    private ConditionNodeItem buildConditionItem(ProducerEnvironment producerEnv, XMLTagInstance conditionElement) {
        ConditionNodeItem cv = new ConditionNodeItem(conditionElement.getValue(JFCGrammar.ATTRIBUTE_TRUE), conditionElement.getValue(JFCGrammar.ATTRIBUTE_FALSE));
        List children = conditionElement.getTagsInstances();
        if (children.size() == 1) {
            this.createLogicNode(producerEnv, (XMLTagInstance)children.get(0)).addReceiver(cv);
            return cv;
        }
        throw new IllegalArgumentException("Condition must have exactly one direct child");
    }

    private Node createLogicNode(ProducerEnvironment producerEnv, XMLTagInstance logicElement) {
        XMLTag tag = logicElement.getTag();
        List children = logicElement.getTagsInstances();
        if (tag == JFCGrammar.TAG_TEST) {
            if (children.isEmpty()) {
                String variableName = this.addProducerPrefix(producerEnv, logicElement, JFCGrammar.ATTRIBUTE_NAME_REFERENCE);
                String operator = logicElement.getValue(JFCGrammar.ATTRIBUTE_OPERATOR);
                String value = logicElement.getValue(JFCGrammar.ATTRIBUTE_VALUE);
                TestNode test = new TestNode(value, operator);
                this.addReceiverNode(producerEnv, variableName, test);
                return test;
            }
            throw new IllegalArgumentException(JFCGrammar.TAG_TEST + " mustn't have any child elements");
        }
        if (tag == JFCGrammar.TAG_NOT) {
            if (children.size() == 1) {
                NotNode notNode = new NotNode();
                Node childNode = this.createLogicNode(producerEnv, (XMLTagInstance)children.get(0));
                childNode.addReceiver(notNode);
                return notNode;
            }
            throw new IllegalArgumentException(JFCGrammar.TAG_NOT + " must have a single child element");
        }
        if (tag == JFCGrammar.TAG_AND) {
            AndNode and = new AndNode();
            this.hookOperatorChildren(producerEnv, and, children);
            return and;
        }
        if (tag == JFCGrammar.TAG_OR) {
            OrNode or = new OrNode();
            this.hookOperatorChildren(producerEnv, or, children);
            return or;
        }
        throw new IllegalArgumentException("Unknown tag " + tag);
    }

    private void hookOperatorChildren(ProducerEnvironment producerEnv, Node operatorNode, List<XMLTagInstance> operandElements) {
        for (XMLTagInstance childElement : operandElements) {
            this.createLogicNode(producerEnv, childElement).addReceiver(operatorNode);
        }
    }

    public List<ProducerEnvironment> getProducers() {
        return this.m_producerEnvs;
    }
}

