/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.common.idesupport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.openjdk.jmc.common.util.Filename;
import org.openjdk.jmc.ui.common.CorePlugin;
import org.openjdk.jmc.ui.common.idesupport.JobFileWrite;
import org.openjdk.jmc.ui.common.resource.MCFile;

public final class IDESupportToolkit {
    private IDESupportToolkit() {
        throw new AssertionError((Object)"Toolkit - do not instantiate!");
    }

    public static Job writeAsJob(String jobName, MCFile file, InputStream stream, boolean append) {
        JobFileWrite writeJob = new JobFileWrite(jobName, file, stream, append);
        writeJob.schedule();
        return writeJob;
    }

    public static MCFile createFileResource(String resourcePath) throws IllegalArgumentException {
        return CorePlugin.getDefault().getIDESupport().createFileResource(resourcePath);
    }

    public static MCFile createDefaultFileResource(String resourcePath) throws IllegalArgumentException {
        return CorePlugin.getDefault().getIDESupport().createDefaultFileResource(resourcePath);
    }

    public static IPath getDefaultRecordingFolder() {
        return CorePlugin.getDefault().getIDESupport().getDefaultRecordingFolder();
    }

    public static File resolveFileSystemPath(String resourcePath) throws FileNotFoundException {
        return CorePlugin.getDefault().getIDESupport().resolveFileSystemPath(resourcePath);
    }

    public static IStatus validateFileResourcePath(String resourcePath) {
        return CorePlugin.getDefault().getIDESupport().validateFileResourcePath(resourcePath);
    }

    public static File writeToUniqueFile(MCFile file, InputStream stream, IProgressMonitor monitor) throws IOException {
        Path path = new Path(file.getPath());
        Filename filename = Filename.splitFilename((String)path.lastSegment());
        path = path.removeLastSegments(1);
        while (!file.tryWriteStream(stream, monitor)) {
            IPath uniquePath = path.append(filename.asRandomFilename().toString());
            file = IDESupportToolkit.createFileResource(uniquePath.toOSString());
        }
        return IDESupportToolkit.resolveFileSystemPath(file.getPath());
    }
}

