/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.servermodel.internal;

import java.util.function.Consumer;
import java.util.logging.Level;
import javax.management.remote.JMXServiceURL;
import org.openjdk.jmc.common.action.IActionProvider;
import org.openjdk.jmc.common.jvm.JVMDescriptor;
import org.openjdk.jmc.common.labelingrules.NameConverter;
import org.openjdk.jmc.common.resource.Resource;
import org.openjdk.jmc.common.security.ICredentials;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.actionprovider.internal.ActionProviderRepository;
import org.openjdk.jmc.rjmx.common.IConnectionDescriptor;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.IServerDescriptor;
import org.openjdk.jmc.rjmx.common.internal.ServerDescriptor;
import org.openjdk.jmc.rjmx.common.servermodel.IDiscoveryInfo;
import org.openjdk.jmc.rjmx.internal.ServerHandle;
import org.openjdk.jmc.rjmx.servermodel.IServer;
import org.openjdk.jmc.ui.common.resource.IImageResource;
import org.openjdk.jmc.ui.common.util.ICopyable;

public class Server
implements IServer,
ICopyable,
IImageResource {
    private final ICredentials credentials;
    private final IDiscoveryInfo discoveryInfo;
    private final JMXServiceURL url;
    private final Resource imageResource;
    private IActionProvider actionProvider;
    private String path;
    private ServerHandle serverHandle;
    private Consumer<? super Server> observer;
    private final Runnable listener = new Runnable(){

        @Override
        public void run() {
            Consumer<? super Server> o = Server.this.getObserver();
            if (o != null) {
                try {
                    o.accept(Server.this);
                }
                catch (Exception e) {
                    RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Notify Server observer " + o + " failed", e);
                }
            }
        }
    };

    public Server(String path, JMXServiceURL url, ICredentials credentials, IDiscoveryInfo discoveryInfo, IServerDescriptor serverDesc, IConnectionDescriptor connector) {
        this.discoveryInfo = discoveryInfo;
        this.credentials = credentials;
        this.path = path;
        this.url = url;
        JVMDescriptor jvmInfo = serverDesc.getJvmInfo();
        this.imageResource = jvmInfo != null ? NameConverter.getInstance().getImageResource(jvmInfo) : null;
        this.serverHandle = new ServerHandle(serverDesc, connector, this.listener);
        this.actionProvider = ActionProviderRepository.buildActionProvider(this.serverHandle);
    }

    synchronized void setObserver(Consumer<? super Server> observer) {
        this.observer = observer;
    }

    private synchronized Consumer<? super Server> getObserver() {
        return this.observer;
    }

    @Override
    public IDiscoveryInfo getDiscoveryInfo() {
        return this.discoveryInfo;
    }

    public ICredentials getCredentials() {
        return this.credentials;
    }

    public synchronized void setPath(String path) {
        this.path = path;
    }

    public synchronized String getPath() {
        return this.path;
    }

    @Override
    public synchronized ServerHandle getServerHandle() {
        return this.serverHandle;
    }

    @Override
    public synchronized IActionProvider getActionProvider() {
        return this.actionProvider;
    }

    @Override
    public synchronized IConnectionHandle[] getConnectionHandles() {
        return this.serverHandle.getConnectionHandles();
    }

    public boolean isCopyable() {
        return this.url != null;
    }

    public JMXServiceURL getConnectionUrl() {
        return this.url;
    }

    public synchronized Object copy() {
        IServerDescriptor originalSd = this.serverHandle.getServerDescriptor();
        ServerDescriptor desc = new ServerDescriptor(null, originalSd.getDisplayName(), originalSd.getJvmInfo());
        return new Server(this.path, this.url, this.credentials, null, (IServerDescriptor)desc, this.serverHandle.getConnectionDescriptor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        ServerHandle oldHandle;
        Server server = this;
        synchronized (server) {
            oldHandle = this.serverHandle;
            this.serverHandle = new ServerHandle(oldHandle.getServerDescriptor(), oldHandle.getConnectionDescriptor(), this.listener);
            this.actionProvider = ActionProviderRepository.buildActionProvider(this.serverHandle);
        }
        oldHandle.dispose(true);
    }

    public Resource getImageResource() {
        return this.imageResource;
    }
}

