/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.dependencyview;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.flightrecorder.dependencyview.Messages;
import org.openjdk.jmc.flightrecorder.serializers.json.IItemCollectionJsonSerializer;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.ui.common.util.AdapterUtil;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public class DependencyView
extends ViewPart
implements ISelectionListener {
    private static final Logger LOGGER = Logger.getLogger(DependencyView.class.getName());
    private static final String DIR_ICONS = "icons/";
    private static final String PLUGIN_ID = "org.openjdk.jmc.flightrecorder.dependencyview";
    private static final String HTML_PAGE;
    private static final int MODEL_EXECUTOR_THREADS_NUMBER = 3;
    private static final ExecutorService MODEL_EXECUTOR;
    private Browser browser;
    private SashForm container;
    private IItemCollection currentItems;
    private volatile ModelState modelState = ModelState.NONE;
    private ModelRebuildRunnable modelRebuildRunnable;
    private int packageDepth = 2;
    private DiagramType diagramType = DiagramType.CHORD;

    static {
        String jsD3 = "jslibs/d3.v7.min.js";
        HTML_PAGE = String.format(DependencyView.loadStringFromFile("page.template"), DependencyView.loadLibraries(jsD3), DependencyView.loadStringFromFile("main.js"), DependencyView.loadStringFromFile("utils.js"), DependencyView.loadStringFromFile("hierarchical-edge.js"), DependencyView.loadStringFromFile("chord.js"));
        MODEL_EXECUTOR = Executors.newFixedThreadPool(3, new ThreadFactory(){
            private ThreadGroup group = new ThreadGroup("DependencyViewCalculationGroup");
            private AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(this.group, r, "DependencyViewCalculation-" + this.counter.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        });
    }

    private static ImageDescriptor dependencyViewImageDescriptor(String iconName) {
        return ResourceLocator.imageDescriptorFromBundle((String)PLUGIN_ID, (String)(DIR_ICONS + iconName)).orElse(null);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        IToolBarManager toolBar = site.getActionBars().getToolBarManager();
        ChangeDiagramTypeAction[] chartTypeActions = new ChangeDiagramTypeAction[]{new ChangeDiagramTypeAction(DiagramType.CHORD), new ChangeDiagramTypeAction(DiagramType.EDGE_BUNDLING)};
        Stream.of(chartTypeActions).forEach(arg_0 -> ((IToolBarManager)toolBar).add(arg_0));
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)new PackageDepthSelection());
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.container = new SashForm(parent, 256);
        this.browser = new Browser((Composite)this.container, 0);
        this.container.setMaximizedControl((Control)this.browser);
        this.browser.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                e.doit = false;
            }
        });
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    public void saveState(IMemento memento) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object first = ((IStructuredSelection)selection).getFirstElement();
            IItemCollection items = (IItemCollection)AdapterUtil.getAdapter((Object)first, IItemCollection.class);
            if (items == null) {
                this.triggerRebuildTask(ItemCollectionToolkit.build(Stream.empty()));
            } else if (!items.equals(this.currentItems)) {
                this.triggerRebuildTask(items);
            }
        }
    }

    private void triggerRebuildTask(IItemCollection items) {
        if (this.modelRebuildRunnable != null) {
            this.modelRebuildRunnable.setInvalid();
        }
        this.currentItems = items;
        this.modelState = ModelState.NOT_STARTED;
        this.modelRebuildRunnable = new ModelRebuildRunnable(this, items, this.packageDepth);
        if (!this.modelRebuildRunnable.isInvalid) {
            MODEL_EXECUTOR.execute(this.modelRebuildRunnable);
        }
    }

    private void setModel(IItemCollection items, String eventsJson, int packageDepth) {
        if (ModelState.FINISHED.equals((Object)this.modelState) && items.equals(this.currentItems) && !this.browser.isDisposed()) {
            this.setViewerInput(eventsJson, packageDepth);
        }
    }

    private void setViewerInput(final String eventsJson, final int packageDepth) {
        this.browser.setText(HTML_PAGE);
        this.browser.addListener(11, event -> this.browser.execute(String.format("updateGraph(`%s`, %d, `%s`);", eventsJson, packageDepth, this.diagramType.name())));
        this.browser.addProgressListener((ProgressListener)new ProgressAdapter(){
            private boolean loaded = false;

            public void changed(ProgressEvent event) {
                if (this.loaded) {
                    DependencyView.this.browser.removeProgressListener((ProgressListener)this);
                }
            }

            public void completed(ProgressEvent event) {
                DependencyView.this.browser.removeProgressListener((ProgressListener)this);
                DependencyView.this.browser.execute(String.format("updateGraph(`%s`, %d, `%s`);", eventsJson, packageDepth, DependencyView.this.diagramType.name()));
                this.loaded = true;
            }
        });
    }

    private static String loadLibraries(String ... libs) {
        if (libs == null || libs.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(2048);
        String[] stringArray = libs;
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            String lib = stringArray[n2];
            builder.append(DependencyView.loadStringFromFile(lib));
            builder.append("\n");
            ++n2;
        }
        return builder.toString();
    }

    private static String loadStringFromFile(String fileName) {
        try {
            return StringToolkit.readString((InputStream)DependencyView.class.getClassLoader().getResourceAsStream(fileName));
        }
        catch (IOException e) {
            FlightRecorderUI.getDefault().getLogger().log(Level.WARNING, MessageFormat.format("Could not load script \"{0}\",\"{1}\"", fileName, e.getMessage()));
            return "";
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int result = bis.read();
        while (result != -1) {
            buf.write((byte)result);
            result = bis.read();
        }
        return buf.toByteArray();
    }

    private class ChangeDiagramTypeAction
    extends Action {
        private final DiagramType type;

        ChangeDiagramTypeAction(DiagramType type) {
            super(type.message, type.action);
            this.type = type;
            this.setToolTipText(type.message);
            this.setImageDescriptor(type.imageDescriptor);
            this.setChecked(DiagramType.CHORD.equals((Object)type));
        }

        public void run() {
            if (this.isChecked()) {
                DependencyView.this.diagramType = this.type;
                if (DependencyView.this.currentItems != null) {
                    String eventsJson = IItemCollectionJsonSerializer.toJsonString((IItemCollection)DependencyView.this.currentItems, () -> false);
                    DependencyView.this.browser.execute(String.format("updateGraph(`%s`, %d, `%s`);", eventsJson, DependencyView.this.packageDepth, DependencyView.this.diagramType.name()));
                }
            }
        }
    }

    private static enum DiagramType {
        EDGE_BUNDLING(Messages.getString("DEPENDENCYVIEW_EDGE_BUNDLING_DIAGRAM"), 8, DependencyView.dependencyViewImageDescriptor("edge.png")),
        CHORD(Messages.getString("DEPENDENCYVIEW_CHORD_DIAGRAM"), 8, DependencyView.dependencyViewImageDescriptor("chord.png"));

        private final String message;
        private final int action;
        private final ImageDescriptor imageDescriptor;

        private DiagramType(String message, int action, ImageDescriptor imageDescriptor) {
            this.message = message;
            this.action = action;
            this.imageDescriptor = imageDescriptor;
        }
    }

    private static class ModelRebuildRunnable
    implements Runnable {
        private final DependencyView view;
        private final IItemCollection items;
        private volatile boolean isInvalid;
        private final int packageDepth;

        private ModelRebuildRunnable(DependencyView view, IItemCollection items, int packageDepth) {
            this.view = view;
            this.items = items;
            this.packageDepth = packageDepth;
        }

        private void setInvalid() {
            this.isInvalid = true;
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            Exception exception = null;
            LOGGER.info("starting to create model");
            try {
                this.view.modelState = ModelState.STARTED;
                if (this.isInvalid) {
                    return;
                }
                String eventsJson = IItemCollectionJsonSerializer.toJsonString((IItemCollection)this.items, () -> this.isInvalid);
                if (this.isInvalid) {
                    return;
                }
                try {
                    this.view.modelState = ModelState.FINISHED;
                    DisplayToolkit.inDisplayThread().execute(() -> this.view.setModel(this.items, eventsJson, this.packageDepth));
                }
                catch (Exception e) {
                    exception = e;
                    throw e;
                }
            }
            finally {
                Duration duration = Duration.ofMillis(System.currentTimeMillis() - start);
                Level level = Level.INFO;
                if (exception != null) {
                    level = Level.SEVERE;
                }
                LOGGER.log(level, "creating model took " + duration + " isInvalid:" + this.isInvalid, exception);
            }
        }
    }

    private static enum ModelState {
        NOT_STARTED,
        STARTED,
        FINISHED,
        NONE;

    }

    private class PackageDepthSelection
    extends Action
    implements IMenuCreator {
        private Menu menu;
        private final List<Pair<String, Integer>> depths;

        PackageDepthSelection() {
            super(Messages.getString("DEPENDENCYVIEW_PACKAGE_DEPTH"), 4);
            this.depths = IntStream.of(1, 2, 3, 4, 5, 6, 7, 8, 9, 10).mapToObj(i -> new Pair((Object)Integer.toString(i), (Object)i)).collect(Collectors.toList());
            this.setMenuCreator(this);
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            if (this.menu == null) {
                this.menu = new Menu(parent);
                this.populate(this.menu);
            }
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            if (this.menu == null) {
                this.menu = new Menu(parent);
                this.populate(this.menu);
            }
            return this.menu;
        }

        private void populate(Menu menu) {
            for (Pair<String, Integer> item : this.depths) {
                ActionContributionItem actionItem = new ActionContributionItem((IAction)new SetPackageDepth(item, (Integer)item.right == DependencyView.this.packageDepth));
                actionItem.fill(menu, -1);
            }
        }

        private class SetPackageDepth
        extends Action {
            private int value;

            SetPackageDepth(Pair<String, Integer> item, boolean isSelected) {
                super((String)item.left, 8);
                this.value = (Integer)item.right;
                this.setChecked(isSelected);
            }

            public void run() {
                if (((PackageDepthSelection)PackageDepthSelection.this).DependencyView.this.packageDepth != this.value) {
                    ((PackageDepthSelection)PackageDepthSelection.this).DependencyView.this.packageDepth = this.value;
                    DependencyView.this.triggerRebuildTask(((PackageDepthSelection)PackageDepthSelection.this).DependencyView.this.currentItems);
                }
            }
        }
    }
}

