/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.Page;
import org.openjdk.jmc.joverflow.heap.model.JavaHeapObject;
import org.openjdk.jmc.joverflow.heap.model.JavaThing;
import org.openjdk.jmc.joverflow.support.RefChainElement;
import org.openjdk.jmc.joverflow.ui.JOverflowEditor;
import org.openjdk.jmc.joverflow.ui.model.JavaThingItem;
import org.openjdk.jmc.joverflow.ui.model.ModelListener;
import org.openjdk.jmc.joverflow.ui.model.ObjectCluster;
import org.openjdk.jmc.joverflow.ui.viewers.JavaThingTreeViewer;
import org.openjdk.jmc.ui.misc.DisplayToolkit;

public class JavaThingPage
extends Page
implements ModelListener {
    private final JOverflowEditor mEditor;
    private JavaThingTreeViewer<JavaThingItem> mTreeViewer;
    private static final int MAX = 500;
    private final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(1);
    private FutureTask<Void> mCurrentTask;
    private Future<?> mBackground;
    private final int[] mObjects = new int[500];
    private int mObjectsInArray;
    private int mTotalInstancesCount;
    private boolean mTaskCancelled = false;
    private Object mInput;

    JavaThingPage(JOverflowEditor editor) {
        this.mEditor = editor;
    }

    public void createControl(Composite parent) {
        this.mTreeViewer = new JavaThingTreeViewer(parent, 67584);
        this.updateInput();
    }

    public Control getControl() {
        return this.mTreeViewer.getControl();
    }

    public void setFocus() {
        this.mTreeViewer.getTree().setFocus();
    }

    public void dispose() {
        this.EXECUTOR_SERVICE.shutdown();
        super.dispose();
    }

    @Override
    public void include(ObjectCluster oc, RefChainElement ref) {
        int insertCount = Math.min(oc.getObjectCount(), 500 - this.mObjectsInArray);
        int i = 0;
        while (i < insertCount) {
            this.mObjects[this.mObjectsInArray++] = oc.getGlobalObjectIndex(i);
            ++i;
        }
        this.mTotalInstancesCount += oc.getObjectCount();
    }

    @Override
    public void allIncluded() {
        if (this.mCurrentTask != null) {
            this.mTaskCancelled = true;
            this.mCurrentTask.cancel(false);
        }
        if (this.mBackground != null && !this.mBackground.isDone()) {
            this.mBackground.cancel(false);
        }
        int[] objects = Arrays.copyOf(this.mObjects, this.mObjectsInArray);
        int instanceCount = this.mTotalInstancesCount;
        this.updateInput(null);
        this.mTaskCancelled = false;
        this.mCurrentTask = new FutureTask<Void>(() -> {
            ArrayList<JavaThingItem> items = new ArrayList<JavaThingItem>();
            int[] nArray2 = objects;
            int n2 = objects.length;
            int n3 = 0;
            while (n3 < n2) {
                int i = nArray2[n3];
                if (this.mTaskCancelled) {
                    return null;
                }
                JavaHeapObject o = this.getObjectAtPosition(i);
                items.add(new JavaThingItem(0, o.idAsString(), (JavaThing)o));
                ++n3;
            }
            if (instanceCount > this.mObjects.length) {
                items.add(new JavaThingItem(0, "...", String.valueOf(instanceCount - this.mObjects.length) + " more instances", 0, null){

                    @Override
                    public String getSize() {
                        return "";
                    }
                });
            }
            DisplayToolkit.inDisplayThread().execute(() -> this.updateInput(items));
            return null;
        });
        this.mBackground = this.EXECUTOR_SERVICE.submit(this.mCurrentTask);
        this.mObjectsInArray = 0;
        this.mTotalInstancesCount = 0;
    }

    private void updateInput() {
        this.updateInput(this.mInput);
    }

    private void updateInput(Object input) {
        this.mInput = input;
        if (this.mTreeViewer != null) {
            this.mTreeViewer.setInput(this.mInput);
        }
    }

    private JavaHeapObject getObjectAtPosition(int globalObjectPos) {
        return this.mEditor.getSnapshot().getObjectAtGlobalIndex(globalObjectPos);
    }
}

