/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.openjdk.jmc.flightrecorder.configuration.events.EventConfiguration;
import org.openjdk.jmc.flightrecorder.configuration.events.IEventConfiguration;
import org.openjdk.jmc.flightrecorder.configuration.model.xml.XMLModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.EventConfigurationRepository;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.model.PrivateStorageDelegate;
import org.openjdk.jmc.ui.misc.DialogToolkit;

public class TemplateToolkit {
    public static List<IEventConfiguration> importFilesTo(EventConfigurationRepository repository, Collection<File> files) {
        ArrayList<IEventConfiguration> imported = new ArrayList<IEventConfiguration>(files.size());
        StringBuilder errBuf = new StringBuilder();
        for (File file : files) {
            try {
                XMLModel model = EventConfiguration.createModel((File)file);
                EventConfiguration template = new EventConfiguration(model, PrivateStorageDelegate.getDelegate());
                if (repository.addAsUnique((IEventConfiguration)template)) {
                    imported.add((IEventConfiguration)template);
                    continue;
                }
                errBuf.append(file.getName());
                errBuf.append(" (local storage)\n");
            }
            catch (IOException ioe) {
                errBuf.append(file.getName());
                errBuf.append(" (" + ioe.getMessage() + ")\n");
            }
            catch (ParseException pe) {
                errBuf.append(file.getName());
                errBuf.append(" (" + pe.getMessage() + ")\n");
            }
            catch (IllegalArgumentException iae) {
                errBuf.append(file.getName());
                errBuf.append(" (" + iae.getMessage() + ")\n");
            }
        }
        if (errBuf.length() != 0) {
            DialogToolkit.showErrorDialogAsync((Display)Display.getDefault(), (String)Messages.IMPORT_FILE_TEMPLATE_WIZARD_PAGE_ERROR_DIALOG_TITLE, (String)(String.valueOf(Messages.IMPORT_FILE_TEMPLATE_WIZARD_PAGE_ERROR_DIALOG_MSG) + errBuf.toString()));
        }
        return imported;
    }
}

