/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.core.ui;

import io.github.bric3.fireplace.core.ui.DarkLightColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.LayerUI;

public abstract class JScrollPaneWithBackButton {
    public static final String BACK_TO_DIRECTION = "backToDirection";

    private JScrollPaneWithBackButton() {
    }

    public static JLayer<JScrollPane> create(Supplier<JScrollPane> scrollPaneSupplier) {
        JLayer<JScrollPane> layer = new JLayer<JScrollPane>(scrollPaneSupplier.get(), new ScrollBackToTopLayerUI(15, 15));
        layer.addPropertyChangeListener(BACK_TO_DIRECTION, evt -> {
            int direction = (Integer)evt.getNewValue();
            ((ScrollBackToTopLayerUI)layer.getUI()).setDirection(direction);
            layer.repaint();
        });
        return layer;
    }

    private static class UpArrowIcon
    implements Icon {
        private final Color arrowColor;
        private final Color rolloverColor;
        private final int size;
        private int direction = 1;

        public UpArrowIcon(Color arrowColor, Color rolloverColor) {
            this.arrowColor = arrowColor;
            this.rolloverColor = rolloverColor;
            this.size = 24;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.translate(x - 1, y);
            if (c instanceof AbstractButton && ((AbstractButton)c).getModel().isRollover()) {
                g2.setPaint(this.rolloverColor);
            } else {
                g2.setPaint(UIManager.getColor("Button.foreground"));
            }
            float w2 = (float)this.getIconWidth() / 2.0f;
            float h2 = (float)this.getIconHeight() / 2.0f;
            float tw = w2 / 3.0f;
            float th = h2 / 6.0f;
            g2.setStroke(new BasicStroke(w2 / 4.0f));
            Path2D.Float p = new Path2D.Float();
            switch (this.direction) {
                case 1: {
                    ((Path2D)p).moveTo(w2 - tw, h2 + th);
                    ((Path2D)p).lineTo(w2, h2 - th);
                    ((Path2D)p).lineTo(w2 + tw, h2 + th);
                    break;
                }
                case 5: {
                    ((Path2D)p).moveTo(w2 - tw, h2 - th);
                    ((Path2D)p).lineTo(w2, h2 + th);
                    ((Path2D)p).lineTo(w2 + tw, h2 - th);
                }
            }
            g2.draw(p);
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }
    }

    private static class ScrollBackToTopLayerUI
    extends LayerUI<JScrollPane> {
        public int xGap;
        public int yGap;
        private final JPanel buttonContainer = new JPanel();
        private final Point currentMousePoint = new Point();
        private final UpArrowIcon buttonIcon = new UpArrowIcon(new Color(-1438825916, true), new Color(-1439129642, true));
        private final JButton button = new JButton((Icon)this.buttonIcon){
            private final Color ARMED_BUTTON_COLOR;
            {
                super(arg0);
                this.ARMED_BUTTON_COLOR = new DarkLightColor(Color.darkGray, Color.lightGray);
            }

            @Override
            public void updateUI() {
                super.updateUI();
                this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
                this.setFocusPainted(false);
                this.setBorderPainted(true);
                this.setContentAreaFilled(false);
                this.setRolloverEnabled(false);
                this.setPreferredSize(new Dimension(30, 30));
            }

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (this.getModel().isArmed()) {
                    g2.setColor(this.ARMED_BUTTON_COLOR);
                } else {
                    g2.setColor(UIManager.getColor("Button.background"));
                }
                g2.fillOval(1, 1, this.getWidth() - 1 - 3, this.getHeight() - 1 - 3);
                super.paintComponent(g2);
            }

            @Override
            protected void paintBorder(Graphics g) {
                g.setColor(UIManager.getColor("Button.borderColor"));
                g.drawOval(1, 1, this.getWidth() - 1 - 3, this.getHeight() - 1 - 3);
            }
        };
        private final Rectangle buttonRect = new Rectangle(this.button.getPreferredSize());
        private Cursor componentCursor;
        private int direction = 1;

        public ScrollBackToTopLayerUI() {
            this(10, 10);
        }

        public ScrollBackToTopLayerUI(int xGap, int yGap) {
            this.xGap = xGap;
            this.yGap = yGap;
        }

        private void updateButtonRect(JScrollPane scrollPane) {
            JViewport viewport = scrollPane.getViewport();
            int x = viewport.getX() + viewport.getWidth() - this.buttonRect.width - this.xGap;
            int y = viewport.getY() + viewport.getHeight() - this.buttonRect.height - this.yGap;
            this.buttonRect.setLocation(x, y);
        }

        @Override
        public void paint(Graphics g, JComponent layer) {
            super.paint(g, layer);
            if (layer instanceof JLayer) {
                JScrollPane scrollPane = (JScrollPane)((JLayer)layer).getView();
                this.updateButtonRect(scrollPane);
                switch (this.direction) {
                    case 1: {
                        if (scrollPane.getViewport().getViewRect().y <= 0) break;
                        this.button.getModel().setRollover(this.buttonRect.contains(this.currentMousePoint));
                        SwingUtilities.paintComponent(g, this.button, this.buttonContainer, this.buttonRect);
                        break;
                    }
                    case 5: {
                        if (!((double)scrollPane.getViewport().getViewRect().y < scrollPane.getViewport().getViewSize().getHeight() - (double)scrollPane.getViewport().getViewRect().height)) break;
                        this.button.getModel().setRollover(this.buttonRect.contains(this.currentMousePoint));
                        SwingUtilities.paintComponent(g, this.button, this.buttonContainer, this.buttonRect);
                    }
                }
            }
        }

        @Override
        public void updateUI(JLayer<? extends JScrollPane> l) {
            super.updateUI(l);
            this.button.updateUI();
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            if (c instanceof JLayer) {
                ((JLayer)c).setLayerEventMask(48L);
            }
        }

        @Override
        public void uninstallUI(JComponent c) {
            if (c instanceof JLayer) {
                ((JLayer)c).setLayerEventMask(0L);
            }
            super.uninstallUI(c);
        }

        @Override
        protected void processMouseEvent(MouseEvent e, JLayer<? extends JScrollPane> layer) {
            JScrollPane scroll = layer.getView();
            Rectangle viewRect = scroll.getViewport().getViewRect();
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), scroll);
            this.currentMousePoint.setLocation(p);
            int id = e.getID();
            if (id == 500) {
                if (this.buttonRect.contains(this.currentMousePoint)) {
                    this.scrollBackToTop(layer.getView());
                    e.consume();
                }
            } else if (id == 501 && viewRect.y > 0 && this.buttonRect.contains(this.currentMousePoint)) {
                e.consume();
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e, JLayer<? extends JScrollPane> layer) {
            Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), layer.getView());
            this.currentMousePoint.setLocation(p);
            layer.repaint(this.buttonRect);
            if (this.buttonRect.contains(this.currentMousePoint)) {
                if (this.componentCursor == null) {
                    this.componentCursor = e.getComponent().getCursor();
                }
                e.getComponent().setCursor(Cursor.getDefaultCursor());
            } else if (this.componentCursor != null) {
                e.getComponent().setCursor(this.componentCursor);
                this.componentCursor = null;
            }
        }

        private void scrollBackToTop(JScrollPane scrollPane) {
            JViewport viewport = scrollPane.getViewport();
            JComponent view = (JComponent)viewport.getView();
            Rectangle currentViewRect = viewport.getViewRect();
            new Timer(20, e -> {
                Timer animator = (Timer)e.getSource();
                if (this.direction == 1 && 0 < currentViewRect.y && animator.isRunning()) {
                    currentViewRect.y -= Math.max(1, currentViewRect.y / 2);
                    view.scrollRectToVisible(currentViewRect);
                } else if (this.direction == 5 && view.getHeight() - currentViewRect.height > currentViewRect.y && animator.isRunning()) {
                    currentViewRect.y += Math.max(1, currentViewRect.y / 2);
                    view.scrollRectToVisible(currentViewRect);
                } else {
                    animator.stop();
                }
            }).start();
        }

        public void setDirection(int direction) {
            this.direction = direction;
            this.buttonIcon.setDirection(direction);
        }
    }
}

