/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import io.github.bric3.fireplace.core.ui.Colors;
import io.github.bric3.fireplace.core.ui.DarkLightColor;
import io.github.bric3.fireplace.flamegraph.FrameBox;
import io.github.bric3.fireplace.flamegraph.FrameColorProvider;
import io.github.bric3.fireplace.flamegraph.FrameRenderingFlags;
import java.awt.Color;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class DimmingFrameColorProvider<T>
implements FrameColorProvider<T> {
    public static final Color DIMMED_TEXT_COLOR = new DarkLightColor(Colors.rgba(28, 43, 52, 0.68f), Colors.rgba(255, 255, 255, 0.51f));
    public static final Color ROOT_BACKGROUND_COLOR = new DarkLightColor(new Color(-1378564), new Color(-16182750));
    private final Function<FrameBox<T>, Color> baseColorFunction;
    private final FrameColorProvider.ColorModel reusedColorModelForMainCanvas = new FrameColorProvider.ColorModel(null, null);
    private final FrameColorProvider.ColorModel reusedColorModelForMinimap = new FrameColorProvider.ColorModel(null, null);
    private final ConcurrentHashMap<Color, Color> dimmedColorCache = new ConcurrentHashMap();
    private Color rootBackGroundColor = ROOT_BACKGROUND_COLOR;
    private Color dimmedTextColor = DIMMED_TEXT_COLOR;

    public DimmingFrameColorProvider(Function<FrameBox<T>, Color> baseColorFunction) {
        this.baseColorFunction = baseColorFunction;
    }

    @Override
    public FrameColorProvider.ColorModel getColors(FrameBox<T> frame, int flags) {
        Color foreground;
        Color backgroundColor;
        boolean rootNode = frame.isRoot();
        Color baseBackgroundColor = rootNode ? (backgroundColor = this.rootBackGroundColor) : (backgroundColor = this.baseColorFunction.apply(frame));
        if (FrameRenderingFlags.isMinimapMode(flags)) {
            return this.reusedColorModelForMinimap.set(backgroundColor, null);
        }
        if (!rootNode && this.shouldDim(flags)) {
            backgroundColor = this.dimmedBackground(backgroundColor);
            foreground = this.dimmedTextColor;
        } else {
            foreground = Colors.foregroundColor(backgroundColor);
        }
        if (FrameRenderingFlags.isHovered(flags)) {
            backgroundColor = this.hoverBackground(baseBackgroundColor);
            foreground = Colors.foregroundColor(backgroundColor);
        }
        if (FrameRenderingFlags.isHoveredSibling(flags)) {
            backgroundColor = this.hoverSiblingBackground(baseBackgroundColor);
            foreground = Colors.foregroundColor(backgroundColor);
        }
        return this.reusedColorModelForMainCanvas.set(backgroundColor, foreground);
    }

    private Color hoverBackground(Color backgroundColor) {
        return Colors.isDarkMode() ? Colors.brighter(backgroundColor, 1.1f, 0.95f) : Colors.darker(backgroundColor, 1.25f);
    }

    private Color hoverSiblingBackground(Color backgroundColor) {
        return this.hoverBackground(backgroundColor);
    }

    protected Color dimmedBackground(Color backgroundColor) {
        return this.cachedDim(backgroundColor);
    }

    private boolean shouldDim(int flags) {
        boolean highlighting = FrameRenderingFlags.isHighlighting(flags);
        boolean highlightedFrame = FrameRenderingFlags.isHighlightedFrame(flags);
        boolean focusing = FrameRenderingFlags.isFocusing(flags);
        boolean focusedFrame = FrameRenderingFlags.isFocusedFrame(flags);
        boolean dimmedForHighlighting = highlighting && !highlightedFrame;
        boolean dimmedForFocus = focusing && !focusedFrame;
        return (dimmedForHighlighting || dimmedForFocus) && (!highlighting || !focusing || !highlightedFrame && !focusedFrame);
    }

    private Color cachedDim(Color color) {
        return this.dimmedColorCache.computeIfAbsent(color, Colors::dim);
    }

    public DimmingFrameColorProvider<T> withRootBackgroundColor(Color rootBackgroundColor) {
        this.rootBackGroundColor = Objects.requireNonNull(rootBackgroundColor);
        return this;
    }

    public DimmingFrameColorProvider<T> withDimmedTextColor(Color dimmedTextColor) {
        this.dimmedTextColor = Objects.requireNonNull(dimmedTextColor);
        return this;
    }
}

