/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import io.github.bric3.fireplace.core.ui.Colors;
import io.github.bric3.fireplace.flamegraph.FrameBox;
import io.github.bric3.fireplace.flamegraph.FrameRenderingFlags;
import java.awt.Color;
import java.util.Objects;
import java.util.function.Function;

@FunctionalInterface
public interface FrameColorProvider<T> {
    public ColorModel getColors(FrameBox<T> var1, int var2);

    public static <T> FrameColorProvider<T> defaultColorProvider(final Function<FrameBox<T>, Color> frameBaseColorFunction) {
        Objects.requireNonNull(frameBaseColorFunction, "frameColorFunction");
        return new FrameColorProvider<T>(){
            private final Color highlightedColor = new Color(-6287, true);
            private final ColorModel reusableDataStructure = new ColorModel(null, null);

            @Override
            public ColorModel getColors(FrameBox<T> frame, int flags) {
                Color baseBackgroundColor;
                Color backgroundColor = baseBackgroundColor = (Color)frameBaseColorFunction.apply(frame);
                if (FrameRenderingFlags.isFocusing(flags) && !FrameRenderingFlags.isFocusedFrame(flags)) {
                    backgroundColor = Colors.blend(baseBackgroundColor, Colors.translucent_black_80);
                }
                if (FrameRenderingFlags.isHighlighting(flags)) {
                    Color color = backgroundColor = Colors.isDarkMode() ? Colors.blend(backgroundColor, Colors.translucent_black_B0) : Colors.blend(backgroundColor, Color.WHITE);
                    if (FrameRenderingFlags.isHighlightedFrame(flags)) {
                        backgroundColor = baseBackgroundColor;
                    }
                }
                if (FrameRenderingFlags.isHovered(flags)) {
                    backgroundColor = Colors.blend(backgroundColor, Colors.translucent_black_40);
                }
                return this.reusableDataStructure.set(backgroundColor, Colors.foregroundColor(backgroundColor));
            }
        };
    }

    public static class ColorModel {
        public Color background;
        public Color foreground;

        public ColorModel(Color background, Color foreground) {
            this.background = background;
            this.foreground = foreground;
        }

        public ColorModel set(Color background, Color foreground) {
            this.background = background;
            this.foreground = foreground;
            return this;
        }

        public ColorModel copy() {
            return new ColorModel(this.background, this.foreground);
        }
    }
}

