/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import io.github.bric3.fireplace.flamegraph.FrameBox;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class FrameModel<T> {
    public static final FrameModel<?> EMPTY = new FrameModel(Collections.emptyList());
    public final String title;
    public final List<FrameBox<T>> frames;
    public final FrameEquality<T> frameEquality;
    public String description;

    public FrameModel(List<FrameBox<T>> frames) {
        this("", (a, b) -> Objects.equals(a.actualNode, b.actualNode), frames);
    }

    public FrameModel(String title, FrameEquality<T> frameEquality, List<FrameBox<T>> frames) {
        this.title = Objects.requireNonNull(title, "title");
        this.frames = Objects.requireNonNull(frames, "frames");
        this.frameEquality = Objects.requireNonNull(frameEquality, "frameEquality");
    }

    public static <T> FrameModel<T> empty() {
        return EMPTY;
    }

    public FrameModel<T> withDescription(String description) {
        this.description = Objects.requireNonNull(description, "description");
        return this;
    }

    public static interface FrameEquality<T> {
        public boolean equal(FrameBox<T> var1, FrameBox<T> var2);
    }
}

