/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application.preferences;

import com.sun.javafx.util.Logging;
import java.util.Objects;
import java.util.function.Function;

public record PreferenceMapping<T>(String keyName, Class<T> valueType, Function<T, T> valueMapper) {
    public PreferenceMapping {
        Objects.requireNonNull(string, "keyName cannot be null");
        Objects.requireNonNull(clazz, "valueType cannot be null");
        Objects.requireNonNull(function, "valueMapper cannot be null");
    }

    public PreferenceMapping(String string, Class<T> clazz) {
        this(string, clazz, Function.identity());
    }

    public T map(Object object) {
        if (this.valueType.isInstance(object)) {
            return this.valueMapper.apply(object);
        }
        if (object != null) {
            Logging.getJavaFXLogger().warning("Unexpected value of " + this.keyName + " platform preference, using default value instead (expected = " + this.valueType.getName() + ", actual = " + object.getClass().getName() + ")");
        }
        return null;
    }
}

