/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.java2d;

import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.ImageStorageException;
import com.sun.javafx.iio.common.ImageDescriptor;
import com.sun.javafx.iio.common.ImageTools;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Objects;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.stream.ImageInputStream;

public class J2DImageLoader
implements ImageLoader {
    private final ImageReader reader;
    private final ImageInputStream stream;
    private final ImageFormatDescription description;

    public J2DImageLoader(ImageReader imageReader, ImageInputStream imageInputStream) throws IOException {
        this.reader = imageReader;
        this.stream = imageInputStream;
        this.description = new ImageDescriptor(imageReader.getFormatName(), new String[]{}, new ImageFormatDescription.Signature[]{}, imageReader.getOriginatingProvider() == null ? new String[]{} : (String[])Arrays.stream(imageReader.getOriginatingProvider().getMIMETypes()).map(string -> string.substring(string.indexOf(47))).toArray(String[]::new));
        imageReader.setInput(imageInputStream);
    }

    @Override
    public ImageFormatDescription getFormatDescription() {
        return this.description;
    }

    @Override
    public void dispose() {
        this.reader.dispose();
        try {
            if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void addListener(ImageLoadListener imageLoadListener) {
        LoadListenerImpl loadListenerImpl = new LoadListenerImpl(imageLoadListener);
        this.reader.addIIOReadProgressListener(loadListenerImpl);
        this.reader.addIIOReadWarningListener(loadListenerImpl);
    }

    @Override
    public void removeListener(ImageLoadListener imageLoadListener) {
        LoadListenerImpl loadListenerImpl = new LoadListenerImpl(imageLoadListener);
        this.reader.removeIIOReadProgressListener(loadListenerImpl);
        this.reader.removeIIOReadWarningListener(loadListenerImpl);
    }

    @Override
    public ImageFrame load(int n, double d, double d2, boolean bl, boolean bl2, float f, float f2) throws IOException {
        Object object;
        float f3;
        int n2;
        int n3;
        if (n != 0) {
            return null;
        }
        ImageReadParam imageReadParam = this.reader.getDefaultReadParam();
        if (imageReadParam.canSetSourceRenderSize()) {
            int n4 = this.reader.getWidth(n);
            int n5 = this.reader.getHeight(n);
            ImageTools.validateMaxDimensions(n4, n5, f);
            ImageTools.validateMaxDimensions(d, d2, f);
            int[] nArray = ImageTools.computeDimensions((int)((float)n4 * f), (int)((float)n5 * f), (int)(d * (double)f), (int)(d2 * (double)f), bl);
            n3 = nArray[0];
            n2 = nArray[1];
            f3 = f;
            imageReadParam.setSourceRenderSize(new Dimension(n3, n2));
        } else {
            ImageTools.validateMaxDimensions(d, d2, f2);
            int[] nArray = ImageTools.computeDimensions(this.reader.getWidth(n), this.reader.getHeight(n), (int)(d * (double)f2), (int)(d2 * (double)f2), bl);
            n3 = nArray[0];
            n2 = nArray[1];
            f3 = f2;
        }
        BufferedImage bufferedImage = this.reader.read(n, imageReadParam);
        if (bufferedImage.getWidth() != n3 || bufferedImage.getHeight() != n2) {
            bufferedImage = (BufferedImage)bufferedImage.getScaledInstance(n3, n2, bl2 ? 4 : 1);
        }
        ImageMetadata imageMetadata = new ImageMetadata(null, true, null, null, null, null, null, bufferedImage.getWidth(), bufferedImage.getHeight(), null, null, null);
        SampleModel sampleModel = bufferedImage.getSampleModel();
        Objects.requireNonNull(sampleModel);
        Object object2 = sampleModel;
        int n6 = 0;
        int n7 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ComponentSampleModel.class, MultiPixelPackedSampleModel.class, SinglePixelPackedSampleModel.class}, (Object)object2, n6)) {
            case 0 -> {
                object = (ComponentSampleModel)object2;
                yield object.getScanlineStride();
            }
            case 1 -> {
                MultiPixelPackedSampleModel var20_23 = (MultiPixelPackedSampleModel)object2;
                yield var20_23.getScanlineStride();
            }
            case 2 -> {
                SinglePixelPackedSampleModel var21_24 = (SinglePixelPackedSampleModel)object2;
                yield var21_24.getScanlineStride();
            }
            default -> throw new IllegalStateException("Unsupported sample model: " + String.valueOf(bufferedImage.getSampleModel()));
        };
        return switch (bufferedImage.getType()) {
            case 10 -> new ImageFrame(ImageStorage.ImageType.GRAY, J2DImageLoader.getByteBuffer(bufferedImage.getRaster().getDataBuffer()), bufferedImage.getWidth(), bufferedImage.getHeight(), n7, f3, imageMetadata);
            case 5 -> new ImageFrame(ImageStorage.ImageType.BGR, J2DImageLoader.getByteBuffer(bufferedImage.getRaster().getDataBuffer()), bufferedImage.getWidth(), bufferedImage.getHeight(), n7, f3, imageMetadata);
            case 6 -> new ImageFrame(ImageStorage.ImageType.ABGR, J2DImageLoader.getByteBuffer(bufferedImage.getRaster().getDataBuffer()), bufferedImage.getWidth(), bufferedImage.getHeight(), n7, f3, imageMetadata);
            case 7 -> new ImageFrame(ImageStorage.ImageType.ABGR_PRE, J2DImageLoader.getByteBuffer(bufferedImage.getRaster().getDataBuffer()), bufferedImage.getWidth(), bufferedImage.getHeight(), n7, f3, imageMetadata);
            case 1 -> new ImageFrame(ImageStorage.ImageType.INT_RGB, J2DImageLoader.getIntBuffer(bufferedImage.getRaster().getDataBuffer()), bufferedImage.getWidth(), bufferedImage.getHeight(), n7, f3, imageMetadata);
            case 4 -> new ImageFrame(ImageStorage.ImageType.INT_BGR, J2DImageLoader.getIntBuffer(bufferedImage.getRaster().getDataBuffer()), bufferedImage.getWidth(), bufferedImage.getHeight(), n7, f3, imageMetadata);
            case 2 -> new ImageFrame(ImageStorage.ImageType.INT_ARGB, J2DImageLoader.getIntBuffer(bufferedImage.getRaster().getDataBuffer()), bufferedImage.getWidth(), bufferedImage.getHeight(), n7, f3, imageMetadata);
            case 3 -> new ImageFrame(ImageStorage.ImageType.INT_ARGB_PRE, J2DImageLoader.getIntBuffer(bufferedImage.getRaster().getDataBuffer()), bufferedImage.getWidth(), bufferedImage.getHeight(), n7, f3, imageMetadata);
            case 12, 13 -> {
                object2 = (IndexColorModel)bufferedImage.getColorModel();
                int[] var18_21 = new int[((IndexColorModel)object2).getMapSize()];
                ((IndexColorModel)object2).getRGBs(var18_21);
                object = ((ColorModel)object2).hasAlpha() ? (((ColorModel)object2).isAlphaPremultiplied() ? ImageStorage.ImageType.PALETTE_ALPHA_PRE : ImageStorage.ImageType.PALETTE_ALPHA) : ImageStorage.ImageType.PALETTE;
                yield new ImageFrame((ImageStorage.ImageType)((Object)object), J2DImageLoader.getByteBuffer(bufferedImage.getRaster().getDataBuffer()), bufferedImage.getWidth(), bufferedImage.getHeight(), n7, var18_21, ((ColorModel)object2).getPixelSize(), f3, imageMetadata);
            }
            default -> {
                String v3 = switch (bufferedImage.getType()) {
                    case 0 -> "TYPE_CUSTOM";
                    case 8 -> "TYPE_USHORT_565_RGB";
                    case 9 -> "TYPE_USHORT_555_RGB";
                    case 11 -> "TYPE_USHORT_GRAY";
                    default -> Integer.toString(bufferedImage.getType());
                };
                throw new ImageStorageException("Unsupported image type: " + v3);
            }
        };
    }

    private static ByteBuffer getByteBuffer(DataBuffer dataBuffer) {
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        byte[] byArray = dataBufferByte.getData();
        int n = dataBufferByte.getOffset();
        int n2 = dataBufferByte.getSize();
        return ByteBuffer.wrap(byArray, n, n2);
    }

    private static IntBuffer getIntBuffer(DataBuffer dataBuffer) {
        DataBufferInt dataBufferInt = (DataBufferInt)dataBuffer;
        int[] nArray = dataBufferInt.getData();
        int n = dataBufferInt.getOffset();
        int n2 = dataBufferInt.getSize();
        return IntBuffer.wrap(nArray, n, n2);
    }

    private final class LoadListenerImpl
    implements IIOReadProgressListener,
    IIOReadWarningListener {
        private final ImageLoadListener listener;
        private float lastProgress;

        LoadListenerImpl(ImageLoadListener imageLoadListener) {
            this.listener = imageLoadListener;
        }

        @Override
        public void warningOccurred(ImageReader imageReader, String string) {
            this.listener.imageLoadWarning(J2DImageLoader.this, string);
        }

        @Override
        public void imageProgress(ImageReader imageReader, float f) {
            if (f > this.lastProgress) {
                this.lastProgress = f;
                this.listener.imageLoadProgress(J2DImageLoader.this, f);
            }
        }

        @Override
        public void imageStarted(ImageReader imageReader, int n) {
            this.listener.imageLoadProgress(J2DImageLoader.this, 0.0f);
        }

        @Override
        public void imageComplete(ImageReader imageReader) {
            if (this.lastProgress < 100.0f) {
                this.listener.imageLoadProgress(J2DImageLoader.this, 100.0f);
            }
        }

        @Override
        public void sequenceStarted(ImageReader imageReader, int n) {
        }

        @Override
        public void sequenceComplete(ImageReader imageReader) {
        }

        @Override
        public void thumbnailStarted(ImageReader imageReader, int n, int n2) {
        }

        @Override
        public void thumbnailProgress(ImageReader imageReader, float f) {
        }

        @Override
        public void thumbnailComplete(ImageReader imageReader) {
        }

        @Override
        public void readAborted(ImageReader imageReader) {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof LoadListenerImpl)) return false;
            LoadListenerImpl loadListenerImpl = (LoadListenerImpl)object;
            if (!Objects.equals(loadListenerImpl.listener, this.listener)) return false;
            return true;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }
    }
}

