/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext.model;

import com.sun.javafx.ModuleUtil;
import com.sun.jfx.incubator.scene.control.richtext.Markers;
import com.sun.jfx.incubator.scene.control.richtext.StyleAttributeMapHelper;
import com.sun.jfx.incubator.scene.control.richtext.UndoableChange;
import com.sun.jfx.incubator.scene.control.richtext.util.RichUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.scene.input.DataFormat;
import javafx.scene.layout.Region;
import jfx.incubator.scene.control.richtext.Marker;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.ContentChange;
import jfx.incubator.scene.control.richtext.model.DataFormatHandler;
import jfx.incubator.scene.control.richtext.model.HtmlExportFormatHandler;
import jfx.incubator.scene.control.richtext.model.PlainTextFormatHandler;
import jfx.incubator.scene.control.richtext.model.RichParagraph;
import jfx.incubator.scene.control.richtext.model.RtfFormatHandler;
import jfx.incubator.scene.control.richtext.model.StyleAttribute;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledInput;
import jfx.incubator.scene.control.richtext.model.StyledOutput;
import jfx.incubator.scene.control.richtext.model.StyledSegment;

public abstract class StyledTextModel {
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();
    private final HashMap<FHKey, FHPriority> handlers = new HashMap(2);
    private final Markers markers = new Markers();
    private final UndoableChange head = UndoableChange.createHead();
    private final ReadOnlyBooleanWrapper undoable = new ReadOnlyBooleanWrapper((Object)this, "undoable", false);
    private final ReadOnlyBooleanWrapper redoable = new ReadOnlyBooleanWrapper((Object)this, "redoable", false);
    private UndoableChange undo = this.head;

    public abstract boolean isWritable();

    public abstract int size();

    public abstract String getPlainText(int var1);

    public abstract RichParagraph getParagraph(int var1);

    protected abstract void removeRange(TextPos var1, TextPos var2);

    protected abstract int insertTextSegment(int var1, int var2, String var3, StyleAttributeMap var4);

    protected abstract void insertLineBreak(int var1, int var2);

    protected abstract void insertParagraph(int var1, Supplier<Region> var2);

    protected abstract void setParagraphStyle(int var1, StyleAttributeMap var2);

    protected abstract void applyStyle(int var1, int var2, int var3, StyleAttributeMap var4, boolean var5);

    public abstract StyleAttributeMap getStyleAttributeMap(StyleResolver var1, TextPos var2);

    protected Set<StyleAttribute<?>> getSupportedAttributes() {
        return null;
    }

    public StyledTextModel() {
        this.registerDataFormatHandler(RtfFormatHandler.getInstance(), true, false, 1000);
        this.registerDataFormatHandler(HtmlExportFormatHandler.getInstance(), true, false, 100);
        this.registerDataFormatHandler(PlainTextFormatHandler.getInstance(), true, false, 0);
    }

    public final void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    protected final void registerDataFormatHandler(DataFormatHandler dataFormatHandler, boolean bl, boolean bl2, int n) {
        FHPriority fHPriority = new FHPriority(dataFormatHandler, n);
        if (bl) {
            this.handlers.put(new FHKey(dataFormatHandler.getDataFormat(), true), fHPriority);
        }
        if (bl2) {
            this.handlers.put(new FHKey(dataFormatHandler.getDataFormat(), false), fHPriority);
        }
    }

    protected final void removeDataFormatHandler(DataFormat dataFormat, boolean bl, boolean bl2) {
        if (bl) {
            this.handlers.remove(new FHKey(dataFormat, true));
        }
        if (bl2) {
            this.handlers.remove(new FHKey(dataFormat, false));
        }
    }

    public final List<DataFormat> getSupportedDataFormats(boolean bl) {
        ArrayList arrayList = new ArrayList(this.handlers.size());
        this.handlers.forEach((fHKey, fHPriority) -> {
            if (fHKey.forExport == bl) {
                arrayList.add(fHPriority);
            }
        });
        Collections.sort(arrayList);
        return arrayList.stream().map(fHPriority -> fHPriority.handler().getDataFormat()).collect(Collectors.toUnmodifiableList());
    }

    public final DataFormatHandler getDataFormatHandler(DataFormat dataFormat, boolean bl) {
        FHKey fHKey = new FHKey(dataFormat, bl);
        FHPriority fHPriority = this.handlers.get(fHKey);
        return fHPriority == null ? null : fHPriority.handler();
    }

    public void fireChangeEvent(TextPos textPos, TextPos textPos2, int n, int n2, int n3) {
        ContentChange contentChange = ContentChange.ofEdit(textPos, textPos2, n, n2, n3);
        this.markers.update(textPos, textPos2, n, n2, n3);
        for (Listener listener : this.listeners) {
            listener.onContentChange(contentChange);
        }
    }

    public void fireStyleChangeEvent(TextPos textPos, TextPos textPos2) {
        ContentChange contentChange = ContentChange.ofStyleChange(textPos, textPos2);
        for (Listener listener : this.listeners) {
            listener.onContentChange(contentChange);
        }
    }

    public int getParagraphLength(int n) {
        return this.getPlainText(n).length();
    }

    public final void export(TextPos textPos, TextPos textPos2, StyledOutput styledOutput) throws IOException {
        int n;
        int n2;
        int n3 = textPos.compareTo(textPos2);
        if (n3 > 0) {
            TextPos textPos3 = textPos;
            textPos = textPos2;
            textPos2 = textPos3;
        }
        if ((n2 = textPos.index()) == (n = textPos2.index())) {
            int n4 = textPos.offset();
            int n5 = textPos2.offset();
            int n6 = this.getParagraphLength(n2);
            boolean bl = n4 == 0 && (n5 >= n6 || n5 < 0);
            this.exportParagraph(n2, n4, n5, bl, styledOutput);
        } else {
            boolean bl = false;
            for (int i = n2; i <= n; ++i) {
                int n7;
                int n8;
                if (bl) {
                    styledOutput.consume(StyledSegment.LINE_BREAK);
                } else {
                    bl = true;
                }
                if (i == n2) {
                    n8 = textPos.offset();
                    n7 = Integer.MAX_VALUE;
                } else if (i == n) {
                    n8 = 0;
                    n7 = textPos2.offset();
                } else {
                    n8 = 0;
                    n7 = Integer.MAX_VALUE;
                }
                this.exportParagraph(i, n8, n7, true, styledOutput);
            }
        }
        styledOutput.flush();
    }

    protected final void exportParagraph(int n, int n2, int n3, boolean bl, StyledOutput styledOutput) throws IOException {
        RichParagraph richParagraph = this.getParagraph(n);
        richParagraph.export(n2, n3, styledOutput);
        if (bl) {
            StyleAttributeMap styleAttributeMap = richParagraph.getParagraphAttributes();
            styledOutput.consume(StyledSegment.ofParagraphAttributes(styleAttributeMap));
        }
    }

    public final Marker getMarker(TextPos textPos) {
        TextPos textPos2 = this.clamp(textPos);
        return this.markers.getMarker(textPos2);
    }

    public final TextPos clamp(TextPos textPos) {
        Objects.nonNull(textPos);
        int n = this.size();
        int n2 = textPos.index();
        if (n2 < 0) {
            return TextPos.ZERO;
        }
        if (n2 < n) {
            int n3 = this.getParagraphLength(n2);
            if (textPos.offset() < n3) {
                return textPos;
            }
            return TextPos.ofLeading(n2, n3);
        }
        if (n == 0) {
            return TextPos.ZERO;
        }
        n2 = n - 1;
        int n4 = this.getParagraphLength(n2);
        return TextPos.ofLeading(n2, n4);
    }

    public final TextPos getDocumentEnd() {
        int n = this.size() - 1;
        if (n < 0) {
            return TextPos.ZERO;
        }
        return this.getEndOfParagraphTextPos(n);
    }

    public final TextPos getEndOfParagraphTextPos(int n) {
        int n2 = this.getParagraphLength(n);
        int n3 = n2 - 1;
        if (n3 < 0) {
            return TextPos.ofLeading(n, n2);
        }
        return new TextPos(n, n2, n3, false);
    }

    public final TextPos replace(StyleResolver styleResolver, TextPos textPos, TextPos textPos2, String string, boolean bl) {
        this.checkWritable();
        StyleAttributeMap styleAttributeMap = this.getStyleAttributeMap(styleResolver, textPos);
        StyledInput styledInput = StyledInput.of(string, styleAttributeMap);
        return this.replace(styleResolver, textPos, textPos2, styledInput, bl);
    }

    public final TextPos replace(StyleResolver styleResolver, TextPos textPos, TextPos textPos2, StyledInput styledInput, boolean bl) {
        Object object;
        StyledSegment styledSegment;
        TextPos textPos3;
        this.checkWritable();
        int n = textPos.compareTo(textPos2);
        if (n > 0) {
            textPos3 = textPos;
            textPos = textPos2;
            textPos2 = textPos3;
        }
        TextPos textPos4 = textPos3 = bl ? UndoableChange.create(this, textPos, textPos2) : null;
        if (n != 0) {
            this.removeRange(textPos, textPos2);
        }
        int n2 = textPos.index();
        int n3 = textPos.offset();
        int n4 = 0;
        int n5 = 0;
        while ((styledSegment = styledInput.nextSegment()) != null) {
            switch (styledSegment.getType()) {
                case LINE_BREAK: {
                    this.insertLineBreak(n2, n3);
                    ++n2;
                    n3 = 0;
                    n5 = 0;
                    break;
                }
                case PARAGRAPH_ATTRIBUTES: {
                    StyleAttributeMap styleAttributeMap = styledSegment.getStyleAttributeMap(styleResolver);
                    this.setParagraphStyle(n2, styleAttributeMap);
                    break;
                }
                case REGION: {
                    n3 = 0;
                    n5 = 0;
                    object = styledSegment.getParagraphNodeGenerator();
                    this.insertParagraph(++n2, (Supplier<Region>)object);
                    break;
                }
                case TEXT: {
                    String string = styledSegment.getText();
                    StyleAttributeMap styleAttributeMap = styledSegment.getStyleAttributeMap(styleResolver);
                    styleAttributeMap = styleAttributeMap == null ? StyleAttributeMap.EMPTY : this.filterUnsupportedAttributes(styleAttributeMap);
                    int n6 = this.insertTextSegment(n2, n3, string, styleAttributeMap);
                    if (n2 == textPos.index()) {
                        n4 += n6;
                    }
                    n3 += n6;
                    n5 += n6;
                }
            }
        }
        int n7 = n2 - textPos.index();
        if (n7 == 0) {
            n5 = 0;
        }
        this.fireChangeEvent(textPos, textPos2, n4, n7, n5);
        object = TextPos.ofLeading(n2, n3);
        if (bl) {
            this.add((UndoableChange)((Object)textPos3), (TextPos)object);
        }
        return object;
    }

    public final void applyStyle(TextPos textPos, TextPos textPos2, StyleAttributeMap styleAttributeMap, boolean bl) {
        StyleAttributeMap styleAttributeMap2;
        boolean bl2;
        TextPos textPos3;
        StyleAttributeMap styleAttributeMap3;
        TextPos textPos4;
        this.checkWritable();
        if (textPos.compareTo(textPos2) > 0) {
            textPos4 = textPos;
            textPos = textPos2;
            textPos2 = textPos4;
        }
        if ((styleAttributeMap3 = StyleAttributeMapHelper.getParagraphAttrs(styleAttributeMap = this.filterUnsupportedAttributes(styleAttributeMap))) == null) {
            textPos4 = textPos;
            textPos3 = textPos2;
            bl2 = false;
        } else {
            textPos4 = TextPos.ofLeading(textPos.index(), 0);
            textPos3 = this.getEndOfParagraphTextPos(textPos2.index());
            bl2 = true;
        }
        UndoableChange undoableChange = UndoableChange.create(this, textPos4, textPos3);
        if (styleAttributeMap3 != null) {
            for (int i = textPos.index(); i <= textPos2.index(); ++i) {
                this.setParagraphStyle(i, styleAttributeMap3);
            }
        }
        if ((styleAttributeMap2 = StyleAttributeMapHelper.getCharacterAttrs(styleAttributeMap)) != null) {
            int n = textPos.index();
            if (n == textPos2.index()) {
                this.applyStyle(n, textPos.offset(), textPos2.offset(), styleAttributeMap, bl);
            } else {
                this.applyStyle(n, textPos.offset(), Integer.MAX_VALUE, styleAttributeMap, bl);
                ++n;
                while (n < textPos2.index()) {
                    this.applyStyle(n, 0, Integer.MAX_VALUE, styleAttributeMap, bl);
                    ++n;
                }
                this.applyStyle(n, 0, textPos2.offset(), styleAttributeMap, bl);
            }
            bl2 = true;
        }
        if (bl2) {
            this.fireStyleChangeEvent(textPos4, textPos3);
            this.add(undoableChange, textPos2);
        }
    }

    private StyleAttributeMap filterUnsupportedAttributes(StyleAttributeMap styleAttributeMap) {
        Set<StyleAttribute<?>> set = this.getSupportedAttributes();
        if (set == null) {
            return styleAttributeMap;
        }
        StyleAttributeMap.Builder builder = StyleAttributeMap.builder();
        for (StyleAttribute<?> styleAttribute : styleAttributeMap.getAttributes()) {
            if (!set.contains(styleAttribute)) continue;
            builder.set(styleAttribute, styleAttributeMap.get(styleAttribute));
        }
        return builder.build();
    }

    public final void clearUndoRedo() {
        this.undo = this.head;
        this.updateUndoRedo();
    }

    private void add(UndoableChange undoableChange, TextPos textPos) {
        if (undoableChange == null) {
            this.clearUndoRedo();
            return;
        }
        undoableChange.setEndAfter(textPos);
        undoableChange.setPrev(this.undo);
        this.undo.setNext(undoableChange);
        this.undo = undoableChange;
        this.updateUndoRedo();
    }

    public final TextPos[] undo(StyleResolver styleResolver) {
        if (this.undo != this.head) {
            try {
                this.undo.undo(styleResolver);
                TextPos[] textPosArray = this.undo.getSelectionBefore();
                this.undo = this.undo.getPrev();
                this.updateUndoRedo();
                return textPosArray;
            }
            catch (IOException iOException) {
                this.clearUndoRedo();
            }
        }
        return null;
    }

    public final TextPos[] redo(StyleResolver styleResolver) {
        if (this.undo.getNext() != null) {
            try {
                this.undo.getNext().redo(styleResolver);
                TextPos[] textPosArray = this.undo.getNext().getSelectionAfter();
                this.undo = this.undo.getNext();
                this.updateUndoRedo();
                return textPosArray;
            }
            catch (IOException iOException) {
                this.clearUndoRedo();
            }
        }
        return null;
    }

    public final ReadOnlyBooleanProperty undoableProperty() {
        return this.undoable.getReadOnlyProperty();
    }

    public final boolean isUndoable() {
        return this.undoable.get();
    }

    private void setUndoable(boolean bl) {
        this.undoable.set(bl);
    }

    public final ReadOnlyBooleanProperty redoableProperty() {
        return this.redoable.getReadOnlyProperty();
    }

    public final boolean isRedoable() {
        return this.redoable.get();
    }

    private void setRedoable(boolean bl) {
        this.redoable.set(bl);
    }

    private void updateUndoRedo() {
        this.setUndoable(this.undo != this.head);
        this.setRedoable(this.undo.getNext() != null);
    }

    private String dump() {
        final StringBuilder stringBuilder = new StringBuilder(2048);
        try {
            stringBuilder.append("\n");
            TextPos textPos = this.getDocumentEnd();
            this.export(TextPos.ZERO, textPos, new StyledOutput(){

                @Override
                public void consume(StyledSegment styledSegment) throws IOException {
                    stringBuilder.append(" ");
                    stringBuilder.append(styledSegment);
                    stringBuilder.append("\n");
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void close() throws IOException {
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuilder.toString();
    }

    public final void read(StyleResolver styleResolver, DataFormat dataFormat, InputStream inputStream) throws IOException {
        this.clearUndoRedo();
        TextPos textPos = this.getDocumentEnd();
        DataFormatHandler dataFormatHandler = this.getDataFormatHandler(dataFormat, false);
        if (dataFormatHandler == null) {
            throw new UnsupportedOperationException("format not supported: " + String.valueOf(dataFormat));
        }
        String string = RichUtils.readString(inputStream);
        StyledInput styledInput = dataFormatHandler.createStyledInput(string, null);
        this.replace(styleResolver, TextPos.ZERO, textPos, styledInput, false);
    }

    public final void write(StyleResolver styleResolver, DataFormat dataFormat, OutputStream outputStream) throws IOException {
        TextPos textPos = this.getDocumentEnd();
        DataFormatHandler dataFormatHandler = this.getDataFormatHandler(dataFormat, true);
        if (dataFormatHandler == null) {
            throw new UnsupportedOperationException("format not supported: " + String.valueOf(dataFormat));
        }
        dataFormatHandler.save(this, styleResolver, TextPos.ZERO, textPos, outputStream);
    }

    private void checkWritable() {
        if (!this.isWritable()) {
            throw new UnsupportedOperationException("the model is not writeable");
        }
    }

    static {
        ModuleUtil.incubatorWarning();
    }

    private record FHPriority(DataFormatHandler handler, int priority) implements Comparable<FHPriority>
    {
        @Override
        public int compareTo(FHPriority fHPriority) {
            int n = fHPriority.priority - this.priority;
            if (n == 0) {
                String string = this.handler().getDataFormat().toString();
                String string2 = fHPriority.handler().getDataFormat().toString();
                n = string2.compareTo(string);
            }
            return n;
        }
    }

    private record FHKey(DataFormat format, boolean forExport) {
    }

    @FunctionalInterface
    public static interface Listener {
        public void onContentChange(ContentChange var1);
    }
}

