/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext.skin;

import com.sun.jfx.incubator.scene.control.input.InputMapHelper;
import com.sun.jfx.incubator.scene.control.input.SkinInputMap;
import com.sun.jfx.incubator.scene.control.richtext.RichTextAreaBehavior;
import com.sun.jfx.incubator.scene.control.richtext.RichTextAreaSkinHelper;
import com.sun.jfx.incubator.scene.control.richtext.TextCell;
import com.sun.jfx.incubator.scene.control.richtext.VFlow;
import com.sun.jfx.incubator.scene.control.richtext.util.ListenerHelper;
import com.sun.jfx.incubator.scene.control.richtext.util.RichUtils;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.input.DataFormat;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.ScrollEvent;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Font;
import jfx.incubator.scene.control.input.InputMap;
import jfx.incubator.scene.control.richtext.RichTextArea;
import jfx.incubator.scene.control.richtext.StyleHandlerRegistry;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.StyleAttribute;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledTextModel;
import jfx.incubator.scene.control.richtext.skin.CellContext;

public class RichTextAreaSkin
extends SkinBase<RichTextArea> {
    private final ListenerHelper listenerHelper;
    private final RichTextAreaBehavior behavior;
    private final VFlow vflow;
    private final ScrollBar vscroll;
    private final ScrollBar hscroll;
    private final EventHandler<InputMethodEvent> inputMethodTextChangedHandler = this::handleInputMethodEvent;
    private InputMethodRequests inputMethodRequests;

    public RichTextAreaSkin(RichTextArea richTextArea) {
        super((Control)richTextArea);
        this.listenerHelper = new ListenerHelper();
        this.vscroll = this.createVScrollBar();
        this.vscroll.setOrientation(Orientation.VERTICAL);
        this.vscroll.addEventFilter(ScrollEvent.ANY, scrollEvent -> scrollEvent.consume());
        this.hscroll = this.createHScrollBar();
        this.hscroll.setOrientation(Orientation.HORIZONTAL);
        this.hscroll.addEventFilter(ScrollEvent.ANY, scrollEvent -> scrollEvent.consume());
        this.vflow = new VFlow(this, this.vscroll, this.hscroll);
        this.getChildren().add((Object)this.vflow);
        this.behavior = new RichTextAreaBehavior(richTextArea);
        this.listenerHelper.addChangeListener(this.vflow::handleSelectionChange, new ObservableValue[]{richTextArea.selectionProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::updateRateRestartBlink, true, new ObservableValue[]{richTextArea.caretBlinkPeriodProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::updateCaretAndSelection, new ObservableValue[]{richTextArea.highlightCurrentParagraphProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleContentPadding, true, new ObservableValue[]{richTextArea.contentPaddingProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleDecoratorChange, new ObservableValue[]{richTextArea.leftDecoratorProperty(), richTextArea.rightDecoratorProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleUseContentHeight, true, new ObservableValue[]{richTextArea.useContentHeightProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleUseContentWidth, true, new ObservableValue[]{richTextArea.useContentWidthProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleVerticalScroll, new ObservableValue[]{this.vscroll.valueProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleHorizontalScroll, new ObservableValue[]{this.hscroll.valueProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleWrapText, new ObservableValue[]{richTextArea.wrapTextProperty()});
        this.listenerHelper.addInvalidationListener(this.vflow::handleModelChange, new ObservableValue[]{richTextArea.modelProperty()});
        this.listenerHelper.addChangeListener(richTextArea.modelProperty(), true, this::handleModelChange);
    }

    public void install() {
        InputMapHelper.setSkinInputMap((InputMap)((RichTextArea)this.getSkinnable()).getInputMap(), (SkinInputMap)this.behavior.getSkinInputMap());
        if (((RichTextArea)this.getSkinnable()).getOnInputMethodTextChanged() == null) {
            ((RichTextArea)this.getSkinnable()).setOnInputMethodTextChanged(this.inputMethodTextChangedHandler);
        }
        if (((RichTextArea)this.getSkinnable()).getInputMethodRequests() == null) {
            this.inputMethodRequests = new InputMethodRequests(this){

                public Point2D getTextLocation(int n) {
                    System.out.println("getTextLocation offset=" + n);
                    return null;
                }

                public String getSelectedText() {
                    System.out.println("getSelectedText");
                    return null;
                }

                public int getLocationOffset(int n, int n2) {
                    System.out.println("getLocationOffset x=" + n + " y=" + n2);
                    return 0;
                }

                public void cancelLatestCommittedText() {
                    System.out.println("cancelLatestCommittedText");
                }
            };
        }
    }

    public void dispose() {
        if (this.getSkinnable() != null) {
            if (((RichTextArea)this.getSkinnable()).getInputMethodRequests() == this.inputMethodRequests) {
                ((RichTextArea)this.getSkinnable()).setInputMethodRequests(null);
            }
            if (((RichTextArea)this.getSkinnable()).getOnInputMethodTextChanged() == this.inputMethodTextChangedHandler) {
                ((RichTextArea)this.getSkinnable()).setOnInputMethodTextChanged(null);
            }
            this.listenerHelper.disconnect();
            this.vflow.dispose();
            this.getChildren().remove((Object)this.vflow);
            super.dispose();
        }
    }

    private void handleModelChange(Object object, StyledTextModel styledTextModel, StyledTextModel styledTextModel2) {
        if (styledTextModel != null) {
            styledTextModel.removeListener(this.vflow);
        }
        if (styledTextModel2 != null) {
            styledTextModel2.addListener(this.vflow);
        }
    }

    protected ScrollBar createVScrollBar() {
        return new ScrollBar();
    }

    protected ScrollBar createHScrollBar() {
        return new ScrollBar();
    }

    private VFlow getVFlow() {
        return this.vflow;
    }

    public StyleResolver getStyleResolver() {
        return this.vflow;
    }

    public void copyText(DataFormat dataFormat) {
        this.behavior.copyWithFormat(dataFormat);
    }

    public void pasteText(DataFormat dataFormat) {
        this.behavior.pasteWithFormat(dataFormat);
    }

    public void applyStyles(CellContext cellContext, StyleAttributeMap styleAttributeMap, boolean bl) {
        if (styleAttributeMap != null) {
            RichTextArea richTextArea = (RichTextArea)this.getSkinnable();
            StyleHandlerRegistry styleHandlerRegistry = richTextArea.getStyleHandlerRegistry();
            for (StyleAttribute<?> styleAttribute : styleAttributeMap.getAttributes()) {
                Object obj = styleAttributeMap.get(styleAttribute);
                if (obj == null) continue;
                styleHandlerRegistry.process(richTextArea, bl, cellContext, styleAttribute, obj);
            }
        }
    }

    public void refreshLayout() {
        this.vflow.invalidateLayout();
        ((RichTextArea)this.getSkinnable()).requestLayout();
    }

    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        if (((RichTextArea)this.getSkinnable()).isUseContentHeight()) {
            return super.computePrefHeight(d, d2, d3, d4, d5);
        }
        return 176.0;
    }

    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        if (((RichTextArea)this.getSkinnable()).isUseContentWidth()) {
            return super.computePrefWidth(d, d2, d3, d4, d5);
        }
        return 176.0;
    }

    protected double computeMinHeight(double d, double d2, double d3, double d4, double d5) {
        return 10.0;
    }

    protected double computeMinWidth(double d, double d2, double d3, double d4, double d5) {
        return 10.0;
    }

    private void handleInputMethodEvent(InputMethodEvent inputMethodEvent) {
        RichTextArea richTextArea = (RichTextArea)this.getSkinnable();
    }

    public void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
        switch (accessibleAction) {
            case SHOW_TEXT_RANGE: {
                Integer n = (Integer)objectArray[0];
                Integer n2 = (Integer)objectArray[1];
                if (n == null || n2 == null) break;
                break;
            }
            default: {
                super.executeAccessibleAction(accessibleAction, objectArray);
            }
        }
    }

    protected Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case BOUNDS_FOR_RANGE: {
                TextPos textPos = ((RichTextArea)this.getSkinnable()).getCaretPosition();
                if (textPos != null) {
                    int n = (Integer)objectArray[0];
                    int n2 = (Integer)objectArray[1];
                    PathElement[] pathElementArray = this.getVFlow().getRangeShape(textPos.index(), n, n2 + 1);
                    return RichUtils.pathToBoundsArray((Node)this.getVFlow(), pathElementArray);
                }
                return null;
            }
            case FONT: {
                Double d;
                String string;
                StyleAttributeMap styleAttributeMap = ((RichTextArea)this.getSkinnable()).getActiveStyleAttributeMap();
                if (styleAttributeMap != null && (string = styleAttributeMap.getFontFamily()) != null && (d = styleAttributeMap.getFontSize()) != null) {
                    return Font.font((String)string, (double)d);
                }
                return null;
            }
            case HORIZONTAL_SCROLLBAR: {
                return this.hscroll;
            }
            case LINE_FOR_OFFSET: {
                TextCell textCell;
                TextPos textPos = ((RichTextArea)this.getSkinnable()).getCaretPosition();
                if (textPos != null && (textCell = this.getVFlow().getCell(textPos.index())) != null) {
                    int n = (Integer)objectArray[0];
                    return textCell.lineForOffset(n);
                }
                return null;
            }
            case LINE_START: {
                TextCell textCell;
                TextPos textPos = ((RichTextArea)this.getSkinnable()).getCaretPosition();
                if (textPos != null && (textCell = this.getVFlow().getCell(textPos.index())) != null) {
                    int n = (Integer)objectArray[0];
                    return textCell.lineStart(n);
                }
                return null;
            }
            case LINE_END: {
                TextCell textCell;
                TextPos textPos = ((RichTextArea)this.getSkinnable()).getCaretPosition();
                if (textPos != null && (textCell = this.getVFlow().getCell(textPos.index())) != null) {
                    int n = (Integer)objectArray[0];
                    return textCell.lineEnd(n);
                }
                return null;
            }
            case OFFSET_AT_POINT: {
                Point2D point2D = (Point2D)objectArray[0];
                TextPos textPos = ((RichTextArea)this.getSkinnable()).getTextPosition(point2D.getX(), point2D.getY());
                return textPos == null ? null : Integer.valueOf(textPos.charIndex());
            }
            case VERTICAL_SCROLLBAR: {
                return this.vscroll;
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    static {
        RichTextAreaSkinHelper.setAccessor(new RichTextAreaSkinHelper.Accessor(){

            @Override
            public VFlow getVFlow(Skin<?> skin) {
                if (skin instanceof RichTextAreaSkin) {
                    RichTextAreaSkin richTextAreaSkin = (RichTextAreaSkin)skin;
                    return richTextAreaSkin.getVFlow();
                }
                return null;
            }

            @Override
            public ListenerHelper getListenerHelper(Skin<?> skin) {
                return ((RichTextAreaSkin)skin).listenerHelper;
            }
        });
    }
}

