/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.binding;

import com.sun.javafx.binding.StringFormatter;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.MapBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.value.ObservableMapValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;

public abstract class MapExpression<K, V>
implements ObservableMapValue<K, V> {
    @Override
    public ObservableMap<K, V> getValue() {
        return (ObservableMap)this.get();
    }

    public static <K, V> MapExpression<K, V> mapExpression(final ObservableMapValue<K, V> observableMapValue) {
        if (observableMapValue == null) {
            throw new NullPointerException("Map must be specified.");
        }
        return observableMapValue instanceof MapExpression ? (MapExpression<K, V>)observableMapValue : new MapBinding<K, V>(){
            {
                super.bind(observableMapValue);
            }

            @Override
            public void dispose() {
                super.unbind(observableMapValue);
            }

            @Override
            protected ObservableMap<K, V> computeValue() {
                return (ObservableMap)observableMapValue.get();
            }

            @Override
            public ObservableList<?> getDependencies() {
                return FXCollections.singletonObservableList(observableMapValue);
            }
        };
    }

    public int getSize() {
        return this.size();
    }

    public abstract ReadOnlyIntegerProperty sizeProperty();

    public abstract ReadOnlyBooleanProperty emptyProperty();

    public ObjectBinding<V> valueAt(K k) {
        return Bindings.valueAt(this, k);
    }

    public ObjectBinding<V> valueAt(ObservableValue<K> observableValue) {
        return Bindings.valueAt(this, observableValue);
    }

    public BooleanBinding isEqualTo(ObservableMap<?, ?> observableMap) {
        return Bindings.equal(this, observableMap);
    }

    public BooleanBinding isNotEqualTo(ObservableMap<?, ?> observableMap) {
        return Bindings.notEqual(this, observableMap);
    }

    public BooleanBinding isNull() {
        return Bindings.isNull(this);
    }

    public BooleanBinding isNotNull() {
        return Bindings.isNotNull(this);
    }

    public StringBinding asString() {
        return (StringBinding)StringFormatter.convert(this);
    }

    @Override
    public int size() {
        return this.getNonNull().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getNonNull().isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getNonNull().containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.getNonNull().containsValue(object);
    }

    @Override
    public V put(K k, V v) {
        return this.getNonNull().put(k, v);
    }

    @Override
    public V remove(Object object) {
        return this.getNonNull().remove(object);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.getNonNull().putAll(map);
    }

    @Override
    public void clear() {
        this.getNonNull().clear();
    }

    @Override
    public Set<K> keySet() {
        return this.getNonNull().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.getNonNull().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getNonNull().entrySet();
    }

    @Override
    public V get(Object object) {
        return this.getNonNull().get(object);
    }

    private ObservableMap<K, V> getNonNull() {
        ObservableMap observableMap = (ObservableMap)this.get();
        return observableMap == null ? FXCollections.emptyObservableMap() : observableMap;
    }
}

