/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext;

import com.sun.jfx.incubator.scene.control.richtext.MarkerHelper;
import java.util.Objects;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import jfx.incubator.scene.control.richtext.TextPos;

public final class Marker
implements Comparable<Marker> {
    private final ReadOnlyObjectWrapper<TextPos> pos;

    private Marker(TextPos textPos) {
        Objects.nonNull(textPos);
        this.pos = new ReadOnlyObjectWrapper((Object)textPos);
    }

    public String toString() {
        return "Marker{index=" + this.getIndex() + ", offset=" + this.getOffset() + "}";
    }

    public final ReadOnlyObjectProperty<TextPos> textPosProperty() {
        return this.pos.getReadOnlyProperty();
    }

    public final TextPos getTextPos() {
        return (TextPos)this.pos.get();
    }

    private final void setTextPos(TextPos textPos) {
        this.pos.set((Object)textPos);
    }

    @Override
    public final int compareTo(Marker marker) {
        return this.getTextPos().compareTo(marker.getTextPos());
    }

    public int hashCode() {
        int n = Marker.class.hashCode();
        n = n * 31 + this.getTextPos().hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Marker) {
            Marker marker = (Marker)object;
            return this.getTextPos().equals(marker.getTextPos());
        }
        return false;
    }

    public final int getIndex() {
        return this.getTextPos().index();
    }

    public final int getOffset() {
        return this.getTextPos().offset();
    }

    static {
        MarkerHelper.setAccessor(new MarkerHelper.Accessor(){

            @Override
            public void setMarkerPos(Marker marker, TextPos textPos) {
                marker.setTextPos(textPos);
            }

            @Override
            public Marker createMarker(TextPos textPos) {
                return new Marker(textPos);
            }
        });
    }
}

