/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.GestureSupport;
import com.sun.glass.ui.TouchInputSupport;
import com.sun.glass.ui.View;
import com.sun.glass.ui.mac.MacTouchInputSupport;

final class MacGestureSupport {
    private static final int GESTURE_ROTATE = 100;
    private static final int GESTURE_MAGNIFY = 101;
    private static final int GESTURE_SWIPE = 102;
    private static final int SCROLL_SRC_WHEEL = 50;
    private static final int SCROLL_SRC_GESTURE = 51;
    private static final int SCROLL_SRC_INERTIA = 52;
    private static final double multiplier = 10.0;
    private static final boolean isDirect = false;
    private static final GestureSupport gestures;
    private static final TouchInputSupport touches;

    MacGestureSupport() {
    }

    private static native void _initIDs();

    public static void notifyBeginTouchEvent(View view, int n, int n2) {
        touches.notifyBeginTouchEvent(view, n, false, n2);
    }

    public static void notifyNextTouchEvent(View view, int n, long l, float f, float f2) {
        int n2 = (int)(10000.0f * f);
        int n3 = 10000 - (int)(10000.0f * f2);
        touches.notifyNextTouchEvent(view, n, l, n2, n3, n2, n3);
    }

    public static void notifyEndTouchEvent(View view) {
        touches.notifyEndTouchEvent(view);
    }

    public static void rotateGesturePerformed(View view, int n, int n2, int n3, int n4, int n5, float f) {
        gestures.handleDeltaRotation(view, n, false, false, n2, n3, n4, n5, -f);
    }

    public static void scrollGesturePerformed(View view, int n, int n2, int n3, int n4, int n5, int n6, float f, float f2) {
        int n7 = touches.getTouchCount();
        boolean bl = n2 == 52;
        switch (n2) {
            case 50: 
            case 52: {
                GestureSupport.handleScrollingPerformed(view, n, false, bl, n7, n3, n4, n5, n6, f, f2, 10.0, 10.0);
                break;
            }
            case 51: {
                gestures.handleDeltaScrolling(view, n, false, bl, n7, n3, n4, n5, n6, f, f2, 10.0, 10.0);
                break;
            }
            default: {
                System.err.println("Unknown scroll gesture sender: " + n2);
            }
        }
    }

    public static void swipeGesturePerformed(View view, int n, int n2, int n3, int n4, int n5, int n6) {
        GestureSupport.handleSwipePerformed(view, n, false, false, touches.getTouchCount(), n2, n3, n4, n5, n6);
    }

    public static void magnifyGesturePerformed(View view, int n, int n2, int n3, int n4, int n5, float f) {
        gestures.handleDeltaZooming(view, n, false, false, n2, n3, n4, n5, f, Double.NaN);
    }

    public static void gestureFinished(View view, int n, int n2, int n3, int n4, int n5) {
        if (gestures.isScrolling()) {
            gestures.handleScrollingEnd(view, n, touches.getTouchCount(), false, false, n2, n3, n4, n5);
        }
        if (gestures.isRotating()) {
            gestures.handleRotationEnd(view, n, false, false, n2, n3, n4, n5);
        }
        if (gestures.isZooming()) {
            gestures.handleZoomingEnd(view, n, false, false, n2, n3, n4, n5);
        }
    }

    static {
        MacGestureSupport._initIDs();
        gestures = new GestureSupport(false);
        touches = new MacTouchInputSupport(gestures.createTouchCountListener(), false);
    }
}

