/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.input;

import com.sun.javafx.PlatformUtil;
import com.sun.jfx.incubator.scene.control.input.EventCriteria;
import com.sun.jfx.incubator.scene.control.input.SkinInputMap;
import java.util.function.BooleanSupplier;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.TraversalDirection;
import javafx.scene.control.Control;
import javafx.scene.input.KeyCode;
import jfx.incubator.scene.control.input.FunctionTag;
import jfx.incubator.scene.control.input.KeyBinding;

public abstract class BehaviorBase<C extends Control> {
    private final C control;
    private SkinInputMap.Stateful skinInputMap;

    public BehaviorBase(C c) {
        this.control = c;
    }

    protected abstract void populateSkinInputMap();

    protected final C getControl() {
        return this.control;
    }

    public final SkinInputMap.Stateful getSkinInputMap() {
        if (this.skinInputMap == null) {
            this.skinInputMap = SkinInputMap.create();
            this.populateSkinInputMap();
        }
        return this.skinInputMap;
    }

    protected final void registerFunction(FunctionTag functionTag, Runnable runnable) {
        this.getSkinInputMap().registerFunction(functionTag, runnable);
    }

    protected final void registerFunction(FunctionTag functionTag, BooleanSupplier booleanSupplier) {
        this.getSkinInputMap().registerFunction(functionTag, booleanSupplier);
    }

    protected final void registerKey(KeyBinding keyBinding, FunctionTag functionTag) {
        this.getSkinInputMap().registerKey(keyBinding, functionTag);
    }

    protected final void registerKey(KeyCode keyCode, FunctionTag functionTag) {
        this.getSkinInputMap().registerKey(keyCode, functionTag);
    }

    protected final void register(FunctionTag functionTag, KeyBinding keyBinding, Runnable runnable) {
        this.getSkinInputMap().registerFunction(functionTag, runnable);
        this.getSkinInputMap().registerKey(keyBinding, functionTag);
    }

    protected final void register(FunctionTag functionTag, KeyBinding keyBinding, BooleanSupplier booleanSupplier) {
        this.getSkinInputMap().registerFunction(functionTag, booleanSupplier);
        this.getSkinInputMap().registerKey(keyBinding, functionTag);
    }

    protected final void register(FunctionTag functionTag, KeyCode keyCode, Runnable runnable) {
        this.getSkinInputMap().registerFunction(functionTag, runnable);
        this.getSkinInputMap().registerKey(KeyBinding.of(keyCode), functionTag);
    }

    protected final void duplicateMapping(KeyBinding keyBinding, KeyBinding keyBinding2) {
        this.getSkinInputMap().duplicateMapping(keyBinding, keyBinding2);
    }

    protected final <T extends Event> void addHandler(EventType<T> eventType, EventHandler<T> eventHandler) {
        this.getSkinInputMap().addHandler(eventType, eventHandler);
    }

    protected final <T extends Event> void addHandler(EventCriteria<T> eventCriteria, EventHandler<T> eventHandler) {
        this.getSkinInputMap().addHandler(eventCriteria, eventHandler);
    }

    protected final boolean isLinux() {
        return PlatformUtil.isLinux();
    }

    protected final boolean isMac() {
        return PlatformUtil.isMac();
    }

    protected final boolean isWindows() {
        return PlatformUtil.isWindows();
    }

    private void traverse(TraversalDirection traversalDirection) {
        this.control.requestFocusTraversal(traversalDirection);
    }

    public final void traverseUp() {
        this.traverse(TraversalDirection.UP);
    }

    public final void traverseDown() {
        this.traverse(TraversalDirection.DOWN);
    }

    public final void traverseLeft() {
        this.traverse(TraversalDirection.LEFT);
    }

    public final void traverseRight() {
        this.traverse(TraversalDirection.RIGHT);
    }

    public final void traverseNext() {
        this.traverse(TraversalDirection.NEXT);
    }

    public final void traversePrevious() {
        this.traverse(TraversalDirection.PREVIOUS);
    }
}

