/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit;

import java.util.Map;
import javafx.scene.input.KeyCode;

public final class KeyCodeMap {
    private static final Map<KeyCode, Entry> MAP = Map.ofEntries(KeyCodeMap.entry(KeyCode.ENTER, 13, "Enter"), KeyCodeMap.entry(KeyCode.BACK_SPACE, 8), KeyCodeMap.entry(KeyCode.TAB, 9), KeyCodeMap.entry(KeyCode.CANCEL, 3), KeyCodeMap.entry(KeyCode.CLEAR, 12, "Clear"), KeyCodeMap.entry(KeyCode.SHIFT, 16, "Shift"), KeyCodeMap.entry(KeyCode.CONTROL, 17, "Control"), KeyCodeMap.entry(KeyCode.ALT, 18, "Alt"), KeyCodeMap.entry(KeyCode.PAUSE, 19, "Pause"), KeyCodeMap.entry(KeyCode.CAPS, 20, "CapsLock"), KeyCodeMap.entry(KeyCode.ESCAPE, 27), KeyCodeMap.entry(KeyCode.SPACE, 32), KeyCodeMap.entry(KeyCode.PAGE_UP, 33, "PageUp"), KeyCodeMap.entry(KeyCode.PAGE_DOWN, 34, "PageDown"), KeyCodeMap.entry(KeyCode.END, 35, "End"), KeyCodeMap.entry(KeyCode.HOME, 36, "Home"), KeyCodeMap.entry(KeyCode.LEFT, 37, "Left"), KeyCodeMap.entry(KeyCode.UP, 38, "Up"), KeyCodeMap.entry(KeyCode.RIGHT, 39, "Right"), KeyCodeMap.entry(KeyCode.DOWN, 40, "Down"), KeyCodeMap.entry(KeyCode.COMMA, 188), KeyCodeMap.entry(KeyCode.MINUS, 189), KeyCodeMap.entry(KeyCode.PERIOD, 190), KeyCodeMap.entry(KeyCode.SLASH, 191), KeyCodeMap.entry(KeyCode.DIGIT0, 48), KeyCodeMap.entry(KeyCode.DIGIT1, 49), KeyCodeMap.entry(KeyCode.DIGIT2, 50), KeyCodeMap.entry(KeyCode.DIGIT3, 51), KeyCodeMap.entry(KeyCode.DIGIT4, 52), KeyCodeMap.entry(KeyCode.DIGIT5, 53), KeyCodeMap.entry(KeyCode.DIGIT6, 54), KeyCodeMap.entry(KeyCode.DIGIT7, 55), KeyCodeMap.entry(KeyCode.DIGIT8, 56), KeyCodeMap.entry(KeyCode.DIGIT9, 57), KeyCodeMap.entry(KeyCode.SEMICOLON, 186), KeyCodeMap.entry(KeyCode.EQUALS, 187), KeyCodeMap.entry(KeyCode.A, 65), KeyCodeMap.entry(KeyCode.B, 66), KeyCodeMap.entry(KeyCode.C, 67), KeyCodeMap.entry(KeyCode.D, 68), KeyCodeMap.entry(KeyCode.E, 69), KeyCodeMap.entry(KeyCode.F, 70), KeyCodeMap.entry(KeyCode.G, 71), KeyCodeMap.entry(KeyCode.H, 72), KeyCodeMap.entry(KeyCode.I, 73), KeyCodeMap.entry(KeyCode.J, 74), KeyCodeMap.entry(KeyCode.K, 75), KeyCodeMap.entry(KeyCode.L, 76), KeyCodeMap.entry(KeyCode.M, 77), KeyCodeMap.entry(KeyCode.N, 78), KeyCodeMap.entry(KeyCode.O, 79), KeyCodeMap.entry(KeyCode.P, 80), KeyCodeMap.entry(KeyCode.Q, 81), KeyCodeMap.entry(KeyCode.R, 82), KeyCodeMap.entry(KeyCode.S, 83), KeyCodeMap.entry(KeyCode.T, 84), KeyCodeMap.entry(KeyCode.U, 85), KeyCodeMap.entry(KeyCode.V, 86), KeyCodeMap.entry(KeyCode.W, 87), KeyCodeMap.entry(KeyCode.X, 88), KeyCodeMap.entry(KeyCode.Y, 89), KeyCodeMap.entry(KeyCode.Z, 90), KeyCodeMap.entry(KeyCode.OPEN_BRACKET, 219), KeyCodeMap.entry(KeyCode.BACK_SLASH, 220), KeyCodeMap.entry(KeyCode.CLOSE_BRACKET, 221), KeyCodeMap.entry(KeyCode.NUMPAD0, 96), KeyCodeMap.entry(KeyCode.NUMPAD1, 97), KeyCodeMap.entry(KeyCode.NUMPAD2, 98), KeyCodeMap.entry(KeyCode.NUMPAD3, 99), KeyCodeMap.entry(KeyCode.NUMPAD4, 100), KeyCodeMap.entry(KeyCode.NUMPAD5, 101), KeyCodeMap.entry(KeyCode.NUMPAD6, 102), KeyCodeMap.entry(KeyCode.NUMPAD7, 103), KeyCodeMap.entry(KeyCode.NUMPAD8, 104), KeyCodeMap.entry(KeyCode.NUMPAD9, 105), KeyCodeMap.entry(KeyCode.MULTIPLY, 106), KeyCodeMap.entry(KeyCode.ADD, 107), KeyCodeMap.entry(KeyCode.SEPARATOR, 108), KeyCodeMap.entry(KeyCode.SUBTRACT, 109), KeyCodeMap.entry(KeyCode.DECIMAL, 110), KeyCodeMap.entry(KeyCode.DIVIDE, 111), KeyCodeMap.entry(KeyCode.DELETE, 46, "U+007F"), KeyCodeMap.entry(KeyCode.NUM_LOCK, 144), KeyCodeMap.entry(KeyCode.SCROLL_LOCK, 145, "Scroll"), KeyCodeMap.entry(KeyCode.F1, 112, "F1"), KeyCodeMap.entry(KeyCode.F2, 113, "F2"), KeyCodeMap.entry(KeyCode.F3, 114, "F3"), KeyCodeMap.entry(KeyCode.F4, 115, "F4"), KeyCodeMap.entry(KeyCode.F5, 116, "F5"), KeyCodeMap.entry(KeyCode.F6, 117, "F6"), KeyCodeMap.entry(KeyCode.F7, 118, "F7"), KeyCodeMap.entry(KeyCode.F8, 119, "F8"), KeyCodeMap.entry(KeyCode.F9, 120, "F9"), KeyCodeMap.entry(KeyCode.F10, 121, "F10"), KeyCodeMap.entry(KeyCode.F11, 122, "F11"), KeyCodeMap.entry(KeyCode.F12, 123, "F12"), KeyCodeMap.entry(KeyCode.F13, 124, "F13"), KeyCodeMap.entry(KeyCode.F14, 125, "F14"), KeyCodeMap.entry(KeyCode.F15, 126, "F15"), KeyCodeMap.entry(KeyCode.F16, 127, "F16"), KeyCodeMap.entry(KeyCode.F17, 128, "F17"), KeyCodeMap.entry(KeyCode.F18, 129, "F18"), KeyCodeMap.entry(KeyCode.F19, 130, "F19"), KeyCodeMap.entry(KeyCode.F20, 131, "F20"), KeyCodeMap.entry(KeyCode.F21, 132, "F21"), KeyCodeMap.entry(KeyCode.F22, 133, "F22"), KeyCodeMap.entry(KeyCode.F23, 134, "F23"), KeyCodeMap.entry(KeyCode.F24, 135, "F24"), KeyCodeMap.entry(KeyCode.PRINTSCREEN, 44, "PrintScreen"), KeyCodeMap.entry(KeyCode.INSERT, 45, "Insert"), KeyCodeMap.entry(KeyCode.HELP, 47, "Help"), KeyCodeMap.entry(KeyCode.META, 0, "Meta"), KeyCodeMap.entry(KeyCode.BACK_QUOTE, 192), KeyCodeMap.entry(KeyCode.QUOTE, 222), KeyCodeMap.entry(KeyCode.KP_UP, 38, "Up"), KeyCodeMap.entry(KeyCode.KP_DOWN, 40, "Down"), KeyCodeMap.entry(KeyCode.KP_LEFT, 37, "Left"), KeyCodeMap.entry(KeyCode.KP_RIGHT, 39, "Right"), KeyCodeMap.entry(KeyCode.AMPERSAND, 55), KeyCodeMap.entry(KeyCode.ASTERISK, 56), KeyCodeMap.entry(KeyCode.QUOTEDBL, 222), KeyCodeMap.entry(KeyCode.LESS, 188), KeyCodeMap.entry(KeyCode.GREATER, 190), KeyCodeMap.entry(KeyCode.BRACELEFT, 219), KeyCodeMap.entry(KeyCode.BRACERIGHT, 221), KeyCodeMap.entry(KeyCode.AT, 50), KeyCodeMap.entry(KeyCode.COLON, 186), KeyCodeMap.entry(KeyCode.CIRCUMFLEX, 54), KeyCodeMap.entry(KeyCode.DOLLAR, 52), KeyCodeMap.entry(KeyCode.EXCLAMATION_MARK, 49), KeyCodeMap.entry(KeyCode.LEFT_PARENTHESIS, 57), KeyCodeMap.entry(KeyCode.NUMBER_SIGN, 51), KeyCodeMap.entry(KeyCode.PLUS, 187), KeyCodeMap.entry(KeyCode.RIGHT_PARENTHESIS, 48), KeyCodeMap.entry(KeyCode.UNDERSCORE, 189), KeyCodeMap.entry(KeyCode.WINDOWS, 91, "Win"), KeyCodeMap.entry(KeyCode.CONTEXT_MENU, 93), KeyCodeMap.entry(KeyCode.FINAL, 24), KeyCodeMap.entry(KeyCode.CONVERT, 28), KeyCodeMap.entry(KeyCode.NONCONVERT, 29), KeyCodeMap.entry(KeyCode.ACCEPT, 30), KeyCodeMap.entry(KeyCode.MODECHANGE, 31), KeyCodeMap.entry(KeyCode.KANA, 21), KeyCodeMap.entry(KeyCode.KANJI, 25), KeyCodeMap.entry(KeyCode.ALT_GRAPH, 165), KeyCodeMap.entry(KeyCode.PLAY, 250), KeyCodeMap.entry(KeyCode.TRACK_PREV, 177), KeyCodeMap.entry(KeyCode.TRACK_NEXT, 176), KeyCodeMap.entry(KeyCode.VOLUME_UP, 175), KeyCodeMap.entry(KeyCode.VOLUME_DOWN, 174), KeyCodeMap.entry(KeyCode.MUTE, 173));

    private static Map.Entry<KeyCode, Entry> entry(KeyCode keyCode, int n, String string) {
        return Map.entry(keyCode, new Entry(n, string));
    }

    private static Map.Entry<KeyCode, Entry> entry(KeyCode keyCode, int n) {
        return KeyCodeMap.entry(keyCode, n, null);
    }

    public static Entry lookup(KeyCode keyCode) {
        Entry entry = MAP.get(keyCode);
        if (entry == null || entry.getKeyIdentifier() == null) {
            int n = entry != null ? entry.getWindowsVirtualKeyCode() : 0;
            String string = String.format("U+%04X", n);
            entry = new Entry(n, string);
        }
        return entry;
    }

    public static final class Entry {
        private final int windowsVirtualKeyCode;
        private final String keyIdentifier;

        private Entry(int n, String string) {
            this.windowsVirtualKeyCode = n;
            this.keyIdentifier = string;
        }

        public int getWindowsVirtualKeyCode() {
            return this.windowsVirtualKeyCode;
        }

        public String getKeyIdentifier() {
            return this.keyIdentifier;
        }
    }
}

