/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import java.io.IOException;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledInput;
import jfx.incubator.scene.control.richtext.model.StyledSegment;

public class StringStyledInput
implements StyledInput {
    private final String text;
    private final StyleAttributeMap attrs;
    private int offset;

    public StringStyledInput(String string, StyleAttributeMap styleAttributeMap) {
        this.text = string == null ? "" : string;
        this.attrs = styleAttributeMap;
    }

    @Override
    public StyledSegment nextSegment() {
        if (this.offset < this.text.length()) {
            int n = this.text.charAt(this.offset);
            switch (n) {
                case 10: {
                    ++this.offset;
                    return StyledSegment.LINE_BREAK;
                }
                case 13: {
                    n = this.charAt(++this.offset);
                    switch (n) {
                        case 10: {
                            ++this.offset;
                        }
                    }
                    return StyledSegment.LINE_BREAK;
                }
            }
            int n2 = this.indexOfLineBreak(this.offset);
            if (n2 < 0) {
                String string = this.text.substring(this.offset);
                this.offset = this.text.length();
                return StyledSegment.of(string, this.attrs);
            }
            String string = this.text.substring(this.offset, n2);
            this.offset = n2;
            return StyledSegment.of(string, this.attrs);
        }
        return null;
    }

    private int charAt(int n) {
        if (n < this.text.length()) {
            return this.text.charAt(n);
        }
        return -1;
    }

    private int indexOfLineBreak(int n) {
        int n2 = this.text.length();
        for (int i = n; i < n2; ++i) {
            char c = this.text.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    return i;
                }
            }
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
    }
}

