/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.InterpolatorConverter;
import com.sun.javafx.css.TransitionDefinition;
import java.util.Arrays;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.scene.text.Font;
import javafx.util.Duration;

public final class TransitionDefinitionConverter
extends StyleConverter<ParsedValue[], TransitionDefinition> {
    public static final String PROPERTY_ALL = "all";

    public static StyleConverter<ParsedValue[], TransitionDefinition> getInstance() {
        return Holder.INSTANCE;
    }

    private TransitionDefinitionConverter() {
    }

    @Override
    public TransitionDefinition convert(ParsedValue<ParsedValue[], TransitionDefinition> parsedValue, Font font) {
        ParsedValue[] parsedValueArray = parsedValue.getValue();
        ParsedValue parsedValue2 = parsedValueArray[0];
        ParsedValue parsedValue3 = parsedValueArray[1];
        ParsedValue parsedValue4 = parsedValueArray[2];
        ParsedValue parsedValue5 = parsedValueArray[3];
        String string = parsedValue2 != null ? (String)parsedValue2.convert(null) : PROPERTY_ALL;
        Duration duration = parsedValue3 != null ? (Duration)parsedValue3.convert(null) : Duration.ZERO;
        Duration duration2 = parsedValue4 != null ? (Duration)parsedValue4.convert(null) : Duration.ZERO;
        Interpolator interpolator = parsedValue5 != null ? (Interpolator)parsedValue5.convert(null) : InterpolatorConverter.CSS_EASE;
        return new TransitionDefinition(string.intern(), duration.lessThan(Duration.ZERO) ? Duration.ZERO : duration, duration2, interpolator);
    }

    private static class Holder {
        static final TransitionDefinitionConverter INSTANCE = new TransitionDefinitionConverter();
        static final SequenceConverter SEQUENCE_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }

    public static final class SequenceConverter
    extends StyleConverter<ParsedValue<ParsedValue[], TransitionDefinition>[], TransitionDefinition[]> {
        private static final TransitionDefinition[] EMPTY_TRANSITION = new TransitionDefinition[0];
        private static final String[] EMPTY_STRING = new String[0];
        private static final Duration[] EMPTY_DURATION = new Duration[0];
        private static final Interpolator[] EMPTY_INTERPOLATOR = new Interpolator[0];

        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public TransitionDefinition[] convert(Map<CssMetaData<? extends Styleable, ?>, Object> map) {
            String[] stringArray = EMPTY_STRING;
            Duration[] durationArray = EMPTY_DURATION;
            Duration[] durationArray2 = EMPTY_DURATION;
            Interpolator[] interpolatorArray = EMPTY_INTERPOLATOR;
            for (Map.Entry<CssMetaData<Styleable, ?>, Object> entry : map.entrySet()) {
                switch (entry.getKey().getProperty()) {
                    case "transition-property": {
                        stringArray = (String[])entry.getValue();
                        break;
                    }
                    case "transition-duration": {
                        durationArray = (Duration[])entry.getValue();
                        break;
                    }
                    case "transition-delay": {
                        durationArray2 = (Duration[])entry.getValue();
                        break;
                    }
                    case "transition-timing-function": {
                        interpolatorArray = (Interpolator[])entry.getValue();
                    }
                }
            }
            if (stringArray.length == 0 || durationArray.length == 0) {
                return EMPTY_TRANSITION;
            }
            TransitionDefinition[] transitionDefinitionArray = new TransitionDefinition[stringArray.length];
            for (int i = 0; i < transitionDefinitionArray.length; ++i) {
                Object object = interpolatorArray.length == 0 ? InterpolatorConverter.CSS_EASE : interpolatorArray[i % interpolatorArray.length];
                Duration duration = durationArray[i % durationArray.length];
                Duration duration2 = durationArray2.length == 0 ? Duration.ZERO : durationArray2[i % durationArray2.length];
                transitionDefinitionArray[i] = new TransitionDefinition(stringArray[i], duration, duration2, (Interpolator)object);
            }
            return transitionDefinitionArray;
        }

        @Override
        public TransitionDefinition[] convert(ParsedValue<ParsedValue<ParsedValue[], TransitionDefinition>[], TransitionDefinition[]> parsedValue, Font font) {
            ParsedValue<ParsedValue[], TransitionDefinition>[] parsedValueArray = parsedValue.getValue();
            if (parsedValueArray.length == 0) {
                return EMPTY_TRANSITION;
            }
            TransitionDefinition[] transitionDefinitionArray = new TransitionDefinition[parsedValueArray.length];
            int n = 0;
            for (ParsedValue<ParsedValue[], TransitionDefinition> parsedValue2 : parsedValueArray) {
                TransitionDefinition transitionDefinition = TransitionDefinitionConverter.getInstance().convert(parsedValue2, font);
                if (transitionDefinition == null) continue;
                transitionDefinitionArray[n++] = transitionDefinition;
            }
            return n == transitionDefinitionArray.length ? transitionDefinitionArray : Arrays.copyOf(transitionDefinitionArray, n);
        }
    }
}

