/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.util.Utils;
import com.sun.jfx.incubator.scene.control.input.BehaviorBase;
import com.sun.jfx.incubator.scene.control.richtext.CaretInfo;
import com.sun.jfx.incubator.scene.control.richtext.RichTextAreaSkinHelper;
import com.sun.jfx.incubator.scene.control.richtext.SelInfo;
import com.sun.jfx.incubator.scene.control.richtext.TextCell;
import com.sun.jfx.incubator.scene.control.richtext.VFlow;
import com.sun.jfx.incubator.scene.control.richtext.util.RichUtils;
import java.io.IOException;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.collections.ObservableList;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.util.Duration;
import jfx.incubator.scene.control.input.KeyBinding;
import jfx.incubator.scene.control.richtext.RichTextArea;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.DataFormatHandler;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledInput;
import jfx.incubator.scene.control.richtext.model.StyledTextModel;

public class RichTextAreaBehavior
extends BehaviorBase<RichTextArea> {
    private VFlow vflow;
    private final Timeline autoScrollTimer;
    private boolean autoScrollUp;
    private boolean fastAutoScroll;
    private boolean scrollStarted;
    private double phantomX = -1.0;
    private final Duration autoScrollPeriod;
    private ContextMenu contextMenu = new ContextMenu();

    public RichTextAreaBehavior(RichTextArea richTextArea) {
        super((Control)richTextArea);
        this.autoScrollPeriod = Duration.millis((double)100.0);
        this.autoScrollTimer = new Timeline(new KeyFrame[]{new KeyFrame(this.autoScrollPeriod, actionEvent -> this.autoScroll(), new KeyValue[0])});
        this.autoScrollTimer.setCycleCount(-1);
    }

    protected void populateSkinInputMap() {
        this.vflow = RichTextAreaSkinHelper.getVFlow((RichTextArea)this.getControl());
        this.registerFunction(RichTextArea.Tag.BACKSPACE, this::backspace);
        this.registerFunction(RichTextArea.Tag.COPY, this::copy);
        this.registerFunction(RichTextArea.Tag.CUT, this::cut);
        this.registerFunction(RichTextArea.Tag.DELETE, this::delete);
        this.registerFunction(RichTextArea.Tag.DELETE_PARAGRAPH, this::deleteParagraph);
        this.registerFunction(RichTextArea.Tag.DELETE_PARAGRAPH_START, this::deleteParagraphStart);
        this.registerFunction(RichTextArea.Tag.DELETE_WORD_NEXT_END, this::deleteWordNextEnd);
        this.registerFunction(RichTextArea.Tag.DELETE_WORD_NEXT_START, this::deleteWordNextBeg);
        this.registerFunction(RichTextArea.Tag.DELETE_WORD_PREVIOUS, this::deleteWordPrevious);
        this.registerFunction(RichTextArea.Tag.DESELECT, this::deselect);
        this.registerFunction(RichTextArea.Tag.FOCUS_NEXT, () -> ((RichTextAreaBehavior)this).traverseNext());
        this.registerFunction(RichTextArea.Tag.FOCUS_PREVIOUS, () -> ((RichTextAreaBehavior)this).traversePrevious());
        this.registerFunction(RichTextArea.Tag.INSERT_LINE_BREAK, this::insertLineBreak);
        this.registerFunction(RichTextArea.Tag.INSERT_TAB, this::insertTab);
        this.registerFunction(RichTextArea.Tag.MOVE_DOWN, this::moveDown);
        this.registerFunction(RichTextArea.Tag.MOVE_LEFT, this::moveLeft);
        this.registerFunction(RichTextArea.Tag.MOVE_PARAGRAPH_DOWN, this::moveParagraphDown);
        this.registerFunction(RichTextArea.Tag.MOVE_PARAGRAPH_UP, this::moveParagraphUp);
        this.registerFunction(RichTextArea.Tag.MOVE_RIGHT, this::moveRight);
        this.registerFunction(RichTextArea.Tag.MOVE_TO_DOCUMENT_END, this::moveDocumentEnd);
        this.registerFunction(RichTextArea.Tag.MOVE_TO_DOCUMENT_START, this::moveDocumentStart);
        this.registerFunction(RichTextArea.Tag.MOVE_TO_LINE_END, this::moveLineEnd);
        this.registerFunction(RichTextArea.Tag.MOVE_TO_LINE_START, this::moveLineStart);
        this.registerFunction(RichTextArea.Tag.MOVE_TO_PARAGRAPH_END, this::moveParagraphEnd);
        this.registerFunction(RichTextArea.Tag.MOVE_TO_PARAGRAPH_START, this::moveParagraphStart);
        this.registerFunction(RichTextArea.Tag.MOVE_UP, this::moveUp);
        this.registerFunction(RichTextArea.Tag.MOVE_WORD_NEXT_END, this::nextWordEnd);
        this.registerFunction(RichTextArea.Tag.MOVE_WORD_NEXT_START, this::nextWord);
        this.registerFunction(RichTextArea.Tag.MOVE_WORD_LEFT, this::leftWord);
        this.registerFunction(RichTextArea.Tag.MOVE_WORD_PREVIOUS, this::previousWord);
        this.registerFunction(RichTextArea.Tag.MOVE_WORD_RIGHT, this::rightWord);
        this.registerFunction(RichTextArea.Tag.PAGE_DOWN, this::pageDown);
        this.registerFunction(RichTextArea.Tag.PAGE_UP, this::pageUp);
        this.registerFunction(RichTextArea.Tag.PASTE, this::paste);
        this.registerFunction(RichTextArea.Tag.PASTE_PLAIN_TEXT, this::pastePlainText);
        this.registerFunction(RichTextArea.Tag.REDO, this::redo);
        this.registerFunction(RichTextArea.Tag.SELECT_ALL, this::selectAll);
        this.registerFunction(RichTextArea.Tag.SELECT_DOWN, this::selectDown);
        this.registerFunction(RichTextArea.Tag.SELECT_LEFT, this::selectLeft);
        this.registerFunction(RichTextArea.Tag.SELECT_PAGE_DOWN, this::selectPageDown);
        this.registerFunction(RichTextArea.Tag.SELECT_PAGE_UP, this::selectPageUp);
        this.registerFunction(RichTextArea.Tag.SELECT_PARAGRAPH, this::selectParagraph);
        this.registerFunction(RichTextArea.Tag.SELECT_PARAGRAPH_DOWN, this::selectParagraphDown);
        this.registerFunction(RichTextArea.Tag.SELECT_PARAGRAPH_END, this::selectParagraphEnd);
        this.registerFunction(RichTextArea.Tag.SELECT_PARAGRAPH_START, this::selectParagraphStart);
        this.registerFunction(RichTextArea.Tag.SELECT_PARAGRAPH_UP, this::selectParagraphUp);
        this.registerFunction(RichTextArea.Tag.SELECT_RIGHT, this::selectRight);
        this.registerFunction(RichTextArea.Tag.SELECT_TO_DOCUMENT_END, this::selectDocumentEnd);
        this.registerFunction(RichTextArea.Tag.SELECT_TO_DOCUMENT_START, this::selectDocumentStart);
        this.registerFunction(RichTextArea.Tag.SELECT_TO_LINE_END, this::selectLineEnd);
        this.registerFunction(RichTextArea.Tag.SELECT_TO_LINE_START, this::selectLineStart);
        this.registerFunction(RichTextArea.Tag.SELECT_UP, this::selectUp);
        this.registerFunction(RichTextArea.Tag.SELECT_WORD, this::selectWord);
        this.registerFunction(RichTextArea.Tag.SELECT_WORD_LEFT, this::selectWordLeft);
        this.registerFunction(RichTextArea.Tag.SELECT_WORD_NEXT, this::selectWordNext);
        this.registerFunction(RichTextArea.Tag.SELECT_WORD_NEXT_END, this::selectNextWordEnd);
        this.registerFunction(RichTextArea.Tag.SELECT_WORD_PREVIOUS, this::selectWordPrevious);
        this.registerFunction(RichTextArea.Tag.SELECT_WORD_RIGHT, this::selectWordRight);
        this.registerFunction(RichTextArea.Tag.UNDO, this::undo);
        this.registerKey(KeyBinding.shortcut((KeyCode)KeyCode.A), RichTextArea.Tag.SELECT_ALL);
        this.registerKey(KeyCode.BACK_SPACE, RichTextArea.Tag.BACKSPACE);
        this.registerKey(KeyBinding.shift((KeyCode)KeyCode.BACK_SPACE), RichTextArea.Tag.BACKSPACE);
        this.registerKey(KeyBinding.shortcut((KeyCode)KeyCode.C), RichTextArea.Tag.COPY);
        this.registerKey(KeyCode.COPY, RichTextArea.Tag.COPY);
        this.registerKey(KeyBinding.shortcut((KeyCode)KeyCode.D), RichTextArea.Tag.DELETE_PARAGRAPH);
        this.registerKey(KeyCode.DELETE, RichTextArea.Tag.DELETE);
        this.registerKey(KeyCode.DOWN, RichTextArea.Tag.MOVE_DOWN);
        this.registerKey(KeyBinding.shift((KeyCode)KeyCode.DOWN), RichTextArea.Tag.SELECT_DOWN);
        this.registerKey(KeyCode.END, RichTextArea.Tag.MOVE_TO_LINE_END);
        this.registerKey(KeyBinding.control((KeyCode)KeyCode.END), RichTextArea.Tag.MOVE_TO_DOCUMENT_END);
        this.registerKey(KeyBinding.controlShift((KeyCode)KeyCode.END), RichTextArea.Tag.SELECT_TO_DOCUMENT_END);
        this.registerKey(KeyBinding.shift((KeyCode)KeyCode.END), RichTextArea.Tag.SELECT_TO_LINE_END);
        this.registerKey(KeyCode.ENTER, RichTextArea.Tag.INSERT_LINE_BREAK);
        this.registerKey(KeyCode.HOME, RichTextArea.Tag.MOVE_TO_LINE_START);
        this.registerKey(KeyBinding.control((KeyCode)KeyCode.HOME), RichTextArea.Tag.MOVE_TO_DOCUMENT_START);
        this.registerKey(KeyBinding.controlShift((KeyCode)KeyCode.HOME), RichTextArea.Tag.SELECT_TO_DOCUMENT_START);
        this.registerKey(KeyBinding.shift((KeyCode)KeyCode.HOME), RichTextArea.Tag.SELECT_TO_LINE_START);
        this.registerKey(KeyBinding.shift((KeyCode)KeyCode.INSERT), RichTextArea.Tag.PASTE);
        this.registerKey(KeyBinding.shortcut((KeyCode)KeyCode.INSERT), RichTextArea.Tag.COPY);
        this.registerKey(KeyCode.LEFT, RichTextArea.Tag.MOVE_LEFT);
        this.registerKey(KeyBinding.shift((KeyCode)KeyCode.LEFT), RichTextArea.Tag.SELECT_LEFT);
        this.registerKey(KeyCode.PAGE_DOWN, RichTextArea.Tag.PAGE_DOWN);
        this.registerKey(KeyBinding.shift((KeyCode)KeyCode.PAGE_DOWN), RichTextArea.Tag.SELECT_PAGE_DOWN);
        this.registerKey(KeyCode.PAGE_UP, RichTextArea.Tag.PAGE_UP);
        this.registerKey(KeyBinding.shift((KeyCode)KeyCode.PAGE_UP), RichTextArea.Tag.SELECT_PAGE_UP);
        this.registerKey(KeyCode.PASTE, RichTextArea.Tag.PASTE);
        this.registerKey(KeyCode.RIGHT, RichTextArea.Tag.MOVE_RIGHT);
        this.registerKey(KeyBinding.shift((KeyCode)KeyCode.RIGHT), RichTextArea.Tag.SELECT_RIGHT);
        this.registerKey(KeyCode.TAB, RichTextArea.Tag.INSERT_TAB);
        this.registerKey(KeyBinding.control((KeyCode)KeyCode.TAB), RichTextArea.Tag.FOCUS_NEXT);
        this.registerKey(KeyBinding.controlShift((KeyCode)KeyCode.TAB), RichTextArea.Tag.FOCUS_PREVIOUS);
        this.registerKey(KeyBinding.shift((KeyCode)KeyCode.TAB), RichTextArea.Tag.FOCUS_PREVIOUS);
        this.registerKey(KeyCode.UP, RichTextArea.Tag.MOVE_UP);
        this.registerKey(KeyBinding.shift((KeyCode)KeyCode.UP), RichTextArea.Tag.SELECT_UP);
        this.registerKey(KeyBinding.shortcut((KeyCode)KeyCode.V), RichTextArea.Tag.PASTE);
        this.registerKey(KeyBinding.shiftShortcut((KeyCode)KeyCode.V), RichTextArea.Tag.PASTE_PLAIN_TEXT);
        this.registerKey(KeyBinding.shortcut((KeyCode)KeyCode.X), RichTextArea.Tag.CUT);
        this.registerKey(KeyCode.CUT, RichTextArea.Tag.CUT);
        this.registerKey(KeyBinding.shortcut((KeyCode)KeyCode.Z), RichTextArea.Tag.UNDO);
        if (this.isMac()) {
            this.registerKey(KeyBinding.option((KeyCode)KeyCode.BACK_SPACE), RichTextArea.Tag.DELETE_WORD_PREVIOUS);
            this.registerKey(KeyBinding.shortcut((KeyCode)KeyCode.BACK_SPACE), RichTextArea.Tag.DELETE_PARAGRAPH_START);
            this.registerKey(KeyBinding.option((KeyCode)KeyCode.DELETE), RichTextArea.Tag.DELETE_WORD_NEXT_END);
            this.registerKey(KeyBinding.option((KeyCode)KeyCode.DOWN), RichTextArea.Tag.MOVE_PARAGRAPH_DOWN);
            this.registerKey(KeyBinding.shiftOption((KeyCode)KeyCode.DOWN), RichTextArea.Tag.SELECT_PARAGRAPH_DOWN);
            this.registerKey(KeyBinding.shiftShortcut((KeyCode)KeyCode.DOWN), RichTextArea.Tag.SELECT_TO_DOCUMENT_END);
            this.registerKey(KeyBinding.shortcut((KeyCode)KeyCode.DOWN), RichTextArea.Tag.MOVE_TO_DOCUMENT_END);
            this.registerKey(KeyBinding.option((KeyCode)KeyCode.LEFT), RichTextArea.Tag.MOVE_WORD_LEFT);
            this.registerKey(KeyBinding.shiftOption((KeyCode)KeyCode.LEFT), RichTextArea.Tag.SELECT_WORD_LEFT);
            this.registerKey(KeyBinding.shiftShortcut((KeyCode)KeyCode.LEFT), RichTextArea.Tag.SELECT_TO_LINE_START);
            this.registerKey(KeyBinding.shortcut((KeyCode)KeyCode.LEFT), RichTextArea.Tag.MOVE_TO_LINE_START);
            this.registerKey(KeyBinding.option((KeyCode)KeyCode.RIGHT), RichTextArea.Tag.MOVE_WORD_RIGHT);
            this.registerKey(KeyBinding.shiftOption((KeyCode)KeyCode.RIGHT), RichTextArea.Tag.SELECT_WORD_RIGHT);
            this.registerKey(KeyBinding.shiftShortcut((KeyCode)KeyCode.RIGHT), RichTextArea.Tag.SELECT_TO_LINE_END);
            this.registerKey(KeyBinding.shortcut((KeyCode)KeyCode.RIGHT), RichTextArea.Tag.MOVE_TO_LINE_END);
            this.registerKey(KeyBinding.builder((KeyCode)KeyCode.TAB).control().option().shift().build(), RichTextArea.Tag.FOCUS_NEXT);
            this.registerKey(KeyBinding.option((KeyCode)KeyCode.UP), RichTextArea.Tag.MOVE_PARAGRAPH_UP);
            this.registerKey(KeyBinding.shiftOption((KeyCode)KeyCode.UP), RichTextArea.Tag.SELECT_PARAGRAPH_UP);
            this.registerKey(KeyBinding.shiftShortcut((KeyCode)KeyCode.UP), RichTextArea.Tag.SELECT_TO_DOCUMENT_START);
            this.registerKey(KeyBinding.shortcut((KeyCode)KeyCode.UP), RichTextArea.Tag.MOVE_TO_DOCUMENT_START);
            this.registerKey(KeyBinding.builder((KeyCode)KeyCode.Z).shift().command().build(), RichTextArea.Tag.REDO);
        } else {
            this.registerKey(KeyBinding.control((KeyCode)KeyCode.BACK_SLASH), RichTextArea.Tag.DESELECT);
            this.registerKey(KeyBinding.control((KeyCode)KeyCode.BACK_SPACE), RichTextArea.Tag.DELETE_WORD_PREVIOUS);
            this.registerKey(KeyBinding.control((KeyCode)KeyCode.DELETE), RichTextArea.Tag.DELETE_WORD_NEXT_START);
            this.registerKey(KeyBinding.control((KeyCode)KeyCode.DOWN), RichTextArea.Tag.MOVE_PARAGRAPH_DOWN);
            this.registerKey(KeyBinding.controlShift((KeyCode)KeyCode.DOWN), RichTextArea.Tag.SELECT_PARAGRAPH_DOWN);
            this.registerKey(KeyBinding.control((KeyCode)KeyCode.H), RichTextArea.Tag.BACKSPACE);
            this.registerKey(KeyBinding.control((KeyCode)KeyCode.LEFT), RichTextArea.Tag.MOVE_WORD_LEFT);
            this.registerKey(KeyBinding.controlShift((KeyCode)KeyCode.LEFT), RichTextArea.Tag.SELECT_WORD_LEFT);
            this.registerKey(KeyBinding.control((KeyCode)KeyCode.RIGHT), RichTextArea.Tag.MOVE_WORD_RIGHT);
            this.registerKey(KeyBinding.controlShift((KeyCode)KeyCode.RIGHT), RichTextArea.Tag.SELECT_WORD_RIGHT);
            this.registerKey(KeyBinding.control((KeyCode)KeyCode.UP), RichTextArea.Tag.MOVE_PARAGRAPH_UP);
            this.registerKey(KeyBinding.controlShift((KeyCode)KeyCode.UP), RichTextArea.Tag.SELECT_PARAGRAPH_UP);
            if (this.isWindows()) {
                this.registerKey(KeyBinding.control((KeyCode)KeyCode.Y), RichTextArea.Tag.REDO);
            } else {
                this.registerKey(KeyBinding.controlShift((KeyCode)KeyCode.Z), RichTextArea.Tag.REDO);
            }
        }
        Pane pane = this.vflow.getContentPane();
        pane.addEventFilter(MouseEvent.MOUSE_CLICKED, this::handleMouseClicked);
        pane.addEventFilter(MouseEvent.MOUSE_PRESSED, this::handleMousePressed);
        pane.addEventFilter(MouseEvent.MOUSE_RELEASED, this::handleMouseReleased);
        pane.addEventFilter(MouseEvent.MOUSE_DRAGGED, this::handleMouseDragged);
        pane.addEventFilter(ScrollEvent.SCROLL_STARTED, this::handleScrollEventStarted);
        pane.addEventHandler(ScrollEvent.SCROLL_FINISHED, this::handleScrollEventFinished);
        pane.addEventHandler(ScrollEvent.SCROLL, this::handleScrollEvent);
        this.addHandler(KeyEvent.KEY_TYPED, this::handleKeyTyped);
        this.addHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, this::contextMenuRequested);
    }

    protected boolean isRTL() {
        return ((RichTextArea)this.getControl()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
    }

    protected String getPlainText(int n) {
        StyledTextModel styledTextModel = ((RichTextArea)this.getControl()).getModel();
        return styledTextModel == null ? "" : styledTextModel.getPlainText(n);
    }

    protected void handleKeyTyped(KeyEvent keyEvent) {
        if (keyEvent == null || keyEvent.isConsumed()) {
            return;
        }
        String string = this.getValidKeyTyped(keyEvent);
        if (string != null) {
            this.vflow.setSuppressBlink(true);
            boolean bl = this.handleTypedChar(string);
            if (bl) {
                keyEvent.consume();
            }
            this.vflow.setSuppressBlink(false);
        }
    }

    protected boolean handleTypedChar(String string) {
        if (this.canEdit()) {
            RichTextArea richTextArea = (RichTextArea)this.getControl();
            StyledTextModel styledTextModel = richTextArea.getModel();
            TextPos textPos = richTextArea.getCaretPosition();
            if (textPos != null) {
                TextPos textPos2 = richTextArea.getAnchorPosition();
                if (textPos2 == null) {
                    textPos2 = textPos;
                }
                TextPos textPos3 = styledTextModel.replace((StyleResolver)this.vflow, textPos, textPos2, string, true);
                this.moveCaret(textPos3, false);
                this.clearPhantomX();
                return true;
            }
        }
        return false;
    }

    protected String getValidKeyTyped(KeyEvent keyEvent) {
        String string;
        if (keyEvent.getEventType() == KeyEvent.KEY_TYPED && (string = keyEvent.getCharacter()).length() > 0) {
            if ((keyEvent.isControlDown() || keyEvent.isAltDown() || PlatformUtil.isMac() && keyEvent.isMetaDown()) && (!keyEvent.isControlDown() && !PlatformUtil.isMac() || !keyEvent.isAltDown())) {
                return null;
            }
            if (string.charAt(0) > '\u001f' && string.charAt(0) != '\u007f' && !keyEvent.isMetaDown()) {
                return string;
            }
        }
        return null;
    }

    protected boolean canEdit() {
        StyledTextModel styledTextModel;
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        if (richTextArea.isEditable() && (styledTextModel = richTextArea.getModel()) != null) {
            return styledTextModel.isWritable();
        }
        return false;
    }

    public boolean insertTab() {
        if (this.canEdit()) {
            this.handleTypedChar("\t");
            return true;
        }
        return false;
    }

    public void insertLineBreak() {
        if (this.canEdit()) {
            RichTextArea richTextArea = (RichTextArea)this.getControl();
            StyledTextModel styledTextModel = richTextArea.getModel();
            TextPos textPos = richTextArea.getCaretPosition();
            if (textPos == null) {
                return;
            }
            TextPos textPos2 = richTextArea.getAnchorPosition();
            if (textPos2 == null) {
                return;
            }
            TextPos textPos3 = styledTextModel.replace((StyleResolver)this.vflow, textPos, textPos2, StyledInput.of("\n"), true);
            this.moveCaret(textPos3, false);
            this.clearPhantomX();
        }
    }

    protected void handleMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            int n = mouseEvent.getClickCount();
            switch (n) {
                case 2: {
                    ((RichTextArea)this.getControl()).selectWord();
                    break;
                }
                case 3: {
                    ((RichTextArea)this.getControl()).selectParagraph();
                }
            }
        }
    }

    protected void handleMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() != MouseButton.PRIMARY) {
            return;
        }
        TextPos textPos = this.getTextPosition(mouseEvent);
        if (textPos == null) {
            return;
        }
        this.vflow.setSuppressBlink(true);
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        if (mouseEvent.isShiftDown()) {
            richTextArea.extendSelection(textPos);
        } else {
            richTextArea.select(textPos, textPos);
        }
        if (this.contextMenu.isShowing()) {
            this.contextMenu.hide();
        }
        richTextArea.requestFocus();
    }

    protected void handleMouseReleased(MouseEvent mouseEvent) {
        this.stopAutoScroll();
        this.vflow.setSuppressBlink(false);
        this.clearPhantomX();
    }

    protected void handleMouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != MouseButton.PRIMARY) {
            return;
        }
        double d = mouseEvent.getY();
        if (d < 0.0) {
            this.autoScroll(d);
            return;
        }
        if (d > this.vflow.getViewPortHeight()) {
            this.autoScroll(d - this.vflow.getViewPortHeight());
            return;
        }
        this.stopAutoScroll();
        TextPos textPos = this.getTextPosition(mouseEvent);
        ((RichTextArea)this.getControl()).extendSelection(textPos);
    }

    private void handleScrollEventStarted(ScrollEvent scrollEvent) {
        this.scrollStarted = true;
    }

    private void handleScrollEventFinished(ScrollEvent scrollEvent) {
        this.scrollStarted = false;
    }

    private void handleScrollEvent(ScrollEvent scrollEvent) {
        double d;
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        double d2 = scrollEvent.getDeltaX();
        if (d2 != 0.0 && !richTextArea.isWrapText() && !richTextArea.isUseContentWidth()) {
            if (this.scrollStarted) {
                this.vflow.scrollHorizontalPixels(-scrollEvent.getDeltaX());
            } else {
                d = 0.1;
                if (d2 >= 0.0) {
                    d = -d;
                }
                this.vflow.scrollHorizontalFraction(d);
            }
            scrollEvent.consume();
        }
        if ((d = scrollEvent.getDeltaY()) != 0.0 && !richTextArea.isUseContentHeight()) {
            if (this.scrollStarted) {
                this.vflow.scrollVerticalPixels(-d);
            } else if (scrollEvent.isShortcutDown()) {
                if (d >= 0.0) {
                    this.vflow.pageUp();
                } else {
                    this.vflow.pageDown();
                }
            } else {
                double d3 = 0.1;
                if (d >= 0.0) {
                    d3 = -d3;
                }
                this.vflow.scrollVerticalFraction(d3);
            }
            scrollEvent.consume();
        }
    }

    protected TextPos getTextPosition(MouseEvent mouseEvent) {
        double d = mouseEvent.getScreenX();
        double d2 = mouseEvent.getScreenY();
        return ((RichTextArea)this.getControl()).getTextPosition(d, d2);
    }

    protected void stopAutoScroll() {
        this.autoScrollTimer.stop();
    }

    protected void autoScroll(double d) {
        this.autoScrollUp = d < 0.0;
        this.fastAutoScroll = Math.abs(d) > 100.0;
        this.autoScrollTimer.play();
    }

    protected void autoScroll() {
        double d;
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        if (richTextArea.isUseContentHeight()) {
            return;
        }
        double d2 = d = this.fastAutoScroll ? 200.0 : 20.0;
        if (this.autoScrollUp) {
            d = -d;
        }
        this.vflow.scrollVerticalPixels(d);
        this.vflow.layoutChildren();
        double d3 = Math.max(0.0, this.phantomX);
        double d4 = this.autoScrollUp ? 0.0 : this.vflow.getViewPortHeight();
        this.vflow.scrollToVisible(d3, d4);
        TextPos textPos = this.vflow.getTextPosLocal(d3, d4);
        richTextArea.extendSelection(textPos);
    }

    public void pageDown() {
        this.moveVertically(this.vflow.getViewPortHeight(), false);
    }

    public void pageUp() {
        this.moveVertically(-this.vflow.getViewPortHeight(), false);
    }

    public void moveRight() {
        this.moveCharacter(true, false);
    }

    public void moveLeft() {
        this.moveCharacter(false, false);
    }

    public void moveParagraphStart() {
        this.moveCaret(false, this::paragraphStart);
    }

    public void moveParagraphEnd() {
        this.moveCaret(false, this::paragraphEnd);
    }

    public void selectParagraphStart() {
        this.moveCaret(true, this::paragraphStart);
    }

    public void selectParagraphEnd() {
        this.moveCaret(true, this::paragraphEnd);
    }

    public void moveParagraphDown() {
        this.moveCaret(false, this::paragraphDown);
    }

    public void selectParagraphDown() {
        this.moveCaret(true, this::paragraphDown);
    }

    public void moveParagraphUp() {
        this.moveCaret(false, this::paragraphUp);
    }

    public void selectParagraphUp() {
        this.moveCaret(true, this::paragraphUp);
    }

    private TextPos paragraphDown(RichTextArea richTextArea, TextPos textPos) {
        int n = textPos.index();
        TextPos textPos2 = richTextArea.getParagraphEnd(n);
        if (textPos.isSameInsertionIndex(textPos2)) {
            if (++n >= richTextArea.getParagraphCount()) {
                return null;
            }
            return richTextArea.getParagraphEnd(n);
        }
        return textPos2;
    }

    public TextPos paragraphUp(RichTextArea richTextArea, TextPos textPos) {
        int n = textPos.index();
        TextPos textPos2 = TextPos.ofLeading(n, 0);
        if (textPos.isSameInsertionIndex(textPos2)) {
            if (--n < 0) {
                return null;
            }
            textPos2 = TextPos.ofLeading(n, 0);
        }
        return textPos2;
    }

    private TextPos paragraphEnd(RichTextArea richTextArea, TextPos textPos) {
        int n = textPos.index();
        return richTextArea.getParagraphEnd(n);
    }

    private void moveCaret(boolean bl, BiFunction<RichTextArea, TextPos, TextPos> biFunction) {
        TextPos textPos;
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        TextPos textPos2 = richTextArea.getCaretPosition();
        if (textPos2 != null && (textPos = biFunction.apply(richTextArea, textPos2)) != null) {
            this.clearPhantomX();
            this.moveCaret(textPos, bl);
        }
    }

    private TextPos paragraphStart(RichTextArea richTextArea, TextPos textPos) {
        return TextPos.ofLeading(textPos.index(), 0);
    }

    public void moveUp() {
        this.moveVertically(-1.0, false);
    }

    public void moveDown() {
        this.moveVertically(1.0, false);
    }

    public void moveDocumentStart() {
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        richTextArea.select(TextPos.ZERO);
    }

    public void moveDocumentEnd() {
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        TextPos textPos = richTextArea.getDocumentEnd();
        richTextArea.select(textPos);
    }

    protected void moveVertically(double d, boolean bl) {
        TextPos textPos = ((RichTextArea)this.getControl()).getCaretPosition();
        if (textPos == null) {
            return;
        }
        this.vflow.scrollCaretToVisible();
        CaretInfo caretInfo = this.vflow.getCaretInfo(textPos);
        if (caretInfo == null) {
            return;
        }
        double d2 = (caretInfo.getMinX() + caretInfo.getMaxX()) / 2.0;
        if (this.phantomX < 0.0) {
            this.phantomX = d2;
        } else {
            d2 = this.phantomX;
        }
        boolean bl2 = d > 0.0;
        double d3 = bl2 ? caretInfo.getMaxY() + d + 0.5 : caretInfo.getMinY() + d - 0.5;
        TextPos textPos2 = this.vflow.moveVertically(textPos.index(), d2, d3, bl2);
        if (textPos2 != null) {
            this.moveCaret(textPos2, bl);
        }
    }

    protected void moveHorizontally(boolean bl, boolean bl2) {
        TextPos textPos = ((RichTextArea)this.getControl()).getCaretPosition();
        if (textPos == null) {
            return;
        }
        this.vflow.scrollCaretToVisible();
        int n = textPos.index();
        int n2 = textPos.charIndex();
        TextPos textPos2 = this.vflow.moveHorizontally(bl, n, n2);
        if (textPos2 != null) {
            this.clearPhantomX();
            this.moveCaret(textPos2, bl2);
        }
    }

    protected void moveLineEnd() {
        this.moveHorizontally(false, false);
    }

    protected void moveLineStart() {
        this.moveHorizontally(true, false);
    }

    protected void moveCharacter(boolean bl, boolean bl2) {
        TextPos textPos;
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        TextPos textPos2 = richTextArea.getCaretPosition();
        if (textPos2 == null) {
            return;
        }
        this.clearPhantomX();
        if (!bl2) {
            TextPos textPos3;
            textPos = richTextArea.getCaretPosition();
            int n = textPos.compareTo(textPos3 = richTextArea.getAnchorPosition());
            if (n < 0) {
                this.moveCaret(bl ? textPos3 : textPos, bl2);
                return;
            }
            if (n > 0) {
                this.moveCaret(bl ? textPos : textPos3, bl2);
                return;
            }
        }
        if ((textPos = this.nextCharacterVisually(textPos2, bl)) != null) {
            this.moveCaret(textPos, bl2);
        }
    }

    protected TextPos nextCharacterVisually(TextPos textPos, boolean bl) {
        if (this.isRTL()) {
            bl = !bl;
        }
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        TextCell textCell = this.vflow.getCell(textPos.index());
        int n = textPos.offset();
        if (bl) {
            if (++n > textCell.getTextLength()) {
                int n2 = textCell.getIndex() + 1;
                TextPos textPos2 = n2 < richTextArea.getParagraphCount() ? TextPos.ofLeading(n2, 0) : TextPos.ofLeading(textCell.getIndex(), textCell.getTextLength());
                return textPos2;
            }
        } else if (textPos.offset() == 0) {
            int n3 = textCell.getIndex() - 1;
            if (n3 >= 0) {
                return richTextArea.getParagraphEnd(n3);
            }
            return null;
        }
        BreakIterator breakIterator = BreakIterator.getCharacterInstance();
        String string = this.getPlainText(textCell.getIndex());
        breakIterator.setText(string);
        int n4 = textPos.offset();
        try {
            int n5;
            int n6 = n5 = bl ? breakIterator.following(n4) : breakIterator.preceding(n4);
            if (n5 == -1) {
                System.err.println(" --- SHOULD NOT HAPPEN: BreakIterator.DONE off=" + n4);
                return null;
            }
            return TextPos.ofLeading(textPos.index(), n5);
        }
        catch (Exception exception) {
            System.err.println("offset=" + n4 + " text=[" + string + "]");
            exception.printStackTrace();
            return null;
        }
    }

    protected void moveCaret(TextPos textPos, boolean bl) {
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        if (bl) {
            richTextArea.extendSelection(textPos);
        } else {
            richTextArea.select(textPos, textPos);
        }
    }

    public void clearPhantomX() {
        this.phantomX = -1.0;
    }

    public void selectLeft() {
        this.moveCharacter(false, true);
    }

    public void selectRight() {
        this.moveCharacter(true, true);
    }

    public void selectUp() {
        this.moveVertically(-1.0, true);
    }

    public void selectDown() {
        this.moveVertically(1.0, true);
    }

    protected void selectLineEnd() {
        this.moveHorizontally(false, true);
    }

    protected void selectLineStart() {
        this.moveHorizontally(true, true);
    }

    public void selectPageDown() {
        this.moveVertically(this.vflow.getViewPortHeight(), true);
    }

    public void selectPageUp() {
        this.moveVertically(-this.vflow.getViewPortHeight(), true);
    }

    public void selectAll() {
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        TextPos textPos = richTextArea.getDocumentEnd();
        richTextArea.select(TextPos.ZERO, textPos);
        this.clearPhantomX();
    }

    public void selectDocumentStart() {
        ((RichTextArea)this.getControl()).extendSelection(TextPos.ZERO);
    }

    public void selectDocumentEnd() {
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        TextPos textPos = richTextArea.getDocumentEnd();
        richTextArea.extendSelection(textPos);
    }

    public void selectWord() {
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        TextPos textPos = richTextArea.getCaretPosition();
        if (textPos == null) {
            return;
        }
        int n = textPos.index();
        String string = this.getPlainText(n);
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n2 = textPos.offset();
        try {
            int n3 = breakIterator.preceding(n2);
            if (n3 == -1) {
                return;
            }
            int n4 = breakIterator.following(n2);
            if (n4 == -1) {
                return;
            }
            TextPos textPos2 = TextPos.ofLeading(n, n3);
            TextPos textPos3 = TextPos.ofLeading(n, n4);
            richTextArea.select(textPos2, textPos3);
        }
        catch (Exception exception) {
            System.err.println("offset=" + n2 + " text=[" + string + "]");
            exception.printStackTrace();
        }
    }

    public void selectParagraph() {
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        TextPos textPos = richTextArea.getCaretPosition();
        if (textPos != null) {
            int n = textPos.index();
            TextPos textPos2 = TextPos.ofLeading(n, 0);
            TextPos textPos3 = richTextArea.getParagraphEnd(n);
            richTextArea.select(textPos2, textPos3);
        }
    }

    public void backspace() {
        if (this.canEdit()) {
            RichTextArea richTextArea = (RichTextArea)this.getControl();
            if (richTextArea.hasNonEmptySelection()) {
                this.deleteSelection();
            } else {
                TextPos textPos;
                TextPos textPos2 = richTextArea.getCaretPosition();
                if (textPos2 == null) {
                    return;
                }
                int n = textPos2.index();
                if (textPos2.offset() == 0) {
                    if (n == 0) {
                        return;
                    }
                    int n2 = this.getPlainText(n - 1).length();
                    textPos = TextPos.ofLeading(n - 1, n2);
                } else {
                    String string = this.getPlainText(textPos2.index());
                    int n3 = Character.offsetByCodePoints(string, textPos2.offset(), -1);
                    textPos = TextPos.ofLeading(n, n3);
                }
                richTextArea.getModel().replace((StyleResolver)this.vflow, textPos, textPos2, StyledInput.EMPTY, true);
                this.moveCaret(textPos, false);
                this.clearPhantomX();
            }
        }
    }

    public void delete() {
        if (this.canEdit()) {
            RichTextArea richTextArea = (RichTextArea)this.getControl();
            if (richTextArea.hasNonEmptySelection()) {
                this.deleteSelection();
            } else {
                TextPos textPos = richTextArea.getCaretPosition();
                TextPos textPos2 = this.nextCharacterVisually(textPos, true);
                if (textPos2 != null) {
                    richTextArea.getModel().replace((StyleResolver)this.vflow, textPos, textPos2, StyledInput.EMPTY, true);
                    this.moveCaret(textPos, false);
                    this.clearPhantomX();
                }
            }
        }
    }

    private SelInfo sel() {
        return SelInfo.get((RichTextArea)this.getControl());
    }

    private TextPos clamp(TextPos textPos) {
        return ((RichTextArea)this.getControl()).getModel().clamp(textPos);
    }

    public void deleteParagraph() {
        SelInfo selInfo;
        if (this.canEdit() && (selInfo = this.sel()) != null) {
            int n = selInfo.getMin().index();
            int n2 = selInfo.getMax().index();
            TextPos textPos = TextPos.ofLeading(n, 0);
            TextPos textPos2 = this.clamp(TextPos.ofLeading(n2 + 1, 0));
            RichTextArea richTextArea = (RichTextArea)this.getControl();
            richTextArea.getModel().replace((StyleResolver)this.vflow, textPos, textPos2, StyledInput.EMPTY, true);
            this.clearPhantomX();
            this.moveCaret(textPos, false);
        }
    }

    public void deleteParagraphStart() {
        this.deleteIgnoreSelection(this::paragraphStart);
    }

    protected void deleteSelection() {
        SelInfo selInfo = this.sel();
        if (selInfo != null) {
            TextPos textPos = selInfo.getMin();
            TextPos textPos2 = selInfo.getMax();
            RichTextArea richTextArea = (RichTextArea)this.getControl();
            richTextArea.getModel().replace((StyleResolver)this.vflow, textPos, textPos2, StyledInput.EMPTY, true);
            this.clearPhantomX();
            this.moveCaret(textPos, false);
        }
    }

    protected void deselect() {
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        TextPos textPos = richTextArea.getCaretPosition();
        if (textPos != null) {
            this.clearPhantomX();
            this.moveCaret(textPos, false);
        }
    }

    public void contextMenuRequested(ContextMenuEvent contextMenuEvent) {
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        if (this.contextMenu.isShowing()) {
            this.contextMenu.hide();
        } else if (richTextArea.getContextMenu() == null && richTextArea.getOnContextMenuRequested() == null) {
            double d = contextMenuEvent.getScreenX();
            double d2 = contextMenuEvent.getScreenY();
            double d3 = contextMenuEvent.getSceneX();
            this.populateContextMenu();
            double d4 = this.contextMenu.prefWidth(-1.0);
            double d5 = d - (RichUtils.isTouchSupported() ? d4 / 2.0 : 0.0);
            Screen screen = Utils.getScreenForPoint((double)d, (double)0.0);
            Rectangle2D rectangle2D = screen.getBounds();
            if (d5 < rectangle2D.getMinX()) {
                richTextArea.getProperties().put((Object)"CONTEXT_MENU_SCREEN_X", (Object)d);
                richTextArea.getProperties().put((Object)"CONTEXT_MENU_SCENE_X", (Object)d3);
                this.contextMenu.show((Node)richTextArea, rectangle2D.getMinX(), d2);
            } else if (d + d4 > rectangle2D.getMaxX()) {
                double d6 = d4 - (rectangle2D.getMaxX() - d);
                richTextArea.getProperties().put((Object)"CONTEXT_MENU_SCREEN_X", (Object)d);
                richTextArea.getProperties().put((Object)"CONTEXT_MENU_SCENE_X", (Object)d3);
                this.contextMenu.show((Node)richTextArea, d - d6, d2);
            } else {
                richTextArea.getProperties().put((Object)"CONTEXT_MENU_SCREEN_X", (Object)0);
                richTextArea.getProperties().put((Object)"CONTEXT_MENU_SCENE_X", (Object)0);
                this.contextMenu.show((Node)richTextArea, d5, d2);
            }
        }
        contextMenuEvent.consume();
    }

    protected void populateContextMenu() {
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        boolean bl = richTextArea.hasNonEmptySelection();
        boolean bl2 = this.findFormatForPaste() != null;
        boolean bl3 = this.canEdit();
        ObservableList observableList = this.contextMenu.getItems();
        observableList.clear();
        MenuItem menuItem = new MenuItem("Undo");
        observableList.add((Object)menuItem);
        menuItem.setOnAction(actionEvent -> richTextArea.undo());
        menuItem.setDisable(!richTextArea.isUndoable());
        menuItem = new MenuItem("Redo");
        observableList.add((Object)menuItem);
        menuItem.setOnAction(actionEvent -> richTextArea.redo());
        menuItem.setDisable(!richTextArea.isRedoable());
        observableList.add((Object)new SeparatorMenuItem());
        menuItem = new MenuItem("Cut");
        observableList.add((Object)menuItem);
        menuItem.setOnAction(actionEvent -> richTextArea.cut());
        menuItem.setDisable(!bl || !bl3);
        menuItem = new MenuItem("Copy");
        observableList.add((Object)menuItem);
        menuItem.setOnAction(actionEvent -> richTextArea.copy());
        menuItem.setDisable(!bl);
        menuItem = new MenuItem("Paste");
        observableList.add((Object)menuItem);
        menuItem.setOnAction(actionEvent -> richTextArea.paste());
        menuItem.setDisable(!bl2 || !bl3);
        observableList.add((Object)new SeparatorMenuItem());
        menuItem = new MenuItem("Select All");
        observableList.add((Object)menuItem);
        menuItem.setOnAction(actionEvent -> richTextArea.selectAll());
    }

    public void copy() {
        this.copyWithCut(false);
    }

    public void cut() {
        if (this.canEdit()) {
            this.copyWithCut(true);
        }
    }

    public void paste() {
        DataFormat dataFormat;
        if (this.canEdit() && (dataFormat = this.findFormatForPaste()) != null) {
            this.pasteLocal(dataFormat);
        }
    }

    public void pasteWithFormat(DataFormat dataFormat) {
        Clipboard clipboard;
        if (this.canEdit() && (clipboard = Clipboard.getSystemClipboard()).hasContent(dataFormat)) {
            this.pasteLocal(dataFormat);
        }
    }

    public void pastePlainText() {
        this.pasteWithFormat(DataFormat.PLAIN_TEXT);
    }

    protected DataFormat findFormatForPaste() {
        StyledTextModel styledTextModel;
        List<DataFormat> list;
        if (this.canEdit() && (list = (styledTextModel = ((RichTextArea)this.getControl()).getModel()).getSupportedDataFormats(false)).size() > 0) {
            for (DataFormat dataFormat : list) {
                if (!Clipboard.getSystemClipboard().hasContent(dataFormat)) continue;
                return dataFormat;
            }
        }
        return null;
    }

    private void pasteLocal(DataFormat dataFormat) {
        SelInfo selInfo = this.sel();
        if (selInfo != null) {
            String string;
            RichTextArea richTextArea = (RichTextArea)this.getControl();
            TextPos textPos = selInfo.getMin();
            TextPos textPos2 = selInfo.getMax();
            StyledTextModel styledTextModel = richTextArea.getModel();
            DataFormatHandler dataFormatHandler = styledTextModel.getDataFormatHandler(dataFormat, false);
            Object object = Clipboard.getSystemClipboard().getContent(dataFormat);
            if (!(object instanceof String)) {
                return;
            }
            String string2 = string = (String)object;
            StyleAttributeMap styleAttributeMap = richTextArea.getActiveStyleAttributeMap();
            try (StyledInput styledInput = dataFormatHandler.createStyledInput(string2, styleAttributeMap);){
                TextPos textPos3 = styledTextModel.replace((StyleResolver)this.vflow, textPos, textPos2, styledInput, true);
                this.moveCaret(textPos3, false);
            }
            catch (IOException iOException) {
                richTextArea.errorFeedback();
            }
        }
    }

    protected void copyWithCut(boolean bl) {
        block6: {
            StyledTextModel styledTextModel;
            List<DataFormat> list;
            RichTextArea richTextArea = (RichTextArea)this.getControl();
            if (richTextArea.hasNonEmptySelection() && (list = (styledTextModel = richTextArea.getModel()).getSupportedDataFormats(true)).size() > 0) {
                SelInfo selInfo = this.sel();
                if (selInfo == null) {
                    return;
                }
                TextPos textPos = selInfo.getMin();
                TextPos textPos2 = selInfo.getMax();
                try {
                    ClipboardContent clipboardContent = new ClipboardContent();
                    for (DataFormat dataFormat : list) {
                        DataFormatHandler dataFormatHandler = styledTextModel.getDataFormatHandler(dataFormat, true);
                        Object object = dataFormatHandler.copy(styledTextModel, this.vflow, textPos, textPos2);
                        if (object == null) continue;
                        clipboardContent.put((Object)dataFormat, object);
                    }
                    Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
                    if (!bl) break block6;
                    if (richTextArea.isEditable()) {
                        this.deleteSelection();
                        break block6;
                    }
                    throw new UnsupportedOperationException("control is not editable");
                }
                catch (Exception | OutOfMemoryError throwable) {
                    throwable.printStackTrace();
                    richTextArea.errorFeedback();
                }
            }
        }
    }

    public void copyWithFormat(DataFormat dataFormat) {
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        try {
            StyledTextModel styledTextModel;
            DataFormatHandler dataFormatHandler;
            if (richTextArea.hasNonEmptySelection() && (dataFormatHandler = (styledTextModel = richTextArea.getModel()).getDataFormatHandler(dataFormat, true)) != null) {
                SelInfo selInfo = this.sel();
                if (selInfo == null) {
                    return;
                }
                TextPos textPos = selInfo.getMin();
                TextPos textPos2 = selInfo.getMax();
                Object object = dataFormatHandler.copy(styledTextModel, this.vflow, textPos, textPos2);
                ClipboardContent clipboardContent = new ClipboardContent();
                clipboardContent.put((Object)dataFormat, object);
                Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
            }
        }
        catch (Exception | OutOfMemoryError throwable) {
            richTextArea.errorFeedback();
        }
    }

    public void previousWord() {
        this.moveCaret(false, this::toPreviousWord);
    }

    public void leftWord() {
        this.toLeftWord(false);
    }

    public void rightWord() {
        this.toRightWord(false);
    }

    public void nextWord() {
        this.moveCaret(false, this::nextWordBeg);
    }

    public void nextWordEnd() {
        this.moveCaret(false, this::toWordEnd);
    }

    public void selectWordPrevious() {
        this.moveCaret(true, this::toPreviousWord);
    }

    public void selectWordNext() {
        this.moveCaret(true, this::nextWordBeg);
    }

    public void selectNextWordEnd() {
        this.moveCaret(true, this::toWordEnd);
    }

    public void selectWordLeft() {
        this.toLeftWord(true);
    }

    public void selectWordRight() {
        this.toRightWord(true);
    }

    protected void toLeftWord(boolean bl) {
        if (this.isRTLText()) {
            if (this.isWindows()) {
                this.moveCaret(bl, this::nextWordBeg);
            } else {
                this.moveCaret(bl, this::toWordEnd);
            }
        } else {
            this.moveCaret(bl, this::toPreviousWord);
        }
    }

    protected void toRightWord(boolean bl) {
        if (this.isRTLText()) {
            this.moveCaret(bl, this::toPreviousWord);
        } else if (this.isWindows()) {
            this.moveCaret(bl, this::nextWordBeg);
        } else {
            this.moveCaret(bl, this::toWordEnd);
        }
    }

    protected TextPos toPreviousWord(RichTextArea richTextArea, TextPos textPos) {
        int n;
        int n2 = textPos.index();
        int n3 = textPos.offset();
        BreakIterator breakIterator = null;
        while (true) {
            if (n2 == 0 && n3 <= 0) {
                return TextPos.ZERO;
            }
            String string = this.getPlainText(n2);
            if (string.length() == 0) {
                --n2;
                n3 = Integer.MAX_VALUE;
                continue;
            }
            if (breakIterator == null) {
                breakIterator = BreakIterator.getWordInstance();
            }
            breakIterator.setText(string);
            int n4 = string.length();
            n = breakIterator.preceding(Utils.clamp((int)0, (int)n3, (int)n4));
            while (n != -1 && !RichUtils.isLetterOrDigit(string, n)) {
                n = breakIterator.preceding(Utils.clamp((int)0, (int)n, (int)n4));
            }
            if (n >= 0) break;
            --n2;
            n3 = Integer.MAX_VALUE;
        }
        return TextPos.ofLeading(n2, n);
    }

    protected TextPos nextWordBeg(RichTextArea richTextArea, TextPos textPos) {
        int n = textPos.index();
        int n2 = textPos.offset();
        boolean bl = true;
        BreakIterator breakIterator = null;
        TextPos textPos2;
        while (n != (textPos2 = richTextArea.getDocumentEnd()).index() || n2 < textPos2.offset()) {
            if (n > textPos2.index()) {
                return textPos2;
            }
            String string = this.getPlainText(n);
            if (string.length() == 0) {
                if (bl) {
                    ++n;
                }
                return TextPos.ofLeading(n, 0);
            }
            if (breakIterator == null) {
                breakIterator = BreakIterator.getWordInstance();
            }
            breakIterator.setText(string);
            int n3 = string.length();
            if (n2 == n3) {
                return TextPos.ofLeading(++n, 0);
            }
            int n4 = breakIterator.following(Utils.clamp((int)0, (int)n2, (int)n3));
            if (n4 == -1 || n4 == n3) {
                return TextPos.ofLeading(n, n3);
            }
            while (n4 != -1) {
                boolean bl2 = RichUtils.isLetterOrDigit(string, n4);
                if (bl2) {
                    return TextPos.ofLeading(n, n4);
                }
                n4 = breakIterator.next();
            }
            ++n;
            n2 = 0;
            bl = false;
        }
        return textPos2;
    }

    protected TextPos toWordEnd(RichTextArea richTextArea, TextPos textPos) {
        int n = textPos.index();
        int n2 = textPos.offset();
        boolean bl = true;
        BreakIterator breakIterator = null;
        TextPos textPos2;
        while (n != (textPos2 = richTextArea.getDocumentEnd()).index() || n2 < textPos2.offset()) {
            if (n > textPos2.index()) {
                return textPos2;
            }
            String string = this.getPlainText(n);
            if (string.length() == 0) {
                if (bl) {
                    ++n;
                }
                return TextPos.ofLeading(n, 0);
            }
            if (breakIterator == null) {
                breakIterator = BreakIterator.getWordInstance();
            }
            breakIterator.setText(string);
            boolean bl2 = RichUtils.isLetterOrDigit(string, n2);
            int n3 = string.length();
            int n4 = breakIterator.following(Utils.clamp((int)0, (int)n2, (int)n3));
            if (n4 == -1) {
                if (bl2) {
                    return TextPos.ofLeading(n, n3);
                }
            } else {
                if (bl2) {
                    return TextPos.ofLeading(n, n4);
                }
                while (n4 != -1) {
                    n2 = n4;
                    n4 = breakIterator.next();
                    bl2 = RichUtils.isLetterOrDigit(string, n2);
                    if (!bl2) continue;
                    return TextPos.ofLeading(n, n4);
                }
            }
            ++n;
            n2 = 0;
            bl = false;
        }
        return textPos2;
    }

    public void redo() {
        TextPos[] textPosArray;
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        StyledTextModel styledTextModel = richTextArea.getModel();
        if (styledTextModel != null && (textPosArray = styledTextModel.redo(this.vflow)) != null) {
            richTextArea.select(textPosArray[0], textPosArray[1]);
        }
    }

    public void undo() {
        TextPos[] textPosArray;
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        StyledTextModel styledTextModel = richTextArea.getModel();
        if (styledTextModel != null && (textPosArray = styledTextModel.undo(this.vflow)) != null) {
            richTextArea.select(textPosArray[0], textPosArray[1]);
        }
    }

    private Bidi getBidi() {
        String string = this.getTextAtCaret();
        int n = ((RichTextArea)this.getControl()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT ? 1 : 0;
        return new Bidi(string, n);
    }

    private String getTextAtCaret() {
        String string;
        RichTextArea richTextArea = (RichTextArea)this.getControl();
        TextPos textPos = richTextArea.getCaretPosition();
        if (textPos != null && (string = richTextArea.getPlainText(textPos.index())) != null) {
            return string;
        }
        return "";
    }

    private boolean isMixed() {
        return this.getBidi().isMixed();
    }

    private boolean isRTLText() {
        Bidi bidi = this.getBidi();
        return bidi.isRightToLeft() || this.isMixed() && ((RichTextArea)this.getControl()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
    }

    public void deleteWordNextBeg() {
        this.deleteIgnoreSelection(this::nextWordBeg);
    }

    public void deleteWordNextEnd() {
        this.deleteIgnoreSelection(this::toWordEnd);
    }

    public void deleteWordPrevious() {
        this.deleteIgnoreSelection(this::toPreviousWord);
    }

    private void deleteIgnoreSelection(BiFunction<RichTextArea, TextPos, TextPos> biFunction) {
        TextPos textPos;
        RichTextArea richTextArea;
        TextPos textPos2;
        if (this.canEdit() && (textPos2 = (richTextArea = (RichTextArea)this.getControl()).getCaretPosition()) != null && (textPos = biFunction.apply(richTextArea, textPos2)) != null) {
            richTextArea.clearSelection();
            this.clearPhantomX();
            textPos = richTextArea.replaceText(textPos2, textPos, "", true);
            richTextArea.select(textPos);
        }
    }
}

