/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.text;

import com.sun.javafx.font.CharToGlyphMapper;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.Translate2D;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextLine;
import com.sun.javafx.scene.text.TextSpan;
import com.sun.javafx.text.CharArrayIterator;
import com.sun.javafx.text.GlyphLayout;
import com.sun.javafx.text.GlyphLayoutManager;
import com.sun.javafx.text.LayoutCache;
import com.sun.javafx.text.PrismTextLine;
import com.sun.javafx.text.TextRun;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicBoolean;

public class PrismTextLayout
implements TextLayout {
    private static final BaseTransform IDENTITY = BaseTransform.IDENTITY_TRANSFORM;
    private static final int X_MIN_INDEX = 0;
    private static final int Y_MIN_INDEX = 1;
    private static final int X_MAX_INDEX = 2;
    private static final int Y_MAX_INDEX = 3;
    private static final Hashtable<Integer, LayoutCache> stringCache = new Hashtable();
    private static final Object CACHE_SIZE_LOCK = new Object();
    private static int cacheSize = 0;
    private static final int MAX_STRING_SIZE = 256;
    private final int maxCacheSize;
    private char[] text;
    private TextSpan[] spans;
    private PGFont font;
    private FontStrike strike;
    private Integer cacheKey;
    private PrismTextLine[] lines;
    private TextRun[] runs;
    private int runCount;
    private BaseBounds logicalBounds;
    private RectBounds visualBounds;
    private float layoutWidth;
    private float layoutHeight;
    private float wrapWidth;
    private float spacing;
    private LayoutCache layoutCache;
    private Shape shape;
    private int flags;
    private int tabSize = 8;

    public PrismTextLayout(int n) {
        this.maxCacheSize = n;
        this.logicalBounds = new RectBounds();
        this.flags = 262144;
    }

    private void reset() {
        this.layoutCache = null;
        this.runs = null;
        this.flags &= 0xFFFFF800;
        this.relayout();
    }

    private void relayout() {
        this.logicalBounds.makeEmpty();
        this.visualBounds = null;
        this.layoutHeight = 0.0f;
        this.layoutWidth = 0.0f;
        this.flags &= 0xFFFFF97F;
        this.lines = null;
        this.shape = null;
    }

    @Override
    public boolean setContent(TextSpan[] textSpanArray) {
        if (textSpanArray == null && this.spans == null) {
            return false;
        }
        if (textSpanArray != null && this.spans != null && textSpanArray.length == this.spans.length) {
            int n;
            for (n = 0; n < textSpanArray.length && textSpanArray[n] == this.spans[n]; ++n) {
            }
            if (n == textSpanArray.length) {
                return false;
            }
        }
        this.reset();
        this.spans = textSpanArray;
        this.font = null;
        this.strike = null;
        this.text = null;
        this.cacheKey = null;
        return true;
    }

    @Override
    public boolean setContent(String string, Object object) {
        int n;
        this.reset();
        this.spans = null;
        this.font = (PGFont)object;
        this.strike = ((PGFont)object).getStrike(IDENTITY);
        this.text = string.toCharArray();
        if (this.maxCacheSize > 0 && 0 < (n = string.length()) && n <= 256) {
            this.cacheKey = string.hashCode() * this.strike.hashCode();
        }
        return true;
    }

    @Override
    public boolean setDirection(int n) {
        if ((this.flags & 0x3C00) == n) {
            return false;
        }
        this.flags &= 0xFFFFC3FF;
        this.flags |= n & 0x3C00;
        this.reset();
        return true;
    }

    @Override
    public boolean setBoundsType(int n) {
        if ((this.flags & 0x4000) == n) {
            return false;
        }
        this.flags &= 0xFFFFBFFF;
        this.flags |= n & 0x4000;
        this.reset();
        return true;
    }

    @Override
    public boolean setAlignment(int n) {
        int n2 = 262144;
        switch (n) {
            case 0: {
                n2 = 262144;
                break;
            }
            case 1: {
                n2 = 524288;
                break;
            }
            case 2: {
                n2 = 0x100000;
                break;
            }
            case 3: {
                n2 = 0x200000;
            }
        }
        if ((this.flags & 0x3C0000) == n2) {
            return false;
        }
        if (n2 == 0x200000 || (this.flags & 0x200000) != 0) {
            this.reset();
        }
        this.flags &= 0xFFC3FFFF;
        this.flags |= n2;
        this.relayout();
        return true;
    }

    @Override
    public boolean setWrapWidth(float f) {
        if (Float.isInfinite(f)) {
            f = 0.0f;
        }
        if (Float.isNaN(f)) {
            f = 0.0f;
        }
        float f2 = this.wrapWidth;
        this.wrapWidth = Math.max(0.0f, f);
        boolean bl = true;
        if (this.lines != null && f2 != 0.0f && f != 0.0f && (this.flags & 0x40000) != 0) {
            if (f > f2) {
                if ((this.flags & 0x80) == 0) {
                    bl = false;
                }
            } else if (f >= this.layoutWidth) {
                bl = false;
            }
        }
        if (bl) {
            this.relayout();
        }
        return bl;
    }

    @Override
    public boolean setLineSpacing(float f) {
        if (this.spacing == f) {
            return false;
        }
        this.spacing = f;
        this.relayout();
        return true;
    }

    private void ensureLayout() {
        if (this.lines == null) {
            this.layout();
        }
    }

    @Override
    public TextLine[] getLines() {
        this.ensureLayout();
        return this.lines;
    }

    @Override
    public GlyphList[] getRuns() {
        this.ensureLayout();
        GlyphList[] glyphListArray = new GlyphList[this.runCount];
        int n = 0;
        for (int i = 0; i < this.lines.length; ++i) {
            TextRun[] textRunArray = this.lines[i].getRuns();
            int n2 = textRunArray.length;
            System.arraycopy(textRunArray, 0, glyphListArray, n, n2);
            n += n2;
        }
        return glyphListArray;
    }

    @Override
    public BaseBounds getBounds() {
        this.ensureLayout();
        return this.logicalBounds;
    }

    @Override
    public BaseBounds getBounds(TextSpan textSpan, BaseBounds baseBounds) {
        this.ensureLayout();
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.NEGATIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        if (textSpan != null) {
            for (int i = 0; i < this.lines.length; ++i) {
                PrismTextLine prismTextLine = this.lines[i];
                TextRun[] textRunArray = prismTextLine.getRuns();
                for (int j = 0; j < textRunArray.length; ++j) {
                    TextRun textRun = textRunArray[j];
                    TextSpan textSpan2 = textRun.getTextSpan();
                    if (textSpan2 != textSpan) continue;
                    Point2D point2D = textRun.getLocation();
                    float f5 = point2D.x;
                    if (textRun.isLeftBearing()) {
                        f5 += prismTextLine.getLeftSideBearing();
                    }
                    float f6 = point2D.x + textRun.getWidth();
                    if (textRun.isRightBearing()) {
                        f6 += prismTextLine.getRightSideBearing();
                    }
                    float f7 = point2D.y;
                    float f8 = point2D.y + prismTextLine.getBounds().getHeight() + this.spacing;
                    if (f5 < f) {
                        f = f5;
                    }
                    if (f7 < f2) {
                        f2 = f7;
                    }
                    if (f6 > f3) {
                        f3 = f6;
                    }
                    if (!(f8 > f4)) continue;
                    f4 = f8;
                }
            }
        } else {
            f4 = 0.0f;
            f2 = 0.0f;
            for (int i = 0; i < this.lines.length; ++i) {
                float f9;
                PrismTextLine prismTextLine = this.lines[i];
                RectBounds rectBounds = prismTextLine.getBounds();
                float f10 = rectBounds.getMinX() + prismTextLine.getLeftSideBearing();
                if (f10 < f) {
                    f = f10;
                }
                if ((f9 = rectBounds.getMaxX() + prismTextLine.getRightSideBearing()) > f3) {
                    f3 = f9;
                }
                f4 += rectBounds.getHeight();
            }
            if (this.isMirrored()) {
                float f11 = this.getMirroringWidth();
                float f12 = f;
                f = f11 - f3;
                f3 = f11 - f12;
            }
        }
        return baseBounds.deriveWithNewBounds(f, f2, 0.0f, f3, f4, 0.0f);
    }

    @Override
    public TextLayout.CaretGeometry getCaretGeometry(int n, boolean bl) {
        int n2;
        int n3;
        PrismTextLine prismTextLine;
        int n4;
        int n5;
        this.ensureLayout();
        int n6 = this.getLineCount();
        for (n5 = 0; n5 < n6 - 1 && (n4 = (prismTextLine = this.lines[n5]).getStart() + prismTextLine.getLength()) <= n; ++n5) {
        }
        int n7 = -1;
        n4 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        PrismTextLine prismTextLine2 = this.lines[n5];
        TextRun[] textRunArray = prismTextLine2.getRuns();
        int n8 = textRunArray.length;
        int n9 = -1;
        for (n3 = 0; n3 < n8; ++n3) {
            TextRun textRun = textRunArray[n3];
            int n10 = textRun.getStart();
            n2 = textRun.getEnd();
            if (n10 > n || n >= n2) continue;
            if (textRun.isLinebreak()) break;
            n9 = n3;
            break;
        }
        if (n9 != -1) {
            TextRun textRun = textRunArray[n9];
            int n11 = textRun.getStart();
            var16_24 = textRun.getLocation();
            f = var16_24.x + textRun.getXAtOffset(n - n11, bl);
            f2 = var16_24.y;
            f3 = prismTextLine2.getBounds().getHeight();
            if (bl) {
                if (n9 > 0 && n == n11) {
                    n4 = textRun.getLevel();
                    n7 = n - 1;
                }
            } else {
                n2 = textRun.getEnd();
                if (n9 + 1 < textRunArray.length && n + 1 == n2) {
                    n4 = textRun.getLevel();
                    n7 = n + 1;
                }
            }
        } else {
            n3 = 0;
            n9 = 0;
            for (int i = 0; i < n8; ++i) {
                TextRun textRun = textRunArray[i];
                if (textRun.getStart() < n3 || textRun.isLinebreak()) continue;
                n3 = textRun.getStart();
                n9 = i;
            }
            TextRun textRun = textRunArray[n9];
            var16_24 = textRun.getLocation();
            f = var16_24.x + (textRun.isLeftToRight() ? textRun.getWidth() : 0.0f);
            f2 = var16_24.y;
            f3 = prismTextLine2.getBounds().getHeight();
        }
        if (this.isMirrored()) {
            f = this.getMirroringWidth() - f;
        }
        if (n7 != -1) {
            for (int i = 0; i < textRunArray.length; ++i) {
                TextRun textRun = textRunArray[i];
                int n12 = textRun.getStart();
                n2 = textRun.getEnd();
                if (n12 > n7 || n7 >= n2 || (textRun.getLevel() & 1) == (n4 & 1)) continue;
                Point2D point2D = textRun.getLocation();
                float f4 = point2D.x;
                if (bl) {
                    if ((n4 & 1) != 0) {
                        f4 += textRun.getWidth();
                    }
                } else if ((n4 & 1) == 0) {
                    f4 += textRun.getWidth();
                }
                if (this.isMirrored()) {
                    f4 = this.getMirroringWidth() - f4;
                }
                return new TextLayout.CaretGeometry.Split(f, f2, f4, f3);
            }
        }
        return new TextLayout.CaretGeometry.Single(f, f2, f3);
    }

    @Override
    public TextLayout.Hit getHitInfo(float f, float f2) {
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        this.ensureLayout();
        int n3 = this.getLineIndex(f2);
        if (n3 >= this.getLineCount()) {
            n = this.getCharCount();
            n2 = n + 1;
        } else {
            PrismTextLine prismTextLine = this.lines[n3];
            TextRun[] textRunArray = prismTextLine.getRuns();
            RectBounds rectBounds = prismTextLine.getBounds();
            TextRun textRun = null;
            f -= rectBounds.getMinX();
            for (int i = 0; i < textRunArray.length && !(f < (textRun = textRunArray[i]).getWidth()); ++i) {
                if (i + 1 >= textRunArray.length) continue;
                if (textRunArray[i + 1].isLinebreak()) break;
                f -= textRun.getWidth();
            }
            if (textRun != null) {
                AtomicBoolean atomicBoolean = new AtomicBoolean();
                n = textRun.getStart() + textRun.getOffsetAtX(f, atomicBoolean);
                bl = !atomicBoolean.get();
                n2 = n;
                if (this.getText() != null && n2 < this.getText().length) {
                    if (!bl) {
                        BreakIterator breakIterator = BreakIterator.getCharacterInstance();
                        breakIterator.setText(new String(this.getText()));
                        int n4 = breakIterator.following(n2);
                        n2 = n4 == -1 ? ++n2 : n4;
                    }
                } else if (!bl) {
                    ++n2;
                }
            } else {
                n = prismTextLine.getStart();
                bl = true;
                n2 = n;
            }
        }
        return new TextLayout.Hit(n, n2, bl);
    }

    @Override
    public void getRange(int n, int n2, int n3, TextLayout.GeometryCallback geometryCallback) {
        this.ensureLayout();
        int n4 = this.getLineCount();
        ArrayList arrayList = new ArrayList();
        float f = 0.0f;
        for (int i = 0; i < n4; ++i) {
            PrismTextLine prismTextLine = this.lines[i];
            RectBounds rectBounds = prismTextLine.getBounds();
            int n5 = prismTextLine.getStart();
            if (n5 >= n2) break;
            int n6 = n5 + prismTextLine.getLength();
            if (n > n6) {
                f += rectBounds.getHeight() + this.spacing;
                continue;
            }
            TextRun[] textRunArray = prismTextLine.getRuns();
            int n7 = Math.min(n6, n2) - Math.max(n5, n);
            float f2 = -1.0f;
            float f3 = -1.0f;
            float f4 = rectBounds.getMinX();
            for (int j = 0; n7 > 0 && j < textRunArray.length; ++j) {
                TextRun textRun = textRunArray[j];
                int n8 = textRun.getStart();
                int n9 = textRun.getEnd();
                float f5 = textRun.getWidth();
                int n10 = Math.max(n8, Math.min(n, n9));
                int n11 = Math.max(n8, Math.min(n2, n9));
                int n12 = n11 - n10;
                if (n12 != 0) {
                    float f6;
                    float f7;
                    boolean bl = textRun.isLeftToRight();
                    float f8 = n8 > n ? (bl ? f4 : f4 + f5) : f4 + textRun.getXAtOffset(n - n8, true);
                    if (f8 > (f7 = n9 < n2 ? (bl ? f4 + f5 : f4) : f4 + textRun.getXAtOffset(n2 - n8, true))) {
                        f6 = f8;
                        f8 = f7;
                        f7 = f6;
                    }
                    n7 -= n12;
                    f6 = 0.0f;
                    float f9 = 0.0f;
                    switch (n3) {
                        case 1: {
                            f6 = f;
                            f9 = f + rectBounds.getHeight();
                            break;
                        }
                        case 2: 
                        case 4: {
                            Object object;
                            FontStrike fontStrike = null;
                            if (this.spans != null) {
                                object = textRun.getTextSpan();
                                PGFont pGFont = (PGFont)object.getFont();
                                if (pGFont == null) break;
                                fontStrike = pGFont.getStrike(IDENTITY);
                            } else {
                                fontStrike = this.strike;
                            }
                            f6 = f - textRun.getAscent();
                            object = fontStrike.getMetrics();
                            f9 = n3 == 2 ? (f6 += object.getUnderLineOffset()) + object.getUnderLineThickness() : (f6 += object.getStrikethroughOffset()) + object.getStrikethroughThickness();
                        }
                    }
                    if (f8 != f3) {
                        if (f2 != -1.0f && f3 != -1.0f) {
                            float f10 = f2;
                            float f11 = f3;
                            if (this.isMirrored()) {
                                float f12 = this.getMirroringWidth();
                                f10 = f12 - f10;
                                f11 = f12 - f11;
                            }
                            geometryCallback.addRectangle(f10, f6, f11, f9);
                        }
                        f2 = f8;
                        f3 = f7;
                    }
                    f3 = f7;
                    if (n7 == 0) {
                        float f13 = f2;
                        float f14 = f3;
                        if (this.isMirrored()) {
                            float f15 = this.getMirroringWidth();
                            f13 = f15 - f13;
                            f14 = f15 - f14;
                        }
                        geometryCallback.addRectangle(f13, f6, f14, f9);
                    }
                }
                f4 += f5;
            }
            f += rectBounds.getHeight() + this.spacing;
        }
    }

    @Override
    public Shape getShape(int n, TextSpan textSpan) {
        boolean bl;
        this.ensureLayout();
        boolean bl2 = (n & 1) != 0;
        boolean bl3 = (n & 2) != 0;
        boolean bl4 = (n & 4) != 0;
        boolean bl5 = bl = (n & 8) != 0;
        if (this.shape != null && bl2 && !bl3 && !bl4 && bl) {
            return this.shape;
        }
        Path2D path2D = new Path2D();
        Translate2D translate2D = new Translate2D(0.0, 0.0);
        float f = 0.0f;
        if (bl) {
            f = -this.lines[0].getBounds().getMinY();
        }
        for (int i = 0; i < this.lines.length; ++i) {
            PrismTextLine prismTextLine = this.lines[i];
            TextRun[] textRunArray = prismTextLine.getRuns();
            RectBounds rectBounds = prismTextLine.getBounds();
            float f2 = -rectBounds.getMinY();
            for (int j = 0; j < textRunArray.length; ++j) {
                Shape shape;
                Object object;
                TextRun textRun = textRunArray[j];
                FontStrike fontStrike = null;
                if (this.spans != null) {
                    PGFont pGFont;
                    object = textRun.getTextSpan();
                    if (textSpan != null && object != textSpan || (pGFont = (PGFont)object.getFont()) == null) continue;
                    fontStrike = pGFont.getStrike(IDENTITY);
                } else {
                    fontStrike = this.strike;
                }
                object = textRun.getLocation();
                float f3 = ((Point2D)object).x;
                float f4 = ((Point2D)object).y + f2 - f;
                Metrics metrics = null;
                if (bl3 || bl4) {
                    metrics = fontStrike.getMetrics();
                }
                if (bl3) {
                    shape = new RoundRectangle2D();
                    shape.x = f3;
                    shape.y = f4 + metrics.getUnderLineOffset();
                    shape.width = textRun.getWidth();
                    shape.height = metrics.getUnderLineThickness();
                    path2D.append(shape, false);
                }
                if (bl4) {
                    shape = new RoundRectangle2D();
                    shape.x = f3;
                    shape.y = f4 + metrics.getStrikethroughOffset();
                    shape.width = textRun.getWidth();
                    shape.height = metrics.getStrikethroughThickness();
                    path2D.append(shape, false);
                }
                if (!bl2 || textRun.getGlyphCount() <= 0) continue;
                ((BaseTransform)translate2D).restoreTransform(1.0, 0.0, 0.0, 1.0, f3, f4);
                shape = (Path2D)fontStrike.getOutline(textRun, translate2D);
                path2D.append(shape, false);
            }
        }
        if (bl2 && !bl3 && !bl4) {
            this.shape = path2D;
        }
        return path2D;
    }

    @Override
    public boolean setTabSize(int n) {
        if (n < 1) {
            n = 1;
        }
        if (this.tabSize != n) {
            this.tabSize = n;
            this.relayout();
            return true;
        }
        return false;
    }

    private int getLineIndex(float f) {
        int n;
        float f2 = 0.0f;
        int n2 = this.getLineCount();
        for (n = 0; n < n2; ++n) {
            f2 += this.lines[n].getBounds().getHeight() + this.spacing;
            if (n + 1 == n2) {
                f2 -= this.lines[n].getLeading();
            }
            if (f2 > f) break;
        }
        return n;
    }

    private boolean copyCache() {
        int n = this.flags & 0x3C0000;
        int n2 = this.flags & 0x4000;
        return this.wrapWidth != 0.0f || n != 262144 || n2 == 0 || this.isMirrored();
    }

    private void initCache() {
        if (this.cacheKey != null) {
            LayoutCache layoutCache;
            if (this.layoutCache == null && (layoutCache = stringCache.get(this.cacheKey)) != null && layoutCache.font.equals(this.font) && Arrays.equals(layoutCache.text, this.text)) {
                this.layoutCache = layoutCache;
                this.runs = layoutCache.runs;
                this.runCount = layoutCache.runCount;
                this.flags |= layoutCache.analysis;
            }
            if (this.layoutCache != null) {
                if (this.copyCache()) {
                    if (this.layoutCache.runs == this.runs) {
                        this.runs = new TextRun[this.runCount];
                        System.arraycopy(this.layoutCache.runs, 0, this.runs, 0, this.runCount);
                    }
                } else if (this.layoutCache.lines != null) {
                    this.runs = this.layoutCache.runs;
                    this.runCount = this.layoutCache.runCount;
                    this.flags |= this.layoutCache.analysis;
                    this.lines = this.layoutCache.lines;
                    this.layoutWidth = this.layoutCache.layoutWidth;
                    this.layoutHeight = this.layoutCache.layoutHeight;
                    float f = this.lines[0].getBounds().getMinY();
                    this.logicalBounds = this.logicalBounds.deriveWithNewBounds(0.0f, f, 0.0f, this.layoutWidth, this.layoutHeight + f, 0.0f);
                }
            }
        }
    }

    private int getLineCount() {
        return this.lines.length;
    }

    private int getCharCount() {
        if (this.text != null) {
            return this.text.length;
        }
        int n = 0;
        for (int i = 0; i < this.lines.length; ++i) {
            n += this.lines[i].getLength();
        }
        return n;
    }

    public TextSpan[] getTextSpans() {
        return this.spans;
    }

    public PGFont getFont() {
        return this.font;
    }

    public int getDirection() {
        if ((this.flags & 0x400) != 0) {
            return 0;
        }
        if ((this.flags & 0x800) != 0) {
            return 1;
        }
        if ((this.flags & 0x1000) != 0) {
            return -2;
        }
        if ((this.flags & 0x2000) != 0) {
            return -1;
        }
        return -2;
    }

    public void addTextRun(TextRun textRun) {
        if (this.runCount + 1 > this.runs.length) {
            TextRun[] textRunArray = new TextRun[this.runs.length + 64];
            System.arraycopy(this.runs, 0, textRunArray, 0, this.runs.length);
            this.runs = textRunArray;
        }
        this.runs[this.runCount++] = textRun;
    }

    private void buildRuns(char[] cArray) {
        this.runCount = 0;
        if (this.runs == null) {
            int n = Math.max(4, Math.min(cArray.length / 16, 16));
            this.runs = new TextRun[n];
        }
        GlyphLayout glyphLayout = this.glyphLayout();
        this.flags = glyphLayout.breakRuns(this, cArray, this.flags);
        glyphLayout.dispose();
        for (int i = this.runCount; i < this.runs.length; ++i) {
            this.runs[i] = null;
        }
    }

    protected GlyphLayout glyphLayout() {
        return GlyphLayoutManager.getInstance();
    }

    private void shape(TextRun textRun, char[] cArray, GlyphLayout glyphLayout) {
        float f;
        FontStrike fontStrike;
        PGFont pGFont;
        Object object;
        if (this.spans != null) {
            if (this.spans.length == 0) {
                return;
            }
            object = textRun.getTextSpan();
            pGFont = (PGFont)object.getFont();
            if (pGFont == null) {
                RectBounds rectBounds = object.getBounds();
                textRun.setEmbedded(rectBounds, object.getText().length());
                return;
            }
            fontStrike = pGFont.getStrike(IDENTITY);
        } else {
            pGFont = this.font;
            fontStrike = this.strike;
        }
        if (textRun.getAscent() == 0.0f) {
            object = fontStrike.getMetrics();
            if ((this.flags & 0x4000) == 16384) {
                float f2 = object.getAscent();
                if (pGFont.getFamilyName().equals("Segoe UI")) {
                    f2 = (float)((double)f2 * 0.8);
                }
                f2 = (int)((double)f2 - 0.75);
                float f3 = (int)((double)object.getDescent() + 0.75);
                f = (int)((double)object.getLineGap() + 0.75);
                float f4 = (int)((double)object.getCapHeight() + 0.75);
                float f5 = -f2 - f4;
                if (f5 > f3) {
                    f3 = f5;
                } else {
                    f2 += f5 - f3;
                }
                textRun.setMetrics(f2, f3, f);
            } else {
                textRun.setMetrics(object.getAscent(), object.getDescent(), object.getLineGap());
            }
        }
        if (textRun.isTab()) {
            return;
        }
        if (textRun.isLinebreak()) {
            return;
        }
        if (textRun.getGlyphCount() > 0) {
            return;
        }
        if (textRun.isComplex()) {
            glyphLayout.layout(textRun, pGFont, fontStrike, cArray);
        } else {
            object = fontStrike.getFontResource();
            int n = textRun.getStart();
            int n2 = textRun.getLength();
            if (this.layoutCache == null) {
                f = fontStrike.getSize();
                CharToGlyphMapper charToGlyphMapper = object.getGlyphMapper();
                int[] nArray = new int[n2];
                charToGlyphMapper.charsToGlyphs(n, n2, cArray, nArray);
                float[] fArray = new float[n2 + 1 << 1];
                float f6 = 0.0f;
                for (int i = 0; i < n2; ++i) {
                    float f7 = object.getAdvance(nArray[i], f);
                    fArray[i << 1] = f6;
                    f6 += f7;
                }
                fArray[n2 << 1] = f6;
                textRun.shape(n2, nArray, fArray, null);
            } else {
                if (!this.layoutCache.valid) {
                    f = fontStrike.getSize();
                    CharToGlyphMapper charToGlyphMapper = object.getGlyphMapper();
                    charToGlyphMapper.charsToGlyphs(n, n2, cArray, this.layoutCache.glyphs, n);
                    int n3 = n + n2;
                    float f8 = 0.0f;
                    for (int i = n; i < n3; ++i) {
                        float f9;
                        this.layoutCache.advances[i] = f9 = object.getAdvance(this.layoutCache.glyphs[i], f);
                        f8 += f9;
                    }
                    textRun.setWidth(f8);
                }
                textRun.shape(n2, this.layoutCache.glyphs, this.layoutCache.advances);
            }
        }
    }

    private PrismTextLine createLine(int n, int n2, int n3, float f) {
        int n4 = n2 - n + 1;
        assert (n4 > 0) : "number of TextRuns in a TextLine cannot be less than one: " + n4;
        TextRun[] textRunArray = new TextRun[n4];
        if (n < this.runCount) {
            System.arraycopy(this.runs, n, textRunArray, 0, n4);
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n5 = 0;
        for (int i = 0; i < textRunArray.length; ++i) {
            TextRun textRun = textRunArray[i];
            f2 += textRun.getWidth();
            f3 = Math.min(f3, textRun.getAscent());
            f4 = Math.max(f4, textRun.getDescent());
            f5 = Math.max(f5, textRun.getLeading());
            n5 += textRun.getLength();
        }
        if ((f2 -= f) > this.layoutWidth) {
            this.layoutWidth = f2;
        }
        return new PrismTextLine(n3, n5, textRunArray, f2, f3, f4, f5);
    }

    private float computeTrailingSpaceWidth(TextRun textRun) {
        int n;
        float f = 0.0f;
        char[] cArray = this.getText();
        for (int i = textRun.getGlyphCount() - 1; i >= 0 && Character.isWhitespace(cArray[n = textRun.getStart() + textRun.getCharOffset(i)]); --i) {
            f += textRun.getAdvance(i);
        }
        return f;
    }

    private void reorderLine(PrismTextLine prismTextLine) {
        Object[] objectArray = prismTextLine.getRuns();
        int n = objectArray.length;
        if (n > 0 && objectArray[n - 1].isLinebreak()) {
            --n;
        }
        if (n < 2) {
            return;
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = objectArray[i].getLevel();
        }
        Bidi.reorderVisually(byArray, 0, objectArray, 0, n);
    }

    private char[] getText() {
        if (this.text == null) {
            int n;
            int n2 = 0;
            for (n = 0; n < this.spans.length; ++n) {
                n2 += this.spans[n].getText().length();
            }
            this.text = new char[n2];
            n = 0;
            for (int i = 0; i < this.spans.length; ++i) {
                String string = this.spans[i].getText();
                int n3 = string.length();
                string.getChars(0, n3, this.text, n);
                n += n3;
            }
        }
        return this.text;
    }

    private boolean isSimpleLayout() {
        int n = this.flags & 0x3C0000;
        boolean bl = this.wrapWidth > 0.0f && n == 0x200000;
        int n2 = 24;
        return (this.flags & n2) == 0 && !bl;
    }

    private boolean isMirrored() {
        boolean bl = false;
        switch (this.flags & 0x3C00) {
            case 2048: {
                bl = true;
                break;
            }
            case 1024: {
                bl = false;
                break;
            }
            case 4096: 
            case 8192: {
                bl = (this.flags & 0x100) != 0;
            }
        }
        return bl;
    }

    private float getMirroringWidth() {
        return this.wrapWidth != 0.0f ? this.wrapWidth : this.layoutWidth;
    }

    private void reuseRuns() {
        TextRun textRun;
        this.runCount = 0;
        int n = 0;
        block0: while (n < this.runs.length && (textRun = this.runs[n]) != null) {
            TextRun textRun2;
            this.runs[n] = null;
            ++n;
            this.runs[this.runCount++] = textRun = textRun.unwrap();
            if (!textRun.isSplit()) continue;
            textRun.merge(null);
            while (n < this.runs.length && (textRun2 = this.runs[n]) != null) {
                textRun.merge(textRun2);
                this.runs[n] = null;
                ++n;
                if (!textRun2.isSplitLast()) continue;
                continue block0;
            }
        }
    }

    private float getTabAdvance() {
        float f = 0.0f;
        if (this.spans != null) {
            for (int i = 0; i < this.spans.length; ++i) {
                TextSpan textSpan = this.spans[i];
                PGFont pGFont = (PGFont)textSpan.getFont();
                if (pGFont == null) continue;
                FontStrike fontStrike = pGFont.getStrike(IDENTITY);
                f = fontStrike.getCharAdvance(' ');
                break;
            }
        } else {
            f = this.strike.getCharAdvance(' ');
        }
        return (float)this.tabSize * f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layout() {
        int n;
        int n2;
        int n3;
        float f;
        this.initCache();
        if (this.lines != null) {
            return;
        }
        char[] cArray = this.getText();
        if ((this.flags & 2) != 0 && this.isSimpleLayout()) {
            this.reuseRuns();
        } else {
            this.buildRuns(cArray);
        }
        GlyphLayout glyphLayout = null;
        if ((this.flags & 0x10) != 0) {
            glyphLayout = this.glyphLayout();
        }
        float f2 = 0.0f;
        if ((this.flags & 4) != 0) {
            f2 = this.getTabAdvance();
        }
        BreakIterator breakIterator = null;
        if (this.wrapWidth > 0.0f && (this.flags & 0x50) != 0) {
            breakIterator = BreakIterator.getLineInstance();
            breakIterator.setText(new CharArrayIterator(cArray));
        }
        int n4 = this.flags & 0x3C0000;
        if (this.isSimpleLayout()) {
            if (this.layoutCache == null) {
                this.layoutCache = new LayoutCache();
                this.layoutCache.glyphs = new int[cArray.length];
                this.layoutCache.advances = new float[cArray.length];
            }
        } else {
            this.layoutCache = null;
        }
        float f3 = 0.0f;
        int n5 = 0;
        int n6 = 0;
        ArrayList<PrismTextLine> arrayList = new ArrayList<PrismTextLine>();
        for (int i = 0; i < this.runCount; ++i) {
            TextRun textRun = this.runs[i];
            this.shape(textRun, cArray, glyphLayout);
            if (textRun.isTab()) {
                f = (float)((int)(f3 / f2) + 1) * f2;
                textRun.setWidth(f - f3);
            }
            f = textRun.getWidth();
            if (this.wrapWidth > 0.0f && f3 + f > this.wrapWidth && !textRun.isLinebreak()) {
                int n7;
                int n8;
                int n9 = n3 = textRun.getStart() + textRun.getWrapIndex(this.wrapWidth - f3);
                n2 = textRun.getEnd();
                while (n9 + 1 < n2 && Character.isWhitespace(cArray[n9])) {
                    ++n9;
                }
                if (breakIterator != null) {
                    n8 = breakIterator.isBoundary(n9) || cArray[n9] == '\t' ? n9 : breakIterator.preceding(n9);
                } else {
                    n7 = Character.isWhitespace(cArray[n8]);
                    for (n8 = n9; n8 > n6; --n8) {
                        boolean bl = Character.isWhitespace(cArray[n8 - 1]);
                        if (n7 == 0 && bl) break;
                        n7 = bl ? 1 : 0;
                    }
                }
                if (n8 < n6) {
                    n8 = n6;
                }
                TextRun textRun2 = null;
                for (n7 = n5; n7 < this.runCount && (textRun2 = this.runs[n7]).getEnd() <= n8; ++n7) {
                }
                if (n8 == n6) {
                    textRun2 = textRun;
                    n7 = i;
                    n8 = n3;
                }
                if ((n = n8 - textRun2.getStart()) == 0 && n7 != n5) {
                    i = n7 - 1;
                } else {
                    i = n7;
                    if (n == 0) {
                        ++n;
                    }
                    if (n < textRun2.getLength()) {
                        if (this.runCount >= this.runs.length) {
                            TextRun[] textRunArray = new TextRun[this.runs.length + 64];
                            System.arraycopy(this.runs, 0, textRunArray, 0, i + 1);
                            System.arraycopy(this.runs, i + 1, textRunArray, i + 2, this.runs.length - i - 1);
                            this.runs = textRunArray;
                        } else {
                            System.arraycopy(this.runs, i + 1, this.runs, i + 2, this.runCount - i - 1);
                        }
                        this.runs[i + 1] = textRun2.split(n);
                        if (textRun2.isComplex()) {
                            this.shape(textRun2, cArray, glyphLayout);
                        }
                        ++this.runCount;
                    }
                }
                if (i + 1 < this.runCount && !this.runs[i + 1].isLinebreak()) {
                    textRun = this.runs[i];
                    textRun.setSoftbreak();
                    this.flags |= 0x80;
                }
            }
            f3 += f;
            if (!textRun.isBreak()) continue;
            PrismTextLine prismTextLine = this.createLine(n5, i, n6, this.computeTrailingSpaceWidth(this.runs[i]));
            arrayList.add(prismTextLine);
            n5 = i + 1;
            n6 += prismTextLine.getLength();
            f3 = 0.0f;
        }
        if (glyphLayout != null) {
            glyphLayout.dispose();
        }
        arrayList.add(this.createLine(n5, this.runCount - 1, n6, 0.0f));
        this.lines = new PrismTextLine[arrayList.size()];
        arrayList.toArray(this.lines);
        float f4 = this.wrapWidth > 0.0f ? this.wrapWidth : this.layoutWidth;
        float f5 = 0.0f;
        if (this.isMirrored()) {
            f = 1.0f;
            if (n4 == 0x100000) {
                f = 0.0f;
            }
        } else {
            f = 0.0f;
            if (n4 == 0x100000) {
                f = 1.0f;
            }
        }
        if (n4 == 524288) {
            f = 0.5f;
        }
        for (n3 = 0; n3 < this.lines.length; ++n3) {
            int n10;
            TextRun[] textRunArray;
            int n11;
            PrismTextLine prismTextLine = this.lines[n3];
            n2 = prismTextLine.getStart();
            RectBounds rectBounds = prismTextLine.getBounds();
            float f6 = f4 - rectBounds.getWidth();
            float f7 = f6 * f;
            prismTextLine.setAlignment(f7);
            int n12 = n = this.wrapWidth > 0.0f && n4 == 0x200000 ? 1 : 0;
            if (n != 0 && (n11 = (textRunArray = prismTextLine.getRuns()).length) > 0 && textRunArray[n11 - 1].isSoftbreak()) {
                n10 = n2 + prismTextLine.getLength();
                int n13 = 0;
                boolean bl = false;
                for (int i = n10 - 1; i >= n2; --i) {
                    if (!bl && cArray[i] != ' ') {
                        bl = true;
                    }
                    if (!bl || cArray[i] != ' ') continue;
                    ++n13;
                }
                if (n13 != 0) {
                    float f8 = f6 / (float)n13;
                    block9: for (int i = 0; i < n11; ++i) {
                        TextRun textRun = textRunArray[i];
                        int n14 = textRun.getStart();
                        int n15 = textRun.getEnd();
                        for (int j = n14; j < n15; ++j) {
                            if (cArray[j] != ' ') continue;
                            textRun.justify(j - n14, f8);
                            if (--n13 == 0) break block9;
                        }
                    }
                    f7 = 0.0f;
                    prismTextLine.setAlignment(f7);
                    prismTextLine.setWidth(f4);
                }
            }
            if ((this.flags & 8) != 0) {
                this.reorderLine(prismTextLine);
            }
            this.computeSideBearings(prismTextLine);
            float f9 = f7;
            TextRun[] textRunArray2 = prismTextLine.getRuns();
            for (n10 = 0; n10 < textRunArray2.length; ++n10) {
                TextRun textRun = textRunArray2[n10];
                textRun.setLocation(f9, f5);
                textRun.setLine(prismTextLine);
                f9 += textRun.getWidth();
            }
            if (n3 + 1 < this.lines.length) {
                f5 = Math.max(f5, f5 + rectBounds.getHeight() + this.spacing);
                continue;
            }
            f5 += rectBounds.getHeight() - prismTextLine.getLeading();
        }
        float f10 = this.lines[0].getBounds().getMinY();
        this.layoutHeight = f5;
        this.logicalBounds = this.logicalBounds.deriveWithNewBounds(0.0f, f10, 0.0f, this.layoutWidth, this.layoutHeight + f10, 0.0f);
        if (this.layoutCache != null) {
            if (this.cacheKey != null && !this.layoutCache.valid && !this.copyCache()) {
                this.layoutCache.font = this.font;
                this.layoutCache.text = this.text;
                this.layoutCache.runs = this.runs;
                this.layoutCache.runCount = this.runCount;
                this.layoutCache.lines = this.lines;
                this.layoutCache.layoutWidth = this.layoutWidth;
                this.layoutCache.layoutHeight = this.layoutHeight;
                this.layoutCache.analysis = this.flags & 0x7FF;
                Object object = CACHE_SIZE_LOCK;
                synchronized (object) {
                    n2 = cArray.length;
                    if (cacheSize + n2 > this.maxCacheSize) {
                        stringCache.clear();
                        cacheSize = 0;
                    }
                    stringCache.put(this.cacheKey, this.layoutCache);
                    cacheSize += n2;
                }
            }
            this.layoutCache.valid = true;
        }
    }

    @Override
    public BaseBounds getVisualBounds(int n) {
        boolean bl;
        this.ensureLayout();
        if (this.strike == null) {
            return null;
        }
        boolean bl2 = (n & 2) != 0;
        boolean bl3 = (this.flags & 0x200) != 0;
        boolean bl4 = (n & 4) != 0;
        boolean bl5 = bl = (this.flags & 0x400) != 0;
        if (this.visualBounds != null && bl2 == bl3 && bl4 == bl) {
            return this.visualBounds;
        }
        this.flags &= 0xFFFFF9FF;
        if (bl2) {
            this.flags |= 0x200;
        }
        if (bl4) {
            this.flags |= 0x400;
        }
        this.visualBounds = new RectBounds();
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.POSITIVE_INFINITY;
        float f3 = Float.NEGATIVE_INFINITY;
        float f4 = Float.NEGATIVE_INFINITY;
        float[] fArray = new float[4];
        FontResource fontResource = this.strike.getFontResource();
        Metrics metrics = this.strike.getMetrics();
        float f5 = this.strike.getSize();
        for (int i = 0; i < this.lines.length; ++i) {
            PrismTextLine prismTextLine = this.lines[i];
            TextRun[] textRunArray = prismTextLine.getRuns();
            for (int j = 0; j < textRunArray.length; ++j) {
                float f6;
                float f7;
                TextRun textRun = textRunArray[j];
                Point2D point2D = textRun.getLocation();
                if (textRun.isLinebreak()) continue;
                int n2 = textRun.getGlyphCount();
                for (int k = 0; k < n2; ++k) {
                    int n3 = textRun.getGlyphCode(k);
                    if (n3 == 65535) continue;
                    fontResource.getGlyphBoundingBox(textRun.getGlyphCode(k), f5, fArray);
                    if (fArray[0] == fArray[2]) continue;
                    f7 = point2D.x + textRun.getPosX(k);
                    f6 = point2D.y + textRun.getPosY(k);
                    float f8 = f7 + fArray[0];
                    float f9 = f6 - fArray[3];
                    float f10 = f7 + fArray[2];
                    float f11 = f6 - fArray[1];
                    if (f8 < f) {
                        f = f8;
                    }
                    if (f9 < f2) {
                        f2 = f9;
                    }
                    if (f10 > f3) {
                        f3 = f10;
                    }
                    if (!(f11 > f4)) continue;
                    f4 = f11;
                }
                if (bl2) {
                    float f12 = point2D.x;
                    float f13 = point2D.y + metrics.getUnderLineOffset();
                    f7 = f12 + textRun.getWidth();
                    f6 = f13 + metrics.getUnderLineThickness();
                    if (f12 < f) {
                        f = f12;
                    }
                    if (f13 < f2) {
                        f2 = f13;
                    }
                    if (f7 > f3) {
                        f3 = f7;
                    }
                    if (f6 > f4) {
                        f4 = f6;
                    }
                }
                if (!bl4) continue;
                float f14 = point2D.x;
                float f15 = point2D.y + metrics.getStrikethroughOffset();
                f7 = f14 + textRun.getWidth();
                f6 = f15 + metrics.getStrikethroughThickness();
                if (f14 < f) {
                    f = f14;
                }
                if (f15 < f2) {
                    f2 = f15;
                }
                if (f7 > f3) {
                    f3 = f7;
                }
                if (!(f6 > f4)) continue;
                f4 = f6;
            }
        }
        if (f < f3 && f2 < f4) {
            this.visualBounds.setBounds(f, f2, f3, f4);
        }
        return this.visualBounds;
    }

    private void computeSideBearings(PrismTextLine prismTextLine) {
        Object object;
        int n;
        TextRun[] textRunArray = prismTextLine.getRuns();
        if (textRunArray.length == 0) {
            return;
        }
        float[] fArray = new float[4];
        FontResource fontResource = null;
        float f = 0.0f;
        if (this.strike != null) {
            fontResource = this.strike.getFontResource();
            f = this.strike.getSize();
        }
        float f2 = 0.0f;
        float f3 = 0.0f;
        block0: for (int i = 0; i < textRunArray.length; ++i) {
            TextRun textRun = textRunArray[i];
            int n2 = textRun.getGlyphCount();
            for (n = 0; n < n2; ++n) {
                int n3;
                float f4 = textRun.getAdvance(n);
                if (f4 != 0.0f && (n3 = textRun.getGlyphCode(n)) != 65535) {
                    FontResource fontResource2 = fontResource;
                    if (fontResource2 == null) {
                        TextSpan textSpan = textRun.getTextSpan();
                        object = (PGFont)textSpan.getFont();
                        f = object.getSize();
                        fontResource2 = object.getFontResource();
                    }
                    fontResource2.getGlyphBoundingBox(n3, f, fArray);
                    float f5 = fArray[0];
                    f2 = Math.min(0.0f, f5 + f3);
                    textRun.setLeftBearing();
                    break block0;
                }
                f3 += f4;
            }
            if (n2 != 0) continue;
            f3 += textRun.getWidth();
        }
        float f6 = 0.0f;
        f3 = 0.0f;
        block2: for (int i = textRunArray.length - 1; i >= 0; --i) {
            TextRun textRun = textRunArray[i];
            n = textRun.getGlyphCount();
            for (int j = n - 1; j >= 0; --j) {
                int n4;
                float f7 = textRun.getAdvance(j);
                if (f7 != 0.0f && (n4 = textRun.getGlyphCode(j)) != 65535) {
                    FontResource fontResource3 = fontResource;
                    if (fontResource3 == null) {
                        object = textRun.getTextSpan();
                        PGFont pGFont = (PGFont)object.getFont();
                        f = pGFont.getSize();
                        fontResource3 = pGFont.getFontResource();
                    }
                    fontResource3.getGlyphBoundingBox(n4, f, fArray);
                    float f8 = fArray[2] - f7;
                    f6 = Math.max(0.0f, f8 - f3);
                    textRun.setRightBearing();
                    break block2;
                }
                f3 += f7;
            }
            if (n != 0) continue;
            f3 += textRun.getWidth();
        }
        prismTextLine.setSideBearings(f2, f6);
    }
}

