/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.input;

import com.sun.jfx.incubator.scene.control.input.EventHandlerPriority;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javafx.event.Event;
import javafx.event.EventHandler;

public class PHList {
    private final ArrayList<Object> items = new ArrayList(4);

    public String toString() {
        return "PHList{items=" + String.valueOf(this.items) + "}";
    }

    public void add(EventHandlerPriority eventHandlerPriority, EventHandler<?> eventHandler) {
        int n = this.findInsertionIndex(eventHandlerPriority);
        if (n < 0) {
            n = -n - 1;
            this.insert(n, (Object)eventHandlerPriority);
            if (eventHandler != null) {
                this.insert(++n, eventHandler);
            }
        } else {
            this.insert(n, eventHandler);
        }
    }

    private void insert(int n, Object object) {
        if (n < this.items.size()) {
            this.items.add(n, object);
        } else {
            this.items.add(object);
        }
    }

    public <T extends Event> boolean remove(EventHandler<T> eventHandler) {
        for (int i = 0; i < this.items.size(); ++i) {
            Object object = this.items.get(i);
            if (object != eventHandler) continue;
            this.items.remove(i);
            if (!this.isNullOrPriority(i) || !this.isNullOrPriority(i - 1)) continue;
            this.items.remove(--i);
        }
        return this.items.isEmpty();
    }

    private boolean isNullOrPriority(int n) {
        if (n >= 0 && n < this.items.size()) {
            Object object = this.items.get(n);
            return object instanceof EventHandlerPriority;
        }
        return true;
    }

    private int findInsertionIndex(EventHandlerPriority eventHandlerPriority) {
        int n = this.items.size();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Object object = this.items.get(i);
            if (!(object instanceof EventHandlerPriority)) continue;
            EventHandlerPriority eventHandlerPriority2 = (EventHandlerPriority)((Object)object);
            if (eventHandlerPriority2.priority == eventHandlerPriority.priority) {
                bl = true;
                continue;
            }
            if (eventHandlerPriority2.priority >= eventHandlerPriority.priority) continue;
            return bl ? i : -(i + 1);
        }
        return bl ? n : -(n + 1);
    }

    public <T extends Event> void forEach(Client<T> client) {
        EventHandlerPriority eventHandlerPriority = null;
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            Object object = this.items.get(i);
            if (object instanceof EventHandlerPriority) {
                EventHandlerPriority eventHandlerPriority2;
                eventHandlerPriority = eventHandlerPriority2 = (EventHandlerPriority)((Object)object);
                if (!this.isNullOrPriority(i + 1)) continue;
                bl = !client.accept(eventHandlerPriority, null);
            } else {
                boolean bl2 = bl = !client.accept(eventHandlerPriority, (EventHandler)object);
            }
            if (bl) break;
        }
    }

    public boolean removeHandlers(Set<EventHandlerPriority> set) {
        boolean bl = false;
        int n = 0;
        while (n < this.items.size()) {
            Object object = this.items.get(n);
            if (object instanceof EventHandlerPriority) {
                EventHandlerPriority eventHandlerPriority = (EventHandlerPriority)((Object)object);
                if (set.contains((Object)eventHandlerPriority)) {
                    bl = true;
                    this.items.remove(n);
                    continue;
                }
                bl = false;
                ++n;
                continue;
            }
            if (bl) {
                this.items.remove(n);
                continue;
            }
            ++n;
        }
        return this.items.isEmpty();
    }

    public void validateInternalState(Object ... objectArray) {
        if (!Arrays.equals(objectArray, this.items.toArray())) {
            throw new RuntimeException("internal mismatch:\nitems=" + String.valueOf(this.items) + "\nexpected=" + String.valueOf(List.of(objectArray)));
        }
    }

    @FunctionalInterface
    public static interface Client<T extends Event> {
        public boolean accept(EventHandlerPriority var1, EventHandler<T> var2);
    }
}

