/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;

final class OffHeapArray {
    private final boolean global;
    private Arena arena;
    static final int SIZE_INT = 4;
    private static final int ALIGNMENT = 16;
    private static final ValueLayout.OfByte BYTE_LAYOUT = ValueLayout.JAVA_BYTE;
    private static final ValueLayout.OfInt INT_LAYOUT = ValueLayout.JAVA_INT;
    private MemorySegment segment;
    private int used;

    OffHeapArray(Object object, long l, boolean bl) {
        this.global = bl;
        this.arena = bl ? Arena.global() : Arena.ofConfined();
        this.segment = this.arena.allocate(l, 16L);
        this.used = 0;
        if (MarlinConst.LOG_OFF_HEAP_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.allocateMemory =   " + l + " for segment = " + String.valueOf(this.segment) + " global = " + bl);
        }
        if (!bl) {
            MarlinUtils.getCleaner().register(object, this::free);
        }
    }

    long getLength() {
        return this.segment.byteSize();
    }

    int getUsed() {
        return this.used;
    }

    void setUsed(int n) {
        this.used = n;
    }

    void incrementUsed(int n) {
        this.used += n;
    }

    void resize(long l) {
        if (this.global) {
            throw new UnsupportedOperationException("Cannot resize a global OffHeapArray");
        }
        Arena arena = Arena.ofConfined();
        MemorySegment memorySegment = arena.allocate(l, 16L);
        if (this.used > 0) {
            MemorySegment.copy(this.segment, 0L, memorySegment, 0L, Math.min((long)this.used, l));
        }
        this.arena.close();
        this.arena = arena;
        this.segment = memorySegment;
        if (MarlinConst.LOG_OFF_HEAP_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.reallocateMemory = " + l + " for segment = " + String.valueOf(this.segment));
        }
    }

    void free() {
        this.arena.close();
        if (MarlinConst.LOG_OFF_HEAP_MALLOC) {
            MarlinUtils.logInfo(System.currentTimeMillis() + ": OffHeapArray.freeMemory =       " + this.segment.byteSize() + " for segment = " + String.valueOf(this.segment));
        }
    }

    void fill(byte by) {
        this.segment.fill(by);
    }

    void putByte(long l, byte by) {
        this.segment.set(BYTE_LAYOUT, l, by);
    }

    void putInt(long l, int n) {
        this.segment.set(INT_LAYOUT, l, n);
    }

    byte getByte(long l) {
        return this.segment.get(BYTE_LAYOUT, l);
    }

    int getInt(long l) {
        return this.segment.get(INT_LAYOUT, l);
    }
}

