/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout;

import com.sun.javafx.PlatformUtil;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HeaderButtonType;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Subscription;

public final class HeaderButtonBehavior
implements EventHandler<MouseEvent> {
    private static final PseudoClass MAXIMIZED_PSEUDO_CLASS = PseudoClass.getPseudoClass("maximized");
    private final Node node;
    private final HeaderButtonType type;
    private final Subscription subscription;

    public HeaderButtonBehavior(Node node, HeaderButtonType headerButtonType) {
        this.node = Objects.requireNonNull(node);
        this.type = Objects.requireNonNull(headerButtonType);
        ObservableValue observableValue = node.sceneProperty().flatMap(Scene::windowProperty).map(window -> {
            Stage stage;
            return window instanceof Stage ? (stage = (Stage)window) : null;
        });
        this.subscription = headerButtonType == HeaderButtonType.MAXIMIZE ? Subscription.combine((Subscription[])new Subscription[]{observableValue.flatMap(Stage::resizableProperty).subscribe(this::onResizableChanged), observableValue.flatMap(Stage::fullScreenProperty).subscribe(this::onFullScreenChanged), observableValue.flatMap(Stage::maximizedProperty).subscribe(this::onMaximizedChanged), () -> node.removeEventHandler(MouseEvent.MOUSE_RELEASED, this)}) : Subscription.combine((Subscription[])new Subscription[]{observableValue.flatMap(Stage::fullScreenProperty).subscribe(this::onFullScreenChanged), () -> node.removeEventHandler(MouseEvent.MOUSE_RELEASED, this)});
        node.addEventHandler(MouseEvent.MOUSE_RELEASED, this);
        if (!node.focusTraversableProperty().isBound()) {
            node.setFocusTraversable(false);
        }
    }

    public void dispose() {
        this.subscription.unsubscribe();
    }

    public void handle(MouseEvent mouseEvent) {
        if (!this.node.getLayoutBounds().contains(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        Stage stage = this.getStage();
        if (stage == null) {
            return;
        }
        switch (this.type) {
            case CLOSE: {
                stage.close();
                break;
            }
            case ICONIFY: {
                stage.setIconified(true);
                break;
            }
            case MAXIMIZE: {
                if (PlatformUtil.isMac() && stage.getModality() == Modality.NONE && !mouseEvent.isAltDown()) {
                    stage.setFullScreen(!stage.isFullScreen());
                    break;
                }
                stage.setMaximized(!stage.isMaximized());
            }
        }
    }

    private Stage getStage() {
        Stage stage;
        Scene scene = this.node.getScene();
        if (scene == null) {
            return null;
        }
        Window window = scene.getWindow();
        return window instanceof Stage ? (stage = (Stage)window) : null;
    }

    private void onResizableChanged(Boolean bl) {
        if (!this.node.disableProperty().isBound()) {
            this.node.setDisable(bl == Boolean.FALSE);
        }
    }

    private void onFullScreenChanged(Boolean bl) {
        if (!this.node.visibleProperty().isBound() && !this.node.managedProperty().isBound()) {
            this.node.setVisible(bl != Boolean.TRUE);
            this.node.setManaged(bl != Boolean.TRUE);
        }
    }

    private void onMaximizedChanged(Boolean bl) {
        this.node.pseudoClassStateChanged(MAXIMIZED_PSEUDO_CLASS, bl == Boolean.TRUE);
    }
}

