/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.PreviewFeature;
import com.sun.javafx.geom.Vec2d;
import com.sun.javafx.scene.layout.HeaderButtonBehavior;
import com.sun.javafx.stage.HeaderButtonMetrics;
import com.sun.javafx.stage.StageHelper;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.css.StyleOrigin;
import javafx.css.StyleableDoubleProperty;
import javafx.geometry.Dimension2D;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.layout.HeaderButtonType;
import javafx.scene.layout.HeaderDragType;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import javafx.util.Subscription;

@Deprecated(since="25")
public class HeaderBar
extends Region {
    private static final Dimension2D EMPTY = new Dimension2D(0.0, 0.0);
    private static final String DRAG_TYPE = "headerbar-drag-type";
    private static final String BUTTON_TYPE = "headerbar-button-type";
    private static final String ALIGNMENT = "headerbar-alignment";
    private static final String MARGIN = "headerbar-margin";
    public static final double USE_DEFAULT_SIZE = -1.0;
    private Subscription subscription = Subscription.EMPTY;
    private HeaderButtonMetrics currentMetrics;
    private boolean currentFullScreen;
    private final ReadOnlyObjectWrapper<Dimension2D> leftSystemInset = new ReadOnlyObjectWrapper<Dimension2D>((Object)this, "leftSystemInset", EMPTY){

        protected void invalidated() {
            HeaderBar.this.requestLayout();
        }
    };
    private final ReadOnlyObjectWrapper<Dimension2D> rightSystemInset = new ReadOnlyObjectWrapper<Dimension2D>((Object)this, "rightSystemInset", EMPTY){

        protected void invalidated() {
            HeaderBar.this.requestLayout();
        }
    };
    private final ReadOnlyDoubleWrapper minSystemHeight = new ReadOnlyDoubleWrapper(this, "minSystemHeight"){

        protected void invalidated() {
            double d = this.get();
            StyleableDoubleProperty styleableDoubleProperty = (StyleableDoubleProperty)HeaderBar.this.minHeightProperty();
            if (styleableDoubleProperty.getStyleOrigin() == null) {
                styleableDoubleProperty.applyStyle((StyleOrigin)null, d);
            }
        }
    };
    private final ObjectProperty<Node> leading = new NodeProperty("leading");
    private final ObjectProperty<Node> center = new NodeProperty("center");
    private final ObjectProperty<Node> trailing = new NodeProperty("trailing");
    private final BooleanProperty leadingSystemPadding = new BooleanPropertyBase(true){

        public Object getBean() {
            return HeaderBar.this;
        }

        public String getName() {
            return "leadingSystemPadding";
        }

        protected void invalidated() {
            HeaderBar.this.requestLayout();
        }
    };
    private final BooleanProperty trailingSystemPadding = new BooleanPropertyBase(true){

        public Object getBean() {
            return HeaderBar.this;
        }

        public String getName() {
            return "trailingSystemPadding";
        }

        protected void invalidated() {
            HeaderBar.this.requestLayout();
        }
    };

    public static void setDragType(Node node, HeaderDragType headerDragType) {
        Pane.setConstraint(node, DRAG_TYPE, (Object)headerDragType);
    }

    public static HeaderDragType getDragType(Node node) {
        return (HeaderDragType)((Object)Pane.getConstraint(node, DRAG_TYPE));
    }

    public static void setButtonType(Node node, HeaderButtonType headerButtonType) {
        Pane.setConstraint(node, BUTTON_TYPE, (Object)headerButtonType);
        Object object = node.getProperties().get(HeaderButtonBehavior.class);
        if (object instanceof HeaderButtonBehavior) {
            HeaderButtonBehavior headerButtonBehavior = (HeaderButtonBehavior)object;
            headerButtonBehavior.dispose();
        }
        if (headerButtonType != null) {
            node.getProperties().put(HeaderButtonBehavior.class, (Object)new HeaderButtonBehavior(node, headerButtonType));
        } else {
            node.getProperties().remove(HeaderButtonBehavior.class);
        }
    }

    public static HeaderButtonType getButtonType(Node node) {
        return (HeaderButtonType)((Object)Pane.getConstraint(node, BUTTON_TYPE));
    }

    public static void setPrefButtonHeight(Stage stage, double d) {
        StageHelper.setPrefHeaderButtonHeight(stage, d);
    }

    public static double getPrefButtonHeight(Stage stage) {
        return StageHelper.getPrefHeaderButtonHeight(stage);
    }

    public static void setAlignment(Node node, Pos pos) {
        Pane.setConstraint(node, ALIGNMENT, (Object)pos);
    }

    public static Pos getAlignment(Node node) {
        return (Pos)((Object)Pane.getConstraint(node, ALIGNMENT));
    }

    public static void setMargin(Node node, Insets insets) {
        Pane.setConstraint(node, MARGIN, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)Pane.getConstraint(node, MARGIN);
    }

    public HeaderBar() {
        PreviewFeature.HEADER_BAR.checkEnabled();
        this.minHeightProperty();
        ObservableValue observableValue = this.sceneProperty().flatMap(Scene::windowProperty).map(window -> {
            Stage stage;
            return window instanceof Stage ? (stage = (Stage)window) : null;
        });
        observableValue.flatMap(Stage::fullScreenProperty).orElse((Object)false).subscribe(this::onFullScreenChanged);
        observableValue.subscribe(this::onStageChanged);
    }

    public HeaderBar(Node node, Node node2, Node node3) {
        this();
        this.setLeading(node);
        this.setCenter(node2);
        this.setTrailing(node3);
    }

    private void onStageChanged(Stage stage) {
        this.subscription.unsubscribe();
        if (stage != null) {
            this.subscription = StageHelper.getHeaderButtonMetrics(stage).subscribe(this::onMetricsChanged);
        }
    }

    private void onMetricsChanged(HeaderButtonMetrics headerButtonMetrics) {
        this.currentMetrics = headerButtonMetrics;
        this.updateInsets();
    }

    private void onFullScreenChanged(boolean bl) {
        this.currentFullScreen = bl;
        this.updateInsets();
    }

    private void updateInsets() {
        if (this.currentFullScreen || this.currentMetrics == null) {
            this.leftSystemInset.set((Object)EMPTY);
            this.rightSystemInset.set((Object)EMPTY);
            this.minSystemHeight.set(0.0);
        } else {
            this.leftSystemInset.set((Object)this.currentMetrics.leftInset());
            this.rightSystemInset.set((Object)this.currentMetrics.rightInset());
            this.minSystemHeight.set(this.currentMetrics.minHeight());
        }
    }

    public final ReadOnlyObjectProperty<Dimension2D> leftSystemInsetProperty() {
        return this.leftSystemInset.getReadOnlyProperty();
    }

    public final Dimension2D getLeftSystemInset() {
        return (Dimension2D)this.leftSystemInset.get();
    }

    public final ReadOnlyObjectProperty<Dimension2D> rightSystemInsetProperty() {
        return this.rightSystemInset.getReadOnlyProperty();
    }

    public final Dimension2D getRightSystemInset() {
        return (Dimension2D)this.rightSystemInset.get();
    }

    public final ReadOnlyDoubleProperty minSystemHeightProperty() {
        return this.minSystemHeight.getReadOnlyProperty();
    }

    public final double getMinSystemHeight() {
        return this.minSystemHeight.get();
    }

    public final ObjectProperty<Node> leadingProperty() {
        return this.leading;
    }

    public final Node getLeading() {
        return (Node)this.leading.get();
    }

    public final void setLeading(Node node) {
        this.leading.set((Object)node);
    }

    public final ObjectProperty<Node> centerProperty() {
        return this.center;
    }

    public final Node getCenter() {
        return (Node)this.center.get();
    }

    public final void setCenter(Node node) {
        this.center.set((Object)node);
    }

    public final ObjectProperty<Node> trailingProperty() {
        return this.trailing;
    }

    public final Node getTrailing() {
        return (Node)this.trailing.get();
    }

    public final void setTrailing(Node node) {
        this.trailing.set((Object)node);
    }

    public final BooleanProperty leadingSystemPaddingProperty() {
        return this.leadingSystemPadding;
    }

    public final boolean isLeadingSystemPadding() {
        return this.leadingSystemPadding.get();
    }

    public final void setLeadingSystemPadding(boolean bl) {
        this.leadingSystemPadding.set(bl);
    }

    public final BooleanProperty trailingSystemPaddingProperty() {
        return this.trailingSystemPadding;
    }

    public final boolean isTrailingSystemPadding() {
        return this.trailingSystemPadding.get();
    }

    public final void setTrailingSystemPadding(boolean bl) {
        this.trailingSystemPadding.set(bl);
    }

    private boolean isLeftSystemPadding(NodeOrientation nodeOrientation) {
        return nodeOrientation == NodeOrientation.LEFT_TO_RIGHT && this.isLeadingSystemPadding() || nodeOrientation == NodeOrientation.RIGHT_TO_LEFT && this.isTrailingSystemPadding();
    }

    private boolean isRightSystemPadding(NodeOrientation nodeOrientation) {
        return nodeOrientation == NodeOrientation.LEFT_TO_RIGHT && this.isTrailingSystemPadding() || nodeOrientation == NodeOrientation.RIGHT_TO_LEFT && this.isLeadingSystemPadding();
    }

    @Override
    protected double computeMinWidth(double d) {
        double d2;
        double d3;
        double d4;
        Node node = this.getLeading();
        Node node2 = this.getCenter();
        Node node3 = this.getTrailing();
        Insets insets = this.getInsets();
        double d5 = 0.0;
        if (d != -1.0 && (this.childHasContentBias(node, Orientation.VERTICAL) || this.childHasContentBias(node3, Orientation.VERTICAL) || this.childHasContentBias(node2, Orientation.VERTICAL))) {
            double d6 = Math.max(0.0, d);
            d4 = this.getAreaWidth(node, d6, false);
            d3 = this.getAreaWidth(node3, d6, false);
            d2 = this.getAreaWidth(node2, d6, true);
        } else {
            d4 = this.getAreaWidth(node, -1.0, false);
            d3 = this.getAreaWidth(node3, -1.0, false);
            d2 = this.getAreaWidth(node2, -1.0, true);
        }
        NodeOrientation nodeOrientation = this.getEffectiveNodeOrientation();
        if (this.isLeftSystemPadding(nodeOrientation)) {
            d5 += this.getLeftSystemInset().getWidth();
        }
        if (this.isRightSystemPadding(nodeOrientation)) {
            d5 += this.getRightSystemInset().getWidth();
        }
        return insets.getLeft() + d4 + d2 + d3 + insets.getRight() + d5;
    }

    @Override
    protected double computeMinHeight(double d) {
        double d2;
        Node node = this.getLeading();
        Node node2 = this.getCenter();
        Node node3 = this.getTrailing();
        Insets insets = this.getInsets();
        double d3 = this.getAreaHeight(node, -1.0, true);
        double d4 = this.getAreaHeight(node3, -1.0, true);
        if (d != -1.0 && this.childHasContentBias(node2, Orientation.HORIZONTAL)) {
            double d5 = this.getAreaWidth(node, -1.0, false);
            double d6 = this.getAreaWidth(node3, -1.0, false);
            d2 = this.getAreaHeight(node2, Math.max(0.0, d - d5 - d6), true);
        } else {
            d2 = this.getAreaHeight(node2, -1.0, true);
        }
        return insets.getTop() + insets.getBottom() + Math.max(d2, Math.max(d4, d3));
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2;
        Node node = this.getLeading();
        Node node2 = this.getCenter();
        Node node3 = this.getTrailing();
        Insets insets = this.getInsets();
        double d3 = this.getAreaHeight(node, -1.0, false);
        double d4 = this.getAreaHeight(node3, -1.0, false);
        if (d != -1.0 && this.childHasContentBias(node2, Orientation.HORIZONTAL)) {
            double d5 = this.getAreaWidth(node, -1.0, false);
            double d6 = this.getAreaWidth(node3, -1.0, false);
            d2 = this.getAreaHeight(node2, Math.max(0.0, d - d5 - d6), false);
        } else {
            d2 = this.getAreaHeight(node2, -1.0, false);
        }
        return insets.getTop() + insets.getBottom() + Math.max(d2, Math.max(d4, d3));
    }

    @Override
    public boolean usesMirroring() {
        return false;
    }

    @Override
    protected void layoutChildren() {
        Pos pos;
        double d;
        double d2;
        Insets insets;
        double d3;
        double d4;
        Node node;
        Node node2;
        double d5;
        Node node3 = this.getCenter();
        Insets insets2 = this.getInsets();
        NodeOrientation nodeOrientation = this.getEffectiveNodeOrientation();
        boolean bl = nodeOrientation == NodeOrientation.RIGHT_TO_LEFT;
        double d6 = Math.max(this.getWidth(), this.minWidth(-1.0));
        double d7 = Math.max(this.getHeight(), this.minHeight(-1.0));
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = insets2.getTop();
        double d11 = d7 - d10 - insets2.getBottom();
        double d12 = this.isLeftSystemPadding(nodeOrientation) ? this.getLeftSystemInset().getWidth() : 0.0;
        double d13 = d5 = this.isRightSystemPadding(nodeOrientation) ? this.getRightSystemInset().getWidth() : 0.0;
        if (bl) {
            node2 = this.getTrailing();
            node = this.getLeading();
            d4 = insets2.getRight() + d12;
            d3 = d6 - d4 - insets2.getLeft() - d5;
        } else {
            node2 = this.getLeading();
            node = this.getTrailing();
            d4 = insets2.getLeft() + d12;
            d3 = d6 - d4 - insets2.getRight() - d5;
        }
        if (node2 != null && node2.isManaged()) {
            insets = this.adjustMarginForRTL(this.getNodeMargin(node2), bl);
            d2 = this.adjustWidthByMargin(d3, insets);
            d = this.resizeChild(node2, d2, false, d11, insets);
            d8 = this.snapSpaceX(insets.getLeft()) + d + this.snapSpaceX(insets.getRight());
            pos = HeaderBar.getAlignment(node2);
            HeaderBar.positionInArea(node2, d4, d10, d8, d11, 0.0, insets, pos != null ? pos.getHpos() : HPos.CENTER, pos != null ? pos.getVpos() : VPos.CENTER, this.isSnapToPixel());
        }
        if (node != null && node.isManaged()) {
            insets = this.adjustMarginForRTL(this.getNodeMargin(node), bl);
            d2 = this.adjustWidthByMargin(d3 - d8, insets);
            d = this.resizeChild(node, d2, false, d11, insets);
            d9 = this.snapSpaceX(insets.getLeft()) + d + this.snapSpaceX(insets.getRight());
            pos = HeaderBar.getAlignment(node);
            HeaderBar.positionInArea(node, d4 + d3 - d9, d10, d9, d11, 0.0, insets, pos != null ? pos.getHpos() : HPos.CENTER, pos != null ? pos.getVpos() : VPos.CENTER, this.isSnapToPixel());
        }
        if (node3 != null && node3.isManaged()) {
            insets = this.adjustMarginForRTL(this.getNodeMargin(node3), bl);
            Pos pos2 = HeaderBar.getAlignment(node3);
            if (pos2 == null || pos2.getHpos() == HPos.CENTER) {
                double d14 = this.adjustWidthByMargin(d3 - d8 - d9, insets);
                double d15 = this.resizeChild(node3, d14, true, d11, insets);
                double d16 = d6 / 2.0 - d15 / 2.0;
                double d17 = d4 + d8 + insets.getLeft();
                double d18 = d4 + d3 - d9 - insets.getRight();
                double d19 = d16 < d17 ? d17 : (d16 + d15 > d18 ? d18 - d15 : d16);
                HeaderBar.positionInArea(node3, d19, d10, d15, d11, 0.0, new Insets(insets.getTop(), 0.0, insets.getBottom(), 0.0), HPos.LEFT, pos2 != null ? pos2.getVpos() : VPos.CENTER, this.isSnapToPixel());
            } else {
                this.layoutInArea(node3, d4 + d8, d10, d3 - d8 - d9, d11, 0.0, insets, pos2.getHpos(), pos2.getVpos());
            }
        }
    }

    private Insets adjustMarginForRTL(Insets insets, boolean bl) {
        if (insets == null) {
            return null;
        }
        return bl ? new Insets(insets.getTop(), insets.getLeft(), insets.getBottom(), insets.getRight()) : insets;
    }

    private boolean childHasContentBias(Node node, Orientation orientation) {
        if (node != null && node.isManaged()) {
            return node.getContentBias() == orientation;
        }
        return false;
    }

    private double resizeChild(Node node, double d, boolean bl, double d2, Insets insets) {
        double d3 = this.adjustHeightByMargin(d2, insets);
        double d4 = bl ? d : Math.min(this.snapSizeX(node.prefWidth(d3)), d);
        Vec2d vec2d = HeaderBar.boundedNodeSizeWithBias(node, d4, d3, true, true, TEMP_VEC2D);
        vec2d.x = this.snapSizeX(vec2d.x);
        vec2d.y = this.snapSizeX(vec2d.y);
        node.resize(vec2d.x, vec2d.y);
        return vec2d.x;
    }

    private double getAreaWidth(Node node, double d, boolean bl) {
        if (node != null && node.isManaged()) {
            Insets insets = this.getNodeMargin(node);
            return bl ? this.computeChildMinAreaWidth(node, -1.0, insets, d, false) : this.computeChildPrefAreaWidth(node, -1.0, insets, d, false);
        }
        return 0.0;
    }

    private double getAreaHeight(Node node, double d, boolean bl) {
        if (node != null && node.isManaged()) {
            Insets insets = this.getNodeMargin(node);
            return bl ? this.computeChildMinAreaHeight(node, -1.0, insets, d, false) : this.computeChildPrefAreaHeight(node, -1.0, insets, d, false);
        }
        return 0.0;
    }

    private Insets getNodeMargin(Node node) {
        Insets insets = HeaderBar.getMargin(node);
        return insets != null ? insets : Insets.EMPTY;
    }

    private final class NodeProperty
    extends ObjectPropertyBase<Node> {
        private final String name;
        private Node value;

        NodeProperty(String string) {
            this.name = string;
        }

        public Object getBean() {
            return HeaderBar.this;
        }

        public String getName() {
            return this.name;
        }

        protected void invalidated() {
            if (this.value != null) {
                HeaderBar.this.getChildren().remove((Object)this.value);
            }
            this.value = (Node)this.get();
            if (this.value != null) {
                HeaderBar.this.getChildren().add((Object)this.value);
            }
        }
    }
}

