/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;

public class RangeInfo {
    private final double[] data;
    private final double ymin;
    private final double ymax;

    private RangeInfo(double[] dArray, double d, double d2) {
        this.data = dArray;
        this.ymin = d;
        this.ymax = d2;
    }

    public static RangeInfo of(double d, double d2) {
        double[] dArray = new double[]{0.0, 0.0, d, d2};
        return new RangeInfo(dArray, 0.0, d2);
    }

    public static RangeInfo of(PathElement[] pathElementArray, double d) {
        int n = pathElementArray.length / 5;
        double[] dArray = new double[n * 4];
        int n2 = 0;
        int n3 = 0;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            MoveTo moveTo = (MoveTo)pathElementArray[n2];
            double d4 = moveTo.getX();
            double d5 = moveTo.getY();
            dArray[n3++] = d4;
            dArray[n3++] = d5;
            if (d5 < d2) {
                d2 = d5;
            }
            if (d5 > d3) {
                d3 = d5;
            }
            LineTo lineTo = (LineTo)pathElementArray[n2 + 2];
            d4 = lineTo.getX();
            d5 = lineTo.getY() + d;
            dArray[n3++] = d4;
            dArray[n3++] = d5;
            if (d5 < d2) {
                d2 = d5;
            }
            if (d5 > d3) {
                d3 = d5;
            }
            n2 += 5;
        }
        return new RangeInfo(dArray, d2, d3);
    }

    public int getSegmentCount() {
        return this.data.length / 4;
    }

    public boolean contains(int n, double d, double d2) {
        n *= 4;
        int n2 = n++;
        if (this.data[n2] <= d) {
            int n3 = n++;
            if (this.data[n3] <= d2) {
                int n4 = n++;
                if (this.data[n4] >= d && this.data[n] >= d2) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean containsX(int n, double d) {
        return this.data[n *= 4] <= d && this.data[n + 2] >= d;
    }

    public double midPointY(int n) {
        return (this.data[(n *= 4) + 1] + this.data[n + 3]) / 2.0;
    }

    public double getMinY(int n) {
        return this.data[n * 4 + 1];
    }

    public double getMaxY(int n) {
        return this.data[n * 4 + 3];
    }

    public boolean insideY(double d) {
        return this.ymin <= d && d <= this.ymax;
    }
}

