/*
 * Decompiled with CFR 0.152.
 */
package jfx.incubator.scene.control.richtext.model;

import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;

public abstract class StyledSegment {
    public static final StyledSegment LINE_BREAK = new StyledSegment(){

        @Override
        public Type getType() {
            return Type.LINE_BREAK;
        }

        public String toString() {
            return "LINE_BREAK";
        }

        @Override
        public StyledSegment subSegment(int n, int n2) {
            return this;
        }
    };

    public abstract Type getType();

    public String getText() {
        return null;
    }

    public int getTextLength() {
        return 0;
    }

    public Supplier<Node> getInlineNodeGenerator() {
        return null;
    }

    public Supplier<Region> getParagraphNodeGenerator() {
        return null;
    }

    public StyleAttributeMap getStyleAttributeMap(StyleResolver styleResolver) {
        return null;
    }

    public abstract StyledSegment subSegment(int var1, int var2);

    private StyledSegment() {
    }

    public static StyledSegment of(String string) {
        return StyledSegment.of(string, StyleAttributeMap.EMPTY);
    }

    public static StyledSegment of(final String string, final StyleAttributeMap styleAttributeMap) {
        return new StyledSegment(){

            @Override
            public Type getType() {
                return Type.TEXT;
            }

            @Override
            public String getText() {
                return string;
            }

            @Override
            public int getTextLength() {
                return string.length();
            }

            @Override
            public StyleAttributeMap getStyleAttributeMap(StyleResolver styleResolver) {
                if (styleResolver != null && styleAttributeMap != null) {
                    return styleResolver.resolveStyles(styleAttributeMap);
                }
                return styleAttributeMap;
            }

            @Override
            public StyledSegment subSegment(int n, int n2) {
                if (n == 0 && n2 == string.length()) {
                    return this;
                }
                return StyledSegment.of(StyledSegment.substring(string, n, n2), styleAttributeMap);
            }

            public String toString() {
                return "StyledSegment{text=" + this.getText() + ", attrs=" + String.valueOf(styleAttributeMap) + "}";
            }
        };
    }

    public static StyledSegment ofInlineNode(final Supplier<Node> supplier) {
        return new StyledSegment(){

            @Override
            public Type getType() {
                return Type.INLINE_NODE;
            }

            @Override
            public String getText() {
                return " ";
            }

            @Override
            public int getTextLength() {
                return 1;
            }

            @Override
            public Supplier<Node> getInlineNodeGenerator() {
                return supplier;
            }

            @Override
            public StyledSegment subSegment(int n, int n2) {
                return this;
            }
        };
    }

    public static StyledSegment ofRegion(final Supplier<Region> supplier) {
        return new StyledSegment(){

            @Override
            public Type getType() {
                return Type.REGION;
            }

            @Override
            public Supplier<Region> getParagraphNodeGenerator() {
                return supplier;
            }

            @Override
            public StyledSegment subSegment(int n, int n2) {
                return this;
            }
        };
    }

    public static StyledSegment ofParagraphAttributes(final StyleAttributeMap styleAttributeMap) {
        return new StyledSegment(){

            @Override
            public Type getType() {
                return Type.PARAGRAPH_ATTRIBUTES;
            }

            @Override
            public StyleAttributeMap getStyleAttributeMap(StyleResolver styleResolver) {
                if (styleResolver != null) {
                    return styleResolver.resolveStyles(styleAttributeMap);
                }
                return styleAttributeMap;
            }

            @Override
            public StyledSegment subSegment(int n, int n2) {
                return this;
            }

            public String toString() {
                return "StyledSegment{par.attrs=" + String.valueOf(styleAttributeMap) + "}";
            }
        };
    }

    private static String substring(String string, int n, int n2) {
        int n3 = string.length();
        if (n <= 0 && n2 >= n3) {
            return string;
        }
        return string.substring(Math.max(0, n), Math.min(n2, n3));
    }

    public static enum Type {
        INLINE_NODE,
        LINE_BREAK,
        PARAGRAPH_ATTRIBUTES,
        REGION,
        TEXT;

    }
}

