/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx;

import com.sun.javafx.runtime.VersionInfo;
import java.util.HashSet;
import java.util.Set;

public enum PreviewFeature {
    STAGE_STYLE_EXTENDED("StageStyle.EXTENDED"),
    HEADER_BAR("HeaderBar");

    private final String featureName;
    private static final String ENABLE_PREVIEW_PROPERTY = "javafx.enablePreview";
    private static final String SUPPRESS_WARNING_PROPERTY = "javafx.suppressPreviewWarning";
    private static final boolean enabled;
    private static final boolean suppressWarning;
    private static final Set<PreviewFeature> enabledFeatures;

    private PreviewFeature(String string2) {
        this.featureName = string2;
    }

    public void checkEnabled() {
        if (!enabled) {
            throw new RuntimeException("%s is a preview feature of JavaFX %s.\nPreview features may be removed in a future release, or upgraded to permanent features of JavaFX.\nPrograms can only use preview features when the following system property is set: -D%s=true\n".formatted(this.featureName, VersionInfo.getVersion(), ENABLE_PREVIEW_PROPERTY));
        }
        if (!suppressWarning && enabledFeatures.add(this)) {
            System.err.printf("Note: This program uses the following preview feature of JavaFX %s: %s\n      Preview features may be removed in a future release, or upgraded to permanent features of JavaFX.\n      This warning can be disabled with the following system property: -D%s=true\n", VersionInfo.getVersion(), this.featureName, SUPPRESS_WARNING_PROPERTY);
        }
    }

    static {
        enabled = Boolean.getBoolean(ENABLE_PREVIEW_PROPERTY);
        suppressWarning = Boolean.getBoolean(SUPPRESS_WARNING_PROPERTY);
        enabledFeatures = new HashSet<PreviewFeature>();
    }
}

