/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jfx.incubator.scene.control.richtext;

import com.sun.jfx.incubator.scene.control.richtext.CaretInfo;
import com.sun.jfx.incubator.scene.control.richtext.CellArrangement;
import com.sun.jfx.incubator.scene.control.richtext.ClippedPane;
import com.sun.jfx.incubator.scene.control.richtext.CssStyles;
import com.sun.jfx.incubator.scene.control.richtext.FastCache;
import com.sun.jfx.incubator.scene.control.richtext.FirstLineIndentSpacer;
import com.sun.jfx.incubator.scene.control.richtext.FxPathBuilder;
import com.sun.jfx.incubator.scene.control.richtext.Origin;
import com.sun.jfx.incubator.scene.control.richtext.RichParagraphHelper;
import com.sun.jfx.incubator.scene.control.richtext.SelectionHelper;
import com.sun.jfx.incubator.scene.control.richtext.TextCell;
import com.sun.jfx.incubator.scene.control.richtext.VFlowCellContext;
import com.sun.jfx.incubator.scene.control.richtext.util.RichUtils;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollBar;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.util.Duration;
import jfx.incubator.scene.control.richtext.RichTextArea;
import jfx.incubator.scene.control.richtext.SideDecorator;
import jfx.incubator.scene.control.richtext.StyleResolver;
import jfx.incubator.scene.control.richtext.TextPos;
import jfx.incubator.scene.control.richtext.model.ContentChange;
import jfx.incubator.scene.control.richtext.model.RichParagraph;
import jfx.incubator.scene.control.richtext.model.StyleAttributeMap;
import jfx.incubator.scene.control.richtext.model.StyledSegment;
import jfx.incubator.scene.control.richtext.model.StyledTextModel;
import jfx.incubator.scene.control.richtext.skin.RichTextAreaSkin;

public class VFlow
extends Pane
implements StyleResolver,
StyledTextModel.Listener {
    private final RichTextAreaSkin skin;
    private final RichTextArea control;
    private final ScrollBar vscroll;
    private final ScrollBar hscroll;
    private final ClippedPane leftGutter;
    private final ClippedPane rightGutter;
    private final Pane content;
    private final ClippedPane vport;
    private final Path caretPath;
    private final Path caretLineHighlight;
    private final Path selectionHighlight;
    private final SimpleBooleanProperty caretVisible = new SimpleBooleanProperty(true);
    private final SimpleBooleanProperty suppressBlink = new SimpleBooleanProperty(false);
    private final SimpleDoubleProperty offsetX = new SimpleDoubleProperty(0.0);
    private final ReadOnlyObjectWrapper<Origin> origin = new ReadOnlyObjectWrapper((Object)Origin.ZERO);
    private final Timeline caretAnimation;
    private final FastCache<TextCell> cellCache;
    private CellArrangement arrangement;
    private boolean dirty = true;
    private FastCache<Node> leftCache;
    private FastCache<Node> rightCache;
    private boolean handleScrollEvents = true;
    private boolean vsbPressed;
    private double contentPaddingTop;
    private double contentPaddingBottom;
    private double contentPaddingLeft;
    private double contentPaddingRight;
    private double leftSide;
    private double rightSide;
    private boolean inReflow;
    private double unwrappedContentWidth;
    private double viewPortWidth;
    private double viewPortHeight;
    private static final Text measurer = VFlow.makeMeasurer();
    private static final VFlowCellContext context = new VFlowCellContext();

    public VFlow(RichTextAreaSkin richTextAreaSkin, ScrollBar scrollBar, ScrollBar scrollBar2) {
        this.skin = richTextAreaSkin;
        this.control = (RichTextArea)richTextAreaSkin.getSkinnable();
        this.vscroll = scrollBar;
        this.hscroll = scrollBar2;
        this.vscroll.setManaged(false);
        this.vscroll.setMin(0.0);
        this.vscroll.setMax(1.0);
        this.vscroll.setUnitIncrement(0.01);
        this.vscroll.setBlockIncrement(0.05);
        this.hscroll.setManaged(false);
        this.hscroll.setMin(0.0);
        this.hscroll.setMax(1.0);
        this.hscroll.setUnitIncrement(0.01);
        this.hscroll.setBlockIncrement(0.05);
        this.cellCache = new FastCache(512);
        this.getStyleClass().add((Object)"vflow");
        this.setPadding(new Insets(1.0));
        this.leftGutter = new ClippedPane("left-side");
        this.leftGutter.setManaged(false);
        this.rightGutter = new ClippedPane("right-side");
        this.rightGutter.setManaged(false);
        this.vport = new ClippedPane("vport");
        this.vport.setManaged(false);
        this.content = new Pane();
        this.content.getStyleClass().add((Object)"content");
        this.content.setManaged(false);
        this.caretPath = new Path();
        this.caretPath.getStyleClass().add((Object)"caret");
        this.caretPath.setManaged(false);
        this.caretLineHighlight = new Path();
        this.caretLineHighlight.getStyleClass().add((Object)"caret-line");
        this.caretLineHighlight.setManaged(false);
        this.selectionHighlight = new Path();
        this.selectionHighlight.getStyleClass().add((Object)"selection-highlight");
        this.selectionHighlight.setManaged(false);
        this.getChildren().addAll((Object[])new Node[]{this.leftGutter, this.rightGutter, this.vscroll, this.hscroll, this.vport});
        this.vport.getChildren().addAll((Object[])new Node[]{this.content});
        this.content.getChildren().addAll((Object[])new Node[]{this.caretLineHighlight, this.selectionHighlight, this.caretPath});
        this.caretPath.setViewOrder(-10.0);
        this.selectionHighlight.setViewOrder(10.0);
        this.caretLineHighlight.setViewOrder(20.0);
        this.caretAnimation = new Timeline();
        this.caretAnimation.setCycleCount(-1);
        this.caretPath.visibleProperty().bind((ObservableValue)new BooleanBinding(){
            {
                this.bind(new Observable[]{VFlow.this.caretVisible, VFlow.this.control.displayCaretProperty(), VFlow.this.control.focusedProperty(), VFlow.this.control.disabledProperty(), VFlow.this.suppressBlink});
            }

            protected boolean computeValue() {
                return (VFlow.this.isCaretVisible() || VFlow.this.suppressBlink.get()) && VFlow.this.control.isDisplayCaret() && VFlow.this.control.isFocused() && !VFlow.this.control.isDisabled();
            }
        });
        this.offsetX.addListener(observable -> this.updateHorizontalScrollBar());
        this.origin.addListener(observable -> this.handleOriginChange());
        this.widthProperty().addListener(observable -> this.handleWidthChange());
        this.heightProperty().addListener(observable -> this.handleHeightChange());
        this.vscroll.addEventFilter(MouseEvent.ANY, this::handleVScrollMouseEvent);
        this.updateHorizontalScrollBar();
        this.handleOriginChange();
    }

    public void dispose() {
        this.caretPath.visibleProperty().unbind();
    }

    public Pane getContentPane() {
        return this.content;
    }

    private static Text makeMeasurer() {
        Text text = new Text("8");
        text.setManaged(false);
        return text;
    }

    public void handleModelChange() {
        this.setOrigin(new Origin(0, -this.contentPaddingTop));
        this.handleWrapText();
    }

    public void handleWrapText() {
        if (this.control.isWrapText()) {
            double d = this.viewPortWidth;
            this.setUnwrappedContentWidth(d);
        } else {
            this.setUnwrappedContentWidth(0.0);
        }
        this.setOffsetX(0.0);
        this.layoutChildren();
        this.updateHorizontalScrollBar();
        this.updateVerticalScrollBar();
        this.requestControlLayout(true);
    }

    public void handleDecoratorChange() {
        this.leftCache = this.updateSideCache(this.control.getLeftDecorator(), this.leftCache);
        this.rightCache = this.updateSideCache(this.control.getRightDecorator(), this.rightCache);
        this.requestControlLayout(false);
        this.updateHorizontalScrollBar();
    }

    private FastCache<Node> updateSideCache(SideDecorator sideDecorator, FastCache<Node> fastCache) {
        if (sideDecorator == null) {
            if (fastCache != null) {
                fastCache.clear();
            }
        } else if (fastCache == null) {
            fastCache = new FastCache(512);
        } else {
            fastCache.clear();
        }
        return fastCache;
    }

    public void invalidateLayout() {
        this.cellCache.clear();
        this.requestLayout();
        this.updateHorizontalScrollBar();
        this.updateVerticalScrollBar();
    }

    public void handleContentPadding() {
        Insets insets = this.control.getContentPadding();
        if (insets == null) {
            insets = Insets.EMPTY;
        }
        this.contentPaddingLeft = this.snapPositionX(insets.getLeft());
        this.contentPaddingRight = this.snapPositionX(insets.getRight());
        this.contentPaddingTop = this.snapPositionY(insets.getTop());
        this.contentPaddingBottom = this.snapPositionY(insets.getBottom());
        this.setOffsetX(0.0);
        if (this.getOrigin().index() == 0) {
            this.setOrigin(new Origin(0, -this.contentPaddingTop));
        }
        this.requestLayout();
        this.updateHorizontalScrollBar();
        this.updateVerticalScrollBar();
    }

    public double leftPadding() {
        return this.contentPaddingLeft;
    }

    public final ReadOnlyProperty<Origin> originProperty() {
        return this.origin.getReadOnlyProperty();
    }

    public final Origin getOrigin() {
        return (Origin)this.origin.get();
    }

    private void setOrigin(Origin origin) {
        if (origin == null) {
            throw new NullPointerException();
        }
        if (this.control.isUseContentHeight() || origin.index() == 0 && origin.offset() == 0.0) {
            origin = new Origin(0, -this.contentPaddingTop);
        }
        this.origin.set((Object)origin);
    }

    private void handleOriginChange() {
        if (!this.inReflow) {
            this.requestLayout();
        }
    }

    public int topCellIndex() {
        return this.getOrigin().index();
    }

    public final double getOffsetX() {
        return this.offsetX.get();
    }

    private final void setOffsetX(double d) {
        d = this.control.isUseContentWidth() ? 0.0 : Math.max(0.0, this.snapPositionX(d));
        this.offsetX.set(d);
        this.content.setTranslateX(-d);
    }

    private void setUnwrappedContentWidth(double d) {
        double d2 = this.snapPositionX(20.0);
        if (d < d2) {
            d = d2;
        }
        this.unwrappedContentWidth = d;
    }

    private double contentWidth() {
        return this.unwrappedContentWidth + this.contentPaddingLeft + this.contentPaddingRight + this.snapPositionX(0.0);
    }

    public void setCaretVisible(boolean bl) {
        this.caretVisible.set(bl);
    }

    public boolean isCaretVisible() {
        return this.caretVisible.get();
    }

    void handleWidthChange() {
        if (!this.control.isWrapText()) {
            double d;
            double d2 = this.unwrappedContentWidth + this.contentPaddingRight - this.getOffsetX() - this.viewPortWidth;
            if (d2 < 0.0 && (d = this.getOffsetX() + d2) > -this.contentPaddingLeft) {
                this.setOffsetX(d);
            }
            this.updateHorizontalScrollBar();
        }
        this.requestLayout();
    }

    void handleHeightChange() {
        this.requestLayout();
    }

    public void handleSelectionChange() {
        this.setSuppressBlink(true);
        this.updateCaretAndSelection();
        this.scrollCaretToVisible();
        this.setSuppressBlink(false);
    }

    public void updateCaretAndSelection() {
        FxPathBuilder fxPathBuilder;
        if (this.arrangement == null) {
            this.removeCaretAndSelection();
            return;
        }
        TextPos textPos = this.control.getCaretPosition();
        if (textPos == null) {
            this.removeCaretAndSelection();
            return;
        }
        TextPos textPos2 = this.control.getAnchorPosition();
        if (textPos2 == null) {
            textPos2 = textPos;
        }
        if (this.control.isHighlightCurrentParagraph()) {
            fxPathBuilder = new FxPathBuilder();
            this.createCurrentLineHighlight(fxPathBuilder, textPos);
            this.caretLineHighlight.getElements().setAll(fxPathBuilder.getPathElements());
        } else {
            this.caretLineHighlight.getElements().clear();
        }
        fxPathBuilder = new FxPathBuilder();
        this.createSelectionHighlight(fxPathBuilder, textPos2, textPos);
        this.selectionHighlight.getElements().setAll(fxPathBuilder.getPathElements());
        fxPathBuilder = new FxPathBuilder();
        this.createCaretPath(fxPathBuilder, textPos);
        this.caretPath.getElements().setAll(fxPathBuilder.getPathElements());
    }

    protected void removeCaretAndSelection() {
        this.caretLineHighlight.getElements().clear();
        this.selectionHighlight.getElements().clear();
        this.caretPath.getElements().clear();
    }

    protected void createCaretPath(FxPathBuilder fxPathBuilder, TextPos textPos) {
        CaretInfo caretInfo = this.getCaretInfo(textPos);
        if (caretInfo != null) {
            fxPathBuilder.addAll(caretInfo.path());
        }
    }

    protected void createSelectionHighlight(FxPathBuilder fxPathBuilder, TextPos textPos, TextPos textPos2) {
        PathElement[] pathElementArray;
        PathElement[] pathElementArray2;
        if (textPos == null || textPos2 == null) {
            return;
        }
        int n = textPos.compareTo(textPos2);
        if (n == 0) {
            return;
        }
        if (n > 0) {
            TextPos textPos3 = textPos;
            textPos = textPos2;
            textPos2 = textPos3;
        }
        int n2 = this.topCellIndex();
        if (textPos2.index() < n2) {
            return;
        }
        if (textPos.index() >= n2 + this.arrangement().getVisibleCellCount()) {
            return;
        }
        if (textPos.index() == textPos2.index()) {
            pathElementArray2 = this.getRangeShape(textPos.index(), textPos.offset(), textPos2.offset());
            pathElementArray = null;
        } else {
            pathElementArray2 = this.getRangeShape(textPos.index(), textPos.offset(), -1);
            if (pathElementArray2 == null) {
                pathElementArray2 = this.getRangeTop();
            }
            if ((pathElementArray = this.getRangeShape(textPos2.index(), 0, textPos2.offset())) == null) {
                pathElementArray = this.getRangeBottom();
            }
        }
        double d = -this.contentPaddingLeft;
        double d2 = this.control.isWrapText() ? this.getWidth() : Math.max(this.getWidth(), this.contentWidth());
        boolean bl = true;
        boolean bl2 = true;
        double d3 = 0.0;
        new SelectionHelper(fxPathBuilder, d, d2).generate(pathElementArray2, pathElementArray, bl, bl2, this.contentPaddingLeft, d3);
    }

    protected void createCurrentLineHighlight(FxPathBuilder fxPathBuilder, TextPos textPos) {
        int n = textPos.index();
        TextCell textCell = this.arrangement().getVisibleCell(n);
        if (textCell != null) {
            double d = this.control.isWrapText() ? this.getWidth() : Math.max(this.getWidth(), this.contentWidth());
            textCell.addBoxOutline(fxPathBuilder, 0.0, this.snapPositionX(d), textCell.getCellHeight());
        }
    }

    public TextPos getTextPosLocal(double d, double d2) {
        return this.arrangement().getTextPos(d - this.contentPaddingLeft, d2);
    }

    protected CaretInfo getCaretInfo(TextPos textPos) {
        return this.arrangement().getCaretInfo((Region)this.content, textPos);
    }

    public CaretInfo getCaretInfo() {
        TextPos textPos = this.control.getCaretPosition();
        if (textPos == null) {
            return null;
        }
        return this.getCaretInfo(textPos);
    }

    protected PathElement[] getRangeTop() {
        double d = this.getWidth();
        return new PathElement[]{new MoveTo(0.0, -1.0), new LineTo(d, -1.0), new LineTo(d, 0.0), new LineTo(0.0, 0.0), new LineTo(0.0, -1.0)};
    }

    protected PathElement[] getRangeBottom() {
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = d2 + 1.0;
        return new PathElement[]{new MoveTo(0.0, d2), new LineTo(d, d2), new LineTo(d, d3), new LineTo(0.0, d3), new LineTo(0.0, d2)};
    }

    public PathElement[] getRangeShape(int n, int n2, int n3) {
        TextCell textCell = this.arrangement().getVisibleCell(n);
        if (textCell == null) {
            return null;
        }
        if (n3 < 0) {
            n3 = textCell.getTextLength();
        }
        PathElement[] pathElementArray = n2 == n3 ? textCell.getCaretShape((Region)this.content, n2, true) : textCell.getRangeShape((Region)this.content, n2, n3);
        return pathElementArray;
    }

    public final void setSuppressBlink(boolean bl) {
        this.suppressBlink.set(bl);
        if (!bl) {
            this.updateRateRestartBlink();
        }
    }

    public final void updateRateRestartBlink() {
        Duration duration = this.control.getCaretBlinkPeriod();
        Duration duration2 = duration.divide(2.0);
        this.caretAnimation.stop();
        this.caretAnimation.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(Duration.ZERO, actionEvent -> this.setCaretVisible(true), new KeyValue[0]), new KeyFrame(duration2, actionEvent -> this.setCaretVisible(false), new KeyValue[0]), new KeyFrame(duration, new KeyValue[0])});
        this.caretAnimation.play();
    }

    public final int getParagraphCount() {
        return this.control.getParagraphCount();
    }

    public final Insets contentPadding() {
        Insets insets = this.control.getContentPadding();
        return insets == null ? Insets.EMPTY : insets;
    }

    private void handleVScrollMouseEvent(MouseEvent mouseEvent) {
        EventType eventType = mouseEvent.getEventType();
        if (eventType == MouseEvent.MOUSE_PRESSED) {
            this.vsbPressed = true;
        } else if (eventType == MouseEvent.MOUSE_RELEASED) {
            this.vsbPressed = false;
            this.updateVerticalScrollBar();
        }
    }

    protected void updateVerticalScrollBar() {
        double d;
        double d2;
        if (this.getParagraphCount() == 0) {
            d2 = 1.0;
            d = 0.0;
        } else {
            CellArrangement cellArrangement = this.arrangement();
            double d3 = cellArrangement.averageHeight();
            double d4 = cellArrangement.estimatedMax();
            double d5 = this.getViewPortHeight();
            d = VFlow.toScrollBarValue((double)(this.topCellIndex() - cellArrangement.topCount()) * d3 + cellArrangement.topHeight(), d5, d4);
            d2 = d5 / d4;
        }
        this.handleScrollEvents = false;
        this.vscroll.setVisibleAmount(d2);
        this.vscroll.setValue(d);
        this.handleScrollEvents = true;
    }

    public void handleVerticalScroll() {
        if (this.handleScrollEvents) {
            if (this.getParagraphCount() == 0) {
                return;
            }
            double d = this.vscroll.getMax();
            double d2 = this.vscroll.getMin();
            double d3 = this.vscroll.getValue();
            double d4 = (d3 - d2) / d;
            int n = this.getParagraphCount();
            int n2 = Math.max(0, (int)Math.round(d4 * (double)(n - 1)));
            Origin origin = new Origin(n2, 0.0);
            this.setOrigin(origin);
            this.layoutCells();
            CellArrangement cellArrangement = this.arrangement();
            int n3 = cellArrangement.topIndex();
            double d5 = cellArrangement.topHeight();
            double d6 = cellArrangement.bottomHeight();
            int n4 = cellArrangement.cellCount();
            double d7 = cellArrangement.averageHeight();
            int n5 = this.getOrigin().index();
            double d8 = this.getViewPortHeight();
            double d9 = this.contentPaddingTop + (double)n3 * d7 + d5;
            double d10 = d6 + (double)(n - n3 - n4) * d7 + this.contentPaddingBottom;
            double d11 = Math.max(0.0, d9 + d10 - d8);
            double d12 = d9 / d11;
            double d13 = (d4 - d12) * d11;
            this.scrollVerticalPixels(d13);
            this.layoutChildren();
        }
    }

    protected void updateHorizontalScrollBar() {
        if (this.control.isWrapText()) {
            return;
        }
        double d = this.contentWidth();
        double d2 = this.vport.getWidth();
        double d3 = this.getOffsetX();
        double d4 = d2 / d;
        double d5 = VFlow.toScrollBarValue(d3, d2, d);
        this.handleScrollEvents = false;
        this.hscroll.setVisibleAmount(d4);
        this.hscroll.setValue(d5);
        this.handleScrollEvents = true;
    }

    public void handleHorizontalScroll() {
        if (this.handleScrollEvents) {
            if (this.arrangement == null || this.control.isWrapText()) {
                return;
            }
            double d = this.contentWidth();
            double d2 = this.vport.getWidth();
            double d3 = this.hscroll.getValue();
            double d4 = VFlow.fromScrollBarValue(d3, d2, d);
            this.setOffsetX(d4);
        }
    }

    private static double toScrollBarValue(double d, double d2, double d3) {
        if (Math.abs(d3 - d2) < 1.0E-10) {
            return 0.0;
        }
        return d / (d3 - d2);
    }

    private static double fromScrollBarValue(double d, double d2, double d3) {
        return d * (d3 - d2);
    }

    public TextCell getCell(int n) {
        return this.arrangement().getCell(n);
    }

    private TextCell createTextCell(int n, RichParagraph richParagraph) {
        Object object;
        TextCell textCell;
        Object object2;
        if (richParagraph == null) {
            return null;
        }
        StyleAttributeMap styleAttributeMap = richParagraph.getParagraphAttributes();
        Supplier<Region> supplier = richParagraph.getParagraphRegion();
        if (supplier != null) {
            object2 = supplier.get();
            textCell = new TextCell(n, (Region)object2);
        } else {
            Object object3;
            textCell = new TextCell(n);
            if (styleAttributeMap != null && (object2 = styleAttributeMap.getFirstLineIndent()) != null) {
                textCell.add((Node)new FirstLineIndentSpacer((Double)object2));
            }
            if ((object2 = RichParagraphHelper.getHighlights(richParagraph)) != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    object3 = (Consumer)object.next();
                    object3.accept(textCell);
                }
            }
            if ((object = RichParagraphHelper.getSegments(richParagraph)) == null || object.isEmpty()) {
                textCell.add((Node)this.createTextNode("", StyleAttributeMap.EMPTY));
            } else {
                object3 = object.iterator();
                while (object3.hasNext()) {
                    StyledSegment styledSegment = (StyledSegment)object3.next();
                    switch (styledSegment.getType()) {
                        case INLINE_NODE: {
                            Node node = styledSegment.getInlineNodeGenerator().get();
                            textCell.add(node);
                            break;
                        }
                        case TEXT: {
                            String string = styledSegment.getText();
                            StyleAttributeMap styleAttributeMap2 = styledSegment.getStyleAttributeMap(this);
                            Text text = this.createTextNode(string, styleAttributeMap2);
                            textCell.add((Node)text);
                        }
                    }
                }
            }
        }
        if (styleAttributeMap == null) {
            styleAttributeMap = StyleAttributeMap.EMPTY;
        } else {
            object2 = styleAttributeMap.getBullet();
            if (object2 != null) {
                textCell.setBullet((String)object2);
            }
            if (this.control.isWrapText() && (object = styleAttributeMap.getParagraphDirection()) != null) {
                switch (2.$SwitchMap$jfx$incubator$scene$control$richtext$model$ParagraphDirection[((Enum)object).ordinal()]) {
                    case 1: {
                        textCell.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
                        break;
                    }
                    case 2: {
                        textCell.setNodeOrientation(NodeOrientation.RIGHT_TO_LEFT);
                    }
                }
            }
        }
        context.reset((Node)textCell.getContent(), styleAttributeMap);
        this.skin.applyStyles(context, styleAttributeMap, true);
        context.apply();
        return textCell;
    }

    private Text createTextNode(String string, StyleAttributeMap styleAttributeMap) {
        Text text = new Text(string);
        context.reset((Node)text, styleAttributeMap);
        this.skin.applyStyles(context, styleAttributeMap, false);
        context.apply();
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double computeSideWidth(SideDecorator sideDecorator) {
        if (sideDecorator != null) {
            double d = sideDecorator.getPrefWidth(this.getWidth());
            if (d <= 0.0) {
                int n = this.topCellIndex();
                Node node = sideDecorator.getMeasurementNode(n);
                node.setManaged(false);
                this.content.getChildren().add((Object)node);
                try {
                    node.applyCss();
                    if (node instanceof Parent) {
                        Parent parent = (Parent)node;
                        parent.layout();
                    }
                    d = node.prefWidth(-1.0);
                }
                finally {
                    this.content.getChildren().remove((Object)node);
                }
            }
            double d2 = 10.0;
            d = ((double)Math.round((d + 1.0) / d2) + 1.0) * d2;
            return this.snapSizeX(d);
        }
        return 0.0;
    }

    protected CellArrangement arrangement() {
        if (!this.inReflow && this.dirty || this.arrangement == null) {
            this.layoutChildren();
        }
        return this.arrangement;
    }

    private double getLineSpacing(Region region) {
        if (region instanceof TextFlow) {
            TextFlow textFlow = (TextFlow)region;
            return textFlow.getLineSpacing();
        }
        return 0.0;
    }

    public double getViewPortHeight() {
        return this.viewPortHeight;
    }

    public void pageUp() {
        this.scrollVerticalPixels(-this.getViewPortHeight());
    }

    public void pageDown() {
        this.scrollVerticalPixels(this.getViewPortHeight());
    }

    public void scrollVerticalFraction(double d) {
        this.scrollVerticalPixels(this.getViewPortHeight() * d);
    }

    public void scrollVerticalPixels(double d) {
        Origin origin = this.arrangement().moveOrigin(d);
        if (origin != null) {
            this.setOrigin(origin);
        }
    }

    public void scrollHorizontalFraction(double d) {
        double d2 = this.content.getWidth() + this.contentPaddingLeft + this.contentPaddingRight;
        this.scrollHorizontalPixels(d * d2);
    }

    public void scrollHorizontalPixels(double d) {
        double d2 = this.getOffsetX() + d;
        if (d2 + this.vport.getWidth() > this.contentWidth()) {
            d2 = this.contentWidth() - this.vport.getWidth();
        }
        this.setOffsetX(d2);
    }

    private void scrollHorizontalToVisible(double d) {
        if (!this.control.isWrapText()) {
            double d2;
            if (d < this.getOffsetX()) {
                d2 = d - 0.0;
            } else if (d > this.getOffsetX() + this.vport.getWidth()) {
                d2 = d + 0.0 - this.vport.getWidth();
            } else {
                return;
            }
            this.setOffsetX(d2);
        }
    }

    public void scrollToVisible(double d, double d2) {
        if (d2 < this.snappedTopInset()) {
            this.scrollVerticalPixels(d2 - this.snappedTopInset());
        } else if (d2 >= this.getViewPortHeight()) {
            this.scrollVerticalPixels(d2 - this.getViewPortHeight());
        }
        this.scrollHorizontalToVisible(d);
    }

    public void scrollCaretToVisible() {
        TextPos textPos = this.control.getCaretPosition();
        if (textPos == null) {
            return;
        }
        boolean bl = false;
        CaretInfo caretInfo = this.getCaretInfo();
        if (caretInfo == null) {
            int n = textPos.index();
            Origin origin = new Origin(n, 0.0);
            boolean bl2 = n > this.getOrigin().index();
            this.setOrigin(origin);
            caretInfo = this.getCaretInfo();
            if (bl2) {
                this.scrollVerticalPixels(caretInfo.getMaxY() - caretInfo.getMinY() - this.getViewPortHeight());
            }
            this.checkForExcessiveWhitespaceAtTheEnd();
            bl = true;
        } else {
            if (caretInfo.getMinY() < this.snappedTopInset()) {
                this.scrollVerticalPixels(caretInfo.getMinY() - this.snappedTopInset());
                bl = true;
            } else if (caretInfo.getMaxY() > this.getViewPortHeight()) {
                this.scrollVerticalPixels(caretInfo.getMaxY() - this.getViewPortHeight());
                bl = true;
            }
            if (!this.control.isWrapText()) {
                double d = caretInfo.getMinX();
                if (d + this.contentPaddingLeft < 0.0) {
                    this.scrollHorizontalToVisible(d);
                } else {
                    this.scrollHorizontalToVisible(caretInfo.getMaxX());
                }
            }
        }
        if (bl) {
            this.layout();
        }
    }

    protected void checkForExcessiveWhitespaceAtTheEnd() {
        double d = this.arrangement().bottomHeight() - this.getViewPortHeight();
        if (d < 0.0) {
            if (this.getOrigin().index() == 0 && this.getOrigin().offset() <= -this.contentPaddingTop) {
                return;
            }
            this.scrollVerticalPixels(d);
        }
    }

    @Override
    public void onContentChange(ContentChange contentChange) {
        Origin origin;
        if (contentChange.isEdit() && (origin = this.computeNewOrigin(contentChange)) != null) {
            this.setOrigin(origin);
        }
        this.cellCache.clear();
        this.requestLayout();
    }

    private Origin computeNewOrigin(ContentChange contentChange) {
        int n = contentChange.getStart().index();
        int n2 = contentChange.getEnd().index();
        Origin origin = this.getOrigin();
        int n3 = n2 - n + contentChange.getLinesAdded();
        if (n <= origin.index() && origin.index() < n + n3) {
            return new Origin(n, 0.0);
        }
        if (n3 != 0 && (n2 < origin.index() || n2 == origin.index() && (double)contentChange.getEnd().offset() < origin.offset())) {
            return new Origin(origin.index() + n3, origin.offset());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StyleAttributeMap resolveStyles(StyleAttributeMap styleAttributeMap) {
        if (styleAttributeMap == null) {
            return styleAttributeMap;
        }
        CssStyles cssStyles = styleAttributeMap.get(CssStyles.CSS);
        if (cssStyles == null) {
            return styleAttributeMap;
        }
        String string = cssStyles.style();
        Object[] objectArray = cssStyles.names();
        this.getChildren().add((Object)measurer);
        try {
            measurer.setStyle(string);
            if (objectArray == null) {
                measurer.getStyleClass().clear();
            } else {
                measurer.getStyleClass().setAll(objectArray);
            }
            measurer.applyCss();
            StyleAttributeMap styleAttributeMap2 = RichUtils.fromTextNode(measurer);
            return styleAttributeMap2;
        }
        finally {
            this.getChildren().remove((Object)measurer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WritableImage snapshot(Node node) {
        node.setManaged(false);
        this.getChildren().add((Object)node);
        try {
            Region region;
            node.applyCss();
            if (node instanceof Region) {
                region = (Region)node;
                double d = this.unwrappedContentWidth;
                double d2 = region.prefHeight(d);
                RichUtils.layoutInArea((Node)region, 0.0, -d2, d, d2);
            }
            region = node.snapshot(null, null);
            return region;
        }
        finally {
            this.getChildren().remove((Object)node);
        }
    }

    public TextPos moveHorizontally(boolean bl, int n, int n2) {
        TextCell textCell = this.getCell(n);
        Integer n3 = textCell.lineEdge(bl, n, n2);
        if (n3 == null) {
            return null;
        }
        if (bl || n3 == 0) {
            return TextPos.ofLeading(n, n3);
        }
        return new TextPos(n, n3, n3 - 1, false);
    }

    public TextPos moveVertically(int n, double d, double d2, boolean bl) {
        TextCell textCell = this.getCell(n);
        if (bl) {
            d2 += textCell.getLineSpacing();
        }
        double d3 = d2 - textCell.getY();
        boolean bl2 = textCell.isInsideText(d - this.contentPaddingLeft, d3, bl);
        TextPos textPos = this.getTextPosLocal(d, d2);
        if (textPos == null) {
            return null;
        }
        if (bl2) {
            return textPos;
        }
        int n2 = textPos.index();
        if (n2 == n) {
            if (bl) {
                if (++n2 >= ((RichTextArea)this.skin.getSkinnable()).getParagraphCount()) {
                    return ((RichTextArea)this.skin.getSkinnable()).getDocumentEnd();
                }
            } else if (--n2 < 0) {
                return TextPos.ZERO;
            }
        }
        textCell = this.getCell(n2);
        double d4 = textCell.findHitCandidate(d2 - textCell.getY(), bl);
        textPos = this.getTextPosLocal(d, d4 + textCell.getY());
        return textPos;
    }

    public void handleUseContentHeight() {
        boolean bl = this.control.isUseContentHeight();
        if (bl) {
            this.setUnwrappedContentWidth(0.0);
            this.setOrigin(new Origin(0, -this.contentPaddingTop));
            this.setOffsetX(0.0);
        }
        this.requestControlLayout(false);
    }

    public void handleUseContentWidth() {
        boolean bl = this.control.isUseContentWidth();
        if (bl) {
            this.setUnwrappedContentWidth(0.0);
            this.setOrigin(new Origin(0, -this.contentPaddingTop));
            this.setOffsetX(0.0);
        }
        this.requestControlLayout(false);
    }

    public void requestLayout() {
        this.dirty = true;
        super.requestLayout();
    }

    public void requestControlLayout(boolean bl) {
        if (bl) {
            this.cellCache.clear();
        }
        this.requestParentLayout();
        this.requestLayout();
    }

    private void updatePrefWidth() {
        if (!this.control.prefWidthProperty().isBound()) {
            Region region;
            Parent parent;
            double d = this.arrangement().getUnwrappedWidth() + this.snapSizeX(this.leftSide) + this.snapSizeX(this.rightSide) + this.contentPaddingLeft + this.contentPaddingRight + this.snapSizeX(0.0);
            if (d >= 0.0 && this.vscroll.isVisible()) {
                d += this.vscroll.getWidth();
            }
            if ((parent = this.getParent()) instanceof Region && (region = (Region)parent).getPrefWidth() != d) {
                region.setPrefWidth(d);
                this.control.getParent().requestLayout();
                this.requestControlLayout(false);
            }
        }
    }

    protected double computePrefHeight(double d) {
        if (this.control.isUseContentHeight()) {
            double d2 = this.snapSizeY(Math.max(10.0, this.arrangement().bottomHeight())) + this.snappedTopInset() + this.snappedBottomInset();
            if (this.hscroll.isVisible()) {
                d2 += this.hscroll.prefHeight(d);
            }
            return d2;
        }
        return super.computePrefHeight(d);
    }

    protected double computePrefWidth(double d) {
        if (this.control.isUseContentWidth()) {
            double d2 = this.contentWidth() + this.leftSide + this.rightSide + this.snappedLeftInset() + this.snappedRightInset();
            if (this.vscroll.isVisible()) {
                d2 += this.vscroll.prefWidth(d);
            }
            return d2;
        }
        return super.computePrefWidth(d);
    }

    protected void layoutChildren() {
        this.inReflow = true;
        try {
            this.layoutCells();
            this.checkForExcessiveWhitespaceAtTheEnd();
            this.updateCaretAndSelection();
            if (!this.vsbPressed) {
                this.updateVerticalScrollBar();
            }
        }
        finally {
            this.dirty = false;
            this.inReflow = false;
        }
    }

    private TextCell prepareCell(int n, double d) {
        Object object;
        TextCell textCell = this.cellCache.get(n);
        if (textCell == null) {
            object = this.control.getModel().getParagraph(n);
            textCell = this.createTextCell(n, (RichParagraph)object);
            this.cellCache.add(textCell.getIndex(), textCell);
        }
        object = textCell.getContent();
        this.content.getChildren().add((Object)textCell);
        textCell.setMaxWidth(d);
        textCell.setMaxHeight(-1.0);
        textCell.applyCss();
        textCell.layout();
        this.arrangement.addCell(textCell);
        return textCell;
    }

    protected void layoutCells() {
        double d;
        double d2;
        boolean bl;
        boolean bl2;
        Node node;
        TextCell textCell;
        int n;
        double d3;
        double d4;
        double d5;
        double d6;
        if (this.arrangement != null) {
            this.arrangement.removeNodesFrom(this.content);
            this.arrangement = null;
        }
        this.arrangement = new CellArrangement(this, this.contentPaddingTop, this.contentPaddingBottom);
        double d7 = this.getWidth();
        if (d7 == 0.0) {
            return;
        }
        double d8 = this.snappedTopInset();
        double d9 = this.snappedBottomInset();
        double d10 = this.snappedLeftInset();
        double d11 = this.snappedRightInset();
        SideDecorator sideDecorator = this.control.getLeftDecorator();
        SideDecorator sideDecorator2 = this.control.getRightDecorator();
        this.leftSide = this.computeSideWidth(sideDecorator);
        this.rightSide = this.computeSideWidth(sideDecorator2);
        int n2 = this.getParagraphCount();
        boolean bl3 = this.control.isUseContentHeight();
        boolean bl4 = this.control.isUseContentWidth();
        boolean bl5 = this.control.isWrapText() && !bl4;
        double d12 = this.getHeight();
        double d13 = this.vscroll.isVisible() ? this.vscroll.prefWidth(-1.0) : 0.0;
        double d14 = d6 = this.hscroll.isVisible() ? this.hscroll.prefHeight(-1.0) : 0.0;
        if (bl5) {
            d4 = d5 = d7 - this.leftSide - this.rightSide - this.contentPaddingLeft - this.contentPaddingRight - d13 - d10 - d11;
        } else {
            d5 = -1.0;
            d4 = 1.0E9;
        }
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = d3 = this.snapPositionY(-this.getOrigin().offset());
        int n3 = 100;
        int n4 = 0;
        int n5 = 0;
        boolean bl6 = true;
        for (n = this.topCellIndex(); n < n2; ++n) {
            textCell = this.prepareCell(n, d4);
            double d18 = textCell.prefHeight(d5) + this.getLineSpacing(textCell.getContent());
            d18 = this.snapSizeY(d18);
            textCell.setPosition(d17, d18);
            if (!bl5 && bl6) {
                double d19 = textCell.prefWidth(-1.0);
                textCell.setCellWidth(d19);
                if (d19 > d16) {
                    d16 = d19;
                }
            }
            d17 = this.snapPositionY(d17 + d18);
            d15 += d18;
            ++n5;
            if (bl3) {
                if (!(d17 > 10000.0)) continue;
                break;
            }
            if (bl6) {
                if (!(d17 > d12)) continue;
                this.arrangement.setVisibleCellCount(n5);
                bl6 = false;
                n4 = n5 + 100;
                int n6 = n4 - this.getParagraphCount();
                if (n6 <= 0) continue;
                n3 += n6;
                continue;
            }
            this.content.getChildren().remove((Object)textCell);
            if (n5 > n4) break;
        }
        if (bl6) {
            this.arrangement.setVisibleCellCount(n5);
        }
        if (n == n2) {
            d17 += this.contentPaddingBottom;
        }
        if (sideDecorator != null) {
            if (this.leftCache == null) {
                this.leftCache = this.updateSideCache(sideDecorator, null);
            }
            for (n = 0; n < this.arrangement.getVisibleCellCount(); ++n) {
                textCell = this.arrangement.getCellAt(n);
                int n7 = textCell.getIndex();
                node = this.leftCache.get(n7);
                if (node == null && (node = sideDecorator.getNode(n7)) != null) {
                    node.setManaged(false);
                    this.leftCache.add(n7, node);
                }
                if (node == null) continue;
                this.arrangement.addLeftNode(n, node);
            }
        }
        if (sideDecorator2 != null) {
            if (this.rightCache == null) {
                this.rightCache = this.updateSideCache(sideDecorator2, null);
            }
            for (n = 0; n < this.arrangement.getVisibleCellCount(); ++n) {
                textCell = this.arrangement.getCellAt(n);
                int n8 = textCell.getIndex();
                node = this.rightCache.get(n8);
                if (node == null && (node = sideDecorator2.getNode(textCell.getIndex())) != null) {
                    node.setManaged(false);
                    this.rightCache.add(n8, node);
                }
                if (node == null) continue;
                this.arrangement.addRightNode(n, node);
            }
        }
        d16 = this.snapSizeX(d16);
        this.arrangement.setBottomCount(n5);
        this.arrangement.setBottomHeight(d17);
        this.arrangement.setUnwrappedWidth(d16);
        n5 = 0;
        d17 = d3;
        for (n = this.topCellIndex() - 1; n >= 0; --n) {
            textCell = this.prepareCell(n, d4);
            double d20 = textCell.prefHeight(d5) + this.getLineSpacing(textCell.getContent());
            d20 = this.snapSizeY(d20);
            d17 = this.snapPositionY(d17 - d20);
            textCell.setPosition(d17, d20);
            textCell.setPosition(d17, d20);
            this.content.getChildren().remove((Object)textCell);
            if (++n5 > n3) break;
        }
        this.arrangement.setTopHeight(-d17);
        if (bl4) {
            d7 = d16 + this.leftSide + this.rightSide + this.contentPaddingLeft + this.contentPaddingRight + d10 + d11;
        }
        this.viewPortWidth = d7 - this.leftSide - this.rightSide - d13 - d10 - d11;
        if (this.viewPortWidth < 10.0) {
            this.viewPortWidth = 10.0;
        }
        this.viewPortHeight = d12 - d6 - d8 - d9;
        boolean bl7 = bl3 ? false : (this.topCellIndex() > 0 ? true : (bl2 = d15 + this.contentPaddingTop + this.contentPaddingBottom > this.viewPortHeight));
        if (bl2 != this.vscroll.isVisible()) {
            this.vscroll.setVisible(bl2);
            this.layoutCells();
            return;
        }
        if (bl2) {
            d7 -= d13;
        }
        boolean bl8 = bl5 || bl4 ? false : (bl = d16 + this.contentPaddingLeft + this.contentPaddingRight > this.viewPortWidth);
        if (this.hscroll.isVisible() != bl) {
            this.hscroll.setVisible(bl);
            this.layoutCells();
            return;
        }
        double d21 = bl3 ? this.contentPaddingTop + this.contentPaddingBottom + d15 : d12 - d6 - d8 - d9;
        if (bl2) {
            RichUtils.layoutInArea((Node)this.vscroll, d7 - d11, d8, d13, d21);
        }
        if (bl) {
            RichUtils.layoutInArea((Node)this.hscroll, d10, d21, d7 - d10 - d11, d6);
        }
        if (sideDecorator == null) {
            this.leftGutter.setVisible(false);
        } else {
            this.leftGutter.setVisible(true);
            RichUtils.layoutInArea((Node)this.leftGutter, d10, d8, this.leftSide, d21);
        }
        if (sideDecorator2 == null) {
            this.rightGutter.setVisible(false);
        } else {
            this.rightGutter.setVisible(true);
            RichUtils.layoutInArea((Node)this.rightGutter, d7 - this.rightSide - d11, d8, this.rightSide, d21);
        }
        RichUtils.layoutInArea((Node)this.vport, this.leftSide + d10, d8, this.viewPortWidth, d21);
        RichUtils.layoutInArea((Node)this.content, 0.0, 0.0, this.viewPortWidth, d21);
        if (bl5) {
            d2 = this.viewPortWidth;
            this.setUnwrappedContentWidth(d2);
        } else if (this.unwrappedContentWidth != d16) {
            this.setUnwrappedContentWidth(d16);
            this.updateHorizontalScrollBar();
            if (bl4) {
                this.requestControlLayout(false);
            }
        }
        if (bl4) {
            this.updatePrefWidth();
        }
        if (bl3) {
            d2 = this.computePrefHeight(-1.0);
            d = this.getPrefHeight();
            this.setPrefHeight(d2);
            this.requestParentLayout();
            if (d2 != d) {
                this.requestLayout();
                Platform.runLater(() -> this.layoutChildren());
            }
        } else if (this.getPrefHeight() != -1.0) {
            this.setPrefHeight(-1.0);
        }
        this.leftGutter.getChildren().clear();
        this.rightGutter.getChildren().clear();
        boolean bl9 = this.control.getLeftDecorator() != null;
        boolean bl10 = this.control.getRightDecorator() != null;
        d = bl5 ? 0.0 : this.contentPaddingLeft;
        int n9 = this.arrangement.getVisibleCellCount();
        for (n = 0; n < n9; ++n) {
            Node node2;
            TextCell textCell2 = this.arrangement.getCellAt(n);
            double d22 = textCell2.getCellHeight();
            double d23 = textCell2.getY();
            double d24 = bl5 ? this.viewPortWidth : textCell2.getCellWidth();
            RichUtils.layoutInArea((Node)textCell2, d, d23, d24, d22);
            textCell2.layout();
            if (bl9 && (node2 = this.arrangement.getLeftNodeAt(n)) != null) {
                this.leftGutter.getChildren().add((Object)node2);
                node2.applyCss();
                RichUtils.layoutInArea(node2, 0.0, d23, this.leftGutter.getWidth(), d22);
            }
            if (!bl10 || (node2 = this.arrangement.getRightNodeAt(n)) == null) continue;
            this.rightGutter.getChildren().add((Object)node2);
            node2.applyCss();
            RichUtils.layoutInArea(node2, 0.0, d23, this.rightGutter.getWidth(), d22);
        }
    }
}

