/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.scene.control.ResizeHelper;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.scene.control.ConstrainedColumnResizeBase;
import javafx.scene.control.Control;
import javafx.scene.control.ResizeFeaturesBase;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import javafx.scene.control.TreeTableView;
import javafx.util.Callback;

public class ConstrainedColumnResize
extends ConstrainedColumnResizeBase {
    private final ResizeMode mode;

    public ConstrainedColumnResize(ResizeMode resizeMode) {
        this.mode = resizeMode;
    }

    public boolean constrainedResize(ResizeFeaturesBase resizeFeaturesBase, List<? extends TableColumnBase<?, ?>> list) {
        double d = resizeFeaturesBase.getContentWidth();
        if (d == 0.0) {
            return false;
        }
        ResizeHelper resizeHelper = new ResizeHelper(resizeFeaturesBase, d, list, this.mode);
        resizeHelper.resizeToContentWidth();
        TableColumnBase tableColumnBase = resizeFeaturesBase.getColumn();
        boolean bl = tableColumnBase == null ? false : resizeHelper.resizeColumn(tableColumnBase);
        Control control = resizeFeaturesBase.getTableControl();
        PseudoClass pseudoClass = PseudoClass.getPseudoClass((String)this.toString());
        boolean bl2 = resizeHelper.applySizes();
        boolean bl3 = control.getPseudoClassStates().contains((Object)pseudoClass);
        if (bl2 != bl3) {
            if (bl2) {
                control.pseudoClassStateChanged(pseudoClass, true);
            } else {
                control.pseudoClassStateChanged(pseudoClass, false);
            }
        }
        return bl;
    }

    public static TablePolicy forTable(ResizeMode resizeMode) {
        return new TablePolicy(resizeMode);
    }

    public static TreeTablePolicy forTreeTable(ResizeMode resizeMode) {
        return new TreeTablePolicy(resizeMode);
    }

    public static enum ResizeMode {
        AUTO_RESIZE_FLEX_HEAD,
        AUTO_RESIZE_FLEX_TAIL,
        AUTO_RESIZE_NEXT_COLUMN,
        AUTO_RESIZE_SUBSEQUENT_COLUMNS,
        AUTO_RESIZE_LAST_COLUMN,
        AUTO_RESIZE_ALL_COLUMNS;

    }

    public static class TablePolicy
    extends ConstrainedColumnResize
    implements Callback<TableView.ResizeFeatures, Boolean> {
        public TablePolicy(ResizeMode resizeMode) {
            super(resizeMode);
        }

        public Boolean call(TableView.ResizeFeatures resizeFeatures) {
            ObservableList observableList = resizeFeatures.getTable().getVisibleLeafColumns();
            return this.constrainedResize(resizeFeatures, (List<? extends TableColumnBase<?, ?>>)observableList);
        }
    }

    public static class TreeTablePolicy
    extends ConstrainedColumnResize
    implements Callback<TreeTableView.ResizeFeatures, Boolean> {
        public TreeTablePolicy(ResizeMode resizeMode) {
            super(resizeMode);
        }

        public Boolean call(TreeTableView.ResizeFeatures resizeFeatures) {
            ObservableList observableList = resizeFeatures.getTable().getVisibleLeafColumns();
            return this.constrainedResize(resizeFeatures, (List<? extends TableColumnBase<?, ?>>)observableList);
        }
    }
}

