/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.control.ListenerHelper;
import com.sun.javafx.scene.control.TreeTableViewBackingList;
import com.sun.javafx.scene.control.behavior.TreeTableViewBehavior;
import java.util.ArrayList;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.NodeOrientation;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.skin.TableViewSkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class TreeTableViewSkin<T>
extends TableViewSkinBase<T, TreeItem<T>, TreeTableView<T>, TreeTableRow<T>, TreeTableColumn<T, ?>> {
    TreeTableViewBackingList<T> tableBackingList;
    ObjectProperty<ObservableList<TreeItem<T>>> tableBackingListProperty;
    private final TreeTableViewBehavior<T> behavior;
    private final EventHandler<TreeItem.TreeModificationEvent<T>> rootListener;

    public TreeTableViewSkin(TreeTableView<T> treeTableView) {
        super(treeTableView);
        this.behavior = new TreeTableViewBehavior<T>(treeTableView);
        this.flow.setFixedCellSize(treeTableView.getFixedCellSize());
        this.flow.setCellFactory(virtualFlow -> this.createCell());
        ListenerHelper listenerHelper = ListenerHelper.get(this);
        EventHandler eventHandler = mouseEvent -> {
            if (treeTableView.isFocusTraversable()) {
                treeTableView.requestFocus();
            }
        };
        listenerHelper.addEventFilter((EventTarget)this.flow.getVbar(), MouseEvent.MOUSE_PRESSED, eventHandler);
        listenerHelper.addEventFilter((EventTarget)this.flow.getHbar(), MouseEvent.MOUSE_PRESSED, eventHandler);
        this.behavior.setOnFocusPreviousRow(() -> this.onFocusAboveCell());
        this.behavior.setOnFocusNextRow(() -> this.onFocusBelowCell());
        this.behavior.setOnMoveToFirstCell(() -> this.onMoveToFirstCell());
        this.behavior.setOnMoveToLastCell(() -> this.onMoveToLastCell());
        this.behavior.setOnScrollPageDown((Callback<Boolean, Integer>)((Callback)bl -> this.onScrollPageDown((boolean)bl)));
        this.behavior.setOnScrollPageUp((Callback<Boolean, Integer>)((Callback)bl -> this.onScrollPageUp((boolean)bl)));
        this.behavior.setOnSelectPreviousRow(() -> this.onSelectAboveCell());
        this.behavior.setOnSelectNextRow(() -> this.onSelectBelowCell());
        this.behavior.setOnSelectLeftCell(() -> this.onSelectLeftCell());
        this.behavior.setOnSelectRightCell(() -> this.onSelectRightCell());
        this.behavior.setOnFocusLeftCell(() -> this.onFocusLeftCell());
        this.behavior.setOnFocusRightCell(() -> this.onFocusRightCell());
        this.behavior.setOnHorizontalUnitScroll(this::horizontalUnitScroll);
        this.behavior.setOnVerticalUnitScroll(this::verticalUnitScroll);
        this.rootListener = treeModificationEvent -> {
            if (treeModificationEvent.wasAdded() && treeModificationEvent.wasRemoved() && treeModificationEvent.getAddedSize() == treeModificationEvent.getRemovedSize()) {
                this.markItemCountDirty();
                treeTableView.requestLayout();
            } else if (treeModificationEvent.getEventType().equals(TreeItem.valueChangedEvent())) {
                this.requestRebuildCells();
            } else {
                for (EventType eventType = treeModificationEvent.getEventType(); eventType != null; eventType = eventType.getSuperType()) {
                    if (!eventType.equals(TreeItem.expandedItemCountChangeEvent())) continue;
                    this.markItemCountDirty();
                    treeTableView.requestLayout();
                    break;
                }
            }
            treeTableView.edit(-1, null);
        };
        listenerHelper.addChangeListener(treeTableView.rootProperty(), true, (observableValue, treeItem, treeItem2) -> {
            if (treeItem != null) {
                treeItem.removeEventHandler(TreeItem.treeNotificationEvent(), this.rootListener);
            }
            if (treeItem2 != null) {
                treeItem2.addEventHandler(TreeItem.treeNotificationEvent(), this.rootListener);
            }
            treeTableView.edit(-1, null);
            if (treeItem2 == null || treeItem2.getValue() == null) {
                this.requestRebuildCells();
            }
            this.updateItemCount();
        });
        listenerHelper.addChangeListener(treeTableView.showRootProperty(), bl -> {
            TreeItem treeItem;
            if (!treeTableView.isShowRoot() && (treeItem = treeTableView.getRoot()) != null) {
                treeItem.setExpanded(true);
            }
            this.updateItemCount();
        });
        listenerHelper.addChangeListener(treeTableView.expandedItemCountProperty(), number -> this.markItemCountDirty());
        listenerHelper.addChangeListener(treeTableView.fixedCellSizeProperty(), number -> this.flow.setFixedCellSize(((TreeTableView)this.getSkinnable()).getFixedCellSize()));
        this.updateItemCount();
    }

    @Override
    public void dispose() {
        this.flow.setCellFactory(null);
        if (this.behavior != null) {
            this.behavior.dispose();
        }
        super.dispose();
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case ROW_AT_INDEX: {
                int n = (Integer)objectArray[0];
                return n < 0 ? null : this.flow.getPrivateCell(n);
            }
            case SELECTED_ITEMS: {
                ArrayList<TreeTableRow> arrayList = new ArrayList<TreeTableRow>();
                TreeTableView.TreeTableViewSelectionModel treeTableViewSelectionModel = ((TreeTableView)this.getSkinnable()).getSelectionModel();
                if (treeTableViewSelectionModel != null) {
                    for (TreeTablePosition treeTablePosition : treeTableViewSelectionModel.getSelectedCells()) {
                        TreeTableRow treeTableRow = (TreeTableRow)this.flow.getPrivateCell(treeTablePosition.getRow());
                        if (treeTableRow == null) continue;
                        arrayList.add(treeTableRow);
                    }
                }
                return FXCollections.observableArrayList(arrayList);
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    @Override
    protected void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
        switch (accessibleAction) {
            case SHOW_ITEM: {
                Node node = (Node)objectArray[0];
                if (!(node instanceof TreeTableCell)) break;
                TreeTableCell treeTableCell = (TreeTableCell)node;
                this.flow.scrollTo(treeTableCell.getIndex());
                break;
            }
            case SET_SELECTED_ITEMS: {
                TreeTableView.TreeTableViewSelectionModel treeTableViewSelectionModel;
                ObservableList observableList = (ObservableList)objectArray[0];
                if (observableList == null || (treeTableViewSelectionModel = ((TreeTableView)this.getSkinnable()).getSelectionModel()) == null) break;
                treeTableViewSelectionModel.clearSelection();
                for (Node node : observableList) {
                    if (!(node instanceof TreeTableCell)) continue;
                    TreeTableCell treeTableCell = (TreeTableCell)node;
                    treeTableViewSelectionModel.select(treeTableCell.getIndex(), treeTableCell.getTableColumn());
                }
                break;
            }
            default: {
                super.executeAccessibleAction(accessibleAction, objectArray);
            }
        }
    }

    private TreeTableRow<T> createCell() {
        TreeTableView treeTableView = (TreeTableView)this.getSkinnable();
        TreeTableRow treeTableRow = treeTableView.getRowFactory() != null ? (TreeTableRow)treeTableView.getRowFactory().call((Object)treeTableView) : new TreeTableRow();
        if (treeTableRow.getDisclosureNode() == null) {
            StackPane stackPane = new StackPane();
            stackPane.getStyleClass().setAll((Object[])new String[]{"tree-disclosure-node"});
            stackPane.setMouseTransparent(true);
            StackPane stackPane2 = new StackPane();
            stackPane2.getStyleClass().setAll((Object[])new String[]{"arrow"});
            stackPane.getChildren().add((Object)stackPane2);
            treeTableRow.setDisclosureNode((Node)stackPane);
        }
        treeTableRow.updateTreeTableView(treeTableView);
        return treeTableRow;
    }

    @Override
    protected int getItemCount() {
        return ((TreeTableView)this.getSkinnable()).getExpandedItemCount();
    }

    @Override
    void horizontalScroll() {
        super.horizontalScroll();
        if (((TreeTableView)this.getSkinnable()).getFixedCellSize() > 0.0) {
            this.flow.requestCellLayout();
        }
    }

    @Override
    protected void updateItemCount() {
        this.updatePlaceholderRegionVisibility();
        this.tableBackingList.resetSize();
        int n = this.flow.getCellCount();
        int n2 = this.getItemCount();
        this.flow.setCellCount(n2);
        if (n2 == n) {
            this.needCellsReconfigured = true;
        }
    }

    private void horizontalUnitScroll(boolean bl) {
        if (((TreeTableView)this.getSkinnable()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
            bl = !bl;
        }
        ScrollBar scrollBar = this.flow.getHbar();
        if (bl) {
            scrollBar.increment();
        } else {
            scrollBar.decrement();
        }
    }

    private void verticalUnitScroll(boolean bl) {
        ScrollBar scrollBar = this.flow.getVbar();
        if (bl) {
            scrollBar.increment();
        } else {
            scrollBar.decrement();
        }
    }
}

